/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.query;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.netbeans.modules.bugtracking.issuetable.ColumnDescriptor;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache;
import org.netbeans.modules.bugtracking.util.LogUtils;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.BugzillaConnector;
import org.netbeans.modules.bugzilla.commands.GetMultiTaskDataCommand;
import org.netbeans.modules.bugzilla.commands.PerformQueryCommand;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.query.QueryController;
import org.netbeans.modules.bugzilla.query.QueryNotifyListener;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;

public class BugzillaQuery {
    private String name;
    private final BugzillaRepository repository;
    protected QueryController controller;
    private final Set<String> issues = new HashSet<String>();
    private Set<String> archivedIssues = new HashSet<String>();
    protected String urlParameters;
    private boolean initialUrlDef;
    private boolean firstRun = true;
    private ColumnDescriptor[] columnDescriptors;
    private OwnerInfo info;
    private boolean saved;
    protected long lastRefresh;
    private final PropertyChangeSupport support;
    private List<QueryNotifyListener> notifyListeners;

    public BugzillaQuery(BugzillaRepository repository) {
        this(null, repository, null, false, false, true);
    }

    public BugzillaQuery(String name, BugzillaRepository repository, String urlParameters, boolean saved, boolean urlDef, boolean initControler) {
        boolean autoRefresh;
        this.repository = repository;
        this.saved = saved;
        this.name = name;
        this.urlParameters = urlParameters;
        this.initialUrlDef = urlDef;
        this.lastRefresh = repository.getIssueCache().getQueryTimestamp(this.getStoredQueryName());
        this.support = new PropertyChangeSupport(this);
        if (initControler) {
            this.controller = this.createControler(repository, this, urlParameters);
        }
        if (repository instanceof KenaiRepository && (autoRefresh = BugzillaConfig.getInstance().getQueryAutoRefresh(this.getDisplayName()))) {
            this.getRepository().scheduleForRefresh(this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private void fireQuerySaved() {
        this.support.firePropertyChange("bugtracking.query.saved", null, null);
    }

    private void fireQueryRemoved() {
        this.support.firePropertyChange("bugtracking.query.removed", null, null);
    }

    private void fireQueryIssuesChanged() {
        this.support.firePropertyChange("bugtracking.query.issues_changed", null, null);
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getTooltip() {
        return this.name + " - " + this.repository.getDisplayName();
    }

    public synchronized QueryController getController() {
        if (this.controller == null) {
            this.controller = this.createControler(this.repository, this, this.urlParameters);
        }
        return this.controller;
    }

    public BugzillaRepository getRepository() {
        return this.repository;
    }

    protected QueryController createControler(BugzillaRepository r, BugzillaQuery q, String parameters) {
        return new QueryController(r, q, parameters, this.initialUrlDef);
    }

    public ColumnDescriptor[] getColumnDescriptors() {
        if (this.columnDescriptors == null) {
            this.columnDescriptors = BugzillaIssue.getColumnDescriptors(this.repository);
        }
        return this.columnDescriptors;
    }

    public void refresh() {
        this.refreshIntern(false);
    }

    boolean refreshIntern(final boolean autoRefresh) {
        assert (this.urlParameters != null);
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        final boolean[] ret = new boolean[1];
        this.executeQuery(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet<String> queryIssues;
                block7: {
                    Bugzilla.LOG.log(Level.FINE, "refresh start - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
                    try {
                        queryIssues = new HashSet<String>();
                        BugzillaQuery.this.issues.clear();
                        BugzillaQuery.this.archivedIssues.clear();
                        if (BugzillaQuery.this.isSaved()) {
                            if (!BugzillaQuery.this.wasRun() && !BugzillaQuery.this.issues.isEmpty()) {
                                Bugzilla.LOG.log(Level.WARNING, "query {0} supposed to be run for the first time yet already contains issues.", BugzillaQuery.this.getDisplayName());
                                assert (false);
                            }
                            queryIssues.addAll(BugzillaQuery.this.repository.getIssueCache().readQueryIssues(BugzillaQuery.this.getStoredQueryName()));
                            queryIssues.addAll(BugzillaQuery.this.repository.getIssueCache().readArchivedQueryIssues(BugzillaQuery.this.getStoredQueryName()));
                            BugzillaQuery.this.archivedIssues.addAll(queryIssues);
                        }
                        BugzillaQuery.this.firstRun = false;
                        StringBuilder url = new StringBuilder();
                        url.append("/buglist.cgi?query_format=advanced");
                        url.append(BugzillaQuery.this.urlParameters);
                        PerformQueryCommand queryCmd = new PerformQueryCommand(BugzillaQuery.this.repository, url.toString(), new IssuesIdCollector());
                        BugzillaQuery.this.repository.getExecutor().execute(queryCmd, !autoRefresh);
                        ret[0] = queryCmd.hasFailed();
                        if (!ret[0]) break block7;
                        BugzillaQuery.this.logQueryEvent(BugzillaQuery.this.issues.size(), autoRefresh);
                    }
                    catch (Throwable throwable) {
                        BugzillaQuery.this.logQueryEvent(BugzillaQuery.this.issues.size(), autoRefresh);
                        Bugzilla.LOG.log(Level.FINE, "refresh finish - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
                        throw throwable;
                    }
                    Bugzilla.LOG.log(Level.FINE, "refresh finish - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
                    return;
                }
                BugzillaQuery.this.archivedIssues.removeAll(BugzillaQuery.this.issues);
                if (BugzillaQuery.this.isSaved()) {
                    BugzillaQuery.this.repository.getIssueCache().storeQueryIssues(BugzillaQuery.this.getStoredQueryName(), BugzillaQuery.this.issues.toArray(new String[BugzillaQuery.this.issues.size()]));
                    BugzillaQuery.this.repository.getIssueCache().storeArchivedQueryIssues(BugzillaQuery.this.getStoredQueryName(), BugzillaQuery.this.archivedIssues.toArray(new String[BugzillaQuery.this.archivedIssues.size()]));
                }
                queryIssues.addAll(BugzillaQuery.this.issues);
                BugzillaQuery.this.getController().switchToDeterminateProgress(queryIssues.size());
                GetMultiTaskDataCommand dataCmd = new GetMultiTaskDataCommand(BugzillaQuery.this.repository, queryIssues, new IssuesCollector());
                BugzillaQuery.this.repository.getExecutor().execute(dataCmd, !autoRefresh);
                ret[0] = dataCmd.hasFailed();
                BugzillaQuery.this.logQueryEvent(BugzillaQuery.this.issues.size(), autoRefresh);
                Bugzilla.LOG.log(Level.FINE, "refresh finish - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
            }
        });
        return ret[0];
    }

    public String getStoredQueryName() {
        return this.getDisplayName();
    }

    protected void logQueryEvent(int count, boolean autoRefresh) {
        LogUtils.logQueryEvent((String)BugzillaConnector.getConnectorName(), (String)this.name, (int)count, (boolean)false, (boolean)autoRefresh);
    }

    void refresh(String urlParameters, boolean autoReresh) {
        assert (urlParameters != null);
        this.urlParameters = urlParameters;
        this.refreshIntern(autoReresh);
    }

    public void remove() {
        this.repository.removeQuery(this);
        this.fireQueryRemoved();
    }

    public boolean contains(String id) {
        return this.issues.contains(id);
    }

    public void setOwnerInfo(OwnerInfo info) {
        this.info = info;
    }

    public OwnerInfo getOwnerInfo() {
        return this.info;
    }

    public int getIssueStatus(String id) {
        return this.repository.getIssueCache().getStatus(id);
    }

    int getSize() {
        return this.issues.size();
    }

    public String getUrlParameters() {
        return this.getController().getUrlParameters(false);
    }

    public boolean isUrlDefined() {
        return this.getController().isUrlDefined();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSaved(boolean saved) {
        if (saved) {
            this.info = null;
        }
        this.saved = saved;
        this.fireQuerySaved();
    }

    public boolean isSaved() {
        return this.saved;
    }

    public Collection<BugzillaIssue> getIssues() {
        return this.getIssues(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<BugzillaIssue> getIssues(int includeStatus) {
        if (this.issues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>();
        Set<String> set = this.issues;
        synchronized (set) {
            ids.addAll(this.issues);
        }
        IssueCache<BugzillaIssue, TaskData> cache = this.repository.getIssueCache();
        ArrayList<BugzillaIssue> ret = new ArrayList<BugzillaIssue>();
        for (String id : ids) {
            int status = this.getIssueStatus(id);
            if ((status & includeStatus) == 0) continue;
            ret.add((BugzillaIssue)cache.getIssue(id));
        }
        return ret;
    }

    boolean wasRun() {
        return !this.firstRun;
    }

    long getLastRefresh() {
        return this.lastRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotifyListener(QueryNotifyListener l) {
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            list.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotifyListener(QueryNotifyListener l) {
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            list.remove(l);
        }
    }

    protected void fireNotifyData(BugzillaIssue issue) {
        QueryNotifyListener[] listeners;
        for (QueryNotifyListener l : listeners = this.getListeners()) {
            l.notifyData(issue);
        }
    }

    protected void fireStarted() {
        QueryNotifyListener[] listeners;
        for (QueryNotifyListener l : listeners = this.getListeners()) {
            l.started();
        }
    }

    protected void fireFinished() {
        QueryNotifyListener[] listeners;
        for (QueryNotifyListener l : listeners = this.getListeners()) {
            l.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQuery(Runnable r) {
        this.fireStarted();
        try {
            r.run();
        }
        finally {
            this.fireFinished();
            this.fireQueryIssuesChanged();
            this.lastRefresh = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryNotifyListener[] getListeners() {
        QueryNotifyListener[] listeners;
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            listeners = list.toArray(new QueryNotifyListener[list.size()]);
        }
        return listeners;
    }

    private List<QueryNotifyListener> getNotifyListeners() {
        if (this.notifyListeners == null) {
            this.notifyListeners = new ArrayList<QueryNotifyListener>();
        }
        return this.notifyListeners;
    }

    private class IssuesCollector
    extends TaskDataCollector {
        public void accept(TaskData taskData) {
            BugzillaIssue issue;
            String id = BugzillaIssue.getID(taskData);
            BugzillaQuery.this.getController().addProgressUnit(BugzillaIssue.getDisplayName(taskData));
            try {
                IssueCache<BugzillaIssue, TaskData> cache = BugzillaQuery.this.repository.getIssueCache();
                issue = (BugzillaIssue)cache.setIssueData(id, (Object)taskData);
            }
            catch (IOException ex) {
                Bugzilla.LOG.log(Level.SEVERE, null, ex);
                return;
            }
            BugzillaQuery.this.fireNotifyData(issue);
        }
    }

    private class IssuesIdCollector
    extends TaskDataCollector {
        public void accept(TaskData taskData) {
            String id = BugzillaIssue.getID(taskData);
            BugzillaQuery.this.issues.add(id);
        }
    }
}

