/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.IssuePanel;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ResolveIssuePanel
extends JPanel {
    private final BugzillaIssue issue;
    private JButton ok = new JButton();
    private JLabel commentLabel;
    private JButton duplicateButton;
    private JTextField duplicateField;
    private JLabel duplicateLabel;
    private JPanel duplicatePanel;
    private JComboBox resolutionCombo;
    private JLabel resolutionLabel;
    private JScrollPane scrollPane;
    private JTextArea textArea;

    public ResolveIssuePanel(BugzillaIssue issue) {
        this.issue = issue;
        this.initComponents();
        ((GroupLayout)this.getLayout()).setHonorsVisibility(false);
        BugzillaRepository repository = issue.getRepository();
        BugzillaConfiguration bc = repository.getConfiguration();
        if (bc == null || !bc.isValid()) {
            return;
        }
        LinkedList<String> resolutions = new LinkedList<String>(bc.getResolutions());
        resolutions.remove("MOVED");
        this.duplicatePanel.setVisible(false);
        this.resolutionCombo.setModel(new DefaultComboBoxModel<Object>(resolutions.toArray()));
        Mnemonics.setLocalizedText((AbstractButton)this.ok, (String)NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.resolveButton"));
    }

    public String getSelectedResolution() {
        return (String)this.resolutionCombo.getSelectedItem();
    }

    public String getComment() {
        return this.textArea.getText();
    }

    private void initComponents() {
        this.resolutionLabel = new JLabel();
        this.resolutionCombo = new JComboBox();
        this.commentLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.duplicatePanel = new JPanel();
        this.duplicateLabel = new JLabel();
        this.duplicateField = new JTextField();
        this.duplicateButton = new JButton();
        this.resolutionLabel.setLabelFor(this.resolutionCombo);
        Mnemonics.setLocalizedText((JLabel)this.resolutionLabel, (String)NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.resolutionLabel.text"));
        this.commentLabel.setLabelFor(this.textArea);
        Mnemonics.setLocalizedText((JLabel)this.commentLabel, (String)NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.commentLabel.text"));
        this.textArea.setColumns(80);
        this.textArea.setRows(5);
        this.scrollPane.setViewportView(this.textArea);
        this.textArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.textArea.AccessibleContext.accessibleDescription"));
        this.duplicateLabel.setLabelFor(this.duplicateField);
        Mnemonics.setLocalizedText((JLabel)this.duplicateLabel, (String)NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.duplicateLabel.text"));
        this.duplicateField.setColumns(15);
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateButton, (String)NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.duplicateButton.text"));
        this.duplicateButton.setFocusPainted(false);
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResolveIssuePanel.this.duplicateButtonActionPerformed(evt);
            }
        });
        GroupLayout duplicatePanelLayout = new GroupLayout(this.duplicatePanel);
        this.duplicatePanel.setLayout(duplicatePanelLayout);
        duplicatePanelLayout.setHorizontalGroup(duplicatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(duplicatePanelLayout.createSequentialGroup().addComponent(this.duplicateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.duplicateField, -2, 151, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.duplicateButton)));
        duplicatePanelLayout.setVerticalGroup(duplicatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(duplicatePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.duplicateLabel).addComponent(this.duplicateButton).addComponent(this.duplicateField, -2, -1, -2)));
        this.duplicateField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.duplicateField.AccessibleContext.accessibleDescription"));
        this.duplicateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.duplicateButton.AccessibleContext.accessibleDescription"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resolutionLabel).addComponent(this.commentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.resolutionCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.duplicatePanel, -2, -1, -2)).addComponent(this.scrollPane)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resolutionLabel).addComponent(this.resolutionCombo, -2, -1, -2)).addComponent(this.duplicatePanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commentLabel).addComponent(this.scrollPane)).addContainerGap()));
        this.resolutionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.resolutionCombo.AccessibleContext.accessibleDescription"));
    }

    private void duplicateButtonActionPerformed(ActionEvent evt) {
        String newIssueID = BugtrackingUtil.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.message"), (Repository)BugzillaUtil.getRepository(this.issue.getRepository()), (JPanel)this, (HelpCtx)new HelpCtx("org.netbeans.modules.bugzilla.duplicateChooser"));
        if (newIssueID != null) {
            this.duplicateField.setText(newIssueID);
        }
    }

    private void checkDuplicateId() {
        this.ok.setEnabled(!"DUPLICATE".equals(this.resolutionCombo.getSelectedItem()) || this.duplicateField.getText().trim().length() > 0);
    }

    private void resolutionComboSelectionChanged() {
        boolean shown = "DUPLICATE".equals(this.resolutionCombo.getSelectedItem());
        this.duplicatePanel.setVisible(shown);
        this.checkDuplicateId();
    }

    boolean showDialog() {
        this.ok.getAccessibleContext().setAccessibleDescription(this.ok.getText());
        DialogDescriptor dd = new DialogDescriptor((Object)this, NbBundle.getMessage(ResolveIssuePanel.class, (String)"BugzillaIssueProvider.resolveIssueButton.text"), true, new Object[]{this.ok, DialogDescriptor.CANCEL_OPTION}, (Object)this.ok, 0, new HelpCtx(ResolveIssuePanel.class), null);
        this.duplicateField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ResolveIssuePanel.this.checkDuplicateId();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ResolveIssuePanel.this.checkDuplicateId();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ResolveIssuePanel.this.checkDuplicateId();
            }
        });
        this.resolutionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResolveIssuePanel.this.resolutionComboSelectionChanged();
            }
        });
        this.resolutionComboSelectionChanged();
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == this.ok;
    }

    String getDuplicateId() {
        return this.duplicateField.getText().trim();
    }
}

