/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.kenai.spi.RepositoryUser;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.OwnerUtils;
import org.netbeans.modules.bugtracking.util.RepositoryUserRenderer;
import org.netbeans.modules.bugtracking.util.UIUtils;
import org.netbeans.modules.bugtracking.util.UndoRedoSupport;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.issue.AttachmentsPanel;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.BugzillaTaskListProvider;
import org.netbeans.modules.bugzilla.issue.CommentsPanel;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.CustomIssueField;
import org.netbeans.modules.bugzilla.repository.IssueField;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.spellchecker.api.Spellchecker;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.modules.Places;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;

public class IssuePanel
extends JPanel
implements Scrollable {
    private static final Color HIGHLIGHT_COLOR = new Color(217, 255, 217);
    private static final RequestProcessor RP = new RequestProcessor("Bugzilla Issue Panel", 5, false);
    private static final String YYYY_MM_DD = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.deadlineField.text");
    private BugzillaIssue issue;
    private CommentsPanel commentsPanel;
    private AttachmentsPanel attachmentsPanel;
    private int resolvedIndex;
    private Map<String, String> initialValues = new HashMap<String, String>();
    private List<String> keywords = new LinkedList<String>();
    private boolean reloading;
    private boolean skipReload;
    private boolean usingTargetMilestones;
    private PropertyChangeListener tasklistListener;
    private OwnerInfo ownerInfo;
    private String assignee = null;
    private UndoRedoSupport undoRedoSupport;
    PropertyChangeListener cacheListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() != IssuePanel.this.issue) {
                return;
            }
            if ("issue.seen_changed".equals(evt.getPropertyName())) {
                IssuePanel.this.updateFieldStatuses();
            }
        }
    };
    private int oldCommentCount;
    private boolean noSummary = false;
    private boolean invalidKeyword = false;
    private boolean cyclicDependency = false;
    private boolean noComponent = false;
    private boolean noVersion = false;
    private boolean noTargetMilestione = false;
    private boolean noDuplicateId = false;
    private List<String> fieldErrors = new LinkedList<String>();
    private List<String> fieldWarnings = new LinkedList<String>();
    private Map<Component, Boolean> enableMap = new HashMap<Component, Boolean>();
    private List<CustomFieldInfo> customFields = new LinkedList<CustomFieldInfo>();
    private JTextField actualField;
    private JLabel actualLabel;
    private JLabel actualWarning;
    private JTextArea addCommentArea;
    private JLabel addCommentLabel;
    private JCheckBox assignToDefaultCheckBox;
    private JComboBox assignedCombo;
    private JTextField assignedField;
    private JLabel assignedLabel;
    private JLabel assignedToStatusLabel;
    private JLabel assignedToWarning;
    private JCheckBox attachLogCheckBox;
    private JLabel attachmentsLabel;
    private JButton blocksButton;
    private JTextField blocksField;
    private JLabel blocksLabel;
    private JLabel blocksWarning;
    private JButton cancelButton;
    private JTextField ccField;
    private JLabel ccLabel;
    private JLabel ccWarning;
    private JTextField completeField;
    private JLabel completeLabel;
    private JLabel completeWarning;
    private JComboBox componentCombo;
    private JLabel componentLabel;
    private JLabel componentWarning;
    private JPanel customFieldsPanelLeft;
    private JPanel customFieldsPanelRight;
    private JTextField deadlineField;
    private JLabel deadlineLabel;
    private JLabel deadlineWarning;
    private JTextField dependsField;
    private JLabel dependsLabel;
    private JButton dependsOnButton;
    private JLabel dependsOnWarning;
    private JPanel dummyAttachmentsPanel;
    private JPanel dummyCommentsPanel;
    private JLabel dummyLabel1;
    private JLabel dummyLabel2;
    private JLabel dummyLabel3;
    private JLabel dummyTimetrackingLabel;
    private JPanel dummyTimetrackingPanel;
    private JButton duplicateButton;
    private JTextField duplicateField;
    private JLabel duplicateLabel;
    private JTextField estimatedField;
    private JLabel estimatedLabel;
    private JLabel estimatedWarning;
    private JTextField gainField;
    private JLabel gainLabel;
    private JLabel gainWarning;
    private JTextField headerField;
    private JComboBox issueTypeCombo;
    private JLabel issueTypeLabel;
    private JLabel issueTypeWarning;
    private JLabel jLabel7;
    private JButton keywordsButton;
    private JTextField keywordsField;
    private JLabel keywordsLabel;
    private JLabel keywordsWarning;
    private JPanel messagePanel;
    private JLabel milestoneWarning;
    private JTextField modifiedField;
    private JLabel modifiedLabel;
    private JComboBox osCombo;
    private JLabel osWarning;
    private JComboBox platformCombo;
    private JLabel platformLabel;
    private JLabel platformWarning;
    private JComboBox priorityCombo;
    private JLabel priorityLabel;
    private JLabel priorityWarning;
    private JComboBox productCombo;
    private JTextField productField;
    private JLabel productLabel;
    private JLabel productWarning;
    private JTextField qaContactField;
    private JLabel qaContactLabel;
    private JLabel qaContactWarning;
    private LinkButton refreshButton;
    private LinkButton reloadButton;
    private JTextField remainingField;
    private JLabel remainingLabel;
    private JLabel remainingWarning;
    private JTextField reportedField;
    private JLabel reportedLabel;
    private JLabel reportedStatusLabel;
    private JComboBox resolutionCombo;
    private JTextField resolutionField;
    private JLabel resolutionLabel;
    private JLabel resolutionWarning;
    private JScrollPane scrollPane1;
    private JSeparator separator;
    private JLabel separatorLabel;
    private JLabel separatorLabel2;
    private JLabel separatorLabel3;
    private JComboBox severityCombo;
    private JLabel severityWarning;
    private LinkButton showInBrowserButton;
    private JComboBox statusCombo;
    private JLabel statusLabel;
    private JLabel statusWarning;
    private JTextField statusWhiteboardField;
    private JLabel statusWhiteboardLabel;
    private JLabel statusWhiteboardWarning;
    private JButton submitButton;
    private JTextField summaryField;
    private JLabel summaryLabel;
    private JLabel summaryWarning;
    private JComboBox targetMilestoneCombo;
    private JLabel targetMilestoneLabel;
    private LinkButton tasklistButton;
    private JLabel timetrackingLabel;
    private JPanel timetrackingPanel;
    private JTextField urlField;
    private LinkButton urlLabel;
    private JLabel urlWarning;
    private JComboBox versionCombo;
    private JLabel versionLabel;
    private JLabel versionWarning;
    private JTextField workedField;
    private JLabel workedLabel;
    private JLabel workedSumField;
    private JLabel workedWarning;
    private int unitIncrement;
    private static final String CURRENT_NB_VERSION = "7.2";

    public IssuePanel() {
        this.initComponents();
        this.updateReadOnlyField(this.reportedField);
        this.updateReadOnlyField(this.modifiedField);
        this.updateReadOnlyField(this.resolutionField);
        this.updateReadOnlyField(this.productField);
        this.updateReadOnlyField(this.headerField);
        this.messagePanel.setBackground(this.getBackground());
        this.customFieldsPanelLeft.setBackground(this.getBackground());
        this.customFieldsPanelRight.setBackground(this.getBackground());
        Font font = this.reportedLabel.getFont();
        this.headerField.setFont(font.deriveFont((float)((double)font.getSize() * 1.7)));
        this.duplicateLabel.setVisible(false);
        this.duplicateField.setVisible(false);
        this.duplicateButton.setVisible(false);
        this.attachDocumentListeners();
        this.attachHideStatusListener();
        this.addCommentArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                IssuePanel.this.makeCaretVisible(IssuePanel.this.addCommentArea);
            }
        });
        UIUtils.fixFocusTraversalKeys((JComponent)this.addCommentArea);
        this.commentsPanel = new CommentsPanel();
        this.commentsPanel.setNewCommentHandler(new CommentsPanel.NewCommentHandler(){

            @Override
            public void append(String text) {
                IssuePanel.this.addCommentArea.append(text);
                IssuePanel.this.addCommentArea.requestFocus();
                IssuePanel.this.scrollRectToVisible(IssuePanel.this.scrollPane1.getBounds());
            }
        });
        this.attachmentsPanel = new AttachmentsPanel();
        GroupLayout layout = (GroupLayout)this.getLayout();
        layout.replace(this.dummyCommentsPanel, this.commentsPanel);
        layout.replace(this.dummyAttachmentsPanel, this.attachmentsPanel);
        layout.replace(this.dummyTimetrackingPanel, this.timetrackingPanel);
        this.attachmentsLabel.setLabelFor(this.attachmentsPanel);
        this.initSpellChecker();
        this.initDefaultButton();
        UIUtils.issue163946Hack((JScrollPane)this.scrollPane1);
    }

    private void initDefaultButton() {
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "submit");
        ActionMap actionMap = this.getActionMap();
        AbstractAction submitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IssuePanel.this.submitButton.isEnabled()) {
                    IssuePanel.this.submitButtonActionPerformed(null);
                }
            }
        };
        actionMap.put("submit", submitAction);
    }

    private void updateReadOnlyField(JTextField field) {
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            field.setUI(new BasicTextFieldUI());
        }
        field.setBackground(this.getBackground());
        Caret caret = field.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
    }

    void reloadFormInAWT(final boolean force) {
        if (EventQueue.isDispatchThread()) {
            this.reloadForm(force);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IssuePanel.this.reloadForm(force);
                }
            });
        }
    }

    BugzillaIssue getIssue() {
        return this.issue;
    }

    public void setIssue(BugzillaIssue issue) {
        assert (SwingUtilities.isEventDispatchThread()) : "Accessing Swing components. Do not call outside event-dispatch thread!";
        if (this.issue == null) {
            IssueCache<BugzillaIssue, TaskData> cache = issue.getRepository().getIssueCache();
            cache.removePropertyChangeListener((Object)issue, this.cacheListener);
            cache.addPropertyChangeListener((Object)issue, this.cacheListener);
            this.summaryField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    IssuePanel.this.updateNoSummary();
                }
            });
            this.keywordsField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    IssuePanel.this.updateInvalidKeyword();
                }
            });
        }
        this.issue = issue;
        this.initCombos();
        this.initCustomFields();
        List<String> kws = issue.getRepository().getConfiguration().getKeywords();
        this.keywords.clear();
        for (String keyword : kws) {
            this.keywords.add(keyword.toUpperCase());
        }
        boolean showQAContact = BugzillaUtil.showQAContact(issue.getRepository());
        if (this.qaContactLabel.isVisible() != showQAContact) {
            GroupLayout layout = (GroupLayout)this.getLayout();
            JLabel temp = new JLabel();
            IssuePanel.swap(layout, this.ccLabel, this.qaContactLabel, temp);
            IssuePanel.swap(layout, this.ccField, this.qaContactField, temp);
            this.qaContactLabel.setVisible(showQAContact);
            this.qaContactField.setVisible(showQAContact);
        }
        boolean showStatusWhiteboard = BugzillaUtil.showStatusWhiteboard(issue.getRepository());
        this.statusWhiteboardLabel.setVisible(showStatusWhiteboard);
        this.statusWhiteboardField.setVisible(showStatusWhiteboard);
        this.statusWhiteboardWarning.setVisible(showStatusWhiteboard);
        boolean showIssueType = BugzillaUtil.showIssueType(issue.getRepository());
        this.issueTypeLabel.setVisible(false);
        this.issueTypeCombo.setVisible(showIssueType);
        this.issueTypeWarning.setVisible(showIssueType);
        this.severityCombo.setVisible(!showIssueType);
        this.severityWarning.setVisible(!showIssueType);
        if (showIssueType) {
            GroupLayout layout = (GroupLayout)this.getLayout();
            JLabel temp = new JLabel();
            IssuePanel.swap(layout, this.severityCombo, this.issueTypeCombo, temp);
            IssuePanel.swap(layout, this.severityWarning, this.issueTypeWarning, temp);
        }
        this.tasklistButton.setEnabled(false);
        this.reloadForm(true);
        if (issue.isNew()) {
            if (BugtrackingUtil.isNbRepository((String)issue.getRepository().getUrl())) {
                this.ownerInfo = issue.getOwnerInfo();
                if (this.ownerInfo == null) {
                    Node[] selection = WindowManager.getDefault().getRegistry().getActivatedNodes();
                    this.ownerInfo = issue.getRepository().getOwnerInfo(selection);
                }
                this.addNetbeansInfo();
            }
            this.selectProduct();
        }
        Dimension dim = this.ccField.getPreferredSize();
        int width1 = Math.max(this.osCombo.getPreferredSize().width, this.platformCombo.getPreferredSize().width);
        int width2 = Math.max(this.priorityCombo.getPreferredSize().width, showIssueType ? this.issueTypeCombo.getPreferredSize().width : this.severityCombo.getPreferredSize().width);
        int gap = LayoutStyle.getInstance().getPreferredGap(this.osCombo, this.platformCombo, LayoutStyle.ComponentPlacement.RELATED, 3, this);
        this.ccField.setPreferredSize(new Dimension(2 * Math.max(width1, width2) + gap, dim.height));
    }

    private void selectProduct() {
        if (this.ownerInfo != null) {
            String owner = this.findInModel(this.productCombo, this.ownerInfo.getOwner());
            this.selectInCombo(this.productCombo, owner, true);
            List data = this.ownerInfo.getExtraData();
            if (data != null && data.size() > 0) {
                String component = this.findInModel(this.componentCombo, (String)data.get(0));
                this.selectInCombo(this.componentCombo, component, true);
            }
        } else {
            BugzillaRepository repository = this.issue.getRepository();
            if (repository instanceof KenaiRepository) {
                String productName = ((KenaiRepository)repository).getProductName();
                this.selectInCombo(this.productCombo, productName, true);
            } else if (BugzillaUtil.isNbRepository(repository)) {
                String defaultProduct = "ide";
                String defaultComponent = "Code";
                this.productCombo.setSelectedItem(defaultProduct);
                this.componentCombo.setSelectedItem(defaultComponent);
            } else {
                this.productCombo.setSelectedIndex(0);
            }
        }
    }

    private String findInModel(JComboBox combo, String value) {
        ComboBoxModel model = combo.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String element = model.getElementAt(i).toString();
            if (!value.toLowerCase().equals(element.toString().toLowerCase())) continue;
            return element;
        }
        return null;
    }

    private static void swap(GroupLayout layout, JComponent comp1, JComponent comp2, JComponent temp) {
        layout.replace(comp1, temp);
        layout.replace(comp2, comp1);
        layout.replace(temp, comp2);
    }

    void reloadForm(boolean force) {
        String message;
        if (this.skipReload) {
            return;
        }
        int noWarnings = this.fieldWarnings.size();
        int noErrors = this.fieldErrors.size();
        if (force) {
            this.fieldWarnings.clear();
            this.fieldErrors.clear();
        }
        this.reloading = true;
        boolean isNew = this.issue.getTaskData().isNew();
        boolean showProductCombo = isNew || !(this.issue.getRepository() instanceof KenaiRepository) || BugzillaUtil.isNbRepository(this.issue.getRepository());
        boolean hasTimeTracking = !isNew && this.issue.hasTimeTracking();
        GroupLayout layout = (GroupLayout)this.getLayout();
        if (showProductCombo) {
            if (this.productCombo.getParent() == null) {
                layout.replace(this.productField, this.productCombo);
            }
        } else if (this.productField.getParent() == null) {
            layout.replace(this.productCombo, this.productField);
        }
        this.productLabel.setLabelFor(isNew ? this.productCombo : this.productField);
        boolean isNetbeans = BugtrackingUtil.isNbRepository((String)this.issue.getRepository().getUrl());
        if (isNew && isNetbeans) {
            this.attachLogCheckBox.setVisible(true);
            this.attachLogCheckBox.setSelected(BugzillaConfig.getInstance().getAttachLogFile());
        } else {
            this.attachLogCheckBox.setVisible(false);
        }
        this.headerField.setVisible(!isNew);
        this.statusCombo.setEnabled(!isNew);
        Mnemonics.setLocalizedText((JLabel)this.addCommentLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)(isNew ? "IssuePanel.description" : "IssuePanel.addCommentLabel.text")));
        this.reportedLabel.setVisible(!isNew);
        this.reportedField.setVisible(!isNew);
        this.modifiedLabel.setVisible(!isNew);
        this.modifiedField.setVisible(!isNew);
        this.assignToDefaultCheckBox.setVisible(!isNew && this.issue.canAssignToDefault());
        this.assignToDefaultCheckBox.setSelected(false);
        this.statusLabel.setVisible(!isNew);
        this.statusCombo.setVisible(!isNew);
        this.resolutionLabel.setVisible(!isNew);
        this.timetrackingLabel.setVisible(hasTimeTracking);
        this.timetrackingPanel.setVisible(hasTimeTracking);
        this.dummyTimetrackingLabel.setVisible(hasTimeTracking);
        this.separator.setVisible(!isNew);
        this.commentsPanel.setVisible(!isNew);
        this.attachmentsLabel.setVisible(!isNew);
        this.attachmentsPanel.setVisible(!isNew);
        this.dummyLabel3.setVisible(!isNew);
        this.refreshButton.setVisible(!isNew);
        this.separatorLabel.setVisible(!isNew);
        this.cancelButton.setVisible(!isNew);
        this.separatorLabel3.setVisible(!isNew);
        this.showInBrowserButton.setVisible(!isNew);
        Border sep2Border = BorderFactory.createLineBorder(Color.BLACK);
        if (isNew) {
            int gap = LayoutStyle.getInstance().getPreferredGap(this.separatorLabel2, (JComponent)this.reloadButton, LayoutStyle.ComponentPlacement.RELATED, 7, null);
            sep2Border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, gap), sep2Border);
        }
        this.separatorLabel2.setBorder(sep2Border);
        this.assignedField.setEditable(this.issue.isNew() || this.issue.canReassign());
        this.assignedCombo.setEnabled(this.assignedField.isEditable());
        Mnemonics.setLocalizedText((AbstractButton)this.submitButton, (String)NbBundle.getMessage(IssuePanel.class, (String)(isNew ? "IssuePanel.submitButton.text.new" : "IssuePanel.submitButton.text")));
        if (isNew && force) {
            this.selectProduct();
            this.initStatusCombo("NEW");
        } else {
            String selectedAssignee;
            String format = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.headerLabel.format");
            String headerTxt = MessageFormat.format(format, this.issue.getID(), this.issue.getSummary());
            this.headerField.setText(headerTxt);
            Dimension dim = this.headerField.getPreferredSize();
            this.headerField.setMinimumSize(new Dimension(0, dim.height));
            this.headerField.setPreferredSize(new Dimension(0, dim.height));
            this.reloadField(force, (JComponent)this.summaryField, IssueField.SUMMARY, this.summaryWarning, this.summaryLabel);
            this.reloadField(force, (JComponent)this.productCombo, IssueField.PRODUCT, this.productWarning, this.productLabel);
            this.reloadField(force, (JComponent)this.productField, IssueField.PRODUCT, null, (String)null);
            this.reloadField(force, (JComponent)this.componentCombo, IssueField.COMPONENT, this.componentWarning, this.componentLabel);
            this.reloadField(force, (JComponent)this.versionCombo, IssueField.VERSION, this.versionWarning, this.versionLabel);
            this.reloadField(force, (JComponent)this.platformCombo, IssueField.PLATFORM, this.platformWarning, this.platformLabel);
            this.reloadField(force, (JComponent)this.osCombo, IssueField.OS, this.osWarning, this.platformLabel);
            this.reloadField(force, (JComponent)this.resolutionField, IssueField.RESOLUTION, null, (String)null);
            String status = this.reloadField(force, (JComponent)this.statusCombo, IssueField.STATUS, this.statusWarning, this.statusLabel);
            this.initStatusCombo(status);
            this.reloadField(force, (JComponent)this.resolutionCombo, IssueField.RESOLUTION, this.resolutionWarning, this.resolutionLabel);
            String initialResolution = this.initialValues.get(IssueField.RESOLUTION.getKey());
            if ("DUPLICATE".equals(initialResolution)) {
                this.duplicateField.setEditable(false);
                this.duplicateField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.duplicateField.setBackground(this.getBackground());
            } else {
                JTextField field = new JTextField();
                this.duplicateField.setEditable(true);
                this.duplicateField.setBorder(field.getBorder());
                this.duplicateField.setBackground(field.getBackground());
            }
            this.reloadField(force, (JComponent)this.priorityCombo, IssueField.PRIORITY, this.priorityWarning, this.priorityLabel);
            if (BugzillaUtil.isNbRepository(this.issue.getRepository())) {
                this.reloadField(force, (JComponent)this.issueTypeCombo, IssueField.ISSUE_TYPE, this.issueTypeWarning, this.issueTypeLabel);
            }
            this.reloadField(force, (JComponent)this.severityCombo, IssueField.SEVERITY, this.severityWarning, this.priorityLabel);
            if (this.usingTargetMilestones) {
                this.reloadField(force, (JComponent)this.targetMilestoneCombo, IssueField.MILESTONE, this.milestoneWarning, this.targetMilestoneLabel);
            }
            this.reloadField(force, (JComponent)this.urlField, IssueField.URL, this.urlWarning, this.fieldName((JComponent)this.urlLabel));
            this.reloadField(force, (JComponent)this.statusWhiteboardField, IssueField.WHITEBOARD, this.statusWhiteboardWarning, this.statusWhiteboardLabel);
            this.reloadField(force, (JComponent)this.keywordsField, IssueField.KEYWORDS, this.keywordsWarning, this.keywordsLabel);
            boolean isKenaiRepository = this.issue.getRepository() instanceof KenaiRepository;
            if (!isNew) {
                Date modification;
                format = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reportedLabel.format");
                Date creation = this.issue.getCreatedDate();
                String creationTxt = creation != null ? DateFormat.getDateInstance(2).format(creation) : "";
                String reporterName = this.issue.getFieldValue(IssueField.REPORTER_NAME);
                String reporter = this.issue.getFieldValue(IssueField.REPORTER);
                String reporterTxt = reporterName == null || reporterName.trim().length() == 0 ? reporter : reporterName;
                String reportedTxt = MessageFormat.format(format, creationTxt, reporterTxt);
                this.reportedField.setText(reportedTxt);
                IssuePanel.fixPrefSize(this.reportedField);
                if (isKenaiRepository && this.reportedStatusLabel.getIcon() == null) {
                    int index = reporter.indexOf(64);
                    String userName = index == -1 ? reporter : reporter.substring(0, index);
                    String host = ((KenaiRepository)this.issue.getRepository()).getHost();
                    JLabel label = KenaiUtil.createUserWidget((String)userName, (String)host, (String)KenaiUtil.getChatLink((String)this.issue.getID()));
                    label.setText(null);
                    ((GroupLayout)this.getLayout()).replace(this.reportedStatusLabel, label);
                    this.reportedStatusLabel = label;
                }
                String modifiedTxt = (modification = this.issue.getCreatedDate()) != null ? DateFormat.getDateTimeInstance().format(modification) : "";
                this.modifiedField.setText(modifiedTxt);
                IssuePanel.fixPrefSize(this.modifiedField);
                if (hasTimeTracking) {
                    BugzillaIssue.Comment[] comments;
                    String actualString;
                    this.reloadField(force, (JComponent)this.estimatedField, IssueField.ESTIMATED_TIME, this.estimatedWarning, this.estimatedLabel);
                    this.reloadField(force, (JComponent)this.workedField, IssueField.WORK_TIME, this.workedWarning, this.workedLabel);
                    this.reloadField(force, (JComponent)this.remainingField, IssueField.REMAINING_TIME, this.remainingWarning, this.remainingLabel);
                    this.reloadField(force, (JComponent)this.deadlineField, IssueField.DEADLINE, this.deadlineWarning, this.deadlineLabel);
                    if ("".equals(this.deadlineField.getText().trim())) {
                        this.deadlineField.setText(YYYY_MM_DD);
                        this.deadlineField.setForeground(UIManager.getDefaults().getColor("TextField.inactiveForeground"));
                    }
                    if ((actualString = this.issue.getFieldValue(IssueField.ACTUAL_TIME)).trim().equals("")) {
                        actualString = "0";
                    }
                    this.actualField.setText(String.valueOf(Double.parseDouble(actualString) + this.getDoubleValue(this.remainingField)));
                    double worked = 0.0;
                    for (BugzillaIssue.Comment comment : comments = this.issue.getComments()) {
                        worked += comment.getWorked().doubleValue();
                    }
                    this.workedSumField.setText(String.valueOf(worked));
                    this.gainField.setText(String.valueOf(this.getDoubleValue(this.estimatedField) - this.getDoubleValue(this.remainingField)));
                    this.completeField.setText(String.valueOf((int)Math.floor(this.getDoubleValue(this.workedSumField) / this.getDoubleValue(this.actualField) * 100.0)));
                }
            }
            String assignee = this.issue.getFieldValue(IssueField.ASSIGNED_TO);
            String string = selectedAssignee = this.assignedField.getParent() == null ? this.assignedCombo.getSelectedItem().toString() : this.assignedField.getText();
            if (isKenaiRepository && assignee.trim().length() > 0 && (force || !selectedAssignee.equals(assignee))) {
                int index = assignee.indexOf(64);
                String userName = index == -1 ? assignee : assignee.substring(0, index);
                String host = ((KenaiRepository)this.issue.getRepository()).getHost();
                JLabel label = KenaiUtil.createUserWidget((String)userName, (String)host, (String)KenaiUtil.getChatLink((String)this.issue.getID()));
                label.setText(null);
                ((GroupLayout)this.getLayout()).replace(this.assignedToStatusLabel, label);
                label.setVisible(this.assignedToStatusLabel.isVisible());
                this.assignedToStatusLabel = label;
            }
            if (force) {
                this.assignedToStatusLabel.setVisible(assignee.trim().length() > 0);
            }
            if (this.assignedField.getParent() == null) {
                this.reloadField(force, (JComponent)this.assignedCombo, IssueField.ASSIGNED_TO, this.assignedToWarning, this.assignedLabel);
            } else {
                this.reloadField(force, (JComponent)this.assignedField, IssueField.ASSIGNED_TO, this.assignedToWarning, this.assignedLabel);
            }
            this.reloadField(force, (JComponent)this.qaContactField, IssueField.QA_CONTACT, this.qaContactWarning, this.qaContactLabel);
            this.reloadField(force, (JComponent)this.ccField, IssueField.CC, this.ccWarning, this.ccLabel);
            this.reloadField(force, (JComponent)this.dependsField, IssueField.DEPENDS_ON, this.dependsOnWarning, this.dependsLabel);
            this.reloadField(force, (JComponent)this.blocksField, IssueField.BLOCKS, this.blocksWarning, this.blocksLabel);
            this.reloadCustomFields(force);
        }
        int newCommentCount = this.issue.getComments().length;
        if (!force && this.oldCommentCount != newCommentCount && !this.fieldWarnings.contains(message = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.commentAddedWarning"))) {
            this.fieldWarnings.add(0, message);
        }
        this.oldCommentCount = newCommentCount;
        List<BugzillaIssue.Attachment> attachments = this.issue.getAttachments();
        if (!isNew) {
            this.commentsPanel.setIssue(this.issue, attachments);
        }
        this.attachmentsPanel.setAttachments(attachments, isNetbeans);
        UIUtils.keepFocusedComponentVisible((Component)this.commentsPanel);
        UIUtils.keepFocusedComponentVisible((Component)this.attachmentsPanel);
        if (force && !isNew) {
            this.addCommentArea.setText("");
        }
        this.updateTasklistButton();
        this.updateFieldStatuses();
        this.updateNoSummary();
        if (this.fieldWarnings.size() != noWarnings || this.fieldErrors.size() != noErrors) {
            this.updateMessagePanel();
        }
        this.reloading = false;
    }

    private void reloadCustomFields(boolean force) {
        for (CustomFieldInfo field : this.customFields) {
            this.reloadField(force, field.comp, (IssueField)field.field, field.warning, field.label);
        }
    }

    private static void fixPrefSize(JTextField textField) {
        textField.setPreferredSize(null);
        Dimension dim = textField.getPreferredSize();
        Dimension fixedDim = new Dimension(dim.width + 1, dim.height);
        textField.setPreferredSize(fixedDim);
    }

    private String reloadField(boolean force, JComponent component, IssueField field, JLabel warningLabel, JLabel fieldLabel) {
        return this.reloadField(force, component, field, warningLabel, this.fieldName(fieldLabel));
    }

    private String reloadField(boolean force, JComponent component, IssueField field, JLabel warningLabel, String fieldName) {
        String message;
        boolean valueModifiedByServer;
        String newValue;
        String currentValue = null;
        boolean isNew = this.issue.getTaskData().isNew();
        if (!force) {
            if (component instanceof JComboBox) {
                Object value = ((JComboBox)component).getSelectedItem();
                currentValue = value == null ? "" : value.toString();
            } else if (component instanceof JTextComponent) {
                currentValue = ((JTextComponent)component).getText();
            } else if (component instanceof JList) {
                JList list = (JList)component;
                StringBuilder sb = new StringBuilder();
                for (Object value : list.getSelectedValues()) {
                    if (sb.length() != 0) {
                        sb.append(',');
                    }
                    sb.append(value);
                }
                currentValue = sb.toString();
            }
        }
        String initialValue = this.initialValues.get(field.getKey());
        if (component instanceof JList) {
            StringBuilder sb = new StringBuilder();
            for (String value : this.issue.getFieldValues(field)) {
                if (sb.length() != 0) {
                    sb.append(',');
                }
                sb.append(value);
            }
            newValue = sb.toString();
        } else {
            newValue = this.issue.getFieldValue(field);
        }
        boolean valueModifiedByUser = currentValue != null && initialValue != null && !currentValue.equals(initialValue);
        boolean bl = valueModifiedByServer = initialValue != null && newValue != null && !initialValue.equals(newValue);
        if (force || !valueModifiedByUser) {
            if (component instanceof JComboBox) {
                JComboBox combo = (JComboBox)component;
                this.selectInCombo(combo, newValue, true);
            } else if (component instanceof JTextComponent) {
                ((JTextComponent)component).setText(newValue);
            } else if (component instanceof JList) {
                JList list = (JList)component;
                list.clearSelection();
                ListModel model = list.getModel();
                for (String value : this.issue.getFieldValues(field)) {
                    for (int i = 0; i < model.getSize(); ++i) {
                        if (!value.equals(model.getElementAt(i))) continue;
                        list.addSelectionInterval(i, i);
                    }
                }
            }
            if (force) {
                if (warningLabel != null) {
                    warningLabel.setIcon(null);
                }
            } else if (!isNew && valueModifiedByServer && warningLabel != null) {
                warningLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/warning.gif", (boolean)true));
                String messageFormat = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.fieldModifiedWarning");
                message = MessageFormat.format(messageFormat, fieldName, currentValue, newValue);
                this.fieldWarnings.add(message);
                warningLabel.setToolTipText(message);
            }
            currentValue = newValue;
        } else if (!isNew && valueModifiedByServer && warningLabel != null) {
            warningLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/error.gif", (boolean)true));
            String messageFormat = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.fieldModifiedError");
            message = MessageFormat.format(messageFormat, fieldName, newValue);
            this.fieldErrors.add(message);
            warningLabel.setToolTipText(message);
        }
        if (IssueField.SUMMARY == field || IssueField.PLATFORM == field || IssueField.PRIORITY == field || field instanceof CustomIssueField) {
            warningLabel.setVisible(warningLabel.getIcon() != null);
        }
        this.initialValues.put(field.getKey(), newValue);
        return currentValue;
    }

    private boolean selectInCombo(JComboBox combo, Object value, boolean forceInModel) {
        ComboBoxModel model;
        if (value == null) {
            return false;
        }
        combo.setSelectedItem(value);
        if (forceInModel && !value.equals("") && !value.equals(combo.getSelectedItem()) && (model = combo.getModel()) instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)model).insertElementAt(value, 0);
            combo.setSelectedIndex(0);
        }
        return value.equals(combo.getSelectedItem());
    }

    private String fieldName(JComponent fieldLabel) {
        assert (fieldLabel instanceof JLabel || fieldLabel instanceof JButton);
        String txt = "";
        if (fieldLabel instanceof JLabel) {
            txt = ((JLabel)fieldLabel).getText().trim();
        } else if (fieldLabel instanceof JButton) {
            txt = ((JButton)fieldLabel).getText().trim();
        } else {
            return null;
        }
        if (txt.endsWith(":")) {
            txt = txt.substring(0, txt.length() - 1);
        }
        return txt;
    }

    private void initCombos() {
        BugzillaRepository repository = this.issue.getRepository();
        BugzillaConfiguration bc = repository.getConfiguration();
        if (bc == null || !bc.isValid()) {
            return;
        }
        this.productCombo.setModel(this.toComboModel(bc.getProducts()));
        this.platformCombo.setModel(this.toComboModel(bc.getPlatforms()));
        this.osCombo.setModel(this.toComboModel(bc.getOSs()));
        LinkedList<String> resolutions = new LinkedList<String>(bc.getResolutions());
        resolutions.remove("MOVED");
        this.resolutionCombo.setModel(this.toComboModel(resolutions));
        this.priorityCombo.setModel(this.toComboModel(bc.getPriorities()));
        this.priorityCombo.setRenderer(new PriorityRenderer());
        this.severityCombo.setModel(this.toComboModel(bc.getSeverities()));
        this.initAssignedCombo();
        if (BugzillaUtil.isNbRepository(repository)) {
            this.issueTypeCombo.setModel(this.toComboModel(bc.getIssueTypes()));
        }
    }

    private void initAssignedCombo() {
        this.assignedCombo.setRenderer(new RepositoryUserRenderer());
        RP.post(new Runnable(){

            @Override
            public void run() {
                BugzillaRepository repository = IssuePanel.this.issue.getRepository();
                final Collection<RepositoryUser> users = repository.getUsers();
                final DefaultComboBoxModel<RepositoryUser> assignedModel = new DefaultComboBoxModel<RepositoryUser>();
                for (RepositoryUser user : users) {
                    assignedModel.addElement(user);
                }
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        IssuePanel.this.reloading = true;
                        try {
                            Object assignee;
                            Object object = assignee = IssuePanel.this.assignedField.getParent() == null ? IssuePanel.this.assignedCombo.getSelectedItem() : IssuePanel.this.assignedField.getText();
                            if (assignee == null) {
                                assignee = "";
                            }
                            IssuePanel.this.assignedCombo.setModel(assignedModel);
                            GroupLayout layout = (GroupLayout)IssuePanel.this.getLayout();
                            if (IssuePanel.this.assignedCombo.getParent() == null != users.isEmpty()) {
                                layout.replace(users.isEmpty() ? IssuePanel.this.assignedCombo : IssuePanel.this.assignedField, users.isEmpty() ? IssuePanel.this.assignedField : IssuePanel.this.assignedCombo);
                                IssuePanel.this.assignedLabel.setLabelFor(users.isEmpty() ? IssuePanel.this.assignedField : IssuePanel.this.assignedCombo);
                            }
                            if (IssuePanel.this.assignedField.getParent() == null) {
                                IssuePanel.this.assignedCombo.setSelectedItem(assignee);
                            } else {
                                IssuePanel.this.assignedField.setText(assignee.toString());
                            }
                        }
                        finally {
                            IssuePanel.this.reloading = false;
                        }
                    }
                });
            }
        });
    }

    private void initStatusCombo(String status) {
        BugzillaRepository repository = this.issue.getRepository();
        BugzillaConfiguration bc = repository.getConfiguration();
        if (bc == null || !bc.isValid()) {
            return;
        }
        List<String> allStatuses = bc.getStatusValues();
        List<String> openStatuses = bc.getOpenStatusValues();
        LinkedList<String> statuses = new LinkedList<String>();
        boolean oldRepository = this.issue.getRepository().getConfiguration().getInstalledVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_2) < 0;
        String nev = "NEW";
        String unconfirmed = "UNCONFIRMED";
        String reopened = "REOPENED";
        String resolved = "RESOLVED";
        if (status != null) {
            status = status.trim();
        }
        if (openStatuses.contains(status)) {
            statuses.addAll(openStatuses);
            if (!unconfirmed.equals(status)) {
                statuses.remove(unconfirmed);
            }
            if (!reopened.equals(status)) {
                statuses.remove(reopened);
            }
            if (oldRepository && !nev.equals(status)) {
                statuses.remove(nev);
            }
            statuses.add(resolved);
        } else {
            if (allStatuses.contains(reopened)) {
                statuses.add(reopened);
            } else {
                statuses.addAll(openStatuses);
                statuses.remove(unconfirmed);
                if (oldRepository) {
                    statuses.remove(nev);
                }
            }
            if (resolved.equals(status)) {
                LinkedList<String> closedStatuses = new LinkedList<String>(allStatuses);
                closedStatuses.removeAll(openStatuses);
                statuses.addAll(closedStatuses);
            } else {
                if (!oldRepository) {
                    statuses.add(resolved);
                }
                if (allStatuses.contains(status)) {
                    if (!status.equals("")) {
                        for (int i = allStatuses.indexOf(status); i < allStatuses.size(); ++i) {
                            String s = allStatuses.get(i);
                            if (openStatuses.contains(s)) continue;
                            statuses.add(s);
                        }
                    }
                } else {
                    Bugzilla.LOG.log(Level.WARNING, "status value {0} not between all statuses: {1}", new Object[]{status, allStatuses});
                }
            }
            this.resolvedIndex = statuses.indexOf(resolved);
        }
        this.statusCombo.setModel(this.toComboModel(statuses));
        this.statusCombo.setSelectedItem(status);
    }

    private ComboBoxModel toComboModel(List<String> items) {
        return new DefaultComboBoxModel<Object>(items.toArray());
    }

    private void updateFieldStatuses() {
        this.updateFieldStatus(IssueField.SUMMARY, this.summaryLabel);
        this.updateFieldStatus(IssueField.PRODUCT, this.productLabel);
        this.updateFieldStatus(IssueField.COMPONENT, this.componentLabel);
        this.updateFieldStatus(IssueField.VERSION, this.versionLabel);
        this.updateFieldStatus(IssueField.PLATFORM, this.platformLabel);
        this.updateFieldStatus(IssueField.OS, this.platformLabel);
        this.updateFieldStatus(IssueField.STATUS, this.statusLabel);
        this.updateFieldStatus(IssueField.RESOLUTION, this.resolutionLabel);
        this.updateFieldStatus(IssueField.PRIORITY, this.priorityLabel);
        this.updateFieldStatus(IssueField.SEVERITY, this.priorityLabel);
        this.updateFieldStatus(IssueField.MILESTONE, this.targetMilestoneLabel);
        this.updateFieldStatus(IssueField.URL, (JComponent)this.urlLabel);
        this.updateFieldStatus(IssueField.WHITEBOARD, this.statusWhiteboardLabel);
        this.updateFieldStatus(IssueField.KEYWORDS, this.keywordsLabel);
        this.updateFieldStatus(IssueField.ASSIGNED_TO, this.assignedLabel);
        this.updateFieldStatus(IssueField.QA_CONTACT, this.qaContactLabel);
        this.updateFieldStatus(IssueField.CC, this.ccLabel);
        this.updateFieldStatus(IssueField.DEPENDS_ON, this.dependsLabel);
        this.updateFieldStatus(IssueField.BLOCKS, this.blocksLabel);
        this.updateFieldStatus(IssueField.ESTIMATED_TIME, this.estimatedLabel);
        this.updateFieldStatus(IssueField.REMAINING_TIME, this.remainingLabel);
        this.updateFieldStatus(IssueField.WORK_TIME, this.timetrackingLabel);
        this.updateFieldStatus(IssueField.DEADLINE, this.deadlineLabel);
        if (BugzillaUtil.isNbRepository(this.issue.getRepository())) {
            this.updateFieldStatus(IssueField.ISSUE_TYPE, this.issueTypeLabel);
        }
        for (CustomFieldInfo field : this.customFields) {
            this.updateFieldStatus(field.field, field.label);
        }
    }

    private void updateFieldStatus(IssueField field, JComponent label) {
        assert (label instanceof JButton || label instanceof JLabel);
        boolean highlight = !this.issue.getTaskData().isNew() && this.issue.getFieldStatus(field) != 1;
        label.setOpaque(highlight);
        if (highlight) {
            label.setBackground(HIGHLIGHT_COLOR);
        }
    }

    private void cancelHighlight(JComponent label) {
        if (!this.reloading) {
            label.setOpaque(false);
            label.getParent().repaint();
        }
    }

    private void storeFieldValue(IssueField field, JComboBox combo) {
        Object value = combo.getSelectedItem();
        if (value != null) {
            this.storeFieldValue(field, value.toString());
        }
    }

    private void storeFieldValue(IssueField field, JTextComponent textComponent) {
        this.storeFieldValue(field, textComponent.getText());
    }

    private void storeFieldValue(IssueField field, JList list) {
        ArrayList<String> values = new ArrayList<String>();
        for (Object value : list.getSelectedValues()) {
            values.add(value.toString());
        }
        this.issue.setFieldValues(field, values);
    }

    private void storeFieldValue(IssueField field, String value) {
        if (this.issue.getTaskData().isNew() || !value.equals(this.initialValues.get(field.getKey()))) {
            if (field == IssueField.STATUS) {
                if (value.equals("CLOSED")) {
                    this.issue.close();
                } else if (value.equals("VERIFIED")) {
                    this.issue.verify();
                } else if (value.equals("REOPENED")) {
                    this.issue.reopen();
                } else if (value.equals("RESOLVED")) {
                    this.issue.resolve(this.resolutionCombo.getSelectedItem().toString());
                } else if (value.equals("ASSIGNED")) {
                    this.issue.accept();
                }
            } else if (field == IssueField.ASSIGNED_TO && !this.issue.isNew()) {
                this.issue.reassign(value);
            }
            this.issue.setFieldValue(field, value);
        }
    }

    private void attachDocumentListeners() {
        this.urlField.getDocument().addDocumentListener(new CancelHighlightDocumentListener((JComponent)this.urlLabel));
        this.statusWhiteboardField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.statusWhiteboardLabel));
        this.keywordsField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.keywordsLabel));
        this.assignedField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.assignedLabel));
        this.qaContactField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.qaContactLabel));
        this.ccField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.ccLabel));
        this.blocksField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.blocksLabel));
        this.dependsField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.dependsLabel));
        CyclicDependencyDocumentListener cyclicDependencyListener = new CyclicDependencyDocumentListener();
        this.blocksField.getDocument().addDocumentListener(cyclicDependencyListener);
        this.dependsField.getDocument().addDocumentListener(cyclicDependencyListener);
        this.addCommentArea.getDocument().addDocumentListener(new RevalidatingListener());
        this.duplicateField.getDocument().addDocumentListener(new DuplicateListener());
    }

    private void attachHideStatusListener() {
        this.assignedField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!IssuePanel.this.reloading) {
                    IssuePanel.this.assignedToStatusLabel.setVisible(false);
                }
            }
        });
    }

    private void updateNoSummary() {
        if (this.summaryField.getText().trim().length() == 0) {
            if (!this.noSummary) {
                this.noSummary = true;
                this.updateMessagePanel();
            }
        } else if (this.noSummary) {
            this.noSummary = false;
            this.updateMessagePanel();
        }
    }

    private void updateInvalidKeyword() {
        boolean invalidFound = false;
        StringTokenizer st = new StringTokenizer(this.keywordsField.getText(), ", \t\n\r\f");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (this.keywords.contains(token.toUpperCase())) continue;
            invalidFound = true;
            break;
        }
        if (invalidFound != this.invalidKeyword) {
            this.invalidKeyword = invalidFound;
            this.updateMessagePanel();
        }
    }

    private void updateNoComponent() {
        boolean newNoComponent;
        boolean bl = newNoComponent = this.componentCombo.getSelectedItem() == null;
        if (this.noComponent != newNoComponent) {
            this.noComponent = newNoComponent;
            this.updateMessagePanel();
        }
    }

    private void updateNoVersion() {
        boolean newNoVersion;
        boolean bl = newNoVersion = this.versionCombo.getSelectedItem() == null;
        if (this.noVersion != newNoVersion) {
            this.noVersion = newNoVersion;
            this.updateMessagePanel();
        }
    }

    private void updateNoTargetMilestone() {
        boolean newNoTargetMilestone;
        boolean bl = newNoTargetMilestone = this.targetMilestoneCombo.getSelectedItem() == null;
        if (this.noTargetMilestione != newNoTargetMilestone) {
            this.noTargetMilestione = newNoTargetMilestone;
            this.updateMessagePanel();
        }
    }

    private void updateMessagePanel() {
        this.messagePanel.removeAll();
        if (this.noComponent) {
            this.addMessage("IssuePanel.noComponent");
        }
        if (this.noVersion) {
            this.addMessage("IssuePanel.noVersion");
        }
        if (this.noTargetMilestione) {
            this.addMessage("IssuePanel.noTargetMilestone");
        }
        if (this.noSummary) {
            JLabel noSummaryLabel = new JLabel();
            noSummaryLabel.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.noSummary"));
            String icon = this.issue.getTaskData().isNew() ? "org/netbeans/modules/bugzilla/resources/info.png" : "org/netbeans/modules/bugzilla/resources/error.gif";
            noSummaryLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)icon)));
            this.messagePanel.add(noSummaryLabel);
        }
        if (this.cyclicDependency) {
            JLabel cyclicDependencyLabel = new JLabel();
            cyclicDependencyLabel.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.cyclicDependency"));
            cyclicDependencyLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugzilla/resources/error.gif")));
            this.messagePanel.add(cyclicDependencyLabel);
        }
        if (this.invalidKeyword) {
            JLabel invalidKeywordLabel = new JLabel();
            invalidKeywordLabel.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.invalidKeyword"));
            invalidKeywordLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugzilla/resources/error.gif")));
            this.messagePanel.add(invalidKeywordLabel);
        }
        if (this.noDuplicateId) {
            JLabel noDuplicateLabel = new JLabel();
            noDuplicateLabel.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.noDuplicateId"));
            noDuplicateLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugzilla/resources/error.gif")));
            this.messagePanel.add(noDuplicateLabel);
        }
        if (this.noSummary || this.cyclicDependency || this.invalidKeyword || this.noComponent || this.noVersion || this.noTargetMilestione || this.noDuplicateId) {
            this.submitButton.setEnabled(false);
        } else {
            this.submitButton.setEnabled(true);
        }
        for (String fieldError : this.fieldErrors) {
            JLabel errorLabel = new JLabel(fieldError);
            errorLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/error.gif", (boolean)true));
            this.messagePanel.add(errorLabel);
        }
        for (String fieldWarning : this.fieldWarnings) {
            JLabel warningLabel = new JLabel(fieldWarning);
            warningLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/warning.gif", (boolean)true));
            this.messagePanel.add(warningLabel);
        }
        if (this.noSummary || this.cyclicDependency || this.invalidKeyword || this.noComponent || this.noVersion || this.noTargetMilestione || this.noDuplicateId || this.fieldErrors.size() + this.fieldWarnings.size() > 0) {
            this.messagePanel.setVisible(true);
            this.messagePanel.revalidate();
        } else {
            this.messagePanel.setVisible(false);
        }
    }

    void addMessage(String messageKey) {
        JLabel messageLabel = new JLabel();
        messageLabel.setText(NbBundle.getMessage(IssuePanel.class, (String)messageKey));
        String icon = this.issue.getTaskData().isNew() ? "org/netbeans/modules/bugzilla/resources/info.png" : "org/netbeans/modules/bugzilla/resources/error.gif";
        messageLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)icon)));
        this.messagePanel.add(messageLabel);
    }

    private void enableComponents(boolean enable) {
        this.enableComponents(this, enable);
        if (enable) {
            this.enableMap.clear();
        }
    }

    private void enableComponents(Component comp, boolean enable) {
        if (comp instanceof Container) {
            for (Component subComp : ((Container)comp).getComponents()) {
                this.enableComponents(subComp, enable);
            }
        }
        if (comp instanceof JComboBox || comp instanceof JTextComponent && ((JTextComponent)comp).isEditable() || comp instanceof AbstractButton || comp instanceof JList) {
            if (enable) {
                Boolean b = this.enableMap.get(comp);
                if (b != null) {
                    comp.setEnabled(b);
                }
            } else {
                this.enableMap.put(comp, comp.isEnabled());
                comp.setEnabled(false);
            }
        }
    }

    private void attachTasklistListener(BugzillaTaskListProvider provider) {
        if (this.tasklistListener == null) {
            this.tasklistListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("issue-removed".equals(evt.getPropertyName()) && IssuePanel.this.issue.equals(evt.getOldValue())) {
                        Runnable inAWT = new Runnable(){

                            @Override
                            public void run() {
                                IssuePanel.this.updateTasklistButton();
                            }
                        };
                        if (EventQueue.isDispatchThread()) {
                            inAWT.run();
                        } else {
                            EventQueue.invokeLater(inAWT);
                        }
                    }
                }
            };
            provider.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.tasklistListener, (Object)provider));
        }
    }

    private void updateTasklistButton() {
        this.tasklistButton.setEnabled(false);
        RP.post(new Runnable(){

            @Override
            public void run() {
                BugzillaTaskListProvider provider = BugzillaTaskListProvider.getInstance();
                if (provider == null || IssuePanel.this.issue.isNew()) {
                    return;
                }
                final boolean isInTasklist = provider.isAdded(IssuePanel.this.issue);
                if (isInTasklist) {
                    IssuePanel.this.attachTasklistListener(provider);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String tasklistMessage = NbBundle.getMessage(IssuePanel.class, (String)(isInTasklist ? "IssuePanel.tasklistButton.remove" : "IssuePanel.tasklistButton.add"));
                        IssuePanel.this.tasklistButton.setText(tasklistMessage);
                        IssuePanel.this.tasklistButton.setEnabled(true);
                    }
                });
            }
        });
    }

    private void initSpellChecker() {
        Spellchecker.register((JTextComponent)this.summaryField);
        Spellchecker.register((JTextComponent)this.addCommentArea);
    }

    private void initCustomFields() {
        this.customFields.clear();
        this.customFieldsPanelLeft.removeAll();
        this.customFieldsPanelRight.removeAll();
        GroupLayout labelLayout = new GroupLayout(this.customFieldsPanelLeft);
        this.customFieldsPanelLeft.setLayout(labelLayout);
        GroupLayout fieldLayout = new GroupLayout(this.customFieldsPanelRight);
        this.customFieldsPanelRight.setLayout(fieldLayout);
        GroupLayout.ParallelGroup labelHorizontalGroup = labelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup labelVerticalGroup = labelLayout.createSequentialGroup();
        GroupLayout.ParallelGroup fieldHorizontalGroup = fieldLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup fieldVerticalGroup = fieldLayout.createSequentialGroup();
        boolean nbRepository = BugzillaUtil.isNbRepository(this.issue.getRepository());
        boolean newIssue = this.issue.isNew();
        boolean anyField = false;
        block7: for (IssueField field : this.issue.getRepository().getConfiguration().getFields()) {
            Object editor;
            Object comp;
            if (!(field instanceof CustomIssueField)) continue;
            CustomIssueField cField = (CustomIssueField)field;
            if (nbRepository && cField.getKey().equals(IssueField.ISSUE_TYPE.getKey()) || newIssue && !cField.getShowOnBugCreation() || this.isNbExceptionReport(field) && (newIssue || "".equals(this.issue.getFieldValue(field).trim()))) continue;
            JLabel label = new JLabel(cField.getDisplayName() + ":");
            boolean rigid = false;
            switch (cField.getType()) {
                case LargeText: {
                    JScrollPane scrollPane = new JScrollPane();
                    JTextArea textArea = new JTextArea();
                    textArea.setRows(5);
                    scrollPane.setViewportView(textArea);
                    comp = scrollPane;
                    editor = textArea;
                    label.setVerticalAlignment(1);
                    UIUtils.fixFocusTraversalKeys((JComponent)textArea);
                    UIUtils.issue163946Hack((JScrollPane)scrollPane);
                    break;
                }
                case FreeText: {
                    if (this.isNbExceptionReport(field)) {
                        final String val = this.issue.getFieldValue(field);
                        LinkButton lb = new LinkButton(val);
                        lb.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                try {
                                    URL url = new URL("http://statistics.netbeans.org/exceptions/detail.do?id=" + val);
                                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                                }
                                catch (MalformedURLException muex) {
                                    Bugzilla.LOG.log(Level.INFO, "Unable to show the exception report in the browser.", muex);
                                }
                            }
                        });
                        editor = lb;
                        comp = editor;
                        break;
                    }
                    editor = new JTextField();
                    comp = editor;
                    break;
                }
                case MultipleSelection: {
                    JList<Object> list = new JList<Object>();
                    DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(cField.getOptions().toArray());
                    list.setModel(model);
                    if (model.getSize() < list.getVisibleRowCount()) {
                        list.setVisibleRowCount(model.getSize());
                    }
                    JScrollPane scrollPane = new JScrollPane();
                    scrollPane.setViewportView(list);
                    comp = scrollPane;
                    editor = list;
                    label.setVerticalAlignment(1);
                    rigid = true;
                    UIUtils.issue163946Hack((JScrollPane)scrollPane);
                    break;
                }
                case DropDown: {
                    editor = new JComboBox();
                    comp = editor;
                    DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(cField.getOptions().toArray());
                    ((JComboBox)comp).setModel(model);
                    rigid = true;
                    break;
                }
                case DateTime: {
                    editor = new JTextField();
                    comp = editor;
                    break;
                }
                default: {
                    Bugzilla.LOG.log(Level.INFO, "Custom field type {0} is not supported!", (Object)cField.getType());
                    continue block7;
                }
            }
            JLabel warning = new JLabel();
            warning.setMinimumSize(new Dimension(16, 16));
            warning.setPreferredSize(new Dimension(16, 16));
            warning.setMaximumSize(new Dimension(16, 16));
            warning.setVisible(false);
            this.customFields.add(new CustomFieldInfo(cField, label, (JComponent)editor, warning));
            label.setLabelFor((Component)editor);
            label.setPreferredSize(new Dimension(label.getPreferredSize().width, ((JComponent)comp).getPreferredSize().height));
            if (anyField) {
                labelVerticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
                fieldVerticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            }
            labelHorizontalGroup.addComponent(label);
            labelVerticalGroup.addComponent(label, -2, -1, -2);
            GroupLayout.SequentialGroup sGroup = fieldLayout.createSequentialGroup();
            if (rigid) {
                sGroup.addComponent((Component)comp, -2, -1, -2);
            } else {
                sGroup.addComponent((Component)comp);
            }
            sGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            sGroup.addComponent(warning);
            fieldHorizontalGroup.addGroup(sGroup);
            GroupLayout.ParallelGroup pGroup = fieldLayout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            pGroup.addComponent((Component)comp);
            pGroup.addComponent(warning);
            fieldVerticalGroup.addGroup(pGroup);
            anyField = true;
        }
        labelLayout.setHorizontalGroup(labelHorizontalGroup);
        labelLayout.setVerticalGroup(labelVerticalGroup);
        fieldLayout.setHorizontalGroup(fieldHorizontalGroup);
        fieldLayout.setVerticalGroup(fieldVerticalGroup);
        this.customFieldsPanelLeft.setVisible(anyField);
        this.customFieldsPanelRight.setVisible(anyField);
    }

    private boolean isNbExceptionReport(IssueField field) {
        return field.getKey().equals("cf_autoreporter_id");
    }

    private void initComponents() {
        this.productField = new JTextField();
        this.resolutionCombo = new JComboBox();
        this.assignedCombo = new JComboBox();
        this.timetrackingPanel = new JPanel();
        this.estimatedLabel = new JLabel();
        this.estimatedField = new JTextField();
        this.estimatedWarning = new JLabel();
        this.actualLabel = new JLabel();
        this.workedLabel = new JLabel();
        this.workedField = new JTextField();
        this.workedWarning = new JLabel();
        this.remainingField = new JTextField();
        this.remainingLabel = new JLabel();
        this.remainingWarning = new JLabel();
        this.completeLabel = new JLabel();
        this.workedSumField = new JLabel();
        this.jLabel7 = new JLabel();
        this.actualField = new JTextField();
        this.completeField = new JTextField();
        this.gainLabel = new JLabel();
        this.gainField = new JTextField();
        this.deadlineLabel = new JLabel();
        this.deadlineField = new JTextField();
        this.actualWarning = new JLabel();
        this.deadlineWarning = new JLabel();
        this.completeWarning = new JLabel();
        this.gainWarning = new JLabel();
        this.customFieldsPanelLeft = new JPanel();
        this.customFieldsPanelRight = new JPanel();
        this.reportedField = new JTextField();
        this.dependsOnWarning = new JLabel();
        this.osWarning = new JLabel();
        this.messagePanel = new JPanel();
        this.ccWarning = new JLabel();
        this.dummyAttachmentsPanel = new JPanel();
        this.dummyTimetrackingPanel = new JPanel();
        this.timetrackingLabel = new JLabel();
        this.qaContactWarning = new JLabel();
        this.assignedToWarning = new JLabel();
        this.reportedStatusLabel = new JLabel();
        this.blocksButton = new JButton();
        this.modifiedField = new JTextField();
        this.blocksLabel = new JLabel();
        this.modifiedLabel = new JLabel();
        this.dependsOnButton = new JButton();
        this.dependsField = new JTextField();
        this.dependsLabel = new JLabel();
        this.reportedLabel = new JLabel();
        this.resolutionField = new JTextField();
        this.duplicateButton = new JButton();
        this.statusCombo = new JComboBox();
        this.duplicateField = new JTextField();
        this.statusLabel = new JLabel();
        this.duplicateLabel = new JLabel();
        this.osCombo = new JComboBox();
        this.summaryWarning = new JLabel();
        this.ccField = new JTextField();
        this.ccLabel = new JLabel();
        this.qaContactLabel = new JLabel();
        this.blocksWarning = new JLabel();
        this.assignedField = new JTextField();
        this.resolutionWarning = new JLabel();
        this.assignedLabel = new JLabel();
        this.statusWarning = new JLabel();
        this.keywordsWarning = new JLabel();
        this.milestoneWarning = new JLabel();
        this.severityWarning = new JLabel();
        this.platformWarning = new JLabel();
        this.versionWarning = new JLabel();
        this.productWarning = new JLabel();
        this.addCommentLabel = new JLabel();
        this.attachmentsLabel = new JLabel();
        this.summaryLabel = new JLabel();
        this.assignedToStatusLabel = new JLabel();
        this.keywordsButton = new JButton();
        this.dummyLabel2 = new JLabel();
        this.keywordsLabel = new JLabel();
        this.targetMilestoneCombo = new JComboBox();
        this.blocksField = new JTextField();
        this.severityCombo = new JComboBox();
        this.priorityLabel = new JLabel();
        this.dummyLabel1 = new JLabel();
        this.componentCombo = new JComboBox();
        this.productCombo = new JComboBox();
        this.dummyCommentsPanel = new JPanel();
        this.separator = new JSeparator();
        this.headerField = new JTextField();
        this.refreshButton = new LinkButton();
        this.reloadButton = new LinkButton();
        this.showInBrowserButton = new LinkButton();
        this.separatorLabel = new JLabel();
        this.resolutionLabel = new JLabel();
        this.tasklistButton = new LinkButton();
        this.separatorLabel2 = new JLabel();
        this.separatorLabel3 = new JLabel();
        this.productLabel = new JLabel();
        this.componentLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.versionCombo = new JComboBox();
        this.platformCombo = new JComboBox();
        this.platformLabel = new JLabel();
        this.priorityCombo = new JComboBox();
        this.priorityWarning = new JLabel();
        this.targetMilestoneLabel = new JLabel();
        this.qaContactField = new JTextField();
        this.urlLabel = new LinkButton();
        this.keywordsField = new JTextField();
        this.urlField = new JTextField();
        this.statusWhiteboardLabel = new JLabel();
        this.statusWhiteboardField = new JTextField();
        this.issueTypeLabel = new JLabel();
        this.issueTypeCombo = new JComboBox();
        this.dummyTimetrackingLabel = new JLabel();
        this.dummyLabel3 = new JLabel();
        this.summaryField = new JTextField();
        this.urlWarning = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.addCommentArea = new JTextArea(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dim = super.getPreferredScrollableViewportSize();
                JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
                int delta = 0;
                if (scrollPane != null) {
                    JScrollBar comp = scrollPane.getHorizontalScrollBar();
                    delta = comp.isVisible() ? ((Component)comp).getHeight() : 0;
                }
                Insets insets = this.getInsets();
                int prefHeight = 5 * this.getRowHeight() + insets.top + insets.bottom;
                dim = new Dimension(dim.width, delta + (dim.height < prefHeight ? prefHeight : dim.height));
                return dim;
            }
        };
        this.submitButton = new JButton();
        this.cancelButton = new JButton();
        this.componentWarning = new JLabel();
        this.statusWhiteboardWarning = new JLabel();
        this.issueTypeWarning = new JLabel();
        this.assignToDefaultCheckBox = new JCheckBox();
        this.attachLogCheckBox = new JCheckBox();
        FormListener formListener = new FormListener();
        this.productField.setEditable(false);
        this.productField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.productField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.productField.AccessibleContext.accessibleDescription"));
        this.resolutionCombo.addActionListener(formListener);
        this.resolutionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.resolutionCombo.AccessibleContext.accessibleDescription"));
        this.assignedCombo.setEditable(true);
        this.assignedCombo.addActionListener(formListener);
        this.timetrackingPanel.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        Mnemonics.setLocalizedText((JLabel)this.estimatedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.estimatedLabel.text"));
        this.estimatedField.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.estimatedField.text"));
        Mnemonics.setLocalizedText((JLabel)this.actualLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.actualLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.workedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.workedLabel.text"));
        this.workedField.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.workedField.text"));
        this.workedField.addFocusListener(formListener);
        this.remainingField.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.remainingField.text"));
        Mnemonics.setLocalizedText((JLabel)this.remainingLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.remainingLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.completeLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.completeLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.workedSumField, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.workedSumField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.jLabel7.text"));
        this.actualField.setEditable(false);
        this.actualField.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.actualField.text"));
        this.completeField.setEditable(false);
        this.completeField.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.completeField.text"));
        Mnemonics.setLocalizedText((JLabel)this.gainLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.gainLabel.text"));
        this.gainField.setEditable(false);
        this.gainField.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.gainField.text"));
        Mnemonics.setLocalizedText((JLabel)this.deadlineLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.deadlineLabel.text"));
        this.deadlineField.setForeground(UIManager.getDefaults().getColor("TextField.inactiveForeground"));
        this.deadlineField.setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.deadlineField.text"));
        this.deadlineField.addFocusListener(formListener);
        GroupLayout timetrackingPanelLayout = new GroupLayout(this.timetrackingPanel);
        this.timetrackingPanel.setLayout(timetrackingPanelLayout);
        timetrackingPanelLayout.setHorizontalGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timetrackingPanelLayout.createSequentialGroup().addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.estimatedLabel).addComponent(this.estimatedField, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estimatedWarning, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.actualLabel).addComponent(this.actualField, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actualWarning, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timetrackingPanelLayout.createSequentialGroup().addComponent(this.workedSumField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.workedField, -2, 80, -2)).addComponent(this.workedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.workedWarning, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.remainingLabel).addGroup(timetrackingPanelLayout.createSequentialGroup().addComponent(this.remainingField, -2, 80, -2).addGap(6, 6, 6).addComponent(this.remainingWarning, -2, 16, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.completeLabel).addComponent(this.completeField, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.completeWarning, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timetrackingPanelLayout.createSequentialGroup().addComponent(this.gainField, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gainWarning, -2, 16, -2).addGap(9, 9, 9).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.deadlineField, -2, 113, -2).addComponent(this.deadlineLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deadlineWarning, -2, 16, -2)).addComponent(this.gainLabel))));
        timetrackingPanelLayout.setVerticalGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timetrackingPanelLayout.createSequentialGroup().addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.completeLabel).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.actualLabel, GroupLayout.Alignment.TRAILING).addComponent(this.estimatedLabel).addComponent(this.remainingLabel)).addComponent(this.workedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.actualWarning, -2, 16, -2).addComponent(this.remainingField, -2, -1, -2).addComponent(this.workedField, -2, -1, -2).addComponent(this.estimatedField, -2, -1, -2).addComponent(this.deadlineWarning, -2, 16, -2).addComponent(this.completeField, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.actualField, -2, -1, -2).addComponent(this.estimatedWarning, -2, 16, -2).addComponent(this.remainingWarning, -2, 16, -2).addComponent(this.workedWarning, -2, 16, -2).addComponent(this.workedSumField).addComponent(this.completeWarning, -2, 16, -2))).addGroup(timetrackingPanelLayout.createSequentialGroup().addComponent(this.gainLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(timetrackingPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.gainField, -2, -1, -2).addComponent(this.gainWarning, -2, 16, -2))).addGroup(timetrackingPanelLayout.createSequentialGroup().addComponent(this.deadlineLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deadlineField, -2, -1, -2)));
        this.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.reportedField.setEditable(false);
        this.reportedField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 3));
        Mnemonics.setLocalizedText((JLabel)this.timetrackingLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.timetrackingLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.blocksButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksButton.text"));
        this.blocksButton.setFocusPainted(false);
        this.blocksButton.setMargin(new Insets(0, 0, 0, 0));
        this.blocksButton.addActionListener(formListener);
        this.modifiedField.setEditable(false);
        this.modifiedField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.blocksLabel.setLabelFor(this.blocksField);
        Mnemonics.setLocalizedText((JLabel)this.blocksLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksLabel.text"));
        this.modifiedLabel.setLabelFor(this.modifiedField);
        Mnemonics.setLocalizedText((JLabel)this.modifiedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.modifiedLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.dependsOnButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsOnButton.text"));
        this.dependsOnButton.setFocusPainted(false);
        this.dependsOnButton.setMargin(new Insets(0, 0, 0, 0));
        this.dependsOnButton.addActionListener(formListener);
        this.dependsField.setColumns(15);
        this.dependsLabel.setLabelFor(this.dependsField);
        Mnemonics.setLocalizedText((JLabel)this.dependsLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsLabel.text"));
        this.reportedLabel.setLabelFor(this.reportedField);
        Mnemonics.setLocalizedText((JLabel)this.reportedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reportedLabel.text"));
        this.resolutionField.setEditable(false);
        this.resolutionField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.text"));
        this.duplicateButton.setFocusPainted(false);
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.addActionListener(formListener);
        this.statusCombo.addActionListener(formListener);
        this.duplicateField.setColumns(15);
        this.statusLabel.setLabelFor(this.statusCombo);
        Mnemonics.setLocalizedText((JLabel)this.statusLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.statusLabel.text"));
        this.duplicateLabel.setLabelFor(this.duplicateField);
        Mnemonics.setLocalizedText((JLabel)this.duplicateLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateLabel.text"));
        this.osCombo.addActionListener(formListener);
        this.ccLabel.setLabelFor(this.ccField);
        Mnemonics.setLocalizedText((JLabel)this.ccLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.ccLabel.text"));
        this.qaContactLabel.setLabelFor(this.qaContactField);
        Mnemonics.setLocalizedText((JLabel)this.qaContactLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.qaContactLabel.text"));
        this.assignedLabel.setLabelFor(this.assignedField);
        Mnemonics.setLocalizedText((JLabel)this.assignedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.assignedLabel.text"));
        this.addCommentLabel.setLabelFor(this.addCommentArea);
        Mnemonics.setLocalizedText((JLabel)this.addCommentLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.addCommentLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.attachmentsLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.attachmentsLabel.text"));
        this.summaryLabel.setLabelFor(this.summaryField);
        Mnemonics.setLocalizedText((JLabel)this.summaryLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.summaryLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.keywordsButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsButton.text"));
        this.keywordsButton.setFocusPainted(false);
        this.keywordsButton.setMargin(new Insets(0, 0, 0, 0));
        this.keywordsButton.addActionListener(formListener);
        this.keywordsLabel.setLabelFor(this.keywordsField);
        Mnemonics.setLocalizedText((JLabel)this.keywordsLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsLabel.text"));
        this.targetMilestoneCombo.addActionListener(formListener);
        this.blocksField.setColumns(15);
        this.severityCombo.addActionListener(formListener);
        this.priorityLabel.setLabelFor(this.priorityCombo);
        Mnemonics.setLocalizedText((JLabel)this.priorityLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.priorityLabel.text"));
        this.componentCombo.addActionListener(formListener);
        this.productCombo.addActionListener(formListener);
        this.headerField.setEditable(false);
        this.headerField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.refreshButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshButton.text"));
        this.refreshButton.setToolTipText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshButton.toolTipText"));
        this.refreshButton.addActionListener((ActionListener)formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.reloadButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reloadButton.text"));
        this.reloadButton.setToolTipText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reloadButton.toolTipText"));
        this.reloadButton.addActionListener((ActionListener)formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.showInBrowserButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.showInBrowserButton.text"));
        this.showInBrowserButton.addActionListener((ActionListener)formListener);
        this.separatorLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        Mnemonics.setLocalizedText((JLabel)this.resolutionLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.resolutionLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.tasklistButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.tasklistButton.add"));
        this.tasklistButton.addActionListener((ActionListener)formListener);
        this.separatorLabel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.separatorLabel3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        Mnemonics.setLocalizedText((JLabel)this.productLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.productLabel.text"));
        this.componentLabel.setLabelFor(this.componentCombo);
        Mnemonics.setLocalizedText((JLabel)this.componentLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.componentLabel.text"));
        this.versionLabel.setLabelFor(this.versionCombo);
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.versionLabel.text"));
        this.versionCombo.addActionListener(formListener);
        this.platformCombo.addActionListener(formListener);
        this.platformLabel.setLabelFor(this.platformCombo);
        Mnemonics.setLocalizedText((JLabel)this.platformLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.platformLabel.text"));
        this.priorityCombo.addActionListener(formListener);
        this.targetMilestoneLabel.setLabelFor(this.targetMilestoneCombo);
        Mnemonics.setLocalizedText((JLabel)this.targetMilestoneLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.targetMilestoneLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.urlLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.urlLabel.text"));
        this.urlLabel.addActionListener((ActionListener)formListener);
        this.keywordsField.setColumns(15);
        this.urlField.setColumns(15);
        Mnemonics.setLocalizedText((JLabel)this.statusWhiteboardLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.statusWhiteboardLabel.text"));
        this.statusWhiteboardField.setColumns(15);
        Mnemonics.setLocalizedText((JLabel)this.issueTypeLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.issueTypeLabel.text"));
        this.issueTypeCombo.addActionListener(formListener);
        this.scrollPane1.setVerticalScrollBarPolicy(21);
        this.addCommentArea.setLineWrap(true);
        this.addCommentArea.setWrapStyleWord(true);
        this.scrollPane1.setViewportView(this.addCommentArea);
        this.addCommentArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.addCommentArea.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.submitButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitButton.text"));
        this.submitButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.cancelButton.text"));
        this.cancelButton.addActionListener(formListener);
        this.assignToDefaultCheckBox.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        Mnemonics.setLocalizedText((AbstractButton)this.assignToDefaultCheckBox, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.assignToDefaultCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.attachLogCheckBox, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.attachLogCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separator, GroupLayout.Alignment.TRAILING).addComponent(this.dummyCommentsPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.headerField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.tasklistButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separatorLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.refreshButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separatorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.reloadButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separatorLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.showInBrowserButton, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.urlLabel, -2, -1, -2).addComponent(this.componentLabel).addComponent(this.productLabel).addComponent(this.versionLabel).addComponent(this.platformLabel).addComponent(this.dummyLabel1).addComponent(this.priorityLabel).addComponent(this.targetMilestoneLabel).addComponent(this.dummyLabel2).addComponent(this.keywordsLabel).addComponent(this.statusWhiteboardLabel).addComponent(this.issueTypeLabel).addComponent(this.dummyLabel3).addComponent(this.dummyTimetrackingLabel).addComponent(this.summaryLabel).addComponent(this.timetrackingLabel).addComponent(this.attachmentsLabel).addComponent(this.addCommentLabel).addComponent(this.customFieldsPanelLeft, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dummyTimetrackingPanel, -1, -1, Short.MAX_VALUE).addComponent(this.dummyAttachmentsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.scrollPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.summaryField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.summaryWarning, -2, 16, -2)).addComponent(this.messagePanel, -1, -1, Short.MAX_VALUE).addComponent(this.customFieldsPanelRight, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.issueTypeCombo, 0, -1, Short.MAX_VALUE).addComponent(this.statusWhiteboardField, 0, 1, Short.MAX_VALUE).addComponent(this.urlField, 0, 1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.keywordsField, 0, 1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.keywordsButton)).addComponent(this.targetMilestoneCombo, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.priorityCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.priorityWarning, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.severityCombo, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.platformCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.platformWarning, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.osCombo, -2, -1, -2)).addComponent(this.versionCombo, 0, -1, Short.MAX_VALUE).addComponent(this.componentCombo, 0, -1, Short.MAX_VALUE).addComponent(this.productCombo, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.componentWarning, -2, 16, -2).addComponent(this.productWarning, -2, 16, -2).addComponent(this.versionWarning, -2, 16, -2).addComponent(this.osWarning, -2, 16, -2).addComponent(this.issueTypeWarning, -2, 16, -2).addComponent(this.severityWarning, -2, 16, -2).addComponent(this.milestoneWarning, -2, 16, -2).addComponent(this.urlWarning, -2, 16, -2).addComponent(this.keywordsWarning, -2, 16, -2).addComponent(this.statusWhiteboardWarning, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.reportedLabel).addComponent(this.blocksLabel).addComponent(this.assignedLabel).addComponent(this.statusLabel).addComponent(this.resolutionLabel).addComponent(this.dependsLabel).addComponent(this.duplicateLabel).addComponent(this.ccLabel).addComponent(this.qaContactLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.reportedField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reportedStatusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.modifiedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modifiedField, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ccField).addComponent(this.assignedField).addComponent(this.statusCombo, 0, -1, Short.MAX_VALUE).addComponent(this.resolutionField).addGroup(layout.createSequentialGroup().addComponent(this.duplicateField).addGap(0, 0, 0).addComponent(this.duplicateButton)).addGroup(layout.createSequentialGroup().addComponent(this.dependsField).addGap(0, 0, 0).addComponent(this.dependsOnButton)).addGroup(layout.createSequentialGroup().addComponent(this.blocksField).addGap(0, 0, 0).addComponent(this.blocksButton)).addComponent(this.assignToDefaultCheckBox).addComponent(this.qaContactField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.assignedToStatusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.assignedToWarning, -2, 16, -2)).addComponent(this.qaContactWarning, -2, 16, -2).addComponent(this.ccWarning, -2, 16, -2).addComponent(this.statusWarning, -2, 16, -2).addComponent(this.resolutionWarning, -2, 16, -2).addComponent(this.blocksWarning, -2, 16, -2).addComponent(this.dependsOnWarning, -2, 16, -2))))).addGroup(layout.createSequentialGroup().addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.attachLogCheckBox)).addGap(0, 0, Short.MAX_VALUE))))).addGap(24, 24, 24)));
        layout.linkSize(0, this.osCombo, this.platformCombo, this.priorityCombo, this.severityCombo);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerField, -2, -1, -2).addComponent(this.separatorLabel2).addComponent((Component)this.tasklistButton, -2, -1, -2).addComponent(this.separatorLabel).addComponent((Component)this.reloadButton, -2, -1, -2).addComponent((Component)this.refreshButton, -2, -1, -2).addComponent(this.separatorLabel3).addComponent((Component)this.showInBrowserButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.productLabel).addComponent(this.productCombo, -2, -1, -2).addComponent(this.productWarning, -2, 16, -2).addComponent(this.reportedLabel).addComponent(this.reportedField, -2, -1, -2).addComponent(this.modifiedLabel).addComponent(this.modifiedField, -2, -1, -2).addComponent(this.reportedStatusLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.componentLabel).addComponent(this.componentCombo, -2, -1, -2).addComponent(this.componentWarning, -2, 16, -2).addComponent(this.assignedLabel).addComponent(this.assignedField, -2, -1, -2).addComponent(this.assignedToStatusLabel).addComponent(this.assignedToWarning, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionLabel).addComponent(this.versionCombo, -2, -1, -2).addComponent(this.versionWarning, -2, 16, -2).addComponent(this.assignToDefaultCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.platformLabel).addComponent(this.platformCombo, -2, -1, -2).addComponent(this.platformWarning, -2, 16, -2).addComponent(this.osCombo, -2, -1, -2).addComponent(this.osWarning, -2, 16, -2).addComponent(this.qaContactLabel).addComponent(this.qaContactField, -2, -1, -2).addComponent(this.qaContactWarning, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.issueTypeLabel).addComponent(this.issueTypeCombo, -2, -1, -2).addComponent(this.issueTypeWarning, -2, 16, -2).addComponent(this.ccLabel).addComponent(this.ccField, -2, -1, -2).addComponent(this.ccWarning, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dummyLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.priorityLabel).addComponent(this.priorityCombo, -2, -1, -2).addComponent(this.priorityWarning, -2, 16, -2).addComponent(this.severityCombo, -2, -1, -2).addComponent(this.severityWarning, -2, 16, -2).addComponent(this.statusLabel).addComponent(this.statusCombo, -2, -1, -2).addComponent(this.statusWarning, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetMilestoneLabel).addComponent(this.targetMilestoneCombo, -2, -1, -2).addComponent(this.milestoneWarning, -2, 16, -2).addComponent(this.resolutionLabel).addComponent(this.resolutionField, -2, -1, -2).addComponent(this.resolutionWarning, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dummyLabel2).addComponent(this.duplicateLabel).addComponent(this.duplicateField, -2, -1, -2).addComponent(this.duplicateButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.urlLabel, -2, -1, -2).addComponent(this.urlField, -2, -1, -2).addComponent(this.urlWarning, -2, 16, -2).addComponent(this.dependsLabel).addComponent(this.dependsField, -2, -1, -2).addComponent(this.dependsOnWarning, -2, 16, -2).addComponent(this.dependsOnButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keywordsLabel).addComponent(this.keywordsField, -2, -1, -2).addComponent(this.keywordsButton).addComponent(this.keywordsWarning, -2, 16, -2).addComponent(this.blocksLabel).addComponent(this.blocksField, -2, -1, -2).addComponent(this.blocksWarning, -2, 16, -2).addComponent(this.blocksButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusWhiteboardLabel).addComponent(this.statusWhiteboardField, -2, -1, -2).addComponent(this.statusWhiteboardWarning, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.timetrackingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dummyTimetrackingLabel)).addComponent(this.dummyTimetrackingPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.attachmentsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dummyLabel3)).addGroup(layout.createSequentialGroup().addComponent(this.dummyAttachmentsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attachLogCheckBox))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.customFieldsPanelRight, -2, -1, -2).addComponent(this.customFieldsPanelLeft, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.summaryLabel).addComponent(this.summaryWarning, -2, 16, -2).addComponent(this.summaryField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addCommentLabel).addComponent(this.scrollPane1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.submitButton).addComponent(this.cancelButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.messagePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.separator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dummyCommentsPanel, -1, 24, Short.MAX_VALUE)));
        layout.linkSize(1, new Component[]{this.refreshButton, this.reloadButton, this.separatorLabel, this.separatorLabel2, this.separatorLabel3, this.showInBrowserButton});
        layout.linkSize(1, this.dummyLabel1, this.dummyLabel2, this.dummyLabel3, this.dummyTimetrackingLabel, this.priorityCombo);
        this.reportedField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reportedField.AccessibleContext.accessibleDescription"));
        this.blocksButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksButton.AccessibleContext.accessibleDescription"));
        this.modifiedField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.modifiedField.AccessibleContext.accessibleDescription"));
        this.dependsOnButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsOnButton.AccessibleContext.accessibleDescription"));
        this.dependsField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsField.AccessibleContext.accessibleDescription"));
        this.resolutionField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.resolutionField.AccessibleContext.accessibleDescription"));
        this.duplicateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.AccessibleContext.accessibleDescription"));
        this.statusCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.statusCombo.AccessibleContext.accessibleDescription"));
        this.duplicateField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateField.AccessibleContext.accessibleDescription"));
        this.osCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.osCombo.AccessibleContext.accessibleDescription"));
        this.ccField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.ccField.AccessibleContext.accessibleDescription"));
        this.assignedField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.assignedField.AccessibleContext.accessibleDescription"));
        this.keywordsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsButton.AccessibleContext.accessibleDescription"));
        this.targetMilestoneCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.targetMilestoneCombo.AccessibleContext.accessibleDescription"));
        this.blocksField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksField.AccessibleContext.accessibleDescription"));
        this.severityCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.severityCombo.AccessibleContext.accessibleDescription"));
        this.componentCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.componentCombo.AccessibleContext.accessibleDescription"));
        this.productCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.productCombo.AccessibleContext.accessibleDescription"));
        this.refreshButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshButton.AccessibleContext.accessibleDescription"));
        this.versionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.versionCombo.AccessibleContext.accessibleDescription"));
        this.platformCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.platformCombo.AccessibleContext.accessibleDescription"));
        this.priorityCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.priorityCombo.AccessibleContext.accessibleDescription"));
        this.qaContactField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.qaContactField.AccessibleContext.accessibleDescription"));
        this.keywordsField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsField.AccessibleContext.accessibleDescription"));
        this.urlField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.urlField.AccessibleContext.accessibleDescription"));
        this.submitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitButton.AccessibleContext.accessibleDescription"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.cancelButton.AccessibleContext.accessibleDescription"));
    }

    private void productComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.productLabel);
        BugzillaRepository repository = this.issue.getRepository();
        BugzillaConfiguration bc = repository.getConfiguration();
        if (bc == null || !bc.isValid()) {
            return;
        }
        String product = this.productCombo.getSelectedItem().toString();
        Object component = this.componentCombo.getSelectedItem();
        Object version = this.versionCombo.getSelectedItem();
        Object targetMilestone = this.targetMilestoneCombo.getSelectedItem();
        this.componentCombo.setModel(this.toComboModel(bc.getComponents(product)));
        this.versionCombo.setModel(this.toComboModel(bc.getVersions(product)));
        List<String> targetMilestones = bc.getTargetMilestones(product);
        this.usingTargetMilestones = !targetMilestones.isEmpty();
        this.targetMilestoneCombo.setModel(this.toComboModel(targetMilestones));
        boolean isNew = this.issue.getTaskData().isNew();
        if (!isNew && !this.selectInCombo(this.componentCombo, component, false) && this.componentCombo.getModel().getSize() > 1) {
            this.componentCombo.setSelectedItem(null);
        }
        if (!isNew && !this.selectInCombo(this.versionCombo, version, false) && this.versionCombo.getModel().getSize() > 1) {
            this.versionCombo.setSelectedItem(null);
        }
        if (this.usingTargetMilestones && !isNew && !this.selectInCombo(this.targetMilestoneCombo, targetMilestone, false) && this.targetMilestoneCombo.getModel().getSize() > 1) {
            this.targetMilestoneCombo.setSelectedItem(null);
        }
        this.targetMilestoneLabel.setVisible(this.usingTargetMilestones);
        this.targetMilestoneCombo.setVisible(this.usingTargetMilestones);
        this.milestoneWarning.setVisible(this.usingTargetMilestones);
        TaskData data = this.issue.getTaskData();
        if (data.isNew()) {
            this.issue.setFieldValue(IssueField.PRODUCT, product);
            BugzillaRepositoryConnector connector = Bugzilla.getInstance().getRepositoryConnector();
            try {
                connector.getTaskDataHandler().initializeTaskData(this.issue.getRepository().getTaskRepository(), data, (ITaskMapping)connector.getTaskMapping(data), (IProgressMonitor)new NullProgressMonitor());
                if (BugzillaUtil.isNbRepository(repository)) {
                    String defaultMilestone;
                    List<String> milestones = repository.getConfiguration().getTargetMilestones(product);
                    if (milestones.contains(defaultMilestone = "TBD")) {
                        this.issue.setFieldValue(IssueField.MILESTONE, defaultMilestone);
                    }
                    List<String> versions = repository.getConfiguration().getVersions(product);
                    String defaultVersion = this.getCurrentNetBeansVersion();
                    for (String v : versions) {
                        if (!v.trim().toLowerCase().equals(defaultVersion.toLowerCase())) continue;
                        this.issue.setFieldValue(IssueField.VERSION, v);
                    }
                }
                this.initialValues.remove(IssueField.COMPONENT.getKey());
                this.initialValues.remove(IssueField.VERSION.getKey());
                this.initialValues.remove(IssueField.MILESTONE.getKey());
                this.reloadForm(false);
            }
            catch (CoreException cex) {
                Bugzilla.LOG.log(Level.INFO, cex.getMessage(), cex);
            }
        }
    }

    private void statusComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.statusLabel);
        this.cancelHighlight(this.resolutionLabel);
        String initialStatus = this.initialValues.get(IssueField.STATUS.getKey());
        boolean resolvedInitial = "RESOLVED".equals(initialStatus);
        if (!resolvedInitial) {
            if ("RESOLVED".equals(this.statusCombo.getSelectedItem())) {
                if (this.resolutionCombo.getParent() == null) {
                    ((GroupLayout)this.getLayout()).replace(this.resolutionField, this.resolutionCombo);
                }
                this.resolutionCombo.setSelectedItem("FIXED");
                this.resolutionCombo.setVisible(true);
            } else {
                this.resolutionCombo.setVisible(false);
                this.duplicateLabel.setVisible(false);
                this.duplicateField.setVisible(false);
                this.duplicateButton.setVisible(false);
            }
        }
        if (!this.resolutionField.getText().trim().equals("")) {
            if (this.statusCombo.getSelectedIndex() >= this.resolvedIndex) {
                if (this.resolutionField.getParent() == null) {
                    ((GroupLayout)this.getLayout()).replace(this.resolutionCombo, this.resolutionField);
                }
                this.resolutionField.setVisible(true);
            } else {
                this.resolutionField.setVisible(false);
            }
            this.duplicateLabel.setVisible(false);
            this.duplicateField.setVisible(false);
            this.duplicateButton.setVisible(false);
        }
        this.resolutionLabel.setLabelFor(this.resolutionCombo.isVisible() ? this.resolutionCombo : this.resolutionField);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.reloadForm(true);
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        BugzillaRepository repository;
        String submitMessage;
        final boolean isNew = this.issue.getTaskData().isNew();
        if (isNew) {
            this.storeFieldValue(IssueField.DESCRIPTION, this.addCommentArea);
        }
        this.storeFieldValue(IssueField.SUMMARY, this.summaryField);
        this.storeFieldValue(IssueField.PRODUCT, this.productCombo);
        this.storeFieldValue(IssueField.COMPONENT, this.componentCombo);
        this.storeFieldValue(IssueField.VERSION, this.versionCombo);
        this.storeFieldValue(IssueField.PLATFORM, this.platformCombo);
        this.storeFieldValue(IssueField.OS, this.osCombo);
        this.storeFieldValue(IssueField.STATUS, this.statusCombo);
        if (this.resolutionCombo.isVisible()) {
            this.storeFieldValue(IssueField.RESOLUTION, this.resolutionCombo);
        } else if (!this.resolutionField.isVisible()) {
            this.storeFieldValue(IssueField.RESOLUTION, "");
        }
        if (this.duplicateField.isVisible() && this.duplicateField.isEditable()) {
            this.issue.duplicate(this.duplicateField.getText());
        }
        this.storeFieldValue(IssueField.PRIORITY, this.priorityCombo);
        if (BugzillaUtil.isNbRepository(this.issue.getRepository())) {
            this.storeFieldValue(IssueField.ISSUE_TYPE, this.issueTypeCombo);
        }
        this.storeFieldValue(IssueField.SEVERITY, this.severityCombo);
        if (this.usingTargetMilestones) {
            this.storeFieldValue(IssueField.MILESTONE, this.targetMilestoneCombo);
        }
        this.storeAssignToDefault();
        this.storeFieldValue(IssueField.URL, this.urlField);
        this.storeFieldValue(IssueField.WHITEBOARD, this.statusWhiteboardField);
        this.storeFieldValue(IssueField.KEYWORDS, this.keywordsField);
        if (this.assignedField.getParent() == null) {
            this.storeFieldValue(IssueField.ASSIGNED_TO, this.assignedCombo);
        } else {
            this.storeFieldValue(IssueField.ASSIGNED_TO, this.assignedField);
        }
        this.storeFieldValue(IssueField.QA_CONTACT, this.qaContactField);
        this.storeCCValue();
        this.storeFieldValue(IssueField.DEPENDS_ON, this.dependsField);
        this.storeFieldValue(IssueField.BLOCKS, this.blocksField);
        if (!isNew && !"".equals(this.addCommentArea.getText().trim())) {
            this.issue.addComment(this.addCommentArea.getText());
        }
        if (!isNew && this.issue.hasTimeTracking()) {
            this.storeFieldValue(IssueField.ESTIMATED_TIME, this.estimatedField);
            this.storeFieldValue(IssueField.WORK_TIME, this.workedField);
            this.storeFieldValue(IssueField.REMAINING_TIME, this.remainingField);
            if (!this.deadlineField.getText().trim().equals(YYYY_MM_DD)) {
                this.storeFieldValue(IssueField.DEADLINE, this.deadlineField);
            }
        }
        for (CustomFieldInfo field : this.customFields) {
            if (field.comp instanceof JTextComponent) {
                this.storeFieldValue((IssueField)field.field, (JTextComponent)field.comp);
                continue;
            }
            if (field.comp instanceof JComboBox) {
                this.storeFieldValue((IssueField)field.field, (JComboBox)field.comp);
                continue;
            }
            if (field.comp instanceof JList) {
                this.storeFieldValue((IssueField)field.field, (JList)field.comp);
                continue;
            }
            Bugzilla.LOG.log(Level.INFO, "Custom field component {0} is not supported!", field.comp);
        }
        if (isNew) {
            submitMessage = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitNewMessage");
        } else {
            String submitMessageFormat = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitMessage");
            submitMessage = MessageFormat.format(submitMessageFormat, this.issue.getID());
        }
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)submitMessage);
        handle.start();
        handle.switchToIndeterminate();
        this.skipReload = true;
        this.enableComponents(false);
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean ret;
                block10: {
                    ret = false;
                    try {
                        ret = IssuePanel.this.issue.submitAndRefresh();
                        for (AttachmentsPanel.AttachmentInfo attachment : IssuePanel.this.attachmentsPanel.getNewAttachments()) {
                            if (!attachment.file.exists() || !attachment.file.isFile()) continue;
                            if (attachment.description.trim().length() == 0) {
                                attachment.description = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.attachment.noDescription");
                            }
                            IssuePanel.this.issue.addAttachment(attachment.file, null, attachment.description, attachment.contentType, attachment.isPatch);
                        }
                        if (IssuePanel.this.attachLogCheckBox.isVisible() && IssuePanel.this.attachLogCheckBox.isSelected()) {
                            File f = new File(Places.getUserDirectory(), "var/log/messages.log");
                            if (f.exists()) {
                                IssuePanel.this.issue.addAttachment(f, "", NbBundle.getMessage(IssuePanel.class, (String)"MSG_LOG_FILE_DESC"), "text/plain", false);
                            }
                            BugzillaConfig.getInstance().putAttachLogFile(true);
                            break block10;
                        }
                        BugzillaConfig.getInstance().putAttachLogFile(false);
                    }
                    catch (Throwable throwable) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                IssuePanel.this.enableComponents(true);
                                IssuePanel.this.skipReload = false;
                            }
                        });
                        handle.finish();
                        if (ret) {
                            if (isNew) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        IssuePanel.this.initCustomFields();
                                    }
                                });
                            }
                            IssuePanel.this.reloadFormInAWT(true);
                        }
                        throw throwable;
                    }
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                handle.finish();
                if (ret) {
                    if (isNew) {
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    IssuePanel.this.reloadFormInAWT(true);
                }
            }
        });
        if (isNew && (repository = this.issue.getRepository()) != null) {
            OwnerUtils.setLooseAssociation((Repository)BugzillaUtil.getRepository(repository), (boolean)false);
        }
    }

    private void storeCCValue() {
        Set<String> oldCCs = this.ccs(this.issue.getFieldValue(IssueField.CC));
        Set<String> newCCs = this.ccs(this.ccField.getText());
        String removedCCs = this.getMissingCCs(oldCCs, newCCs);
        String addedCCs = this.getMissingCCs(newCCs, oldCCs);
        this.issue.setFieldValue(IssueField.CC, this.ccField.getText());
        this.storeFieldValue(IssueField.REMOVECC, removedCCs);
        this.storeFieldValue(IssueField.NEWCC, addedCCs);
    }

    private Set<String> ccs(String values) {
        HashSet<String> ccs = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(values, ", \t\n\r\f");
        while (st.hasMoreTokens()) {
            ccs.add(st.nextToken());
        }
        return ccs;
    }

    private String getMissingCCs(Set<String> ccs, Set<String> missingIn) {
        StringBuilder ret = new StringBuilder();
        Iterator<String> it = ccs.iterator();
        while (it.hasNext()) {
            String cc = it.next();
            if (cc.trim().equals("") || missingIn.contains(cc)) continue;
            ret.append(cc);
            if (!it.hasNext()) continue;
            ret.append(',');
        }
        return ret.toString();
    }

    private void storeAssignToDefault() {
        if (this.assignToDefaultCheckBox.isSelected()) {
            this.issue.assignToDefault();
        }
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        String refreshMessageFormat = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshMessage");
        String refreshMessage = MessageFormat.format(refreshMessageFormat, this.issue.getID());
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)refreshMessage);
        handle.start();
        handle.switchToIndeterminate();
        this.skipReload = true;
        this.enableComponents(false);
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IssuePanel.this.issue.refresh();
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IssuePanel.this.enableComponents(true);
                            IssuePanel.this.skipReload = false;
                        }
                    });
                    handle.finish();
                    IssuePanel.this.reloadFormInAWT(true);
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                handle.finish();
                IssuePanel.this.reloadFormInAWT(true);
            }
        });
    }

    private void resolutionComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.resolutionLabel);
        if (this.resolutionCombo.getParent() == null) {
            return;
        }
        boolean shown = "DUPLICATE".equals(this.resolutionCombo.getSelectedItem());
        this.duplicateLabel.setVisible(shown);
        this.duplicateField.setVisible(shown);
        this.duplicateButton.setVisible(shown && this.duplicateField.isEditable());
        this.updateNoDuplicateId();
    }

    private void keywordsButtonActionPerformed(ActionEvent evt) {
        String message = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsButton.message");
        String kws = BugzillaUtil.getKeywords(message, this.keywordsField.getText(), this.issue.getRepository());
        this.keywordsField.setText(kws);
    }

    private void blocksButtonActionPerformed(ActionEvent evt) {
        String newIssueID = BugtrackingUtil.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksButton.message"), (Repository)BugzillaUtil.getRepository(this.issue.getRepository()), (JPanel)this, (HelpCtx)new HelpCtx("org.netbeans.modules.bugzilla.blocksChooser"));
        if (newIssueID != null) {
            StringBuilder sb = new StringBuilder();
            if (!this.blocksField.getText().trim().equals("")) {
                sb.append(this.blocksField.getText()).append(',').append(' ');
            }
            sb.append(newIssueID);
            this.blocksField.setText(sb.toString());
        }
    }

    private void dependsOnButtonActionPerformed(ActionEvent evt) {
        String newIssueID = BugtrackingUtil.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsOnButton.message"), (Repository)BugzillaUtil.getRepository(this.issue.getRepository()), (JPanel)this, (HelpCtx)new HelpCtx("org.netbeans.modules.bugzilla.dependsOnChooser"));
        if (newIssueID != null) {
            StringBuilder sb = new StringBuilder();
            if (!this.dependsField.getText().trim().equals("")) {
                sb.append(this.dependsField.getText()).append(',').append(' ');
            }
            sb.append(newIssueID);
            this.dependsField.setText(sb.toString());
        }
    }

    private void componentComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.componentLabel);
        this.updateNoComponent();
    }

    private void versionComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.versionLabel);
        this.updateNoVersion();
    }

    private void platformComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.platformLabel);
    }

    private void priorityComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.priorityLabel);
    }

    private void severityComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.priorityLabel);
    }

    private void targetMilestoneComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.targetMilestoneLabel);
        this.updateNoTargetMilestone();
    }

    private void osComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.platformLabel);
    }

    private void reloadButtonActionPerformed(ActionEvent evt) {
        String reloadMessage = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reloadMessage");
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)reloadMessage);
        handle.start();
        handle.switchToIndeterminate();
        this.skipReload = true;
        this.enableComponents(false);
        RP.post(new Runnable(){

            @Override
            public void run() {
                IssuePanel.this.issue.getRepository().refreshConfiguration();
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            IssuePanel.this.reloading = true;
                            Object product = IssuePanel.this.productCombo.getSelectedItem();
                            Object platform = IssuePanel.this.platformCombo.getSelectedItem();
                            Object os = IssuePanel.this.osCombo.getSelectedItem();
                            Object priority = IssuePanel.this.priorityCombo.getSelectedItem();
                            Object severity = IssuePanel.this.severityCombo.getSelectedItem();
                            Object resolution = IssuePanel.this.resolutionCombo.getSelectedItem();
                            Object issueType = IssuePanel.this.issueTypeCombo.getSelectedItem();
                            IssuePanel.this.initCombos();
                            IssuePanel.this.initCustomFields();
                            IssuePanel.this.selectInCombo(IssuePanel.this.productCombo, product, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.platformCombo, platform, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.osCombo, os, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.priorityCombo, priority, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.severityCombo, severity, false);
                            IssuePanel.this.initStatusCombo(IssuePanel.this.statusCombo.getSelectedItem().toString());
                            IssuePanel.this.selectInCombo(IssuePanel.this.resolutionCombo, resolution, false);
                            if (BugzillaUtil.isNbRepository(IssuePanel.this.issue.getRepository())) {
                                IssuePanel.this.issueTypeCombo.setSelectedItem(issueType);
                            }
                            IssuePanel.this.reloadCustomFields(true);
                        }
                        finally {
                            IssuePanel.this.reloading = false;
                            IssuePanel.this.enableComponents(true);
                            IssuePanel.this.skipReload = false;
                        }
                    }
                });
                handle.finish();
            }
        });
    }

    private void duplicateButtonActionPerformed(ActionEvent evt) {
        String newIssueID = BugtrackingUtil.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.message"), (Repository)BugzillaUtil.getRepository(this.issue.getRepository()), (JPanel)this, (HelpCtx)new HelpCtx("org.netbeans.modules.bugzilla.duplicateChooser"));
        if (newIssueID != null) {
            this.duplicateField.setText(newIssueID);
        }
    }

    private void tasklistButtonActionPerformed(ActionEvent evt) {
        this.tasklistButton.setEnabled(false);
        BugzillaTaskListProvider provider = BugzillaTaskListProvider.getInstance();
        if (provider.isAdded(this.issue)) {
            provider.remove(this.issue);
        } else {
            this.attachTasklistListener(provider);
            provider.add(this.issue, true);
        }
        this.updateTasklistButton();
    }

    private void assignedComboActionPerformed(ActionEvent evt) {
        Object value;
        this.cancelHighlight(this.assignedLabel);
        if (!this.reloading) {
            this.assignedToStatusLabel.setVisible(false);
        }
        if ((value = this.assignedCombo.getSelectedItem()) instanceof RepositoryUser) {
            String assignee = ((RepositoryUser)value).getUserName();
            BugzillaRepository repository = this.issue.getRepository();
            if (repository instanceof KenaiRepository) {
                assignee = assignee + '@' + ((KenaiRepository)repository).getHost();
            }
            this.assignedCombo.setSelectedItem(assignee);
        }
    }

    private void issueTypeComboActionPerformed(ActionEvent evt) {
        this.cancelHighlight(this.issueTypeLabel);
    }

    private void showInBrowserButtonActionPerformed(ActionEvent evt) {
        try {
            URL url = new URL(this.issue.getRepository().getUrl() + "/show_bug.cgi?id=" + this.issue.getID());
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException muex) {
            Bugzilla.LOG.log(Level.INFO, "Unable to show the issue in the browser.", muex);
        }
    }

    private void urlButtonActionPerformed(ActionEvent evt) {
        URL url;
        block6: {
            String urlString = this.urlField.getText();
            if (urlString.isEmpty()) {
                return;
            }
            url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException muex) {
                if (this.issue == null) break block6;
                String repoUrlString = this.issue.getRepository().getUrl();
                urlString = repoUrlString + (repoUrlString.endsWith("/") ? "" : "/") + urlString;
                try {
                    url = new URL(urlString);
                }
                catch (MalformedURLException ex) {
                    Bugzilla.LOG.log(Level.INFO, "Unable to open " + urlString, muex);
                }
            }
        }
        if (url != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
    }

    private void deadlineFieldFocusGained(FocusEvent evt) {
        if (this.deadlineField.getText().trim().equals(YYYY_MM_DD)) {
            this.deadlineField.setText("");
        }
        this.deadlineField.setForeground(this.workedField.getForeground());
    }

    private void deadlineFieldFocusLost(FocusEvent evt) {
        if ("".equals(this.deadlineField.getText().trim())) {
            this.deadlineField.setText(YYYY_MM_DD);
            this.deadlineField.setForeground(UIManager.getDefaults().getColor("TextField.inactiveForeground"));
        }
    }

    private void workedFieldFocusLost(FocusEvent evt) {
        if (!"".equals(this.workedField.getText().trim())) {
            double workedSum;
            double worked;
            double actual;
            double remaining;
            String workedString = this.workedField.getText().trim();
            if (!workedString.trim().equals("")) {
                try {
                    Double.parseDouble(workedString);
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            if ((remaining = (actual = this.getDoubleValue(this.actualField)) - (worked = this.getDoubleValue(this.workedField)) - (workedSum = this.getDoubleValue(this.workedSumField))) > 0.0) {
                this.remainingField.setText(String.valueOf(remaining));
            } else {
                this.remainingField.setText("0");
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getUnitIncrement();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 ? visibleRect.height : visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (scrollPane != null) {
            JScrollBar vsb;
            int minWidth = this.getMinimumSize().width;
            int width = scrollPane.getSize().width;
            Insets insets = scrollPane.getInsets();
            width -= insets.left + insets.right;
            Border border = scrollPane.getViewportBorder();
            if (border != null) {
                insets = border.getBorderInsets(scrollPane);
                width -= insets.left + insets.right;
            }
            if ((vsb = scrollPane.getVerticalScrollBar()) != null && vsb.isVisible()) {
                width -= vsb.getSize().width;
            }
            if (minWidth > width) {
                return false;
            }
        }
        return true;
    }

    void makeCaretVisible(JTextArea textArea) {
        int pos = textArea.getCaretPosition();
        try {
            Rectangle rec = textArea.getUI().modelToView(textArea, pos);
            if (rec != null) {
                Point p = SwingUtilities.convertPoint(textArea, rec.x, rec.y, this);
                this.scrollRectToVisible(new Rectangle(p.x, p.y, rec.width, rec.height));
            }
        }
        catch (BadLocationException blex) {
            Bugzilla.LOG.log(Level.INFO, blex.getMessage(), blex);
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private int getUnitIncrement() {
        Font font;
        if (this.unitIncrement == 0 && (font = UIManager.getFont("Label.font")) != null) {
            this.unitIncrement = (int)((double)font.getSize() * 1.5);
        }
        return this.unitIncrement;
    }

    private String getCurrentNetBeansVersion() {
        String version = IssuePanel.parseProductVersion(IssuePanel.getProductVersionValue());
        if (version != null) {
            if (version.toLowerCase().equals("dev")) {
                return CURRENT_NB_VERSION;
            }
            return version;
        }
        return CURRENT_NB_VERSION;
    }

    static String parseProductVersion(String productVersionValue) {
        String version;
        Pattern p = Pattern.compile("NetBeans IDE\\s([a-zA-Z0-9\\.?]*)\\s?.*");
        Matcher m = p.matcher(productVersionValue);
        if (m.matches() && (version = m.group(1)) != null && !version.trim().isEmpty()) {
            return version;
        }
        return null;
    }

    private void addNetbeansInfo() {
        String format = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.newIssue.netbeansInfo");
        Object[] info = new Object[]{IssuePanel.getProductVersionValue(), System.getProperty("os.name", "unknown"), System.getProperty("os.version", "unknown"), System.getProperty("os.arch", "unknown"), System.getProperty("java.version", "unknown"), System.getProperty("java.vm.name", "unknown"), System.getProperty("java.vm.version", "")};
        String infoTxt = MessageFormat.format(format, info);
        this.addCommentArea.setText(infoTxt);
    }

    public static String getProductVersionValue() {
        return MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
    }

    void opened() {
        this.undoRedoSupport = Bugzilla.getInstance().getUndoRedoSupport(this.issue);
        this.undoRedoSupport.register((JTextComponent)this.addCommentArea);
        this.reloadForm(true);
    }

    void closed() {
        if (this.issue != null) {
            this.commentsPanel.storeSettings();
            if (this.undoRedoSupport != null) {
                this.undoRedoSupport.unregisterAll();
                this.undoRedoSupport = null;
            }
        }
    }

    private double getDoubleValue(JComponent field) {
        assert (field instanceof JTextField || field instanceof JLabel);
        String txt = field instanceof JTextField ? ((JTextField)field).getText() : ((JLabel)field).getText();
        if (txt.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(txt);
        }
        catch (NumberFormatException e) {
            Bugzilla.LOG.log(Level.WARNING, txt, e);
            return 0.0;
        }
    }

    private void updateNoDuplicateId() {
        boolean newNoDuplicateId;
        boolean bl = newNoDuplicateId = "DUPLICATE".equals(this.resolutionCombo.getSelectedItem()) && "".equals(this.duplicateField.getText().trim());
        if (newNoDuplicateId != this.noDuplicateId) {
            this.noDuplicateId = newNoDuplicateId;
            this.updateMessagePanel();
        }
    }

    class CancelHighlightDocumentListener
    implements DocumentListener {
        private JComponent label;

        CancelHighlightDocumentListener(JComponent label) {
            this.label = label;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            IssuePanel.this.cancelHighlight(this.label);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            IssuePanel.this.cancelHighlight(this.label);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            IssuePanel.this.cancelHighlight(this.label);
        }
    }

    private static class CustomFieldInfo {
        CustomIssueField field;
        JLabel label;
        JComponent comp;
        JLabel warning;

        CustomFieldInfo(CustomIssueField field, JLabel label, JComponent comp, JLabel warning) {
            this.field = field;
            this.label = label;
            this.comp = comp;
            this.warning = warning;
        }
    }

    class CyclicDependencyDocumentListener
    implements DocumentListener {
        CyclicDependencyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            Set<Integer> bugs1 = this.bugs(IssuePanel.this.blocksField.getText());
            Set<Integer> bugs2 = this.bugs(IssuePanel.this.dependsField.getText());
            bugs1.retainAll(bugs2);
            if (bugs1.isEmpty()) {
                if (IssuePanel.this.cyclicDependency) {
                    IssuePanel.this.cyclicDependency = false;
                    IssuePanel.this.updateMessagePanel();
                }
            } else if (!IssuePanel.this.cyclicDependency) {
                IssuePanel.this.cyclicDependency = true;
                IssuePanel.this.updateMessagePanel();
            }
        }

        private Set<Integer> bugs(String values) {
            HashSet<Integer> bugs = new HashSet<Integer>();
            StringTokenizer st = new StringTokenizer(values, ", \t\n\r\f");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    bugs.add(Integer.parseInt(token));
                }
                catch (NumberFormatException nfex) {}
            }
            return bugs;
        }
    }

    private class DuplicateListener
    implements DocumentListener {
        private DuplicateListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            IssuePanel.this.updateNoDuplicateId();
        }
    }

    private class FormListener
    implements ActionListener,
    FocusListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == IssuePanel.this.blocksButton) {
                IssuePanel.this.blocksButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.dependsOnButton) {
                IssuePanel.this.dependsOnButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.duplicateButton) {
                IssuePanel.this.duplicateButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.statusCombo) {
                IssuePanel.this.statusComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.osCombo) {
                IssuePanel.this.osComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.keywordsButton) {
                IssuePanel.this.keywordsButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.targetMilestoneCombo) {
                IssuePanel.this.targetMilestoneComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.severityCombo) {
                IssuePanel.this.severityComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.componentCombo) {
                IssuePanel.this.componentComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.productCombo) {
                IssuePanel.this.productComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.refreshButton) {
                IssuePanel.this.refreshButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.reloadButton) {
                IssuePanel.this.reloadButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.showInBrowserButton) {
                IssuePanel.this.showInBrowserButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.tasklistButton) {
                IssuePanel.this.tasklistButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.versionCombo) {
                IssuePanel.this.versionComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.platformCombo) {
                IssuePanel.this.platformComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.priorityCombo) {
                IssuePanel.this.priorityComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.urlLabel) {
                IssuePanel.this.urlButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.issueTypeCombo) {
                IssuePanel.this.issueTypeComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.submitButton) {
                IssuePanel.this.submitButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.cancelButton) {
                IssuePanel.this.cancelButtonActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.resolutionCombo) {
                IssuePanel.this.resolutionComboActionPerformed(evt);
            } else if (evt.getSource() == IssuePanel.this.assignedCombo) {
                IssuePanel.this.assignedComboActionPerformed(evt);
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
            if (evt.getSource() == IssuePanel.this.deadlineField) {
                IssuePanel.this.deadlineFieldFocusGained(evt);
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (evt.getSource() == IssuePanel.this.workedField) {
                IssuePanel.this.workedFieldFocusLost(evt);
            } else if (evt.getSource() == IssuePanel.this.deadlineField) {
                IssuePanel.this.deadlineFieldFocusLost(evt);
            }
        }
    }

    private static class PriorityRenderer
    extends DefaultListCellRenderer {
        private PriorityRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            renderer.setIcon(BugzillaConfig.getInstance().getPriorityIcon((String)value));
            return renderer;
        }
    }

    class RevalidatingListener
    implements DocumentListener,
    Runnable {
        private boolean ignoreUpdate;

        RevalidatingListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (this.ignoreUpdate) {
                return;
            }
            this.ignoreUpdate = true;
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            IssuePanel.this.revalidate();
            IssuePanel.this.repaint();
            this.ignoreUpdate = false;
        }
    }
}

