/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.RepositoryManager;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiAccessor;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.spi.TaskListIssueProvider;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.ResolveIssuePanel;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class BugzillaTaskListProvider
extends TaskListIssueProvider
implements PropertyChangeListener {
    private static BugzillaTaskListProvider instance;
    private final Object LOCK = new Object();
    private boolean initialized;
    private HashMap<String, BugzillaLazyIssue> watchedIssues = new HashMap(10);
    private static final Logger LOG;
    private static final Level LOG_LEVEL;
    private final RequestProcessor rp = new RequestProcessor("BugzillaTaskListProvider", 1, false);
    private static final String KENAI_REPOSITORY_IDENT_PREFIX = "K##";
    private static final String STORAGE_KENAI_VERSION = "1";
    private static final String STORAGE_COMMON_VERSION = "1";
    private final PropertyChangeSupport support;
    public static final String PROPERTY_ISSUE_REMOVED = "issue-removed";
    Map<String, BugzillaRepository> bugzillaRepositories = new HashMap<String, BugzillaRepository>();
    private Map<String, PropertyChangeListener> kenaiListeners;

    public static synchronized BugzillaTaskListProvider getInstance() {
        if (instance == null) {
            instance = new BugzillaTaskListProvider();
        }
        return instance;
    }

    private BugzillaTaskListProvider() {
        this.support = new PropertyChangeSupport(this);
        this.reloadAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BugzillaIssue issue, boolean openTaskList) {
        BugzillaLazyIssue lazyIssue;
        URL url = BugzillaTaskListProvider.getUrl(issue);
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isAdded(url)) {
                return;
            }
            try {
                BugzillaRepository bugzillaRepository = issue.getRepository();
                Repository repository = BugzillaUtil.getRepository(bugzillaRepository);
                repository.removePropertyChangeListener((PropertyChangeListener)this);
                repository.addPropertyChangeListener((PropertyChangeListener)this);
                lazyIssue = bugzillaRepository instanceof KenaiRepository ? new KenaiBugzillaLazyIssue(issue, this) : new BugzillaLazyIssue(issue, this);
                this.watchedIssues.put(url.toString(), lazyIssue);
            }
            catch (MalformedURLException e) {
                return;
            }
        }
        this.saveIntern();
        super.add(openTaskList, new TaskListIssueProvider.LazyIssue[]{lazyIssue});
    }

    public void remove(BugzillaIssue issue) {
        URL url = BugzillaTaskListProvider.getUrl(issue);
        this.remove(url, true);
    }

    public boolean isAdded(BugzillaIssue issue) {
        URL url = BugzillaTaskListProvider.getUrl(issue);
        return this.isAdded(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removed(TaskListIssueProvider.LazyIssue lazyIssue) {
        BugzillaLazyIssue removedIssue;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.isAdded(lazyIssue.getUrl())) {
                return;
            }
            removedIssue = this.watchedIssues.remove(lazyIssue.getUrl().toString());
        }
        this.saveIntern();
        this.fireIssueRemoved(removedIssue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object oldValue;
        if ("bugtracking.repository.attributes.changed".equals(evt.getPropertyName()) && evt.getOldValue() != null && evt.getOldValue() instanceof Map && (oldValue = ((Map)evt.getOldValue()).get("repository.attribute.url")) != null && oldValue instanceof String) {
            String oldRepoUrl = (String)oldValue;
            LinkedList<BugzillaLazyIssue> issuesToRefresh = new LinkedList<BugzillaLazyIssue>();
            Object object = this.LOCK;
            synchronized (object) {
                for (Map.Entry<String, BugzillaLazyIssue> e : this.watchedIssues.entrySet()) {
                    BugzillaLazyIssue issue = e.getValue();
                    Object sourceRepository = evt.getSource();
                    if (issue instanceof KenaiBugzillaLazyIssue || sourceRepository == null || !sourceRepository.equals(issue.getRepository())) continue;
                    URL oldUrl = BugzillaTaskListProvider.getUrl(oldRepoUrl, issue.issueId);
                    if (!issue.getUrl().toString().equals(oldUrl.toString())) continue;
                    LOG.log(Level.FINE, "propertyChange: Issue {0} with url {1} needs to be refreshed, repository's url {2} has changed", new String[]{issue.toString(), oldUrl.toString(), oldRepoUrl});
                    issuesToRefresh.add(issue);
                }
            }
            for (BugzillaLazyIssue issue : issuesToRefresh) {
                this.remove(issue.getUrl(), false);
                this.add(issue.getName(), issue.issueId, issue.getRepository());
            }
            if (!issuesToRefresh.isEmpty()) {
                this.saveIntern();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllFor(BugzillaRepository repository) {
        LinkedList<BugzillaLazyIssue> issuesToRemove = new LinkedList<BugzillaLazyIssue>();
        Object object = this.LOCK;
        synchronized (object) {
            for (Map.Entry<String, BugzillaLazyIssue> e : this.watchedIssues.entrySet()) {
                BugzillaLazyIssue issue = e.getValue();
                if (issue instanceof KenaiBugzillaLazyIssue || repository != issue.getRepository()) continue;
                LOG.log(Level.FINE, "removeAllFor: issue {0} repository {1} has been removed", new String[]{issue.toString(), repository.toString()});
                issuesToRemove.add(issue);
            }
        }
        for (BugzillaLazyIssue issue : issuesToRemove) {
            this.remove(issue.getUrl(), false);
        }
        if (!issuesToRemove.isEmpty()) {
            this.saveIntern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyIssueCreated(BugzillaIssue issue) {
        URL url = BugzillaTaskListProvider.getUrl(issue);
        BugzillaLazyIssue lazyIssue = null;
        Object object = this.LOCK;
        synchronized (object) {
            lazyIssue = this.watchedIssues.get(url.toString());
        }
        if (lazyIssue != null) {
            lazyIssue.setIssueReference(issue);
        }
    }

    public void notifyRepositoryCreated(BugzillaRepository repository) {
        if (repository.getInfo() != null) {
            this.bugzillaRepositories.put(repository.getID(), repository);
        }
    }

    public void notifyRepositoryRemoved(BugzillaRepository repository) {
        if (repository.getInfo() != null) {
            this.bugzillaRepositories.remove(repository.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAdded(URL url) {
        this.initializeIssues();
        if (url == null) {
            return false;
        }
        Object object = this.LOCK;
        synchronized (object) {
            return this.watchedIssues.containsKey(url.toString());
        }
    }

    private static URL getUrl(BugzillaIssue issue) {
        return BugzillaTaskListProvider.getUrl(issue.getRepository().getUrl(), issue.getID());
    }

    private static URL getUrl(String repositoryUrl, String issueId) {
        String url = Bugzilla.getInstance().getRepositoryConnector().getTaskUrl(repositoryUrl, issueId);
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            LOG.log(LOG_LEVEL, null, ex);
            try {
                return new URL(repositoryUrl + "#" + issueId);
            }
            catch (MalformedURLException ex2) {
                LOG.log(LOG_LEVEL, null, ex2);
                return null;
            }
        }
    }

    private void reloadAsync() {
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                BugzillaTaskListProvider.this.initializeIssues();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIntern() {
        BugzillaLazyIssue[] lazyIssues;
        Object object = this.LOCK;
        synchronized (object) {
            lazyIssues = this.watchedIssues.values().toArray(new BugzillaLazyIssue[this.watchedIssues.size()]);
        }
        final BugzillaLazyIssue[] lazyIssuesToSave = lazyIssues;
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                BugzillaTaskListProvider.this.initializeIssues();
                LOG.log(Level.FINE, "saveIntern: saving issues");
                HashMap<String, List<String>> issues = new HashMap<String, List<String>>();
                for (BugzillaLazyIssue issue : lazyIssuesToSave) {
                    String repositoryIdent = null;
                    boolean isKenai = false;
                    if (issue instanceof KenaiBugzillaLazyIssue) {
                        BugzillaRepository repo = issue.getRepository();
                        if (repo != null && !(repo instanceof KenaiRepository)) {
                            LOG.warning("saveIntern: KenaiBugzillaIssue has no kenai repository: " + repo);
                        } else {
                            repositoryIdent = BugzillaTaskListProvider.KENAI_REPOSITORY_IDENT_PREFIX + (repo == null ? ((KenaiBugzillaLazyIssue)issue).projectName : ((KenaiRepository)repo).getProductName());
                            isKenai = true;
                        }
                    } else {
                        repositoryIdent = issue.getRepositoryUrl();
                    }
                    if (repositoryIdent == null) continue;
                    List<String> issueAttributes = issues.get(repositoryIdent);
                    if (issueAttributes == null) {
                        issueAttributes = new LinkedList<String>();
                        issueAttributes.add(isKenai ? "1" : "1");
                    }
                    issueAttributes.add(issue.issueId);
                    issueAttributes.add(issue.getName());
                    if (isKenai) {
                        issueAttributes.add(issue.getUrl().toString());
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("saveIntern: saving " + issueAttributes + " for repo: " + repositoryIdent);
                    }
                    issues.put(repositoryIdent, issueAttributes);
                }
                BugzillaConfig.getInstance().setTaskListIssues(issues);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIssues() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            LOG.finer("initializeIssues: reloading saved issues");
            Map<String, List<String>> repositoryIssues = BugzillaConfig.getInstance().getTaskListIssues();
            if (repositoryIssues.isEmpty()) {
                LOG.fine("initializeIssues: no saved issues");
                return;
            }
            this.addCommonIssues(repositoryIssues);
            this.addKenaiIssues(repositoryIssues);
        }
    }

    private String getNextAttribute(ListIterator<String> it) {
        String attr = null;
        if (it.hasNext()) {
            attr = it.next();
        }
        return attr;
    }

    private void addCommonIssues(Map<String, List<String>> repositoryIssues) {
        Collection repositories = RepositoryManager.getInstance().getRepositories("org.netbeans.modules.bugzilla");
        for (Repository repository : repositories) {
            List<String> issueAttributes = repositoryIssues.get(repository.getUrl());
            if (issueAttributes == null || issueAttributes.size() <= 1) continue;
            ListIterator<String> it = issueAttributes.listIterator();
            if (!"1".equals(it.next())) {
                LOG.log(Level.WARNING, "Old unsupported storage version, expecting {0}", "1");
                break;
            }
            while (it.hasNext()) {
                String issueId = this.getNextAttribute(it);
                String issueName = this.getNextAttribute(it);
                if (issueId == null || issueName == null) {
                    LOG.log(Level.WARNING, "Corrupted issue attributes: {0} {1}", new String[]{issueId, issueName});
                    break;
                }
                BugzillaRepository bugzillaRepository = this.bugzillaRepositories.get(repository.getId());
                assert (bugzillaRepository != null);
                this.add(issueName, issueId, bugzillaRepository);
            }
            repository.addPropertyChangeListener((PropertyChangeListener)this);
            repositoryIssues.remove(repository.getUrl());
        }
    }

    private void addKenaiIssues(Map<String, List<String>> repositoryIssues) {
        block2: for (Map.Entry<String, List<String>> e : repositoryIssues.entrySet()) {
            String projectName = e.getKey();
            if (!projectName.startsWith(KENAI_REPOSITORY_IDENT_PREFIX)) continue;
            projectName = projectName.substring(KENAI_REPOSITORY_IDENT_PREFIX.length());
            List<String> issueAttributes = e.getValue();
            if (issueAttributes == null || issueAttributes.size() <= 1) continue;
            ListIterator<String> it = issueAttributes.listIterator();
            if (!"1".equals(it.next())) {
                LOG.log(Level.WARNING, "Old unsupported storage version for kenai issues, expecting {0}", "1");
                break;
            }
            while (it.hasNext()) {
                URL issueUrl;
                String issueId = this.getNextAttribute(it);
                String issueName = this.getNextAttribute(it);
                String url = this.getNextAttribute(it);
                if (issueId == null || issueName == null || url == null) {
                    LOG.log(Level.WARNING, "Corrupted kenai issue attributes: {0} {1} {2}", new String[]{issueId, issueName, url});
                    continue block2;
                }
                try {
                    issueUrl = new URL(url);
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.INFO, null, ex);
                    continue;
                }
                this.add(issueName, issueUrl, issueId, projectName);
                KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
                if (ka == null) continue;
                String host = issueUrl.getHost();
                Map<String, PropertyChangeListener> kl = this.getKenaiListeners();
                PropertyChangeListener l = kl.get(host);
                if (l != null) continue;
                l = new KenaiListener(host);
                ka.addPropertyChangeListener(l, host);
                kl.put(host, l);
            }
        }
    }

    private Map<String, PropertyChangeListener> getKenaiListeners() {
        if (this.kenaiListeners == null) {
            this.kenaiListeners = new HashMap<String, PropertyChangeListener>();
        }
        return this.kenaiListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(URL url, boolean savePermanently) {
        BugzillaLazyIssue lazyIssue;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.isAdded(url)) {
                return;
            }
            lazyIssue = this.watchedIssues.remove(url.toString());
        }
        if (savePermanently) {
            this.saveIntern();
        }
        super.remove(new TaskListIssueProvider.LazyIssue[]{lazyIssue});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(String issueName, URL issueUrl, String issueId, String projectName) {
        KenaiBugzillaLazyIssue issue;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isAdded(issueUrl)) {
                return;
            }
            issue = new KenaiBugzillaLazyIssue(issueName, issueUrl, issueId, projectName, this);
            this.watchedIssues.put(issueUrl.toString(), issue);
        }
        super.add(new TaskListIssueProvider.LazyIssue[]{issue});
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "initializeIssues: issue added: {0}", (Object)issue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(String issueName, String issueId, BugzillaRepository repository) {
        BugzillaLazyIssue issue;
        URL issueUrl = BugzillaTaskListProvider.getUrl(repository.getUrl(), issueId);
        Object object = this.LOCK;
        synchronized (object) {
            if (issueUrl == null || this.isAdded(issueUrl)) {
                return;
            }
            issue = new BugzillaLazyIssue(issueName, issueUrl, issueId, repository, this);
            this.watchedIssues.put(issueUrl.toString(), issue);
        }
        super.add(new TaskListIssueProvider.LazyIssue[]{issue});
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "initializeIssues: issue added: {0}", (Object)issue);
        }
    }

    private static void runCancellableCommand(Runnable runnable, String progressMessage) {
        RequestProcessor.Task task = Bugzilla.getInstance().getRequestProcessor().post(runnable);
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)progressMessage, (Cancellable)task);
        handle.start();
        task.waitFinished();
        handle.finish();
    }

    private BugzillaIssue getIssue(final BugzillaRepository repository, final String issueId) {
        assert (!EventQueue.isDispatchThread());
        int status = repository.getIssueCache().getStatus(issueId);
        final BugzillaIssue[] issue = new BugzillaIssue[1];
        if (status == 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    LOG.log(Level.FINE, "getIssue: creating issue {0}", repository.getUrl() + "#" + issueId);
                    issue[0] = repository.getIssue(issueId);
                }
            };
            BugzillaTaskListProvider.runCancellableCommand(runnable, NbBundle.getMessage(BugzillaTaskListProvider.class, (String)"BugzillaIssueProvider.loadingIssue"));
        } else {
            LOG.log(Level.FINER, "getIssue: getting issue {0} from the cache", repository.getUrl() + "#" + issueId);
            issue[0] = (BugzillaIssue)repository.getIssueCache().getIssue(issueId);
        }
        return issue[0];
    }

    private void fireIssueRemoved(BugzillaLazyIssue lazyIssue) {
        BugzillaIssue issue = (BugzillaIssue)lazyIssue.issueRef.get();
        if (issue != null) {
            this.support.firePropertyChange(PROPERTY_ISSUE_REMOVED, issue, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyKenaiLogin(String notifiedKenaiHost) {
        assert (notifiedKenaiHost != null);
        Object object = this.LOCK;
        synchronized (object) {
            for (BugzillaLazyIssue issue : this.watchedIssues.values()) {
                if (!(issue instanceof KenaiBugzillaLazyIssue) || !notifiedKenaiHost.equals(issue.getUrl().getHost())) continue;
                ((KenaiBugzillaLazyIssue)issue).notifyKenaiLogin();
            }
        }
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.Bugzilla.tasklist");
        LOG_LEVEL = BugzillaUtil.isAssertEnabled() ? Level.INFO : Level.FINE;
    }

    private static class BugzillaLazyIssue
    extends TaskListIssueProvider.LazyIssue {
        private final String issueId;
        private WeakReference<BugzillaRepository> repositoryRef;
        protected final BugzillaTaskListProvider provider;
        private WeakReference<BugzillaIssue> issueRef;
        private PropertyChangeListener issueListener;

        public BugzillaLazyIssue(BugzillaIssue issue, BugzillaTaskListProvider provider) throws MalformedURLException {
            super(BugzillaTaskListProvider.getUrl(issue), issue.getDisplayName());
            this.issueId = issue.getID();
            this.provider = provider;
            this.repositoryRef = new WeakReference<BugzillaRepository>(issue.getRepository());
            this.issueRef = new WeakReference<BugzillaIssue>(issue);
            this.attachIssueListener(issue);
        }

        public BugzillaLazyIssue(String name, URL url, String issueId, BugzillaRepository repository, BugzillaTaskListProvider provider) {
            super(url, name);
            this.issueId = issueId;
            this.repositoryRef = new WeakReference<BugzillaRepository>(repository);
            this.provider = provider;
            this.issueRef = new WeakReference<Object>(null);
        }

        public BugzillaIssue getIssue() {
            BugzillaIssue issue = (BugzillaIssue)this.issueRef.get();
            if (issue == null) {
                BugzillaRepository repository = this.getRepository();
                if (repository == null) {
                    LOG.log(Level.INFO, "Repository unavailable for {0}", this.getUrl().toString());
                    if (this.canBeAutoRemoved()) {
                        this.provider.remove(this.getUrl(), true);
                    }
                } else {
                    issue = this.provider.getIssue(repository, this.issueId);
                }
                this.setIssueReference(issue);
            }
            return issue;
        }

        private BugzillaRepository getRepository() {
            return (BugzillaRepository)this.repositoryRef.get();
        }

        private void setIssueReference(BugzillaIssue issue) {
            this.issueRef = new WeakReference<BugzillaIssue>(issue);
            if (issue != null) {
                this.applyChangesFor(issue);
                this.attachIssueListener(issue);
            }
        }

        private void attachIssueListener(BugzillaIssue issue) {
            if (this.issueListener == null) {
                this.issueListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        BugzillaIssue issue = (BugzillaIssue)BugzillaLazyIssue.this.issueRef.get();
                        if ("issue.data_changed".equals(evt.getPropertyName()) && issue != null) {
                            BugzillaLazyIssue.this.applyChangesFor(issue);
                        }
                    }
                };
            }
            LOG.log(Level.FINE, "attachIssueListener: on issue {0}", issue.toString());
            issue.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.issueListener, (Object)issue));
        }

        private void applyChangesFor(BugzillaIssue issue) {
            boolean requiresSave = false;
            if (!this.getName().equals(issue.getDisplayName())) {
                this.setName(issue.getDisplayName());
                requiresSave = true;
            }
            if (requiresSave) {
                this.provider.saveIntern();
            }
        }

        public String getRepositoryUrl() {
            String repoUrl = null;
            BugzillaRepository repository = this.getRepository();
            if (repository != null) {
                repoUrl = repository.getUrl();
            }
            return repoUrl;
        }

        public List<? extends Action> getActions() {
            LinkedList<2> actions = new LinkedList<2>();
            actions.add(new AbstractAction(NbBundle.getMessage(BugzillaTaskListProvider.class, (String)"BugzillaIssueProvider.resolveAction")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            final BugzillaIssue issue = BugzillaLazyIssue.this.getIssue();
                            if (issue == null) {
                                LOG.fine("Resole action: null issue returned");
                            } else {
                                if (!issue.isResolveAvailable()) {
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(BugzillaTaskListProvider.class, (String)"BugzillaIssueProvider.resolveAction.notPermitted"), 1));
                                    return;
                                }
                                ResolveIssuePanel panel = new ResolveIssuePanel(issue);
                                if (panel.showDialog()) {
                                    LOG.finer("Resolve action: resolving...");
                                    String pattern = NbBundle.getMessage(BugzillaTaskListProvider.class, (String)"BugzillaIssueProvider.resolveIssueMessage");
                                    final String resolution = panel.getSelectedResolution();
                                    final String duplicateId = panel.getDuplicateId();
                                    final String comment = panel.getComment();
                                    BugzillaTaskListProvider.runCancellableCommand(new Runnable(){

                                        @Override
                                        public void run() {
                                            if ("DUPLICATE".equals(resolution)) {
                                                issue.duplicate(duplicateId);
                                            } else {
                                                issue.resolve(resolution);
                                            }
                                            if (comment.length() > 0) {
                                                issue.addComment(comment);
                                            }
                                            if (issue.submitAndRefresh()) {
                                                BugzillaUtil.openIssue(issue);
                                            }
                                        }
                                    }, MessageFormat.format(pattern, issue.getID()));
                                }
                            }
                        }
                    });
                }

                @Override
                public boolean isEnabled() {
                    boolean allowed = true;
                    BugzillaIssue issue = (BugzillaIssue)BugzillaLazyIssue.this.issueRef.get();
                    if (issue != null) {
                        allowed = issue.isResolveAvailable();
                    }
                    return allowed;
                }
            });
            return actions;
        }

        protected boolean canBeAutoRemoved() {
            return true;
        }

        protected void setRepositoryReference(BugzillaRepository repository) {
            if (repository != null) {
                this.repositoryRef = new WeakReference<BugzillaRepository>(repository);
            }
        }

        public void open() {
            BugzillaIssue issue = this.getIssue();
            if (issue != null) {
                LOG.log(Level.FINER, "TaskListProvider: openning issue {0}", this.getName());
                BugzillaUtil.openIssue(issue);
            } else {
                LOG.log(Level.FINE, "null issue returned for {0}", this.getName());
            }
        }
    }

    private static final class KenaiBugzillaLazyIssue
    extends BugzillaLazyIssue {
        private final String projectName;
        private boolean loginStatusChanged = true;

        public KenaiBugzillaLazyIssue(BugzillaIssue issue, BugzillaTaskListProvider provider) throws MalformedURLException {
            super(issue, provider);
            BugzillaRepository repo = issue.getRepository();
            if (!(repo instanceof KenaiRepository)) {
                throw new IllegalStateException("Cannot instantiate with a non kenai issue: " + issue);
            }
            this.projectName = ((KenaiRepository)repo).getProductName();
        }

        public KenaiBugzillaLazyIssue(String name, URL url, String issueId, String projectName, BugzillaTaskListProvider provider) {
            super(name, url, issueId, null, provider);
            this.projectName = projectName;
        }

        protected KenaiRepository lookupRepository() {
            KenaiRepository kenaiRepo = null;
            BugzillaRepository repo = null;
            if (this.loginStatusChanged) {
                try {
                    LOG.log(Level.FINE, "KenaiBugzillaLazyIssue.lookupRepository: getting repository for: " + this.projectName);
                    String url = this.getUrl().toString();
                    Repository repository = KenaiUtil.getRepository((String)url, (String)this.projectName);
                    repo = repository != null ? this.provider.bugzillaRepositories.get(repository.getId()) : null;
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, "KenaiBugzillaLazyIssue.lookupRepository: getting repository for " + this.projectName, ex);
                }
                this.loginStatusChanged = false;
            }
            if (repo != null && repo instanceof KenaiRepository) {
                kenaiRepo = (KenaiRepository)repo;
            } else {
                LOG.log(Level.FINE, "KenaiBugzillaLazyIssue.lookupRepository: no repository for: " + this.projectName);
            }
            return kenaiRepo;
        }

        @Override
        protected boolean canBeAutoRemoved() {
            return false;
        }

        @Override
        public String getRepositoryUrl() {
            KenaiRepository repo;
            String repoUrl = super.getRepositoryUrl();
            if (repoUrl == null && (repo = this.lookupRepository()) != null) {
                this.setRepositoryReference(repo);
                repoUrl = repo.getUrl();
            }
            return repoUrl;
        }

        private void notifyKenaiLogin() {
            this.loginStatusChanged = true;
            this.setValid(false);
        }
    }

    private class KenaiListener
    implements PropertyChangeListener {
        private final String kenaiHost;

        public KenaiListener(String kenaiHost) {
            this.kenaiHost = kenaiHost;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("kenai.login.changed".equals(evt.getPropertyName())) {
                BugzillaTaskListProvider.this.rp.post(new Runnable(){

                    @Override
                    public void run() {
                        BugzillaTaskListProvider.this.notifyKenaiLogin(KenaiListener.this.kenaiHost);
                    }
                });
            }
        }
    }
}

