/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.util.Arrays;
import java.util.HashSet;
import org.netbeans.modules.bugtracking.spi.IssueFinder;
import org.openide.ErrorManager;

public class BugzillaIssueFinder
extends IssueFinder {
    private static BugzillaIssueFinder instance;
    private static final int[] EMPTY_INT_ARR;

    private BugzillaIssueFinder() {
    }

    public static synchronized BugzillaIssueFinder getInstance() {
        if (instance == null) {
            instance = new BugzillaIssueFinder();
        }
        return instance;
    }

    public int[] getIssueSpans(CharSequence text) {
        int[] result = BugzillaIssueFinder.findBoundaries(text);
        return result != null ? result : EMPTY_INT_ARR;
    }

    public String getIssueId(String issueHyperlinkText) {
        int pos;
        for (pos = issueHyperlinkText.length() - 1; pos >= 0 && Impl.isDigit(issueHyperlinkText.charAt(pos)); --pos) {
        }
        return issueHyperlinkText.substring(pos + 1);
    }

    private static int[] findBoundaries(CharSequence str) {
        try {
            return BugzillaIssueFinder.getImpl().findBoundaries(str);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
            return null;
        }
    }

    private static Impl getImpl() {
        return new Impl();
    }

    static BugzillaIssueFinder getTestInstance() {
        return new BugzillaIssueFinder();
    }

    private static boolean equalsIgnoreCase(CharSequence pattern, CharSequence str) {
        int patternLength = pattern.length();
        if (str.length() != patternLength) {
            return false;
        }
        for (int i = 0; i < patternLength; ++i) {
            if ((str.charAt(i) | 0x20) == pattern.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static {
        EMPTY_INT_ARR = new int[0];
    }

    private static final class Impl {
        private static final String[] BUGWORDS = new String[]{"bug", "issue"};
        private static final String BUG_NUMBER_PREFIX = "duplicate of";
        private static final String[] BUGNUM_PREFIX_PARTS = "duplicate of".split(" ");
        private static final String PUNCT_CHARS = ".,:;()[]{}/*";
        private static final int LOWER_A = 97;
        private static final int LOWER_Z = 122;
        private static final int INIT = 0;
        private static final int CHARS = 1;
        private static final int HASH = 2;
        private static final int HASH_SPC = 3;
        private static final int NUM = 4;
        private static final int BUGWORD = 5;
        private static final int BUGWORD_NL = 6;
        private static final int STAR = 7;
        private static final int GARBAGE = 8;
        private CharSequence str;
        private int pos;
        private int state;
        private int bugnumPrefixPartsProcessed;
        int startOfWord;
        int start;
        int end;
        int[] result;

        private Impl() {
        }

        private int[] findBoundaries(CharSequence str) {
            this.reset();
            this.str = str;
            this.pos = 0;
            while (this.pos < str.length()) {
                this.handleChar(str.charAt(this.pos));
                ++this.pos;
            }
            if (this.state == 4) {
                this.storeResult(this.start, this.pos);
            }
            return this.result;
        }

        private void reset() {
            this.str = null;
            this.pos = 0;
            this.state = 0;
            this.bugnumPrefixPartsProcessed = 0;
            this.startOfWord = -1;
            this.start = -1;
            this.end = -1;
            this.result = null;
        }

        private void handleChar(int c) {
            int newState;
            boolean keepCountingBugwords = false;
            switch (this.state) {
                case 0: {
                    if (c == 35) {
                        this.rememberIsStart();
                        newState = 2;
                        break;
                    }
                    if (Impl.isLetter(c)) {
                        this.rememberIsStart();
                        newState = 1;
                        break;
                    }
                    newState = this.getInitialState(c);
                    break;
                }
                case 1: {
                    if (Impl.isLetter(c)) {
                        newState = 1;
                        keepCountingBugwords = true;
                        break;
                    }
                    if (c == 32 || c == 9 || c == 13 || c == 10) {
                        if (this.bugnumPrefixPartsProcessed == 0 && this.isBugword() || this.tryHandleBugnumPrefixPart()) {
                            newState = c == 32 || c == 9 ? 5 : 6;
                            keepCountingBugwords = true;
                            break;
                        }
                        newState = this.getInitialState(c);
                        break;
                    }
                    newState = this.getInitialState(c);
                    break;
                }
                case 2: {
                    if (c == 32 || c == 9) {
                        newState = 3;
                        break;
                    }
                    if (Impl.isDigit(c)) {
                        newState = 4;
                        break;
                    }
                    newState = this.getInitialState(c);
                    break;
                }
                case 3: {
                    if (c == 32 || c == 9) {
                        newState = 3;
                        break;
                    }
                    if (Impl.isDigit(c)) {
                        newState = 4;
                        break;
                    }
                    newState = this.getInitialState(c);
                    break;
                }
                case 4: {
                    if (Impl.isDigit(c)) {
                        newState = 4;
                        break;
                    }
                    newState = this.getInitialState(c);
                    break;
                }
                case 5: 
                case 6: {
                    if (this.state == 6 && c == 42) {
                        keepCountingBugwords = true;
                        newState = 7;
                        break;
                    }
                    if (c == 32 || c == 9) {
                        keepCountingBugwords = true;
                        newState = this.state;
                        break;
                    }
                    if (c == 13 || c == 10) {
                        keepCountingBugwords = true;
                        newState = 6;
                        break;
                    }
                    if (c == 35) {
                        newState = 2;
                        if (!this.isBugnumPrefix()) break;
                        this.start = this.pos;
                        break;
                    }
                    if (Impl.isDigit(c)) {
                        if (this.isPartialBugnumPrefix()) {
                            newState = this.getInitialState(c);
                            break;
                        }
                        newState = 4;
                        if (!this.isFullBugnumPrefix()) break;
                        this.start = this.pos;
                        break;
                    }
                    if (Impl.isLetter(c)) {
                        newState = 1;
                        if (this.isPartialBugnumPrefix()) {
                            keepCountingBugwords = true;
                            this.startOfWord = this.pos;
                            break;
                        }
                        this.rememberIsStart();
                        break;
                    }
                    newState = this.getInitialState(c);
                    break;
                }
                case 7: {
                    if (c == 32 || c == 9) {
                        keepCountingBugwords = true;
                        newState = 5;
                        break;
                    }
                    if (c == 13 || c == 10) {
                        keepCountingBugwords = true;
                        newState = 6;
                        break;
                    }
                    newState = this.getInitialState(c);
                    break;
                }
                case 8: {
                    newState = this.getInitialState(c);
                    break;
                }
                default: {
                    assert (false);
                    newState = this.getInitialState(c);
                }
            }
            if (this.state == 4 && newState != 4 && Impl.isSpaceOrPunct(c)) {
                this.storeResult(this.start, this.pos);
            }
            if (newState == 0 || newState == 8) {
                this.start = -1;
            }
            if (!keepCountingBugwords) {
                this.bugnumPrefixPartsProcessed = 0;
            }
            this.state = newState;
        }

        private int getInitialState(int c) {
            return Impl.isSpaceOrPunct(c) ? 0 : 8;
        }

        private void rememberIsStart() {
            this.start = this.pos;
            this.startOfWord = this.pos;
        }

        private void storeResult(int start, int end) {
            assert (start != -1);
            if (this.result == null) {
                this.result = new int[]{start, end};
            } else {
                int[] newResult = new int[this.result.length + 2];
                System.arraycopy(this.result, 0, newResult, 0, this.result.length);
                newResult[this.result.length] = start;
                newResult[this.result.length + 1] = end;
                this.result = newResult;
            }
        }

        private static boolean isLetter(int c) {
            return (c |= 0x20) >= 97 && c <= 122;
        }

        private static boolean isDigit(int c) {
            return c >= 48 && c <= 57;
        }

        private static boolean isSpaceOrPunct(int c) {
            return c == 13 || c == 10 || Character.isSpaceChar(c) || Impl.isPunct(c);
        }

        private static boolean isPunct(int c) {
            return PUNCT_CHARS.indexOf(c) != -1;
        }

        private boolean isBugword() {
            CharSequence word = this.str.subSequence(this.start, this.pos);
            for (int i = 0; i < BUGWORDS.length; ++i) {
                if (!BugzillaIssueFinder.equalsIgnoreCase(Impl.BUGWORDS[i], word)) continue;
                return true;
            }
            return false;
        }

        private boolean tryHandleBugnumPrefixPart() {
            CharSequence word = this.str.subSequence(this.startOfWord, this.pos);
            if (this.bugnumPrefixPartsProcessed < BUGNUM_PREFIX_PARTS.length && BugzillaIssueFinder.equalsIgnoreCase(Impl.BUGNUM_PREFIX_PARTS[this.bugnumPrefixPartsProcessed], word)) {
                ++this.bugnumPrefixPartsProcessed;
                return true;
            }
            if (this.bugnumPrefixPartsProcessed != 0 && BugzillaIssueFinder.equalsIgnoreCase(Impl.BUGNUM_PREFIX_PARTS[0], word)) {
                this.bugnumPrefixPartsProcessed = 1;
                this.start = this.startOfWord;
                return true;
            }
            return false;
        }

        private boolean isBugnumPrefix() {
            return this.bugnumPrefixPartsProcessed != 0;
        }

        private boolean isPartialBugnumPrefix() {
            return this.bugnumPrefixPartsProcessed > 0 && this.bugnumPrefixPartsProcessed < BUGNUM_PREFIX_PARTS.length;
        }

        private boolean isFullBugnumPrefix() {
            return this.bugnumPrefixPartsProcessed == BUGNUM_PREFIX_PARTS.length;
        }

        static {
            boolean asserts = false;
            if (!$assertionsDisabled) {
                asserts = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (asserts) {
                int i;
                for (i = 0; i < BUGWORDS.length; ++i) {
                    assert (BUGWORDS[i].equals(BUGWORDS[i].toLowerCase()));
                }
                for (i = 0; i < BUGNUM_PREFIX_PARTS.length; ++i) {
                    assert (BUGNUM_PREFIX_PARTS[i].equals(BUGNUM_PREFIX_PARTS[i].toLowerCase()));
                }
                HashSet<String> bugnumPrefixPartsSet = new HashSet<String>(7);
                bugnumPrefixPartsSet.addAll(Arrays.asList(BUGNUM_PREFIX_PARTS));
                assert (bugnumPrefixPartsSet.size() == BUGNUM_PREFIX_PARTS.length);
            }
        }
    }
}

