/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.UIUtils;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.issue.AttachmentPanel;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.IssuePanel;
import org.openide.modules.Places;
import org.openide.util.NbBundle;

public class AttachmentsPanel
extends JPanel {
    private static final Color BG_COLOR = new Color(220, 220, 220);
    private boolean hadNoAttachments = true;
    private List<AttachmentPanel> newAttachments;
    private JLabel noneLabel;
    private LinkButton createNewButton;
    private LinkButton attachLogFileButton;
    private JLabel dummyCreateLabel = new JLabel();
    private JLabel dummyAttachLabel = new JLabel();
    private Method maxMethod;
    private PropertyChangeListener deletedListener;

    public AttachmentsPanel() {
        this.setBackground(UIManager.getColor("TextArea.background"));
        ResourceBundle bundle = NbBundle.getBundle(AttachmentsPanel.class);
        this.noneLabel = new JLabel(bundle.getString("AttachmentsPanel.noneLabel.text"));
        this.createNewButton = new LinkButton((Action)new CreateNewAction());
        this.createNewButton.getAccessibleContext().setAccessibleDescription(bundle.getString("AttachmentPanels.createNewButton.AccessibleContext.accessibleDescription"));
        try {
            this.maxMethod = GroupLayout.Group.class.getDeclaredMethod("calculateMaximumSize", Integer.TYPE);
            this.maxMethod.setAccessible(true);
        }
        catch (NoSuchMethodException nsmex) {
            Bugzilla.LOG.log(Level.INFO, nsmex.getMessage(), nsmex);
        }
    }

    void setAttachments(List<BugzillaIssue.Attachment> attachments, boolean attachLogFile) {
        GroupLayout.ParallelGroup pg;
        GroupLayout.SequentialGroup sg;
        if (attachLogFile) {
            this.attachLogFileButton = new LinkButton((Action)new CreateNewAction(true));
            this.attachLogFileButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AttachmentsPanel.class).getString("AttachmentPanels.attachLogFileButton.AccessibleContext.accessibleDescription"));
        }
        this.hadNoAttachments = attachments.isEmpty();
        this.newAttachments = new LinkedList<AttachmentPanel>();
        this.removeAll();
        GroupLayout layout = new GroupLayout(this);
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        ResourceBundle bundle = NbBundle.getBundle(AttachmentsPanel.class);
        GroupLayout.SequentialGroup newVerticalGroup = layout.createSequentialGroup();
        boolean noAttachments = this.hadNoAttachments;
        if (this.attachLogFileButton != null) {
            sg = layout.createSequentialGroup();
            sg.addComponent(this.noneLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)(noAttachments ? this.createNewButton : this.dummyCreateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)(noAttachments ? this.attachLogFileButton : this.dummyAttachLabel));
            horizontalGroup.addGroup(sg);
        } else {
            horizontalGroup.addGroup(layout.createSequentialGroup().addComponent(this.noneLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)(noAttachments ? this.createNewButton : this.dummyCreateLabel)));
        }
        if (this.attachLogFileButton != null) {
            pg = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            pg.addComponent(this.noneLabel).addComponent((Component)(noAttachments ? this.createNewButton : this.dummyCreateLabel)).addComponent((Component)(noAttachments ? this.attachLogFileButton : this.dummyAttachLabel));
            verticalGroup.addGroup(pg);
        } else {
            verticalGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noneLabel).addComponent((Component)(noAttachments ? this.createNewButton : this.dummyCreateLabel)));
        }
        this.dummyCreateLabel.setVisible(false);
        this.dummyAttachLabel.setVisible(false);
        this.noneLabel.setVisible(noAttachments);
        this.updateButtonText(noAttachments);
        if (noAttachments) {
            verticalGroup.addGroup(newVerticalGroup);
        } else {
            ArrayList<JPanel> panels = new ArrayList<JPanel>();
            JLabel descriptionLabel = new JLabel(bundle.getString("AttachmentsPanel.table.description"));
            JLabel filenameLabel = new JLabel(bundle.getString("AttachmentsPanel.table.filename"));
            JLabel dateLabel = new JLabel(bundle.getString("AttachmentsPanel.table.date"));
            JLabel authorLabel = new JLabel(bundle.getString("AttachmentsPanel.table.author"));
            this.makeBold(descriptionLabel);
            this.makeBold(filenameLabel);
            this.makeBold(dateLabel);
            this.makeBold(authorLabel);
            GroupLayout.ParallelGroup descriptionGroup = layout.createParallelGroup();
            GroupLayout.ParallelGroup filenameGroup = layout.createParallelGroup();
            GroupLayout.ParallelGroup dateGroup = layout.createParallelGroup();
            GroupLayout.ParallelGroup authorGroup = layout.createParallelGroup();
            int descriptionWidth = Math.max(descriptionLabel.getPreferredSize().width, 150);
            descriptionGroup.addComponent(descriptionLabel, descriptionWidth, descriptionWidth, descriptionWidth);
            filenameGroup.addComponent(filenameLabel);
            dateGroup.addComponent(dateLabel);
            authorGroup.addComponent(authorLabel);
            JPanel panel = this.createHighlightPanel();
            panels.add(panel);
            horizontalGroup.addGroup(layout.createSequentialGroup().addGroup(descriptionGroup).addPreferredGap(descriptionLabel, filenameLabel, LayoutStyle.ComponentPlacement.UNRELATED).addGroup(filenameGroup).addPreferredGap(filenameLabel, dateLabel, LayoutStyle.ComponentPlacement.UNRELATED).addGroup(dateGroup).addPreferredGap(dateLabel, authorLabel, LayoutStyle.ComponentPlacement.UNRELATED).addGroup(authorGroup));
            verticalGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(panel, 0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(descriptionLabel).addComponent(filenameLabel).addComponent(dateLabel).addComponent(authorLabel)));
            for (BugzillaIssue.Attachment attachment : attachments) {
                boolean isPatch = "1".equals(attachment.getIsPatch());
                String description = attachment.getDesc();
                String filename = attachment.getFilename();
                Date date = attachment.getDate();
                String author = attachment.getAuthor();
                String authorName = attachment.getAuthorName();
                authorName = authorName != null && authorName.trim().length() > 0 ? authorName : author;
                descriptionLabel = new JLabel(description);
                LinkButton filenameButton = new LinkButton();
                LinkButton patchButton = null;
                JLabel lBrace = null;
                JLabel rBrace = null;
                GroupLayout.SequentialGroup hPatchGroup = null;
                if (isPatch) {
                    patchButton = new LinkButton();
                    lBrace = new JLabel("(");
                    rBrace = new JLabel(")");
                    hPatchGroup = layout.createSequentialGroup().addComponent((Component)filenameButton).addPreferredGap((JComponent)filenameButton, lBrace, LayoutStyle.ComponentPlacement.RELATED).addComponent(lBrace).addComponent((Component)patchButton).addComponent(rBrace);
                }
                JPopupMenu menu = this.menuFor(attachment, patchButton);
                filenameButton.setAction((Action)new BugzillaIssue.Attachment.DefaultAttachmentAction(attachment));
                filenameButton.setText(filename);
                filenameButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentPanels.filenameButton.AccessibleContext.accessibleDescription"));
                dateLabel = new JLabel(date != null ? DateFormat.getDateInstance().format(date) : "");
                JLabel authorComponent = author.indexOf("@") > -1 ? new LinkButton.MailtoButton(authorName, NbBundle.getMessage(IssuePanel.class, (String)"AttachmentPanel.authorButton.AccessibleContext.accessibleDescription"), author) : new JLabel(authorName);
                descriptionLabel.setComponentPopupMenu(menu);
                filenameButton.setComponentPopupMenu(menu);
                dateLabel.setComponentPopupMenu(menu);
                authorComponent.setComponentPopupMenu(menu);
                descriptionGroup.addComponent(descriptionLabel, 0, -1, -2);
                if (isPatch) {
                    lBrace.setComponentPopupMenu(menu);
                    patchButton.setComponentPopupMenu(menu);
                    rBrace.setComponentPopupMenu(menu);
                    filenameGroup.addGroup(hPatchGroup);
                } else {
                    filenameGroup.addComponent((Component)filenameButton);
                }
                dateGroup.addComponent(dateLabel);
                authorGroup.addComponent(authorComponent);
                panel = this.createHighlightPanel();
                panel.addMouseListener(new MouseAdapter(){});
                panel.setComponentPopupMenu(menu);
                panels.add(panel);
                GroupLayout.ParallelGroup pGroup = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
                pGroup.addComponent(descriptionLabel);
                pGroup.addComponent((Component)filenameButton);
                if (isPatch) {
                    pGroup.addComponent(lBrace);
                    pGroup.addComponent((Component)patchButton);
                    pGroup.addComponent(rBrace);
                }
                pGroup.addComponent(dateLabel);
                pGroup.addComponent(authorComponent);
                verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(panel, 0, 0, Short.MAX_VALUE).addGroup(pGroup));
            }
            verticalGroup.addGroup(newVerticalGroup);
            int groupWidth = 0;
            if (this.maxMethod != null) {
                try {
                    groupWidth = (Integer)this.maxMethod.invoke((Object)horizontalGroup, 0);
                }
                catch (Exception ex) {
                    Bugzilla.LOG.log(Level.INFO, ex.getMessage(), ex);
                }
            }
            for (JPanel p : panels) {
                horizontalGroup.addComponent(p, 0, 0, groupWidth);
            }
        }
        if (this.attachLogFileButton != null) {
            sg = layout.createSequentialGroup();
            sg.addComponent(noAttachments ? this.dummyCreateLabel : this.createNewButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(noAttachments ? this.dummyAttachLabel : this.attachLogFileButton).addGap(0, 0, Short.MAX_VALUE);
            horizontalGroup.addGroup(sg);
        } else {
            horizontalGroup.addGroup(layout.createSequentialGroup().addComponent(noAttachments ? this.dummyCreateLabel : this.createNewButton).addGap(0, 0, Short.MAX_VALUE));
        }
        if (this.attachLogFileButton != null) {
            pg = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            pg.addComponent(noAttachments ? this.dummyCreateLabel : this.createNewButton).addComponent(noAttachments ? this.dummyAttachLabel : this.attachLogFileButton);
            verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            verticalGroup.addGroup(pg);
        } else {
            verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            verticalGroup.addComponent(noAttachments ? this.dummyCreateLabel : this.createNewButton);
        }
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        ((CreateNewAction)this.createNewButton.getAction()).setLayoutGroups(horizontalGroup, newVerticalGroup);
        if (this.attachLogFileButton != null) {
            ((CreateNewAction)this.attachLogFileButton.getAction()).setLayoutGroups(horizontalGroup, newVerticalGroup);
        }
        this.setLayout(layout);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, super.getMinimumSize().height);
    }

    private JPopupMenu menuFor(BugzillaIssue.Attachment attachment, LinkButton patchButton) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new BugzillaIssue.Attachment.DefaultAttachmentAction(attachment));
        menu.add(new BugzillaIssue.Attachment.SaveAttachmentAction(attachment));
        if ("1".equals(attachment.getIsPatch())) {
            BugzillaIssue.Attachment.ApplyPatchAction action = new BugzillaIssue.Attachment.ApplyPatchAction(attachment);
            menu.add(action);
            patchButton.setAction((Action)action);
            String label = patchButton.getText();
            patchButton.setText(label.substring(0, 1).toLowerCase() + label.substring(1));
            patchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentPanels.patchButton.AccessibleContext.accessibleDescription"));
        }
        return menu;
    }

    private void updateButtonText(boolean noAttachments) {
        String txt = NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentsPanel.createNewButton.text");
        this.createNewButton.setText(noAttachments ? '(' + txt + ')' : txt);
        if (this.attachLogFileButton != null) {
            txt = NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentsPanel.attachLogFileButton.text");
            this.attachLogFileButton.setText(noAttachments ? '(' + txt + ')' : txt);
        }
    }

    private void makeBold(JLabel label) {
        Font font = label.getFont().deriveFont(1);
        label.setFont(font);
    }

    private JPanel createHighlightPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(BG_COLOR);
        this.add(panel);
        return panel;
    }

    PropertyChangeListener getDeletedListener() {
        if (this.deletedListener == null) {
            this.deletedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("attachmentDeleted".equals(evt.getPropertyName())) {
                        for (AttachmentPanel panel : AttachmentsPanel.this.newAttachments) {
                            if (panel.isDeleted()) continue;
                            return;
                        }
                        AttachmentsPanel.this.noneLabel.setVisible(true);
                        AttachmentsPanel.this.switchHelper();
                        AttachmentsPanel.this.updateButtonText(true);
                    }
                }
            };
        }
        return this.deletedListener;
    }

    private void switchHelper() {
        JLabel temp = new JLabel();
        GroupLayout layout = (GroupLayout)this.getLayout();
        layout.replace(this.dummyCreateLabel, temp);
        layout.replace((Component)this.createNewButton, this.dummyCreateLabel);
        layout.replace(temp, (Component)this.createNewButton);
        if (this.attachLogFileButton != null) {
            layout.replace(this.dummyAttachLabel, temp);
            layout.replace((Component)this.attachLogFileButton, this.dummyAttachLabel);
            layout.replace(temp, (Component)this.attachLogFileButton);
        }
    }

    List<AttachmentInfo> getNewAttachments() {
        LinkedList<AttachmentInfo> infos = new LinkedList<AttachmentInfo>();
        for (AttachmentPanel attachment : this.newAttachments) {
            if (attachment.isDeleted()) continue;
            AttachmentInfo info = new AttachmentInfo();
            info.file = attachment.getFile();
            info.description = attachment.getDescription();
            info.contentType = attachment.getContentType();
            info.isPatch = attachment.isPatch();
            infos.add(info);
        }
        return infos;
    }

    class AttachmentInfo {
        File file;
        String description;
        String contentType;
        boolean isPatch;

        AttachmentInfo() {
        }
    }

    class CreateNewAction
    extends AbstractAction {
        private final boolean attachLogFile;
        private GroupLayout.ParallelGroup horizontalGroup;
        private GroupLayout.SequentialGroup verticalGroup;

        public CreateNewAction() {
            this.attachLogFile = false;
        }

        public CreateNewAction(boolean attachLogFile) {
            this.attachLogFile = attachLogFile;
        }

        void setLayoutGroups(GroupLayout.ParallelGroup horizontalGroup, GroupLayout.SequentialGroup verticalGroup) {
            this.horizontalGroup = horizontalGroup;
            this.verticalGroup = verticalGroup;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f;
            AttachmentPanel attachment = new AttachmentPanel();
            attachment.setBackground(BG_COLOR);
            this.horizontalGroup.addComponent(attachment, -2, -1, -2);
            this.verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            this.verticalGroup.addComponent(attachment, -2, -1, -2);
            if (AttachmentsPanel.this.noneLabel.isVisible()) {
                AttachmentsPanel.this.noneLabel.setVisible(false);
                AttachmentsPanel.this.switchHelper();
                AttachmentsPanel.this.updateButtonText(false);
            }
            if (AttachmentsPanel.this.hadNoAttachments) {
                attachment.addPropertyChangeListener(AttachmentsPanel.this.getDeletedListener());
            }
            if (this.attachLogFile && (f = new File(Places.getUserDirectory(), "var/log/messages.log")).exists()) {
                attachment.setAttachment(f, NbBundle.getMessage(IssuePanel.class, (String)"MSG_LOG_FILE_DESC"), "text/plain");
            }
            AttachmentsPanel.this.newAttachments.add(attachment);
            UIUtils.keepFocusedComponentVisible((Component)attachment);
            AttachmentsPanel.this.revalidate();
        }
    }
}

