/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.commands.BugzillaCommand;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;

public class SubmitCommand
extends BugzillaCommand {
    private final BugzillaRepository repository;
    private final TaskData data;
    private RepositoryResponse rr;
    private boolean wasNew;
    private String stringValue;

    public SubmitCommand(BugzillaRepository repository, TaskData data) {
        this.repository = repository;
        this.data = data;
        this.wasNew = data.isNew();
    }

    @Override
    public void execute() throws CoreException, IOException, MalformedURLException {
        this.rr = Bugzilla.getInstance().getRepositoryConnector().getTaskDataHandler().postTaskData(this.repository.getTaskRepository(), this.data, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public RepositoryResponse getRepositoryResponse() {
        return this.rr;
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder sb = new StringBuilder();
            if (this.wasNew) {
                sb.append("SubmitCommand new issue [repository=");
                sb.append(this.repository.getTaskRepository().getUrl());
                sb.append("]");
            } else {
                sb.append("SubmitCommand [issue #");
                sb.append(BugzillaIssue.getID(this.data));
                sb.append(",repository=");
                sb.append(this.repository.getTaskRepository().getUrl());
                sb.append("]");
            }
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }
}

