/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.api;

import java.net.URL;
import java.util.regex.Pattern;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.repository.NBRepositorySupport;

public class NBBugzillaUtils {
    private static Pattern netbeansUrlPattern = Pattern.compile("(https|http)://(([a-z]|\\d)+\\.)*([a-z]|\\d)*netbeans([a-z]|\\d)*(([a-z]|\\d)*\\.)+org(.*)");

    public static void openIssue(String issueID) {
        Repository nbRepo = NBRepositorySupport.getInstance().getNBRepository();
        assert (nbRepo != null);
        if (nbRepo == null) {
            Bugzilla.LOG.warning("No bugzilla repository available for netbeans.org");
            return;
        }
        Issue.open((Repository)nbRepo, (String)issueID);
    }

    public static String getNBUsername() {
        return BugtrackingUtil.getNBUsername();
    }

    public static char[] getNBPassword() {
        return BugtrackingUtil.getNBPassword();
    }

    public static void saveNBUsername(String username) {
        BugtrackingUtil.saveNBUsername((String)username);
    }

    public static void saveNBPassword(char[] password) {
        BugtrackingUtil.saveNBPassword((char[])password);
    }

    public static boolean isNbRepository(URL url) {
        assert (url != null);
        boolean ret = netbeansUrlPattern.matcher(url.toString()).matches();
        if (ret) {
            return true;
        }
        String nbUrl = System.getProperty("netbeans.bugzilla.url");
        if (nbUrl == null || nbUrl.equals("")) {
            return false;
        }
        return url.toString().startsWith(nbUrl);
    }

    public static Repository findNBRepository() {
        return NBRepositorySupport.getInstance().getNBRepository();
    }
}

