/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.ReportNBIssueAction;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class NBLoginPanel
extends JPanel
implements DocumentListener {
    private JButton login = new JButton(NbBundle.getMessage(NBLoginPanel.class, (String)"LBL_Login"));
    private JButton cancel = new JButton(NbBundle.getMessage(NBLoginPanel.class, (String)"LBL_Cancel"));
    private JLabel errorLabel;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPasswordField passwordField;
    private JTextField usernameTextField;

    public NBLoginPanel() {
        this.initComponents();
        this.errorLabel.setVisible(false);
        this.login.getAccessibleContext().setAccessibleDescription(this.login.getText());
        this.cancel.getAccessibleContext().setAccessibleDescription(this.cancel.getText());
        this.usernameTextField.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.usernameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jButton1 = new LinkButton((Action)new NBRegisterAction());
        this.passwordField = new JPasswordField();
        this.errorLabel = new JLabel();
        this.jLabel1.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.jLabel1.text"));
        this.usernameTextField.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.usernameTextField.text"));
        this.jLabel2.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.jLabel2.text"));
        this.jLabel3.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.jLabel3.text"));
        this.jLabel4.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.jLabel4.text"));
        this.jButton1.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.jButton1.text"));
        this.passwordField.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.passwordField.text"));
        this.errorLabel.setForeground(new Color(153, 0, 0));
        this.errorLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/bugzilla/resources/error.gif")));
        this.errorLabel.setText(NbBundle.getMessage(NBLoginPanel.class, (String)"NBLoginPanel.errorLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.passwordField).addComponent(this.usernameTextField, -2, 141, -2))).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.errorLabel).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.usernameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.passwordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jButton1)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    static boolean show(BugzillaRepository repo, String errorMsg) {
        NBLoginPanel panel = new NBLoginPanel();
        panel.usernameTextField.setText(repo.getUsername());
        panel.passwordField.setText(new String(repo.getPassword()));
        panel.validateFields();
        panel.updateErrorMessage(errorMsg);
        if (panel.showLogin()) {
            repo.setCredentials(panel.usernameTextField.getText(), panel.passwordField.getPassword(), null, null);
            return true;
        }
        return false;
    }

    private boolean showLogin() {
        DialogDescriptor descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(ReportNBIssueAction.class, (String)"LBL_LOGIN_2_NBORG"), true, new Object[]{this.login, this.cancel}, (Object)this.login, 0, new HelpCtx(NBLoginPanel.class), null);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == this.login;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateFields();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateFields();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateFields();
    }

    private void validateFields() {
        if (this.usernameTextField.getText().trim().equals("")) {
            this.login.setEnabled(false);
            this.updateErrorMessage(NbBundle.getMessage(ReportNBIssueAction.class, (String)"MSG_MISSING_USERNAME_PASSWORD"));
        } else {
            this.login.setEnabled(true);
            this.updateErrorMessage(null);
        }
    }

    private void updateErrorMessage(String errorMsg) {
        if (errorMsg != null) {
            this.errorLabel.setVisible(true);
            this.errorLabel.setText(errorMsg);
        } else {
            this.errorLabel.setVisible(false);
            this.errorLabel.setText("");
        }
    }

    private class NBRegisterAction
    extends AbstractAction {
        private NBRegisterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("https://netbeans.org/people/new"));
            }
            catch (MalformedURLException ex) {
                Bugzilla.LOG.log(Level.SEVERE, "Name", ex);
            }
        }
    }
}

