/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiBugtrackingConnector;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiProject;
import org.netbeans.modules.bugtracking.spi.IssueFinder;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.QueryProvider;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugtracking.spi.RepositoryProvider;
import org.netbeans.modules.bugtracking.spi.TaskListIssueProvider;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.api.NBBugzillaUtils;
import org.netbeans.modules.bugzilla.issue.BugzillaIssueFinder;
import org.netbeans.modules.bugzilla.issue.BugzillaTaskListProvider;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.NBRepositorySupport;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.util.NbBundle;

public class BugzillaConnector
extends KenaiBugtrackingConnector {
    public static final String ID = "org.netbeans.modules.bugzilla";

    public Repository createRepository(RepositoryInfo info) {
        BugzillaRepository bugzillaRepository = new BugzillaRepository(info);
        if (BugzillaUtil.isNbRepository(bugzillaRepository)) {
            NBRepositorySupport.getInstance().setNBBugzillaRepository(bugzillaRepository);
        }
        return Bugzilla.getInstance().getBugtrackingFactory().createRepository((Object)bugzillaRepository, (RepositoryProvider)Bugzilla.getInstance().getRepositoryProvider(), (QueryProvider)Bugzilla.getInstance().getQueryProvider(), (IssueProvider)Bugzilla.getInstance().getIssueProvider());
    }

    public Repository createRepository() {
        Bugzilla.init();
        BugzillaRepository bugzillaRepository = new BugzillaRepository();
        return Bugzilla.getInstance().getBugtrackingFactory().createRepository((Object)bugzillaRepository, (RepositoryProvider)Bugzilla.getInstance().getRepositoryProvider(), (QueryProvider)Bugzilla.getInstance().getQueryProvider(), (IssueProvider)Bugzilla.getInstance().getIssueProvider());
    }

    public static String getConnectorName() {
        return NbBundle.getMessage(BugzillaConnector.class, (String)"LBL_ConnectorName");
    }

    public IssueFinder getIssueFinder() {
        return BugzillaIssueFinder.getInstance();
    }

    public TaskListIssueProvider getTasklistProvider() {
        return BugzillaTaskListProvider.getInstance();
    }

    public Repository createRepository(KenaiProject project) {
        if (project == null || project.getType() != KenaiBugtrackingConnector.BugtrackingType.BUGZILLA) {
            return null;
        }
        KenaiRepository repo = this.createKenaiRepository(project, project.getDisplayName(), project.getFeatureLocation());
        if (BugzillaUtil.isNbRepository(repo)) {
            NBRepositorySupport.getInstance().setNBBugzillaRepository(repo);
        }
        return BugzillaUtil.getRepository(repo);
    }

    private KenaiRepository createKenaiRepository(KenaiProject kenaiProject, String displayName, String location) {
        URL loc;
        try {
            loc = new URL(location);
        }
        catch (MalformedURLException ex) {
            Bugzilla.LOG.log(Level.WARNING, null, ex);
            return null;
        }
        String host = loc.getHost();
        int idx = location.indexOf("/buglist.cgi");
        if (idx <= 0) {
            Bugzilla.LOG.log(Level.WARNING, "can't get issue tracker url from [{0}, {1}]", new Object[]{displayName, location});
            return null;
        }
        String url = location.substring(0, idx);
        if (url.startsWith("http:")) {
            url = "https" + url.substring(4);
        }
        String productParamUrl = null;
        String productAttribute = "product=";
        String product = null;
        int idxProductStart = location.indexOf(productAttribute);
        if (idxProductStart <= 0) {
            Bugzilla.LOG.log(Level.WARNING, "can''t get issue tracker product from [{0}, {1}]", new Object[]{displayName, location});
            return null;
        }
        int idxProductEnd = location.indexOf("&", idxProductStart);
        if (idxProductEnd > -1) {
            productParamUrl = location.substring(idxProductStart, idxProductEnd);
            product = location.substring(idxProductStart + productAttribute.length(), idxProductEnd);
        } else {
            productParamUrl = location.substring(idxProductStart);
            product = location.substring(idxProductStart + productAttribute.length());
        }
        return new KenaiRepository(kenaiProject, displayName, url, host, productParamUrl, product);
    }

    public KenaiBugtrackingConnector.BugtrackingType getType() {
        return KenaiBugtrackingConnector.BugtrackingType.BUGZILLA;
    }

    public Repository findNBRepository() {
        return NBBugzillaUtils.findNBRepository();
    }
}

