/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Date;

public abstract class HttpURLConnection
extends URLConnection {
    protected String method = "GET";
    protected int chunkLength = -1;
    protected int fixedContentLength = -1;
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    protected int responseCode = -1;
    protected String responseMessage = null;
    private static boolean followRedirects = true;
    protected boolean instanceFollowRedirects = followRedirects;
    private static final String[] methods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE"};
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    @Deprecated
    public static final int HTTP_SERVER_ERROR = 500;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION = 505;

    public String getHeaderFieldKey(int n) {
        return null;
    }

    public void setFixedLengthStreamingMode(int n) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (this.chunkLength != -1) {
            throw new IllegalStateException("Chunked encoding streaming mode set");
        }
        if (n < 0) {
            throw new IllegalArgumentException("invalid content length");
        }
        this.fixedContentLength = n;
    }

    public void setChunkedStreamingMode(int n) {
        if (this.connected) {
            throw new IllegalStateException("Can't set streaming mode: already connected");
        }
        if (this.fixedContentLength != -1) {
            throw new IllegalStateException("Fixed length streaming mode set");
        }
        this.chunkLength = n <= 0 ? 4096 : n;
    }

    public String getHeaderField(int n) {
        return null;
    }

    protected HttpURLConnection(URL uRL) {
        super(uRL);
    }

    public static void setFollowRedirects(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        followRedirects = bl;
    }

    public static boolean getFollowRedirects() {
        return followRedirects;
    }

    public void setInstanceFollowRedirects(boolean bl) {
        this.instanceFollowRedirects = bl;
    }

    public boolean getInstanceFollowRedirects() {
        return this.instanceFollowRedirects;
    }

    public void setRequestMethod(String string) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Can't reset method: already connected");
        }
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].equals(string)) continue;
            this.method = string;
            return;
        }
        throw new ProtocolException("Invalid HTTP method: " + string);
    }

    public String getRequestMethod() {
        return this.method;
    }

    public int getResponseCode() throws IOException {
        int n;
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        Exception exception = null;
        try {
            this.getInputStream();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        String string = this.getHeaderField(0);
        if (string == null) {
            if (exception != null) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw (IOException)exception;
            }
            return -1;
        }
        if (string.startsWith("HTTP/1.") && (n = string.indexOf(32)) > 0) {
            int n2 = string.indexOf(32, n + 1);
            if (n2 > 0 && n2 < string.length()) {
                this.responseMessage = string.substring(n2 + 1);
            }
            if (n2 < 0) {
                n2 = string.length();
            }
            try {
                this.responseCode = Integer.parseInt(string.substring(n + 1, n2));
                return this.responseCode;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public String getResponseMessage() throws IOException {
        this.getResponseCode();
        return this.responseMessage;
    }

    public long getHeaderFieldDate(String string, long l) {
        String string2 = this.getHeaderField(string);
        try {
            if (string2.indexOf("GMT") == -1) {
                string2 = string2 + " GMT";
            }
            return Date.parse(string2);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public abstract void disconnect();

    public abstract boolean usingProxy();

    public Permission getPermission() throws IOException {
        int n = this.url.getPort();
        n = n < 0 ? 80 : n;
        String string = this.url.getHost() + ":" + n;
        SocketPermission socketPermission = new SocketPermission(string, "connect");
        return socketPermission;
    }

    public InputStream getErrorStream() {
        return null;
    }
}

