/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.VersionString;
import com.sun.javaws.jnl.DefaultMatchJRE;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;

public class LaunchSelection {
    private static final String anyJREVersion = "0+";

    public static MatchJREIf createDefaultMatchJRE() {
        return new DefaultMatchJRE();
    }

    protected static JREInfo selectJRE(LaunchDesc launchDesc, MatchJREIf matchJREIf) {
        matchJREIf.beginTraversal(launchDesc);
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            LaunchSelection.selectJREDescHelper(launchDesc, matchJREIf);
            JREDesc jREDesc = matchJREIf.getSelectedJREDesc();
            if (jREDesc != null) {
                jREDesc.markAsSelected();
                resourcesDesc.addNested(jREDesc.getNestedResources());
            }
            LaunchSelection.selectJREExtensionHelper(launchDesc, matchJREIf);
        }
        matchJREIf.endTraversal(launchDesc);
        return matchJREIf.getSelectedJREInfo();
    }

    private static void selectJREDescHelper(final LaunchDesc launchDesc, MatchJREIf matchJREIf) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
                if (launchDesc.isLibrary()) {
                    Trace.println((String)("JNLP JREDesc in Component ignored: " + launchDesc.getLocation()));
                } else {
                    arrayList.add(jREDesc);
                }
            }
        });
        JREDesc jREDesc = null;
        JREInfo jREInfo = null;
        if (arrayList.size() > 0) {
            for (int i = 0; jREInfo == null && i < arrayList.size(); ++i) {
                jREDesc = (JREDesc)arrayList.get(i);
                URL uRL = jREDesc.getHref();
                jREInfo = LaunchSelection.selectJRE(uRL, jREDesc.getVersion());
            }
            if (jREInfo == null) {
                jREDesc = (JREDesc)arrayList.get(0);
            }
        } else {
            jREDesc = new JREDesc(anyJREVersion, -1L, -1L, null, null, new ResourcesDesc());
            resourcesDesc.addResource(jREDesc);
            jREInfo = LaunchSelection.selectJRE(jREDesc.getHref(), jREDesc.getVersion());
        }
        matchJREIf.digest(jREDesc, jREInfo);
    }

    private static void selectJREExtensionHelper(LaunchDesc launchDesc, MatchJREIf matchJREIf) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                arrayList.add(extensionDesc);
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }
        });
        matchJREIf.digest(launchDesc);
        if (launchDesc.isInstaller()) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ExtensionDesc extensionDesc = (ExtensionDesc)arrayList.get(i);
            LaunchDesc launchDesc2 = extensionDesc.getExtensionDesc();
            if (launchDesc2 == null) {
                try {
                    File file = DownloadEngine.getCachedFile((URL)extensionDesc.getLocation(), (String)extensionDesc.getVersion(), (boolean)false, (boolean)false, null);
                    if (null != file) {
                        launchDesc2 = LaunchDescFactory.buildDescriptor(file, extensionDesc.getCodebase(), extensionDesc.getLocation(), extensionDesc.getLocation());
                    }
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
            }
            if (null == launchDesc2) continue;
            if (launchDesc2.isInstaller()) {
                extensionDesc.setInstaller(true);
                continue;
            }
            extensionDesc.setExtensionDesc(launchDesc2);
            LaunchSelection.selectJREExtensionHelper(launchDesc2, matchJREIf);
        }
    }

    public static JREInfo selectJRE(URL uRL, String string) {
        JREInfo[] jREInfoArray = JREInfo.getAll();
        if (jREInfoArray == null) {
            return null;
        }
        VersionString versionString = new VersionString(string);
        for (int i = 0; i < jREInfoArray.length; ++i) {
            if (!jREInfoArray[i].isOsInfoMatch(Config.getOSName(), Config.getOSArch()) || !jREInfoArray[i].isEnabled() || !(uRL == null ? LaunchSelection.isPlatformMatch(jREInfoArray[i], versionString) : LaunchSelection.isProductMatch(jREInfoArray[i], uRL, versionString))) continue;
            return jREInfoArray[i];
        }
        return null;
    }

    public static boolean isPlatformMatch(JREInfo jREInfo, VersionString versionString) {
        String string = jREInfo.getProduct();
        boolean bl = string == null || string.indexOf(45) == -1 || string.startsWith("1.2") || LaunchSelection.isInstallJRE(jREInfo);
        if (new File(jREInfo.getPath()).exists()) {
            return versionString.contains(jREInfo.getPlatform()) && bl;
        }
        return false;
    }

    public static boolean isProductMatch(JREInfo jREInfo, URL uRL, VersionString versionString) {
        if (new File(jREInfo.getPath()).exists()) {
            return jREInfo.getLocation().equals(uRL.toString()) && versionString.contains(jREInfo.getProduct());
        }
        return false;
    }

    public static boolean isInstallJRE(JREInfo jREInfo) {
        File file = new File(Config.getJavaHome());
        File file2 = new File(jREInfo.getPath());
        File file3 = file2.getParentFile();
        return file.equals(file3.getParentFile());
    }

    public static interface MatchJREIf {
        public boolean hasBeenRun();

        public void beginTraversal(LaunchDesc var1);

        public void digest(JREDesc var1, JREInfo var2);

        public void digest(LaunchDesc var1);

        public void endTraversal(LaunchDesc var1);

        public JREInfo getSelectedJREInfo();

        public JREDesc getSelectedJREDesc();

        public JVMParameters getSelectedJVMParameters();

        public String getSelectedJVMParameterString();

        public long getSelectedInitHeapSize();

        public long getSelectedMaxHeapSize();

        public boolean isRunningJVMSatisfying(boolean var1);

        public String toString();
    }
}

