/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;

public class JdbcOdbcObject {
    protected static void dumpByte(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 * 16 < n) {
            String string = JdbcOdbcObject.toHex(n2 * 16);
            String string2 = "";
            for (int i = 0; i < 16; ++i) {
                int n3 = n2 * 16 + i;
                if (n3 >= n) {
                    string = "  ";
                    string2 = string2 + " ";
                    continue;
                }
                string = JdbcOdbcObject.toHex(byArray[n3]);
                string = JdbcOdbcObject.hexPad(string, 2);
                string2 = byArray[n3] < 32 || byArray[n3] > 128 ? string2 + "." : string2 + new String(byArray, n3, 1);
            }
            ++n2;
        }
    }

    public static String hexPad(String string, int n) {
        if (!string.startsWith("0x")) {
            return string;
        }
        String string2 = string.substring(2);
        int n2 = string2.length();
        if (n2 > n) {
            string2 = string2.substring(n2 - n);
        } else if (n2 < n) {
            String string3;
            String string4 = "0000000000000000";
            string2 = string3 = string4.substring(0, n - n2) + string2;
        }
        string2 = string2.toUpperCase();
        return string2;
    }

    public static String toHex(int n) {
        char[] cArray = new char[8];
        String string = "0123456789ABCDEF";
        for (int i = 0; i < 4; ++i) {
            byte by = (byte)(n & 0xFF);
            cArray[6 - i * 2] = string.charAt(by >> 4 & 0xF);
            cArray[7 - i * 2] = string.charAt(by & 0xF);
            n >>= 8;
        }
        return "0x" + new String(cArray);
    }

    public static byte[] hexStringToByteArray(String string) throws NumberFormatException {
        int n = string.length();
        int n2 = (n + 1) / 2;
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)JdbcOdbcObject.hexPairToInt(string.substring(i * 2, (i + 1) * 2));
        }
        return byArray;
    }

    public static int hexPairToInt(String string) throws NumberFormatException {
        String string2 = "0123456789ABCDEF";
        String string3 = string.toUpperCase();
        int n = 0;
        int n2 = 0;
        int n3 = string3.length();
        if (n3 > 2) {
            n3 = 2;
        }
        for (int i = 0; i < n3; ++i) {
            n2 = string2.indexOf(string3.substring(i, i + 1));
            if (n2 < 0) {
                throw new NumberFormatException();
            }
            if (i == 0) {
                n2 *= 16;
            }
            n += n2;
        }
        return n;
    }

    public String BytesToChars(String string, byte[] byArray) throws UnsupportedEncodingException {
        int n;
        String string2 = new String();
        try {
            string2 = Charset.forName(string).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?").decode(ByteBuffer.wrap(byArray)).toString();
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new UnsupportedEncodingException(string);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        char[] cArray = string2.toCharArray();
        for (n = 0; n < cArray.length && cArray[n] != '\u0000'; ++n) {
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        string2 = new String(cArray2);
        return string2;
    }

    public byte[] CharsToBytes(String string, char[] cArray) throws UnsupportedEncodingException {
        try {
            char[] cArray2 = new char[cArray.length + 1];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            ByteBuffer byteBuffer = Charset.forName(string).newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(new byte[]{63}).encode(CharBuffer.wrap(cArray2));
            byte[] byArray = new byte[byteBuffer.limit()];
            System.arraycopy(byteBuffer.array(), 0, byArray, 0, byteBuffer.limit());
            return byArray;
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new UnsupportedEncodingException(string);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
        catch (CharacterCodingException characterCodingException) {
            characterCodingException.printStackTrace();
        }
        return new byte[0];
    }
}

