/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import com.sun.java.accessibility.util.ComponentEvtDispatchThread;
import com.sun.java.accessibility.util.EventQueueMonitorItem;
import com.sun.java.accessibility.util.GUIInitializedListener;
import com.sun.java.accessibility.util.GUIInitializedMulticaster;
import com.sun.java.accessibility.util.TopLevelWindowListener;
import com.sun.java.accessibility.util.TopLevelWindowMulticaster;
import com.sun.java.accessibility.util.Translator;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;

public class EventQueueMonitor
implements AWTEventListener {
    static Vector topLevelWindows = new Vector();
    static Window topLevelWindowWithFocus = null;
    static Point currentMousePosition = null;
    static Component currentMouseComponent = null;
    static GUIInitializedListener guiInitializedListener = null;
    static TopLevelWindowListener topLevelWindowListener = null;
    static MouseMotionListener mouseMotionListener = null;
    static boolean guiInitialized = false;
    static EventQueueMonitorItem componentEventQueue = null;
    private static ComponentEvtDispatchThread cedt = null;
    static Object componentEventQueueLock = new Object();

    public EventQueueMonitor() {
        if (cedt == null) {
            cedt = new ComponentEvtDispatchThread("EventQueueMonitor-ComponentEvtDispatch");
            cedt.setDaemon(true);
            cedt.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void queueComponentEvent(ComponentEvent componentEvent) {
        Object object = componentEventQueueLock;
        synchronized (object) {
            EventQueueMonitorItem eventQueueMonitorItem = new EventQueueMonitorItem(componentEvent);
            if (componentEventQueue == null) {
                componentEventQueue = eventQueueMonitorItem;
            } else {
                EventQueueMonitorItem eventQueueMonitorItem2 = componentEventQueue;
                while (eventQueueMonitorItem2.next != null) {
                    eventQueueMonitorItem2 = eventQueueMonitorItem2.next;
                }
                eventQueueMonitorItem2.next = eventQueueMonitorItem;
            }
            componentEventQueueLock.notifyAll();
        }
    }

    public static void maybeInitialize() {
        if (cedt == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        long l = 100L;
                        Toolkit.getDefaultToolkit().addAWTEventListener(new EventQueueMonitor(), l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        EventQueueMonitor.processEvent(aWTEvent);
    }

    static void maybeNotifyAssistiveTechnologies() {
        if (!guiInitialized) {
            guiInitialized = true;
            if (guiInitializedListener != null) {
                guiInitializedListener.guiInitialized();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean addTopLevelWindow(Component component) {
        Container container;
        if (component == null) {
            return false;
        }
        if (!(component instanceof Window)) {
            return EventQueueMonitor.addTopLevelWindow(component.getParent());
        }
        if (component instanceof Dialog || component instanceof Window) {
            container = (Container)component;
        } else {
            container = component.getParent();
            if (container != null) {
                return EventQueueMonitor.addTopLevelWindow(container);
            }
        }
        if (container == null) {
            container = (Container)component;
        }
        Vector vector = topLevelWindows;
        synchronized (vector) {
            if (container != null && !topLevelWindows.contains(container)) {
                topLevelWindows.addElement(container);
                if (topLevelWindowListener != null) {
                    topLevelWindowListener.topLevelWindowCreated((Window)container);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeTopLevelWindow(Window window) {
        Vector vector = topLevelWindows;
        synchronized (vector) {
            if (topLevelWindows.contains(window)) {
                topLevelWindows.removeElement(window);
                if (topLevelWindowListener != null) {
                    topLevelWindowListener.topLevelWindowDestroyed(window);
                }
            }
        }
    }

    static void updateCurrentMousePosition(MouseEvent mouseEvent) {
        Point point = currentMousePosition;
        try {
            Point point2 = mouseEvent.getPoint();
            currentMouseComponent = (Component)mouseEvent.getSource();
            currentMousePosition = currentMouseComponent.getLocationOnScreen();
            currentMousePosition.translate(point2.x, point2.y);
        }
        catch (Exception exception) {
            currentMousePosition = point;
        }
    }

    static void processEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 206: 
            case 503: 
            case 506: 
            case 1004: {
                EventQueueMonitor.queueComponentEvent((ComponentEvent)aWTEvent);
                break;
            }
            case 205: {
                if (aWTEvent instanceof ComponentEvent) {
                    ComponentEvent componentEvent = (ComponentEvent)aWTEvent;
                    if (componentEvent.getComponent() instanceof Window) {
                        EventQueueMonitor.addTopLevelWindow(componentEvent.getComponent());
                        EventQueueMonitor.maybeNotifyAssistiveTechnologies();
                    } else {
                        EventQueueMonitor.maybeNotifyAssistiveTechnologies();
                        EventQueueMonitor.addTopLevelWindow(componentEvent.getComponent());
                    }
                }
                EventQueueMonitor.queueComponentEvent((ComponentEvent)aWTEvent);
                break;
            }
            case 200: {
                if (!(aWTEvent instanceof ComponentEvent)) break;
                ComponentEvent componentEvent = (ComponentEvent)aWTEvent;
                if (componentEvent.getComponent() instanceof Window) {
                    EventQueueMonitor.addTopLevelWindow(componentEvent.getComponent());
                    EventQueueMonitor.maybeNotifyAssistiveTechnologies();
                    break;
                }
                EventQueueMonitor.maybeNotifyAssistiveTechnologies();
                EventQueueMonitor.addTopLevelWindow(componentEvent.getComponent());
                break;
            }
            case 202: {
                if (!(aWTEvent instanceof ComponentEvent)) break;
                ComponentEvent componentEvent = (ComponentEvent)aWTEvent;
                EventQueueMonitor.removeTopLevelWindow((Window)componentEvent.getComponent());
                break;
            }
        }
    }

    static synchronized Component getShowingComponentAt(Container container, int n, int n2) {
        if (!container.contains(n, n2)) {
            return null;
        }
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (component == null || !component.isShowing()) continue;
            Point point = component.getLocation();
            if (!component.contains(n - point.x, n2 - point.y)) continue;
            return component;
        }
        return container;
    }

    static synchronized Component getComponentAt(Container container, Point point) {
        if (!container.isShowing()) {
            return null;
        }
        Point point2 = container.getLocationOnScreen();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        Component component = EventQueueMonitor.getShowingComponentAt(container, point3.x, point3.y);
        if (component != container && component instanceof Container) {
            return EventQueueMonitor.getComponentAt((Container)component, point);
        }
        return component;
    }

    public static Accessible getAccessibleAt(Point point) {
        Window window = EventQueueMonitor.getTopLevelWindowWithFocus();
        Window[] windowArray = EventQueueMonitor.getTopLevelWindows();
        Component component = null;
        if (currentMousePosition == null) {
            return null;
        }
        if (currentMousePosition.equals(point) && currentMouseComponent instanceof Container) {
            component = EventQueueMonitor.getComponentAt((Container)currentMouseComponent, point);
        }
        if (component == null && window != null) {
            component = EventQueueMonitor.getComponentAt(window, point);
        }
        if (component == null) {
            for (int i = 0; i < windowArray.length && (component = EventQueueMonitor.getComponentAt(windowArray[i], point)) == null; ++i) {
            }
        }
        if (component instanceof Accessible) {
            AccessibleComponent accessibleComponent;
            AccessibleContext accessibleContext = ((Accessible)((Object)component)).getAccessibleContext();
            if (accessibleContext != null && (accessibleComponent = accessibleContext.getAccessibleComponent()) != null && accessibleContext.getAccessibleChildrenCount() != 0) {
                Point point2 = accessibleComponent.getLocationOnScreen();
                point2.move(point.x - point2.x, point.y - point2.y);
                return accessibleComponent.getAccessibleAt(point2);
            }
            return (Accessible)((Object)component);
        }
        return Translator.getAccessible(component);
    }

    public static boolean isGUIInitialized() {
        EventQueueMonitor.maybeInitialize();
        return guiInitialized;
    }

    public static void addGUIInitializedListener(GUIInitializedListener gUIInitializedListener) {
        EventQueueMonitor.maybeInitialize();
        guiInitializedListener = GUIInitializedMulticaster.add(guiInitializedListener, gUIInitializedListener);
    }

    public static void removeGUIInitializedListener(GUIInitializedListener gUIInitializedListener) {
        guiInitializedListener = GUIInitializedMulticaster.remove(guiInitializedListener, gUIInitializedListener);
    }

    public static void addTopLevelWindowListener(TopLevelWindowListener topLevelWindowListener) {
        EventQueueMonitor.topLevelWindowListener = TopLevelWindowMulticaster.add(EventQueueMonitor.topLevelWindowListener, topLevelWindowListener);
    }

    public static void removeTopLevelWindowListener(TopLevelWindowListener topLevelWindowListener) {
        EventQueueMonitor.topLevelWindowListener = TopLevelWindowMulticaster.remove(EventQueueMonitor.topLevelWindowListener, topLevelWindowListener);
    }

    public static Point getCurrentMousePosition() {
        return currentMousePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Window[] getTopLevelWindows() {
        Vector vector = topLevelWindows;
        synchronized (vector) {
            int n = topLevelWindows.size();
            if (n > 0) {
                Window[] windowArray = new Window[n];
                for (int i = 0; i < n; ++i) {
                    windowArray[i] = (Window)topLevelWindows.elementAt(i);
                }
                return windowArray;
            }
            return new Window[0];
        }
    }

    public static Window getTopLevelWindowWithFocus() {
        return topLevelWindowWithFocus;
    }
}

