/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.AbstractPlainSocketImpl;
import java.net.DualStackPlainSocketImpl;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.TwoStacksPlainSocketImpl;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;

class PlainSocketImpl
extends AbstractPlainSocketImpl {
    private AbstractPlainSocketImpl impl;
    private static float version;
    private static boolean preferIPv4Stack;
    private static boolean useDualStackImpl;
    private static String exclBindProp;
    private static boolean exclusiveBind;

    PlainSocketImpl() {
        this.impl = useDualStackImpl ? new DualStackPlainSocketImpl(exclusiveBind) : new TwoStacksPlainSocketImpl(exclusiveBind);
    }

    PlainSocketImpl(FileDescriptor fileDescriptor) {
        this.impl = useDualStackImpl ? new DualStackPlainSocketImpl(fileDescriptor, exclusiveBind) : new TwoStacksPlainSocketImpl(fileDescriptor, exclusiveBind);
    }

    @Override
    protected FileDescriptor getFileDescriptor() {
        return this.impl.getFileDescriptor();
    }

    @Override
    protected InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    @Override
    protected int getPort() {
        return this.impl.getPort();
    }

    @Override
    protected int getLocalPort() {
        return this.impl.getLocalPort();
    }

    @Override
    void setSocket(Socket socket) {
        this.impl.setSocket(socket);
    }

    @Override
    Socket getSocket() {
        return this.impl.getSocket();
    }

    @Override
    void setServerSocket(ServerSocket serverSocket) {
        this.impl.setServerSocket(serverSocket);
    }

    @Override
    ServerSocket getServerSocket() {
        return this.impl.getServerSocket();
    }

    @Override
    public String toString() {
        return this.impl.toString();
    }

    @Override
    protected synchronized void create(boolean bl) throws IOException {
        this.impl.create(bl);
        this.fd = this.impl.fd;
    }

    @Override
    protected void connect(String string, int n) throws UnknownHostException, IOException {
        this.impl.connect(string, n);
    }

    @Override
    protected void connect(InetAddress inetAddress, int n) throws IOException {
        this.impl.connect(inetAddress, n);
    }

    @Override
    protected void connect(SocketAddress socketAddress, int n) throws IOException {
        this.impl.connect(socketAddress, n);
    }

    @Override
    public void setOption(int n, Object object) throws SocketException {
        this.impl.setOption(n, object);
    }

    @Override
    public Object getOption(int n) throws SocketException {
        return this.impl.getOption(n);
    }

    @Override
    synchronized void doConnect(InetAddress inetAddress, int n, int n2) throws IOException {
        this.impl.doConnect(inetAddress, n, n2);
    }

    @Override
    protected synchronized void bind(InetAddress inetAddress, int n) throws IOException {
        this.impl.bind(inetAddress, n);
    }

    @Override
    protected synchronized void accept(SocketImpl socketImpl) throws IOException {
        if (socketImpl instanceof PlainSocketImpl) {
            AbstractPlainSocketImpl abstractPlainSocketImpl = ((PlainSocketImpl)socketImpl).impl;
            abstractPlainSocketImpl.address = new InetAddress();
            abstractPlainSocketImpl.fd = new FileDescriptor();
            this.impl.accept(abstractPlainSocketImpl);
            socketImpl.fd = abstractPlainSocketImpl.fd;
        } else {
            this.impl.accept(socketImpl);
        }
    }

    @Override
    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.impl.setFileDescriptor(fileDescriptor);
    }

    @Override
    void setAddress(InetAddress inetAddress) {
        this.impl.setAddress(inetAddress);
    }

    @Override
    void setPort(int n) {
        this.impl.setPort(n);
    }

    @Override
    void setLocalPort(int n) {
        this.impl.setLocalPort(n);
    }

    @Override
    protected synchronized InputStream getInputStream() throws IOException {
        return this.impl.getInputStream();
    }

    @Override
    void setInputStream(SocketInputStream socketInputStream) {
        this.impl.setInputStream(socketInputStream);
    }

    @Override
    protected synchronized OutputStream getOutputStream() throws IOException {
        return this.impl.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        try {
            this.impl.close();
        }
        finally {
            this.fd = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reset() throws IOException {
        try {
            this.impl.reset();
        }
        finally {
            this.fd = null;
        }
    }

    @Override
    protected void shutdownInput() throws IOException {
        this.impl.shutdownInput();
    }

    @Override
    protected void shutdownOutput() throws IOException {
        this.impl.shutdownOutput();
    }

    @Override
    protected void sendUrgentData(int n) throws IOException {
        this.impl.sendUrgentData(n);
    }

    @Override
    FileDescriptor acquireFD() {
        return this.impl.acquireFD();
    }

    @Override
    void releaseFD() {
        this.impl.releaseFD();
    }

    @Override
    public boolean isConnectionReset() {
        return this.impl.isConnectionReset();
    }

    @Override
    public boolean isConnectionResetPending() {
        return this.impl.isConnectionResetPending();
    }

    @Override
    public void setConnectionReset() {
        this.impl.setConnectionReset();
    }

    @Override
    public void setConnectionResetPending() {
        this.impl.setConnectionResetPending();
    }

    @Override
    public boolean isClosedOrPending() {
        return this.impl.isClosedOrPending();
    }

    @Override
    public int getTimeout() {
        return this.impl.getTimeout();
    }

    @Override
    void socketCreate(boolean bl) throws IOException {
        this.impl.socketCreate(bl);
    }

    @Override
    void socketConnect(InetAddress inetAddress, int n, int n2) throws IOException {
        this.impl.socketConnect(inetAddress, n, n2);
    }

    @Override
    void socketBind(InetAddress inetAddress, int n) throws IOException {
        this.impl.socketBind(inetAddress, n);
    }

    @Override
    void socketListen(int n) throws IOException {
        this.impl.socketListen(n);
    }

    @Override
    void socketAccept(SocketImpl socketImpl) throws IOException {
        this.impl.socketAccept(socketImpl);
    }

    @Override
    int socketAvailable() throws IOException {
        return this.impl.socketAvailable();
    }

    @Override
    void socketClose0(boolean bl) throws IOException {
        this.impl.socketClose0(bl);
    }

    @Override
    void socketShutdown(int n) throws IOException {
        this.impl.socketShutdown(n);
    }

    @Override
    void socketSetOption(int n, boolean bl, Object object) throws SocketException {
        this.socketSetOption(n, bl, object);
    }

    @Override
    int socketGetOption(int n, Object object) throws SocketException {
        return this.impl.socketGetOption(n, object);
    }

    @Override
    void socketSendUrgentData(int n) throws IOException {
        this.impl.socketSendUrgentData(n);
    }

    static {
        preferIPv4Stack = false;
        useDualStackImpl = false;
        exclusiveBind = true;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block2: {
                    version = 0.0f;
                    try {
                        version = Float.parseFloat(System.getProperties().getProperty("os.version"));
                        preferIPv4Stack = Boolean.parseBoolean(System.getProperties().getProperty("java.net.preferIPv4Stack"));
                        exclBindProp = System.getProperty("sun.net.useExclusiveBind");
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError((Object)numberFormatException);
                    }
                }
                return null;
            }
        });
        if ((double)version >= 6.0 && !preferIPv4Stack) {
            useDualStackImpl = true;
        }
        if (exclBindProp != null) {
            exclusiveBind = exclBindProp.length() == 0 ? true : Boolean.parseBoolean(exclBindProp);
        } else if ((double)version < 6.0) {
            exclusiveBind = false;
        }
    }
}

