/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CachedJarFile;
import com.sun.deploy.cache.CachedJarFile14;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.SyncFileAccess;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class CacheEntry {
    private File indexFile = null;
    private SyncFileAccess indexFileSyncAccess = null;
    private File tempDataFile = null;
    private int busy = 1;
    private int incomplete = 0;
    private int forceUpdate = 0;
    private int noHref = 0;
    private int cacheVersion = Cache.getCacheVersion();
    private int contentLength = 0;
    private int isShortcutImage = 0;
    private long lastModified = 0L;
    private long expirationDate = 0L;
    private String version = null;
    private String url = "";
    private String namespaceID = "";
    private MessageHeader headerFields = new MessageHeader();
    private String filename = null;
    private String codebaseIP = null;
    private long entryCreationTime = 0L;
    private long validationTimestampt = 0L;
    private boolean knownToBeSigned = false;
    private long blacklistValidationTime = 0L;
    Map checkedJars = null;
    private static final int section1Length = 128;
    private int section2Length = 0;
    private int section3Length = 0;
    private int section4Length = 0;
    private int section5Length = 0;
    private static final String META_FILE_DIR = "META-INF/";
    private static final String JAR_INDEX_NAME = "META-INF/INDEX.LIST";
    private Manifest manifestHardRef = null;
    private SoftReference manifestRef = null;
    private boolean doneReadManifest = false;
    private boolean doneReadCerts = false;
    private Map signerMapHardRef = null;
    private SoftReference signerMapRef = null;
    private CodeSigner[] signersHardRef = null;
    private SoftReference signersRef = null;
    private Map signerMapCertHardRef = null;
    private SoftReference signerMapCertRef;
    private Certificate[] certificatesHardRef = null;
    private SoftReference certificatesRef = null;

    public long getCreationTimespampt() {
        return this.entryCreationTime;
    }

    public long getValidationTimestampt() {
        return this.validationTimestampt;
    }

    private void updateBlacklistValidation() {
        this.blacklistValidationTime = System.currentTimeMillis();
    }

    public boolean isKnownToBeSigned() {
        return this.knownToBeSigned;
    }

    public boolean hasSigningInfo() {
        return this.section4Length != 0;
    }

    public void updateValidationResults(boolean bl, Map map, long l) {
        this.knownToBeSigned = bl;
        this.validationTimestampt = l;
        this.checkedJars = map;
        try {
            this.updateSecurityValidationCache();
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.print("Failed to update list of trusted cached entries in the index", TraceLevel.CACHE);
            Trace.ignoredException(iOException);
        }
    }

    private void updateSecurityValidationCache() throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Object run() throws IOException {
                        RandomAccessFile randomAccessFile = null;
                        try {
                            randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                            CacheEntry.this.section5Length = 0;
                            if (CacheEntry.this.checkedJars != null && !CacheEntry.this.checkedJars.isEmpty()) {
                                Object object;
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(500);
                                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                                Set set = CacheEntry.this.checkedJars.entrySet();
                                dataOutputStream.writeInt(set.size());
                                Iterator iterator = set.iterator();
                                while (iterator.hasNext()) {
                                    object = iterator.next();
                                    dataOutputStream.writeUTF((String)object.getKey());
                                    dataOutputStream.writeLong((Long)object.getValue());
                                }
                                dataOutputStream.close();
                                byteArrayOutputStream.close();
                                object = byteArrayOutputStream.toByteArray();
                                randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length + CacheEntry.this.section4Length);
                                randomAccessFile.write((byte[])object);
                                CacheEntry.this.section5Length = ((Object)object).length;
                            }
                            Object var8_7 = null;
                            if (randomAccessFile == null) return null;
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            if (randomAccessFile == null) throw throwable;
                            CacheEntry.this.doUpdateHeader(randomAccessFile);
                            randomAccessFile.close();
                            throw throwable;
                        }
                        CacheEntry.this.doUpdateHeader(randomAccessFile);
                        randomAccessFile.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readSecurityValidationCache() throws IOException {
        if (this.section5Length != 0) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws IOException {
                        DataInputStream dataInputStream;
                        byte[] byArray = new byte[CacheEntry.this.section5Length];
                        RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                        try {
                            randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length + CacheEntry.this.section4Length);
                            randomAccessFile.readFully(byArray);
                            dataInputStream = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            randomAccessFile.close();
                            throw throwable;
                        }
                        randomAccessFile.close();
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        dataInputStream = new DataInputStream(byteArrayInputStream);
                        HashMap<String, Long> hashMap = new HashMap<String, Long>();
                        for (int i = dataInputStream.readInt(); i > 0; --i) {
                            String string = dataInputStream.readUTF();
                            Long l = new Long(dataInputStream.readLong());
                            hashMap.put(string, l);
                        }
                        CacheEntry.this.checkedJars = hashMap;
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) return;
                throw (IOException)privilegedActionException.getException();
            }
        } else {
            this.checkedJars = null;
        }
    }

    public Map getCachedTrustedEntries() {
        if (this.section5Length == 0 && this.checkedJars == null) {
            return null;
        }
        if (this.checkedJars == null) {
            try {
                this.readSecurityValidationCache();
            }
            catch (IOException iOException) {
                Trace.print("Failed to read list of trusted cached entries from index", TraceLevel.CACHE);
                Trace.ignoredException(iOException);
            }
        }
        return this.checkedJars;
    }

    private void invalidateEntryDueToException(Throwable throwable) {
        Trace.println("Invalidating entry url=" + this.url + " file=" + this.indexFile.getAbsolutePath());
        Trace.ignored(throwable);
        this.invalidateEntry();
    }

    private void invalidateEntry() {
        this.setIncomplete(1);
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    public CacheEntry(File file) {
        String string = file.getPath();
        this.filename = string.substring(0, string.length() - 4);
        this.indexFile = file;
        this.indexFileSyncAccess = new SyncFileAccess(this.indexFile);
        this.tempDataFile = new File(this.filename + "-temp");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    CacheEntry.this.readIndexFile();
                    if (CacheEntry.this.hasSigningInfo()) {
                        if (BlackList.hasBeenModifiedSince(CacheEntry.this.blacklistValidationTime)) {
                            if (BlackList.checkJarFile(CacheEntry.this.getJarFile())) {
                                throw new RuntimeException("Blacklisted entry!");
                            }
                            CacheEntry.this.updateBlacklistValidation();
                        } else {
                            Trace.println("Skip blacklist check as cached value is ok.", TraceLevel.CACHE);
                        }
                    }
                }
                catch (Throwable throwable) {
                    CacheEntry.this.invalidateEntryDueToException(throwable);
                }
                return null;
            }
        });
    }

    public void generateShortcutImage() throws IOException {
        if (this.getIsShortcutImage() == 0) {
            this.setIsShortcutImage(1);
            this.updateIndexHeaderOnDisk();
        }
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return ((Object)principal2).equals(principal = x509Certificate2.getSubjectDN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile openLockIndexFile(String string, boolean bl) throws IOException {
        RandomAccessFile randomAccessFile;
        block2: {
            SyncFileAccess.RandomAccessFileLock randomAccessFileLock = null;
            RandomAccessFile randomAccessFile2 = null;
            try {
                randomAccessFileLock = this.indexFileSyncAccess.openLockRandomAccessFile(string, 10000, bl);
                randomAccessFile = randomAccessFile2 = randomAccessFileLock != null ? randomAccessFileLock.getRandomAccessFile() : new RandomAccessFile(this.indexFile, string);
                Object var7_6 = null;
                if (randomAccessFileLock == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (randomAccessFileLock == null) break block3;
                    randomAccessFileLock.release();
                }
                throw throwable;
            }
            randomAccessFileLock.release();
        }
        return randomAccessFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readIndexFileOld() {
        var2_1 = null;
        try {
            block17: {
                if (!this.indexFile.exists()) ** GOTO lbl74
                var2_1 = this.openLockIndexFile("r", false);
                this.setBusy(var2_1.read());
                this.setIncomplete(var2_1.read());
                this.setCacheVersion(var2_1.readInt());
                if (this.getCacheVersion() != Cache.getCacheVersion() || !this.isValidEntry()) break block17;
                var2_1.close();
                var2_1 = null;
                this.readIndexFile();
                var6_2 = null;
                ** GOTO lbl67
            }
            if (this.getCacheVersion() == 602 && this.isValidEntry()) {
                this.setForceUpdate(var2_1.read());
                this.setNoHref(var2_1.read());
                this.setIsShortcutImage(var2_1.read());
                this.setContentLength(var2_1.readInt());
                this.setLastModified(var2_1.readLong());
                this.setExpirationDate(var2_1.readLong());
                this.setVersion(var2_1.readUTF());
                this.setURL(var2_1.readUTF());
                this.setNamespaceID(var2_1.readUTF());
                var3_10 = new File(this.getResourceFilename());
                if (!var3_10.exists()) {
                    var2_1.close();
                    var2_1 = null;
                    this.invalidateEntry();
                }
            } else {
                var2_1.close();
                var2_1 = null;
                this.invalidateEntry();
            }
            if (this.getIncomplete() == 0) {
                this.readHeadersOld(var2_1);
            }
            ** GOTO lbl74
        }
        catch (IOException var3_11) {
            if (var2_1 != null) {
                try {
                    var2_1.close();
                    var2_1 = null;
                }
                catch (IOException var4_12) {
                    Trace.ignoredException(var4_12);
                }
            }
            this.invalidateEntryDueToException(var3_11);
            var6_4 = null;
            try {
                if (var2_1 == null) return;
                var2_1.close();
                return;
            }
            catch (IOException var7_8) {
                Trace.ignoredException(var7_8);
                return;
            }
        }
        {
            catch (Throwable var5_13) {
                var6_5 = null;
                ** try [egrp 3[TRYBLOCK] [7 : 266->277)] { 
lbl61:
                // 1 sources

                if (var2_1 == null) throw var5_13;
                var2_1.close();
                throw var5_13;
lbl64:
                // 1 sources

                catch (IOException var7_9) {
                    Trace.ignoredException(var7_9);
                }
                throw var5_13;
            }
lbl67:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [7 : 266->277)] { 
lbl68:
            // 1 sources

            if (var2_1 == null) return;
            var2_1.close();
            return;
lbl71:
            // 1 sources

            catch (IOException var7_6) {
                Trace.ignoredException(var7_6);
            }
            return;
lbl74:
            // 2 sources

            var6_3 = null;
            try {}
            catch (IOException var7_7) {}
            Trace.ignoredException(var7_7);
            return;
            if (var2_1 == null) return;
            var2_1.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readIndexFile() {
        var1_1 = null;
        try {
            block19: {
                block18: {
                    if (!this.indexFile.exists()) ** GOTO lbl106
                    var1_1 = this.openLockIndexFile("r", false);
                    var2_2 = new byte[128];
                    var3_4 = var1_1.read(var2_2);
                    var4_5 = new DataInputStream(new ByteArrayInputStream(var2_2, 0, var3_4));
                    this.setBusy(var4_5.readByte());
                    this.setIncomplete(var4_5.readByte());
                    this.setCacheVersion(var4_5.readInt());
                    if (this.getCacheVersion() == Cache.getCacheVersion()) break block18;
                    var1_1.close();
                    var1_1 = null;
                    Trace.println("Trying to upgrade in place " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
                    this.readIndexFileOld();
                    this.cacheVersion = Cache.getCacheVersion();
                    var5_6 = this.isValidEntry();
                    try {
                        this.setBusy(1);
                        this.updateIndexHeaderOnDisk();
                        if (var5_6) {
                            this.writeFileToDisk();
                            Trace.println("Upgrade of entry done", TraceLevel.CACHE);
                        } else {
                            Trace.println("Upgrade to of incomplete entry done", TraceLevel.CACHE);
                        }
                    }
                    catch (IOException var6_8) {
                        this.setBusy(0);
                        this.invalidateEntryDueToException(var6_8);
                    }
                    var8_9 = null;
                    ** GOTO lbl91
                }
                this.setForceUpdate(var4_5.readByte());
                this.setNoHref(var4_5.readByte());
                this.setIsShortcutImage(var4_5.readByte());
                this.setContentLength(var4_5.readInt());
                this.setLastModified(var4_5.readLong());
                this.setExpirationDate(var4_5.readLong());
                var5_7 = new File(this.getResourceFilename());
                if (!var5_7.exists()) {
                    this.setIncomplete(1);
                }
                if (this.getIncomplete() != 1) break block19;
                var1_1.close();
                ** GOTO lbl98
            }
            this.validationTimestampt = var4_5.readLong();
            this.knownToBeSigned = var4_5.readByte() == 1;
            this.section2Length = var4_5.readInt();
            this.section3Length = var4_5.readInt();
            this.section4Length = var4_5.readInt();
            this.section5Length = var4_5.readInt();
            this.blacklistValidationTime = var4_5.readLong();
            var4_5.close();
            if (this.section2Length > 0) {
                var2_2 = new byte[this.section2Length];
                var1_1.read(var2_2);
                var4_5 = new DataInputStream(new ByteArrayInputStream(var2_2));
                this.setVersion(var4_5.readUTF());
                this.setURL(var4_5.readUTF());
                this.setNamespaceID(var4_5.readUTF());
                this.setCodebaseIP(var4_5.readUTF());
                this.readHeaders(var4_5);
            }
            ** GOTO lbl106
        }
        catch (IOException var2_3) {
            this.setIncomplete(1);
            Trace.ignoredException(var2_3);
            var8_12 = null;
            try {
                if (var1_1 == null) return;
                var1_1.close();
                return;
            }
            catch (IOException var9_17) {
                Trace.ignoredException(var9_17);
                return;
            }
        }
        {
            catch (Throwable var7_19) {
                var8_13 = null;
                ** try [egrp 3[TRYBLOCK] [9 : 483->494)] { 
lbl85:
                // 1 sources

                if (var1_1 == null) throw var7_19;
                var1_1.close();
                throw var7_19;
lbl88:
                // 1 sources

                catch (IOException var9_18) {
                    Trace.ignoredException(var9_18);
                }
                throw var7_19;
            }
lbl91:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [9 : 483->494)] { 
lbl92:
            // 1 sources

            if (var1_1 == null) return;
            var1_1.close();
            return;
lbl95:
            // 1 sources

            catch (IOException var9_14) {
                Trace.ignoredException(var9_14);
            }
            return;
lbl98:
            // 1 sources

            var8_10 = null;
            ** try [egrp 3[TRYBLOCK] [9 : 483->494)] { 
lbl100:
            // 1 sources

            if (var1_1 == null) return;
            var1_1.close();
            return;
lbl103:
            // 1 sources

            catch (IOException var9_15) {
                Trace.ignoredException(var9_15);
            }
            return;
lbl106:
            // 2 sources

            var8_11 = null;
            try {}
            catch (IOException var9_16) {}
            Trace.ignoredException(var9_16);
            return;
            if (var1_1 == null) return;
            var1_1.close();
            return;
        }
    }

    public void setBusy(int n) {
        this.busy = n;
    }

    int getBusy() {
        return this.busy;
    }

    private void setCacheVersion(int n) {
        this.cacheVersion = n;
    }

    int getCacheVersion() {
        return this.cacheVersion;
    }

    public void setIncomplete(int n) {
        this.incomplete = n;
    }

    int getIncomplete() {
        return this.incomplete;
    }

    public boolean isValidEntry() {
        return this.busy == 0 && this.incomplete == 0;
    }

    public void setIsShortcutImage(int n) {
        this.isShortcutImage = n;
    }

    public int getIsShortcutImage() {
        return this.isShortcutImage;
    }

    private void setForceUpdate(int n) {
        this.forceUpdate = n;
    }

    private int getForceUpdate() {
        return this.forceUpdate;
    }

    void setNoHref(int n) {
        this.noHref = n;
    }

    private int getNoHref() {
        return this.noHref;
    }

    boolean removeBefore(CacheEntry cacheEntry) {
        long l;
        long l2;
        if (this.getIncomplete() == 1) {
            return true;
        }
        if (cacheEntry.getIncomplete() == 1) {
            return false;
        }
        long l3 = this.getIndexFile().lastModified();
        if (l3 < (l2 = cacheEntry.getIndexFile().lastModified())) {
            return true;
        }
        if (l3 > l2) {
            return false;
        }
        long l4 = System.currentTimeMillis();
        long l5 = this.getExpirationDate();
        if (l5 != (l = cacheEntry.getExpirationDate())) {
            if (l5 < l4) {
                return true;
            }
            if (l < l4) {
                return false;
            }
        }
        return this.getContentLength() >= cacheEntry.getContentLength();
    }

    void setContentLength(int n) {
        this.contentLength = n;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Map getCertificateMap() {
        Map map;
        Map map2 = map = this.signerMapCertRef != null ? (Map)this.signerMapCertRef.get() : null;
        if (!this.doneReadCerts || this.signerMapCertRef != null && map == null) {
            try {
                this.readCertificates();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                this.recover();
                try {
                    this.readCertificates();
                }
                catch (IOException iOException2) {
                    this.invalidateEntryDueToException(iOException2);
                }
            }
            map = this.signerMapCertHardRef;
            this.clearHardRefs();
        }
        this.touchRefs();
        return map;
    }

    public Map getSignerMap() {
        Map map;
        Map map2 = map = this.signerMapRef != null ? (Map)this.signerMapRef.get() : null;
        if (!this.doneReadCerts || this.signerMapRef != null && map == null) {
            try {
                this.readCertificates();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                this.recover();
                try {
                    this.readCertificates();
                }
                catch (IOException iOException2) {
                    this.invalidateEntryDueToException(iOException2);
                }
            }
            map = this.signerMapHardRef;
            this.clearHardRefs();
        }
        this.touchRefs();
        return map;
    }

    public CodeSigner[] getCodeSigners() {
        CodeSigner[] codeSignerArray;
        CodeSigner[] codeSignerArray2 = codeSignerArray = this.signersRef != null ? (CodeSigner[])this.signersRef.get() : null;
        if (!this.doneReadCerts || codeSignerArray == null && this.signersRef != null) {
            try {
                this.readCertificates();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                this.recover();
                try {
                    this.readCertificates();
                }
                catch (IOException iOException2) {
                    this.invalidateEntryDueToException(iOException2);
                }
            }
            codeSignerArray = this.signersHardRef;
            this.clearHardRefs();
        }
        this.touchRefs();
        return codeSignerArray;
    }

    public Certificate[] getCertificates() {
        Certificate[] certificateArray;
        Certificate[] certificateArray2 = certificateArray = this.certificatesRef != null ? (Certificate[])this.certificatesRef.get() : null;
        if (!this.doneReadCerts || this.certificatesRef != null && certificateArray == null) {
            try {
                this.readCertificates();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                this.recover();
                try {
                    this.readCertificates();
                }
                catch (IOException iOException2) {
                    this.invalidateEntryDueToException(iOException2);
                }
            }
            certificateArray = this.certificatesHardRef;
            this.clearHardRefs();
        }
        this.touchRefs();
        return certificateArray;
    }

    private void touchRefs() {
        Object t;
        if (this.signerMapRef != null) {
            t = this.signerMapRef.get();
        }
        if (this.signersRef != null) {
            t = this.signersRef.get();
        }
        if (this.certificatesRef != null) {
            t = this.certificatesRef.get();
        }
        if (this.signerMapCertRef != null) {
            t = this.signerMapCertRef.get();
        }
        if (this.manifestRef != null) {
            t = this.manifestRef.get();
        }
    }

    private void clearHardRefs() {
        this.manifestHardRef = null;
        this.signerMapHardRef = null;
        this.signersHardRef = null;
        this.signerMapCertHardRef = null;
        this.certificatesHardRef = null;
    }

    void setLastModified(long l) {
        this.lastModified = l;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    void setExpirationDate(long l) {
        this.expirationDate = l;
    }

    public void updateExpirationInIndexFile(long l) {
        if (this.getExpirationDate() == l) {
            return;
        }
        this.setExpirationDate(l);
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public boolean isExpired() {
        return this.expirationDate == 0L || System.currentTimeMillis() >= this.expirationDate;
    }

    void setURL(String string) {
        this.url = string;
    }

    public String getURL() {
        return this.url;
    }

    void setVersion(String string) {
        this.version = string == null || string.equals("") ? null : string;
    }

    public String getVersion() {
        return this.version;
    }

    private void setNamespaceID(String string) {
        this.namespaceID = string;
    }

    private String getNamespaceID() {
        return this.namespaceID;
    }

    public JarFile getJarFile() {
        JarFile jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Config.isJavaVersionAtLeast15()) {
                    CachedJarFile cachedJarFile = null;
                    try {
                        cachedJarFile = new CachedJarFile(CacheEntry.this);
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                    }
                    return cachedJarFile;
                }
                CachedJarFile14 cachedJarFile14 = null;
                try {
                    cachedJarFile14 = new CachedJarFile14(CacheEntry.this);
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                return cachedJarFile14;
            }
        });
        return jarFile;
    }

    public String getResourceFilename() {
        return this.filename;
    }

    public File getDataFile() {
        File file = null;
        if (this.filename != null && !this.url.equals("")) {
            file = new File(this.filename);
            MemoryCache.addResourceReference(file, this.url);
        }
        return file;
    }

    File getTempDataFile() {
        return this.tempDataFile;
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public long getSize() {
        return this.getDataFile().length() + this.getIndexFile().length();
    }

    void setHeaders(MessageHeader messageHeader) {
        this.headerFields = messageHeader;
    }

    public Map getHeaders() {
        return this.headerFields.getHeaders();
    }

    public boolean isHttpNoCacheEnabled() {
        String string = this.headerFields.getValue(this.headerFields.getKey("cache-control"));
        if (string != null && string.equals("no-cache")) {
            return true;
        }
        String string2 = this.headerFields.getValue(this.headerFields.getKey("pragma"));
        return string2 != null && string2.equals("no-cache");
    }

    boolean processTempDataFile(boolean bl, DownloadEngine.DownloadDelegate downloadDelegate, URL uRL, URL uRL2, String string) {
        Object object;
        boolean bl2 = false;
        if (bl) {
            object = null;
            String string2 = uRL2.getQuery().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (!string3.startsWith("current-version-id")) continue;
                object = string3.substring("current-version-id".length() + 1);
                break;
            }
            CacheEntry cacheEntry = null;
            cacheEntry = Cache.getCacheEntry(uRL, null, (String)object);
            File file = null;
            if (cacheEntry != null) {
                file = new File(cacheEntry.getResourceFilename());
            }
            File file2 = null;
            try {
                Trace.println(ResourceManager.getString("cacheEntry.applyJarDiff", uRL == null ? "" : uRL.toString(), (String)object, string), TraceLevel.NETWORK);
                file2 = DownloadEngine.applyPatch(file, this.tempDataFile, uRL, string, downloadDelegate, this.filename);
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CacheEntry.this.tempDataFile.delete();
                    return null;
                }
            });
            if (file2 != null) {
                bl2 = true;
            }
        }
        if (((Boolean)(object = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(CacheEntry.this.tempDataFile.renameTo(new File(CacheEntry.this.filename)));
            }
        }))).booleanValue()) {
            bl2 = true;
        }
        return bl2;
    }

    private void initFrom(CacheEntry cacheEntry) {
        Trace.println("Recovering CacheEntry for " + cacheEntry.getURL(), TraceLevel.CACHE);
        this.filename = cacheEntry.filename;
        this.indexFile = cacheEntry.indexFile;
        this.indexFileSyncAccess = new SyncFileAccess(this.indexFile);
        this.tempDataFile = new File(this.filename + "-temp");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CacheEntry.this.readIndexFile();
                return null;
            }
        });
    }

    private void recover() {
        Trace.println("Trying to recover cache entry for " + this.url, TraceLevel.CACHE);
        try {
            URL uRL = new URL(this.url);
            String string = this.getVersion();
            String string2 = this.getNamespaceID();
            MemoryCache.removeLoadedResource(this.url);
            Cache.removeCacheEntry(this, false);
            DownloadEngine.getCachedFile(uRL);
            CacheEntry cacheEntry = Cache.getCacheEntry(uRL, string2, string);
            if (cacheEntry == null) {
                throw new RuntimeException("ERROR: Recovery got null entry");
            }
            this.initFrom(cacheEntry);
        }
        catch (Exception exception) {
            throw new RuntimeException("ERROR: Failed to recover corrupt cache entry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() {
        Manifest manifest;
        Manifest manifest2 = manifest = this.manifestRef != null ? (Manifest)this.manifestRef.get() : null;
        if (!this.doneReadManifest || this.manifestRef != null && manifest == null) {
            try {
                try {
                    manifest = this.readManifest();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                    this.recover();
                    try {
                        manifest = this.readManifest();
                    }
                    catch (IOException iOException2) {
                        this.invalidateEntryDueToException(iOException2);
                    }
                    Object var5_3 = null;
                    this.clearHardRefs();
                }
                Object var5_2 = null;
                this.clearHardRefs();
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.clearHardRefs();
                throw throwable;
            }
        }
        this.touchRefs();
        return manifest;
    }

    private void setCodebaseIP(String string) {
        this.codebaseIP = string;
    }

    public String getCodebaseIP() {
        return this.codebaseIP;
    }

    private void setManifest(Manifest manifest) {
        this.manifestHardRef = manifest;
        if (manifest != null) {
            if (!Environment.isJavaPlugin()) {
                manifest.getMainAttributes().remove(Attributes.Name.CLASS_PATH);
            }
            CachedJarFile.makeManifestImmutable(this.manifestHardRef);
            this.manifestRef = new SoftReference<Manifest>(this.manifestHardRef);
        } else {
            this.manifestRef = null;
        }
    }

    public void writeFileToDisk() throws IOException {
        this.writeFileToDisk(1, null);
    }

    private boolean hasMimeType(String string) {
        if (this.headerFields != null) {
            Object v = this.getHeaders().get("content-type");
            if (!(v instanceof List)) {
                return false;
            }
            List list = (List)v;
            return list.contains(string);
        }
        return false;
    }

    private boolean hasRequestType(String string) {
        if (this.headerFields != null) {
            Object v = this.getHeaders().get("deploy-request-content-type");
            if (!(v instanceof List)) {
                return false;
            }
            List list = (List)v;
            return list.contains(string);
        }
        return false;
    }

    private boolean isJarFile(String string) {
        if (this.hasRequestType("application/x-java-archive")) {
            return true;
        }
        int n = string.indexOf(";");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("?")) != -1) {
            string = string.substring(0, n);
        }
        return string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".jarjar") || this.hasMimeType("application/x-java-archive") || this.hasMimeType("application/java-archive") || this.hasMimeType("application/x-java-archive-diff");
    }

    public void updateIndexHeaderOnDisk() throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Object run() throws IOException {
                        RandomAccessFile randomAccessFile = null;
                        try {
                            randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                            CacheEntry.this.doUpdateHeader(randomAccessFile);
                            Object var3_2 = null;
                            if (randomAccessFile == null) return null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            if (randomAccessFile == null) throw throwable;
                            randomAccessFile.close();
                            throw throwable;
                        }
                        randomAccessFile.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    private void doUpdateHeader(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile != null) {
            randomAccessFile.seek(0L);
            randomAccessFile.write(this.prepareHeader());
        }
    }

    private byte[] prepareHeader() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(this.busy);
        dataOutputStream.writeByte(this.incomplete);
        dataOutputStream.writeInt(this.cacheVersion);
        dataOutputStream.writeByte(this.forceUpdate);
        dataOutputStream.writeByte(this.noHref);
        dataOutputStream.writeByte(this.isShortcutImage);
        dataOutputStream.writeInt(this.contentLength);
        dataOutputStream.writeLong(this.lastModified);
        dataOutputStream.writeLong(this.expirationDate);
        dataOutputStream.writeLong(this.validationTimestampt);
        dataOutputStream.writeByte(this.knownToBeSigned ? 1 : 0);
        dataOutputStream.writeInt(this.section2Length);
        dataOutputStream.writeInt(this.section3Length);
        dataOutputStream.writeInt(this.section4Length);
        dataOutputStream.writeInt(this.section5Length);
        dataOutputStream.writeLong(this.blacklistValidationTime);
        if (byteArrayOutputStream.size() < 128) {
            byte[] byArray = new byte[128 - byteArrayOutputStream.size()];
            dataOutputStream.write(byArray);
        }
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    void writeFileToDisk(final int n, final DownloadEngine.DownloadDelegate downloadDelegate) throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public Object run() throws IOException {
                        ZipFile zipFile;
                        block14: {
                            zipFile = null;
                            RandomAccessFile randomAccessFile = null;
                            CacheEntry.this.section2Length = 0;
                            CacheEntry.this.section3Length = 0;
                            CacheEntry.this.section4Length = 0;
                            CacheEntry.this.section5Length = 0;
                            try {
                                try {
                                    Object object;
                                    String string;
                                    randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                                    byte[] byArray = CacheEntry.this.prepareHeader();
                                    randomAccessFile.write(byArray);
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
                                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                                    dataOutputStream.writeUTF(CacheEntry.this.getVersion() != null ? CacheEntry.this.getVersion() : "");
                                    dataOutputStream.writeUTF(CacheEntry.this.getURL());
                                    dataOutputStream.writeUTF(CacheEntry.this.getNamespaceID());
                                    InetAddress inetAddress = null;
                                    String string2 = "";
                                    if (CacheEntry.this.url != null && !CacheEntry.this.url.equals("") && (inetAddress = Cache.getHostIP(string = ((URL)(object = new URL(CacheEntry.this.url))).getHost())) != null) {
                                        string2 = inetAddress.getHostAddress();
                                    }
                                    dataOutputStream.writeUTF(string2);
                                    CacheEntry.this.writeHeaders(dataOutputStream);
                                    dataOutputStream.close();
                                    byteArrayOutputStream.close();
                                    CacheEntry.this.section2Length = byteArrayOutputStream.size();
                                    randomAccessFile.write(byteArrayOutputStream.toByteArray());
                                    if (CacheEntry.this.incomplete == 0) {
                                        if (CacheEntry.this.isJarFile(CacheEntry.this.url)) {
                                            zipFile = new JarFile(new File(CacheEntry.this.filename));
                                            object = ((JarFile)zipFile).getManifest();
                                            CacheEntry.this.writeManifest(randomAccessFile, (JarFile)zipFile, (Manifest)object, n, downloadDelegate);
                                            CacheEntry.this.setManifest((Manifest)object);
                                            CacheEntry.this.manifestHardRef = null;
                                            zipFile.close();
                                        }
                                        DownloadEngine.addToUpdateCheckDoneList(CacheEntry.this.url);
                                        Cache.addToCleanupThreadLoadedResourceList(CacheEntry.this.url);
                                        CacheEntry.this.setBusy(0);
                                        CacheEntry.this.setIncomplete(0);
                                        CacheEntry.this.updateBlacklistValidation();
                                        CacheEntry.this.doUpdateHeader(randomAccessFile);
                                        CacheEntry.this.doneReadManifest = true;
                                        CacheEntry.this.doneReadCerts = true;
                                    }
                                }
                                catch (Exception exception) {
                                    Trace.ignoredException(exception);
                                    if (randomAccessFile != null) {
                                        randomAccessFile.close();
                                        randomAccessFile = null;
                                    }
                                    if (zipFile != null) {
                                        zipFile.close();
                                        zipFile = null;
                                    }
                                    Cache.removeCacheEntry(CacheEntry.this);
                                    if (exception instanceof JARSigningException) {
                                        throw (JARSigningException)exception;
                                    }
                                    if (!(exception instanceof ZipException)) throw new IOException(exception.getMessage());
                                    throw new JARSigningException(new URL(CacheEntry.this.url), CacheEntry.this.version, 2, exception);
                                }
                                Object var11_11 = null;
                                if (randomAccessFile == null) break block14;
                            }
                            catch (Throwable throwable) {
                                Object var11_12 = null;
                                if (randomAccessFile != null) {
                                    randomAccessFile.close();
                                }
                                if (zipFile != null) {
                                    zipFile.close();
                                }
                                Cache.cleanup();
                                throw throwable;
                            }
                            randomAccessFile.close();
                        }
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        Cache.cleanup();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    private Manifest readManifest() throws IOException {
        try {
            return (Manifest)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Object run() throws IOException {
                    Manifest manifest = null;
                    if (CacheEntry.this.section3Length == 0) return manifest;
                    RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("r", false);
                    try {
                        randomAccessFile.seek(128 + CacheEntry.this.section2Length);
                        Object var3_3 = null;
                        byte[] byArray = new byte[CacheEntry.this.section3Length];
                        randomAccessFile.readFully(byArray);
                        CacheEntry.this.readManifest(byArray);
                        manifest = CacheEntry.this.manifestHardRef;
                        CacheEntry.this.doneReadManifest = true;
                        Object var6_5 = null;
                        if (randomAccessFile == null) return manifest;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (randomAccessFile == null) throw throwable;
                        randomAccessFile.close();
                        throw throwable;
                    }
                    randomAccessFile.close();
                    return manifest;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                throw (IOException)privilegedActionException.getException();
            }
            return null;
        }
    }

    private void readCertificates() throws IOException {
        block3: {
            Trace.println("Reading certificates from " + this.section4Length + " " + this.url + " | " + this.indexFile.getAbsolutePath());
            if (this.section4Length != 0) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public Object run() throws IOException {
                            RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("r", false);
                            try {
                                randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length);
                                byte[] byArray = new byte[CacheEntry.this.section4Length];
                                randomAccessFile.readFully(byArray);
                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                                CacheEntry.this.readCertificates(new BufferedInputStream(byteArrayInputStream));
                                CacheEntry.this.doneReadCerts = true;
                                Object var5_4 = null;
                                if (randomAccessFile == null) return null;
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                if (randomAccessFile == null) throw throwable;
                                randomAccessFile.close();
                                throw throwable;
                            }
                            randomAccessFile.close();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (!(privilegedActionException.getException() instanceof IOException)) break block3;
                    throw (IOException)privilegedActionException.getException();
                }
            }
        }
    }

    private void readManifest(byte[] byArray) throws IOException {
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            Manifest manifest = new Manifest();
            manifest.read(gZIPInputStream);
            gZIPInputStream.close();
            this.setManifest(manifest);
        }
    }

    private void readCertificates(BufferedInputStream bufferedInputStream) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ObjectInputStream objectInputStream = null;
        BufferedReader bufferedReader = null;
        objectInputStream = new ObjectInputStream(bufferedInputStream);
        bufferedReader = new BufferedReader(new InputStreamReader(objectInputStream));
        int n = objectInputStream.readInt();
        if (n > 0) {
            int n2;
            Object object;
            String string;
            HashMap<Object, int[]> hashMap = new HashMap<Object, int[]>();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            Certificate[] certificateArray = new Certificate[n];
            this.signerMapHardRef = hashMap;
            this.signerMapRef = new SoftReference<Map>(this.signerMapHardRef);
            this.signerMapCertHardRef = hashMap2;
            this.signerMapCertRef = new SoftReference<Map>(this.signerMapCertHardRef);
            this.certificatesHardRef = certificateArray;
            this.certificatesRef = new SoftReference<Certificate[]>(this.certificatesHardRef);
            try {
                for (int i = 0; i < n; ++i) {
                    certificateArray[i] = (Certificate)objectInputStream.readObject();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Error reading signer certificates");
            }
            String string2 = bufferedReader.readLine();
            String string3 = null;
            while (string2 != null && !string2.equals("")) {
                string = string2;
                if (string.startsWith("/")) {
                    string = string3 + string;
                } else {
                    int n3 = string.lastIndexOf("/");
                    if (n3 != -1) {
                        string3 = string.substring(0, n3);
                    }
                }
                string2 = bufferedReader.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                object = new int[n4];
                for (n2 = 0; n2 < n4; ++n2) {
                    object[n2] = Integer.parseInt(stringTokenizer.nextToken());
                }
                arrayList.add(string);
                hashMap2.put(string, object);
                string2 = bufferedReader.readLine();
            }
            if (Config.isJavaVersionAtLeast15()) {
                string = bufferedReader.readLine();
                int n5 = 0;
                if (string != null) {
                    n5 = Integer.parseInt(string);
                }
                if (n5 == 0) {
                    try {
                        int n6;
                        Object object2;
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        object = new ArrayList();
                        n2 = 0;
                        int n7 = 0;
                        int n8 = 0;
                        while (n8 < certificateArray.length) {
                            Serializable serializable;
                            object2 = new ArrayList();
                            int n9 = n7;
                            for (n9 = n7; n9 < certificateArray.length; ++n9) {
                                serializable = null;
                                Serializable serializable2 = null;
                                if (certificateArray[n9] instanceof X509Certificate) {
                                    serializable = (X509Certificate)certificateArray[n9];
                                }
                                serializable2 = n9 + 1 < certificateArray.length && certificateArray[n9 + 1] instanceof X509Certificate ? (X509Certificate)certificateArray[n9 + 1] : serializable;
                                ((ArrayList)object2).add(serializable);
                                if (!CacheEntry.isIssuerOf((X509Certificate)serializable, (X509Certificate)serializable2)) break;
                            }
                            n8 = n9 < certificateArray.length ? n9 + 1 : n9;
                            serializable = certificateFactory.generateCertPath((List<? extends Certificate>)object2);
                            ((ArrayList)object2).clear();
                            ((ArrayList)object).add(serializable);
                            n7 = n8;
                            ++n2;
                        }
                        object2 = new CodeSigner[n2];
                        this.signersHardRef = object2;
                        this.signersRef = new SoftReference<CodeSigner[]>(this.signersHardRef);
                        int[] nArray = new int[n2];
                        for (n6 = 0; n6 < n2; ++n6) {
                            object2[n6] = new CodeSigner((CertPath)((ArrayList)object).get(n6), null);
                            nArray[n6] = n6;
                        }
                        for (n6 = 0; n6 < arrayList.size(); ++n6) {
                            hashMap.put(arrayList.get(n6), nArray);
                        }
                    }
                    catch (CertificateException certificateException) {
                        throw new IOException("Error process signer certificates");
                    }
                }
                if (n5 > 0) {
                    CodeSigner[] codeSignerArray = new CodeSigner[n5];
                    this.signersHardRef = codeSignerArray;
                    this.signersRef = new SoftReference<CodeSigner[]>(this.signersHardRef);
                    try {
                        for (int i = 0; i < n5; ++i) {
                            codeSignerArray[i] = (CodeSigner)objectInputStream.readObject();
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IOException("Error reading code signer");
                    }
                    String string4 = bufferedReader.readLine();
                    String string5 = null;
                    while (string4 != null && !string4.equals("")) {
                        String string6 = string4;
                        if (string6.startsWith("/")) {
                            string6 = string5 + string6;
                        } else {
                            int n10 = string6.lastIndexOf("/");
                            if (n10 != -1) {
                                string5 = string6.substring(0, n10);
                            }
                        }
                        string4 = bufferedReader.readLine();
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, " ", false);
                        int n11 = Integer.parseInt(stringTokenizer.nextToken());
                        int[] nArray = new int[n11];
                        for (int i = 0; i < n11; ++i) {
                            nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        hashMap.put(string6, nArray);
                        string4 = bufferedReader.readLine();
                    }
                }
            }
        } else {
            Trace.println(ResourceManager.getString("cacheEntry.unsignedJar", this.url), TraceLevel.NETWORK);
        }
    }

    public String getNativeLibPath() {
        return this.getResourceFilename() + "-n";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeManifest(RandomAccessFile randomAccessFile, JarFile jarFile, Manifest manifest, int n, DownloadEngine.DownloadDelegate downloadDelegate) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<CodeSigner> arrayList2 = new ArrayList<CodeSigner>();
        CodeSigner[] codeSignerArray = null;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FilterOutputStream filterOutputStream = null;
        byte[] byArray = new byte[2048];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        int n2 = jarFile.size();
        int n3 = 0;
        URL uRL = new URL(this.url);
        boolean bl = false;
        if (downloadDelegate != null) {
            downloadDelegate.validating(uRL, 0, n2);
        }
        while (enumeration.hasMoreElements()) {
            int n4;
            block38: {
                object6 = enumeration.nextElement();
                object5 = ((ZipEntry)object6).getName();
                if (!bl) {
                    try {
                        bl = BlackList.checkJarEntry(jarFile, (JarEntry)object6);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        throw new JARSigningException(new URL(this.url), this.version, 5, generalSecurityException);
                    }
                }
                if (((String)object5).startsWith(META_FILE_DIR) && !((String)object5).equals(JAR_INDEX_NAME)) continue;
                object4 = null;
                int n5 = 0;
                try {
                    try {
                        object4 = jarFile.getInputStream((ZipEntry)object6);
                        if (DownloadEngine.isNativeContentType(n) && ((String)object5).indexOf("/") == -1 && ((String)object5).indexOf("\\") == -1 && ((File)(object3 = new File((File)(object2 = new File(this.getNativeLibPath()).getCanonicalFile()), (String)object5).getCanonicalFile())).getParentFile().equals(object2)) {
                            ((File)object3).getParentFile().mkdirs();
                            filterOutputStream = new BufferedOutputStream(new FileOutputStream((File)object3));
                        }
                        while ((n5 = ((InputStream)object4).read(byArray, 0, byArray.length)) != -1) {
                            if (filterOutputStream == null) continue;
                            ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n5);
                        }
                        object = null;
                        if (filterOutputStream == null) break block38;
                    }
                    catch (SecurityException securityException) {
                        throw new JARSigningException(new URL(this.url), this.version, 2, securityException);
                    }
                }
                catch (Throwable throwable) {
                    object = null;
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                        filterOutputStream = null;
                    }
                    if (object4 == null) throw throwable;
                    ((InputStream)object4).close();
                    throw throwable;
                }
                filterOutputStream.close();
                filterOutputStream = null;
            }
            if (object4 != null) {
                ((InputStream)object4).close();
            }
            if ((object2 = ((JarEntry)object6).getCertificates()) != null && ((Certificate[])object2).length > 0) {
                object3 = new int[((Certificate[])object2).length];
                for (n4 = 0; n4 < ((Object)object2).length; ++n4) {
                    int n6 = arrayList.indexOf(object2[n4]);
                    if (n6 == -1) {
                        n6 = arrayList.size();
                        arrayList.add(object2[n4]);
                    }
                    object3[n4] = n6;
                }
                hashMap.put(object5, object3);
            }
            if (Config.isJavaVersionAtLeast15() && (codeSignerArray = ((JarEntry)object6).getCodeSigners()) != null && codeSignerArray.length > 0) {
                object3 = new int[codeSignerArray.length];
                for (n4 = 0; n4 < codeSignerArray.length; ++n4) {
                    int n7 = arrayList2.indexOf(codeSignerArray[n4]);
                    if (n7 == -1) {
                        n7 = arrayList2.size();
                        arrayList2.add(codeSignerArray[n4]);
                    }
                    object3[n4] = n7;
                }
                hashMap2.put(object5, object3);
            }
            if (downloadDelegate == null) continue;
            downloadDelegate.validating(uRL, ++n3, n2);
        }
        if (manifest != null) {
            object6 = new ByteArrayOutputStream();
            object5 = new GZIPOutputStream((OutputStream)object6);
            manifest.write((OutputStream)object5);
            ((DeflaterOutputStream)object5).close();
            object4 = ((ByteArrayOutputStream)object6).toByteArray();
            byteArrayOutputStream.write((byte[])object4);
            this.section3Length = ((byte[])object4).length;
        } else {
            this.section3Length = 0;
        }
        object6 = new ObjectOutputStream(byteArrayOutputStream);
        object5 = new BufferedWriter(new OutputStreamWriter((OutputStream)object6));
        if (!arrayList.isEmpty()) {
            ((ObjectOutputStream)object6).writeInt(arrayList.size());
            object4 = arrayList.iterator();
            while (object4.hasNext()) {
                ((ObjectOutputStream)object6).writeObject(object4.next());
            }
            Iterator iterator = hashMap.keySet().iterator();
            object2 = null;
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                int[] nArray = (int[])hashMap.get(object3);
                if (((String)object3).indexOf("/") != -1) {
                    object = ((String)object3).substring(0, ((String)object3).lastIndexOf("/"));
                    if (object2 != null && ((String)object).equals(object2)) {
                        object3 = ((String)object3).substring(((String)object).length());
                    }
                    object2 = object;
                }
                ((Writer)object5).write((String)object3);
                ((BufferedWriter)object5).newLine();
                object = String.valueOf(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    object = (String)object + " " + nArray[i];
                }
                ((BufferedWriter)object5).write((String)object, 0, ((String)object).length());
                ((BufferedWriter)object5).newLine();
            }
            ((BufferedWriter)object5).newLine();
            ((BufferedWriter)object5).flush();
        } else {
            ((ObjectOutputStream)object6).writeInt(0);
        }
        if (!arrayList2.isEmpty()) {
            object4 = new Integer(arrayList2.size());
            ((Writer)object5).write(((Integer)object4).toString());
            ((BufferedWriter)object5).newLine();
            ((BufferedWriter)object5).flush();
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                ((ObjectOutputStream)object6).writeObject(iterator.next());
            }
            object2 = hashMap2.keySet().iterator();
            object3 = null;
            while (object2.hasNext()) {
                String string;
                String string2 = (String)object2.next();
                object = (int[])hashMap2.get(string2);
                if (string2.indexOf("/") != -1) {
                    string = string2.substring(0, string2.lastIndexOf("/"));
                    if (object3 != null && string.equals(object3)) {
                        string2 = string2.substring(string.length());
                    }
                    object3 = string;
                }
                ((Writer)object5).write(string2);
                ((BufferedWriter)object5).newLine();
                string = String.valueOf(((Object)object).length);
                for (int i = 0; i < ((Object)object).length; ++i) {
                    string = string + " " + (int)object[i];
                }
                ((BufferedWriter)object5).write(string, 0, string.length());
                ((BufferedWriter)object5).newLine();
            }
        } else {
            ((Writer)object5).write("0");
        }
        ((BufferedWriter)object5).flush();
        ((ObjectOutputStream)object6).flush();
        randomAccessFile.write(byteArrayOutputStream.toByteArray());
        this.section4Length = byteArrayOutputStream.size() - this.section3Length;
        if (Config.isJavaVersionAtLeast15()) {
            if (!arrayList2.isEmpty()) {
                object4 = new CodeSigner[arrayList2.size()];
                this.signersHardRef = (CodeSigner[])arrayList2.toArray((T[])object4);
                this.signersRef = new SoftReference<CodeSigner[]>(this.signersHardRef);
                this.signerMapHardRef = hashMap2;
                this.signerMapRef = new SoftReference<Map>(this.signerMapHardRef);
                return;
            }
            this.signersHardRef = null;
            this.signersRef = null;
            this.signerMapHardRef = null;
            this.signerMapRef = null;
            return;
        }
        if (!arrayList.isEmpty()) {
            object4 = new Certificate[arrayList.size()];
            this.certificatesHardRef = (Certificate[])arrayList.toArray((T[])object4);
            this.certificatesRef = new SoftReference<Certificate[]>(this.certificatesHardRef);
            this.signerMapCertHardRef = hashMap;
            this.signerMapCertRef = new SoftReference<Map>(this.signerMapCertHardRef);
            return;
        }
        this.certificatesHardRef = null;
        this.certificatesRef = null;
        this.signerMapCertHardRef = null;
        this.signerMapCertRef = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeadersOld(RandomAccessFile randomAccessFile) throws IOException {
        try {
            for (int i = randomAccessFile.readInt(); i > 0; --i) {
                String string = randomAccessFile.readUTF();
                if (string.equals("deploy_resource_codebase_ip")) {
                    this.setCodebaseIP(randomAccessFile.readUTF());
                    continue;
                }
                if (string.equals("<null>")) {
                    string = null;
                }
                this.headerFields.add(string, randomAccessFile.readUTF());
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaders(DataInputStream dataInputStream) throws IOException {
        try {
            for (int i = dataInputStream.readInt(); i > 0; --i) {
                String string = dataInputStream.readUTF();
                if (string.equals("<null>")) {
                    string = null;
                }
                this.headerFields.add(string, dataInputStream.readUTF());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeaders(DataOutputStream dataOutputStream) throws IOException {
        try {
            if (this.headerFields == null) {
                dataOutputStream.writeInt(0);
                Object var6_2 = null;
                return;
            }
            Map map = this.headerFields.getHeaders();
            if (!map.isEmpty()) {
                dataOutputStream.writeInt(map.size());
                for (int i = 0; i < map.size(); ++i) {
                    String string = this.headerFields.getKey(i);
                    if (null == string) {
                        string = "<null>";
                    }
                    dataOutputStream.writeUTF(string);
                    dataOutputStream.writeUTF(this.headerFields.getValue(i));
                }
            } else {
                dataOutputStream.writeInt(0);
            }
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            throw throwable;
        }
        Object var6_3 = null;
    }

    private String printManifest() {
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Attributes attributes = manifest.getMainAttributes();
            Iterator<Object> iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                stringBuffer.append("key: " + object);
                stringBuffer.append(" value: " + attributes.get(object) + "\n");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----Cache Entry------\n");
        stringBuffer.append("busy: " + this.getBusy() + "\n");
        stringBuffer.append("incomplete: " + this.getIncomplete() + "\n");
        stringBuffer.append("cacheVersion: " + this.getCacheVersion() + "\n");
        stringBuffer.append("forceUpdate: " + this.getForceUpdate() + "\n");
        stringBuffer.append("noHref: " + this.getNoHref() + "\n");
        stringBuffer.append("contentLength: " + this.getContentLength() + "\n");
        long l = this.getLastModified();
        stringBuffer.append("lastModified: " + l + " [" + new Date(l).toString() + "]\n");
        stringBuffer.append("expirationDate: " + this.getExpirationDate() + "\n");
        stringBuffer.append("version: " + this.getVersion() + "\n");
        stringBuffer.append("URL: " + this.url + "\n");
        stringBuffer.append("NamespaceID: " + this.getNamespaceID() + "\n");
        stringBuffer.append("HTTP/HTTPS Header: " + this.getHeaders() + "\n");
        if (this.getManifest() != null) {
            stringBuffer.append("Jar-Manifest Main Attributes:\n");
            stringBuffer.append(this.printManifest());
            stringBuffer.append("----------------------\n");
        }
        return stringBuffer.toString();
    }
}

