/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MimeTypeFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.activation.FileTypeMap;
import javax.activation.SecuritySupport;

public class MimetypesFileTypeMap
extends FileTypeMap {
    private static MimeTypeFile defDB = null;
    private MimeTypeFile[] DB;
    private static final int PROG = 0;
    private static String defaultType = "application/octet-stream";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimetypesFileTypeMap() {
        Object object;
        Vector<MimeTypeFile> vector = new Vector<MimeTypeFile>(5);
        MimeTypeFile mimeTypeFile = null;
        vector.addElement(null);
        LogSupport.log("MimetypesFileTypeMap: load HOME");
        try {
            String string;
            object = System.getProperty("user.home");
            if (object != null && (mimeTypeFile = this.loadFile(string = (String)object + File.separator + ".mime.types")) != null) {
                vector.addElement(mimeTypeFile);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log("MimetypesFileTypeMap: load SYS");
        try {
            object = System.getProperty("java.home") + File.separator + "lib" + File.separator + "mime.types";
            mimeTypeFile = this.loadFile((String)object);
            if (mimeTypeFile != null) {
                vector.addElement(mimeTypeFile);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log("MimetypesFileTypeMap: load JAR");
        this.loadAllResources(vector, "META-INF/mime.types");
        LogSupport.log("MimetypesFileTypeMap: load DEF");
        object = MimetypesFileTypeMap.class;
        synchronized (MimetypesFileTypeMap.class) {
            if (defDB == null) {
                defDB = this.loadResource("/META-INF/mimetypes.default");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (defDB != null) {
                vector.addElement(defDB);
            }
            this.DB = new MimeTypeFile[vector.size()];
            vector.copyInto(this.DB);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeTypeFile loadResource(String string) {
        InputStream inputStream = null;
        try {
            inputStream = SecuritySupport.getResourceAsStream(this.getClass(), string);
            if (inputStream != null) {
                MimeTypeFile mimeTypeFile = new MimeTypeFile(inputStream);
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MimetypesFileTypeMap: successfully loaded mime types file: " + string);
                }
                MimeTypeFile mimeTypeFile2 = mimeTypeFile;
                return mimeTypeFile2;
            }
            if (LogSupport.isLoggable()) {
                LogSupport.log("MimetypesFileTypeMap: not loading mime types file: " + string);
            }
        }
        catch (IOException iOException) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("MimetypesFileTypeMap: can't load " + string, iOException);
            }
        }
        catch (SecurityException securityException) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("MimetypesFileTypeMap: can't load " + string, securityException);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllResources(Vector vector, String string) {
        Object object;
        boolean bl;
        block25: {
            bl = false;
            try {
                ClassLoader classLoader = null;
                classLoader = SecuritySupport.getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                if ((object = classLoader != null ? SecuritySupport.getResources(classLoader, string) : SecuritySupport.getSystemResources(string)) == null) break block25;
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MimetypesFileTypeMap: getResources");
                }
                for (int i = 0; i < ((URL[])object).length; ++i) {
                    URL uRL = object[i];
                    InputStream inputStream = null;
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("MimetypesFileTypeMap: URL " + uRL);
                    }
                    try {
                        inputStream = SecuritySupport.openStream(uRL);
                        if (inputStream != null) {
                            vector.addElement(new MimeTypeFile(inputStream));
                            bl = true;
                            if (!LogSupport.isLoggable()) continue;
                            LogSupport.log("MimetypesFileTypeMap: successfully loaded mime types from URL: " + uRL);
                            continue;
                        }
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MimetypesFileTypeMap: not loading mime types from URL: " + uRL);
                        continue;
                    }
                    catch (IOException iOException) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MimetypesFileTypeMap: can't load " + uRL, iOException);
                        continue;
                    }
                    catch (SecurityException securityException) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MimetypesFileTypeMap: can't load " + uRL, securityException);
                        continue;
                    }
                    finally {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception exception) {
                if (!LogSupport.isLoggable()) break block25;
                LogSupport.log("MimetypesFileTypeMap: can't load " + string, exception);
            }
        }
        if (!bl) {
            LogSupport.log("MimetypesFileTypeMap: !anyLoaded");
            object = this.loadResource("/" + string);
            if (object != null) {
                vector.addElement(object);
            }
        }
    }

    private MimeTypeFile loadFile(String string) {
        MimeTypeFile mimeTypeFile = null;
        try {
            mimeTypeFile = new MimeTypeFile(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mimeTypeFile;
    }

    public MimetypesFileTypeMap(String string) throws IOException {
        this();
        this.DB[0] = new MimeTypeFile(string);
    }

    public MimetypesFileTypeMap(InputStream inputStream) {
        this();
        try {
            this.DB[0] = new MimeTypeFile(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void addMimeTypes(String string) {
        if (this.DB[0] == null) {
            this.DB[0] = new MimeTypeFile();
        }
        this.DB[0].appendToRegistry(string);
    }

    public String getContentType(File file) {
        return this.getContentType(file.getName());
    }

    public synchronized String getContentType(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return defaultType;
        }
        String string2 = string.substring(n + 1);
        if (string2.length() == 0) {
            return defaultType;
        }
        for (int i = 0; i < this.DB.length; ++i) {
            String string3;
            if (this.DB[i] == null || (string3 = this.DB[i].getMIMETypeString(string2)) == null) continue;
            return string3;
        }
        return defaultType;
    }
}

