/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.staxex;

import com.sun.xml.internal.org.jvnet.staxex.Base64Encoder;
import com.sun.xml.internal.org.jvnet.staxex.ByteArrayOutputStreamEx;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;

public class Base64Data
implements CharSequence,
Cloneable {
    private DataHandler dataHandler;
    private byte[] data;
    private int dataLen;
    private boolean dataCloneByRef;
    private String mimeType;

    public Base64Data() {
    }

    public Base64Data(Base64Data base64Data) {
        base64Data.get();
        if (base64Data.dataCloneByRef) {
            this.data = base64Data.data;
        } else {
            this.data = new byte[base64Data.dataLen];
            System.arraycopy(base64Data.data, 0, this.data, 0, base64Data.dataLen);
        }
        this.dataCloneByRef = true;
        this.dataLen = base64Data.dataLen;
        this.dataHandler = null;
        this.mimeType = base64Data.mimeType;
    }

    public void set(byte[] byArray, int n, String string, boolean bl) {
        this.data = byArray;
        this.dataLen = n;
        this.dataCloneByRef = bl;
        this.dataHandler = null;
        this.mimeType = string;
    }

    public void set(byte[] byArray, int n, String string) {
        this.set(byArray, n, string, false);
    }

    public void set(byte[] byArray, String string) {
        this.set(byArray, byArray.length, string, false);
    }

    public void set(DataHandler dataHandler) {
        assert (dataHandler != null);
        this.dataHandler = dataHandler;
        this.data = null;
    }

    public DataHandler getDataHandler() {
        if (this.dataHandler == null) {
            this.dataHandler = new DataHandler(new DataSource(){

                public String getContentType() {
                    return Base64Data.this.getMimeType();
                }

                public InputStream getInputStream() {
                    return new ByteArrayInputStream(Base64Data.this.data, 0, Base64Data.this.dataLen);
                }

                public String getName() {
                    return null;
                }

                public OutputStream getOutputStream() {
                    throw new UnsupportedOperationException();
                }
            });
        }
        return this.dataHandler;
    }

    public byte[] getExact() {
        this.get();
        if (this.dataLen != this.data.length) {
            byte[] byArray = new byte[this.dataLen];
            System.arraycopy(this.data, 0, byArray, 0, this.dataLen);
            this.data = byArray;
        }
        return this.data;
    }

    public InputStream getInputStream() throws IOException {
        if (this.dataHandler != null) {
            return this.dataHandler.getInputStream();
        }
        return new ByteArrayInputStream(this.data, 0, this.dataLen);
    }

    public boolean hasData() {
        return this.data != null;
    }

    public byte[] get() {
        if (this.data == null) {
            try {
                ByteArrayOutputStreamEx byteArrayOutputStreamEx = new ByteArrayOutputStreamEx(1024);
                InputStream inputStream = this.dataHandler.getDataSource().getInputStream();
                byteArrayOutputStreamEx.readFrom(inputStream);
                inputStream.close();
                this.data = byteArrayOutputStreamEx.getBuffer();
                this.dataLen = byteArrayOutputStreamEx.size();
                this.dataCloneByRef = true;
            }
            catch (IOException iOException) {
                this.dataLen = 0;
            }
        }
        return this.data;
    }

    public int getDataLen() {
        this.get();
        return this.dataLen;
    }

    public String getMimeType() {
        if (this.mimeType == null) {
            return "application/octet-stream";
        }
        return this.mimeType;
    }

    public int length() {
        this.get();
        return (this.dataLen + 2) / 3 * 4;
    }

    public char charAt(int n) {
        int n2 = n % 4;
        int n3 = n / 4 * 3;
        switch (n2) {
            case 0: {
                return Base64Encoder.encode(this.data[n3] >> 2);
            }
            case 1: {
                byte by = n3 + 1 < this.dataLen ? this.data[n3 + 1] : (byte)0;
                return Base64Encoder.encode((this.data[n3] & 3) << 4 | by >> 4 & 0xF);
            }
            case 2: {
                if (n3 + 1 < this.dataLen) {
                    byte by = this.data[n3 + 1];
                    byte by2 = n3 + 2 < this.dataLen ? this.data[n3 + 2] : (byte)0;
                    return Base64Encoder.encode((by & 0xF) << 2 | by2 >> 6 & 3);
                }
                return '=';
            }
            case 3: {
                if (n3 + 2 < this.dataLen) {
                    return Base64Encoder.encode(this.data[n3 + 2] & 0x3F);
                }
                return '=';
            }
        }
        throw new IllegalStateException();
    }

    public CharSequence subSequence(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.get();
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(this.charAt(i));
        }
        return stringBuilder;
    }

    public String toString() {
        this.get();
        return Base64Encoder.print(this.data, 0, this.dataLen);
    }

    public void writeTo(char[] cArray, int n) {
        this.get();
        Base64Encoder.print(this.data, 0, this.dataLen, cArray, n);
    }

    public Base64Data clone() {
        return new Base64Data(this);
    }
}

