/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.binding;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.binding.HTTPBindingImpl;
import com.sun.xml.internal.ws.binding.SOAPBindingImpl;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.client.HandlerConfiguration;
import com.sun.xml.internal.ws.developer.BindingTypeFeature;
import com.sun.xml.internal.ws.developer.MemberSubmissionAddressingFeature;
import java.util.Collections;
import java.util.List;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.AddressingFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindingImpl
implements WSBinding {
    private HandlerConfiguration handlerConfig;
    private final BindingID bindingId;
    protected final WebServiceFeatureList features = new WebServiceFeatureList();

    protected BindingImpl(BindingID bindingID) {
        this.bindingId = bindingID;
        this.setHandlerConfig(this.createHandlerConfig(Collections.<Handler>emptyList()));
    }

    @Override
    @NotNull
    public List<Handler> getHandlerChain() {
        return this.handlerConfig.getHandlerChain();
    }

    public HandlerConfiguration getHandlerConfig() {
        return this.handlerConfig;
    }

    @Override
    public void setHandlerChain(List<Handler> list) {
        this.setHandlerConfig(this.createHandlerConfig(list));
    }

    protected void setHandlerConfig(HandlerConfiguration handlerConfiguration) {
        this.handlerConfig = handlerConfiguration;
    }

    protected abstract HandlerConfiguration createHandlerConfig(List<Handler> var1);

    @Override
    @NotNull
    public BindingID getBindingId() {
        return this.bindingId;
    }

    @Override
    public final SOAPVersion getSOAPVersion() {
        return this.bindingId.getSOAPVersion();
    }

    @Override
    public AddressingVersion getAddressingVersion() {
        AddressingVersion addressingVersion = this.features.isEnabled(AddressingFeature.class) ? AddressingVersion.W3C : (this.features.isEnabled(MemberSubmissionAddressingFeature.class) ? AddressingVersion.MEMBER : null);
        return addressingVersion;
    }

    @NotNull
    public final Codec createCodec() {
        return this.bindingId.createEncoder(this);
    }

    public static BindingImpl create(@NotNull BindingID bindingID) {
        if (bindingID.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingID);
    }

    public static BindingImpl create(@NotNull BindingID bindingID, WebServiceFeature[] webServiceFeatureArray) {
        for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
            if (!(webServiceFeature instanceof BindingTypeFeature)) continue;
            BindingTypeFeature bindingTypeFeature = (BindingTypeFeature)webServiceFeature;
            bindingID = BindingID.parse(bindingTypeFeature.getBindingId());
        }
        if (bindingID.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingID, webServiceFeatureArray);
    }

    public static WSBinding getDefaultBinding() {
        return new SOAPBindingImpl(BindingID.SOAP11_HTTP);
    }

    @Override
    public String getBindingID() {
        return this.bindingId.toString();
    }

    @Override
    @Nullable
    public <F extends WebServiceFeature> F getFeature(@NotNull Class<F> clazz) {
        return this.features.get(clazz);
    }

    @Override
    public boolean isFeatureEnabled(@NotNull Class<? extends WebServiceFeature> clazz) {
        return this.features.isEnabled(clazz);
    }

    @Override
    @NotNull
    public WebServiceFeatureList getFeatures() {
        return this.features;
    }

    public void setFeatures(WebServiceFeature ... webServiceFeatureArray) {
        if (webServiceFeatureArray != null) {
            for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
                this.features.add(webServiceFeature);
            }
        }
    }

    public void addFeature(@NotNull WebServiceFeature webServiceFeature) {
        this.features.add(webServiceFeature);
    }
}

