/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.protocol.soap;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.message.DOMHeader;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MUTube
extends AbstractFilterTubeImpl {
    private static final String MU_FAULT_DETAIL_LOCALPART = "NotUnderstood";
    private static final QName MU_HEADER_DETAIL = new QName(SOAPVersion.SOAP_12.nsUri, "NotUnderstood");
    protected static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.soap.decoder");
    private static final String MUST_UNDERSTAND_FAULT_MESSAGE_STRING = "One or more mandatory SOAP header blocks not understood";
    protected final SOAPVersion soapVersion;
    private final AddressingVersion addressingVersion;

    protected MUTube(WSBinding wSBinding, Tube tube) {
        super(tube);
        if (!(wSBinding instanceof SOAPBinding)) {
            throw new WebServiceException("MUPipe should n't be used for bindings other than SOAP.");
        }
        this.soapVersion = wSBinding.getSOAPVersion();
        this.addressingVersion = wSBinding.getAddressingVersion();
    }

    protected MUTube(MUTube mUTube, TubeCloner tubeCloner) {
        super(mUTube, tubeCloner);
        this.soapVersion = mUTube.soapVersion;
        this.addressingVersion = mUTube.addressingVersion;
    }

    protected final Set<QName> getMisUnderstoodHeaders(HeaderList headerList, Set<String> set, Set<QName> set2) {
        HashSet<QName> hashSet = null;
        this.understandAddressingHeaders(set2);
        for (int i = 0; i < headerList.size(); ++i) {
            QName qName;
            Header header;
            if (headerList.isUnderstood(i) || (header = headerList.get(i)).isIgnorable(this.soapVersion, set) || set2.contains(qName = new QName(header.getNamespaceURI(), header.getLocalPart()))) continue;
            logger.info("Element not understood=" + qName);
            if (hashSet == null) {
                hashSet = new HashSet<QName>();
            }
            hashSet.add(qName);
        }
        return hashSet;
    }

    private void understandAddressingHeaders(Set<QName> set) {
        if (this.addressingVersion != null) {
            set.add(this.addressingVersion.actionTag);
            set.add(this.addressingVersion.faultToTag);
            set.add(this.addressingVersion.fromTag);
            set.add(this.addressingVersion.messageIDTag);
            set.add(this.addressingVersion.relatesToTag);
            set.add(this.addressingVersion.replyToTag);
            set.add(this.addressingVersion.toTag);
        }
    }

    final SOAPFaultException createMUSOAPFaultException(Set<QName> set) {
        try {
            SOAPFault sOAPFault = this.createMUSOAPFault();
            this.setMUFaultString(sOAPFault, set);
            return new SOAPFaultException(sOAPFault);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    final Message createMUSOAPFaultMessage(Set<QName> set) {
        try {
            SOAPFault sOAPFault = this.createMUSOAPFault();
            if (this.soapVersion == SOAPVersion.SOAP_11) {
                this.setMUFaultString(sOAPFault, set);
            }
            Message message = Messages.create(sOAPFault);
            if (this.soapVersion == SOAPVersion.SOAP_12) {
                MUTube.addHeader(message, set);
            }
            return message;
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    private void setMUFaultString(SOAPFault sOAPFault, Set<QName> set) throws SOAPException {
        sOAPFault.setFaultString("MustUnderstand headers:" + set + " are not understood");
    }

    private static void addHeader(Message message, Set<QName> set) throws SOAPException {
        for (QName qName : set) {
            SOAPElement sOAPElement = SOAPVersion.SOAP_12.saajSoapFactory.createElement(MU_HEADER_DETAIL);
            sOAPElement.addNamespaceDeclaration("abc", qName.getNamespaceURI());
            sOAPElement.setAttribute("qname", "abc:" + qName.getLocalPart());
            DOMHeader<SOAPElement> dOMHeader = new DOMHeader<SOAPElement>(sOAPElement);
            message.getHeaders().add(dOMHeader);
        }
    }

    private SOAPFault createMUSOAPFault() throws SOAPException {
        return this.soapVersion.saajSoapFactory.createFault(MUST_UNDERSTAND_FAULT_MESSAGE_STRING, this.soapVersion.faultCodeMustUnderstand);
    }
}

