/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.Functions;

final class TemplateManager {
    private static final boolean DEBUG = false;
    static final String O_ANY = "*";
    static final String O_IMPORT = "import";
    static final String O_GENERATE = "generate";
    private final List<KeyAndTemplate> primitiveTemplates = new ArrayList<KeyAndTemplate>();
    private final Map<TemplateKey, Template> compositeTemplates = new ConcurrentHashMap<TemplateKey, Template>();

    TemplateManager() {
    }

    void addTemplate(String string, long l, long l2, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        TemplateKey templateKey = new TemplateKey(string, l, l2);
        Template template = new Template(cK_ATTRIBUTEArray);
        this.primitiveTemplates.add(new KeyAndTemplate(templateKey, template));
    }

    private Template getTemplate(TemplateKey templateKey) {
        Template template = this.compositeTemplates.get(templateKey);
        if (template == null) {
            template = this.buildCompositeTemplate(templateKey);
            this.compositeTemplates.put(templateKey, template);
        }
        return template;
    }

    CK_ATTRIBUTE[] getAttributes(String string, long l, long l2, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        TemplateKey templateKey = new TemplateKey(string, l, l2);
        Template template = this.getTemplate(templateKey);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = template.getAttributes(cK_ATTRIBUTEArray);
        return cK_ATTRIBUTEArray2;
    }

    private Template buildCompositeTemplate(TemplateKey templateKey) {
        Template template = new Template();
        for (KeyAndTemplate keyAndTemplate : this.primitiveTemplates) {
            if (!keyAndTemplate.key.appliesTo(templateKey)) continue;
            template.add(keyAndTemplate.template);
        }
        return template;
    }

    private static final class Template {
        private static final CK_ATTRIBUTE[] A0 = new CK_ATTRIBUTE[0];
        private CK_ATTRIBUTE[] attributes;

        Template() {
            this.attributes = A0;
        }

        Template(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
            this.attributes = cK_ATTRIBUTEArray;
        }

        void add(Template template) {
            this.attributes = this.getAttributes(template.attributes);
        }

        CK_ATTRIBUTE[] getAttributes(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
            return Template.combine(this.attributes, cK_ATTRIBUTEArray);
        }

        private static CK_ATTRIBUTE[] combine(CK_ATTRIBUTE[] cK_ATTRIBUTEArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray2) {
            ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
            for (CK_ATTRIBUTE cK_ATTRIBUTE : cK_ATTRIBUTEArray) {
                if (cK_ATTRIBUTE.pValue == null) continue;
                arrayList.add(cK_ATTRIBUTE);
            }
            for (CK_ATTRIBUTE cK_ATTRIBUTE : cK_ATTRIBUTEArray2) {
                long l = cK_ATTRIBUTE.type;
                for (CK_ATTRIBUTE cK_ATTRIBUTE2 : cK_ATTRIBUTEArray) {
                    if (cK_ATTRIBUTE2.type != l) continue;
                    arrayList.remove(cK_ATTRIBUTE2);
                }
                if (cK_ATTRIBUTE.pValue == null) continue;
                arrayList.add(cK_ATTRIBUTE);
            }
            return arrayList.toArray(A0);
        }

        public String toString() {
            return Arrays.asList(this.attributes).toString();
        }
    }

    private static final class TemplateKey {
        final String operation;
        final long keyType;
        final long keyAlgorithm;

        TemplateKey(String string, long l, long l2) {
            this.operation = string;
            this.keyType = l;
            this.keyAlgorithm = l2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof TemplateKey)) {
                return false;
            }
            TemplateKey templateKey = (TemplateKey)object;
            boolean bl = this.operation.equals(templateKey.operation) && this.keyType == templateKey.keyType && this.keyAlgorithm == templateKey.keyAlgorithm;
            return bl;
        }

        public int hashCode() {
            return this.operation.hashCode() + (int)this.keyType + (int)this.keyAlgorithm;
        }

        boolean appliesTo(TemplateKey templateKey) {
            return !(!this.operation.equals(TemplateManager.O_ANY) && !this.operation.equals(templateKey.operation) || this.keyType != 2147483427L && this.keyType != templateKey.keyType || this.keyAlgorithm != 0x7FFFFF22L && this.keyAlgorithm != templateKey.keyAlgorithm);
        }

        public String toString() {
            return "(" + this.operation + "," + Functions.getObjectClassName(this.keyType) + "," + Functions.getKeyName(this.keyAlgorithm) + ")";
        }
    }

    private static class KeyAndTemplate {
        final TemplateKey key;
        final Template template;

        KeyAndTemplate(TemplateKey templateKey, Template template) {
            this.key = templateKey;
            this.template = template;
        }
    }
}

