/*
  JSmooth: a VM wrapper toolkit for Windows
  Copyright (C) 2003 Rodrigo Reyes <reyes@charabia.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

package net.charabia.jsmoothgen.application.gui.util;

import net.charabia.jsmoothgen.application.*;
import java.util.*;

/**
 *
 * @author  Rodrigo
 */
public class CompilationDialog extends javax.swing.JDialog implements ExeCompiler.StepListener
{
	private ExeCompiler m_compiler;
	private boolean m_result = false;
	private boolean m_canceled = false;
	
	/** Creates new form CompilationDialog */
	public CompilationDialog(java.awt.Frame parent, boolean modal)
	{
		super(parent, modal);
		initComponents();
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        m_progress = new javax.swing.JProgressBar();
        jScrollPane1 = new javax.swing.JScrollPane();
        m_state = new javax.swing.JTextArea(10,60);
	m_state.setLineWrap(true);
        m_cancelbutton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setText("Progress");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 20);
        getContentPane().add(m_progress, gridBagConstraints);

	//        jScrollPane1.setBorder(new javax.swing.border.TitledBorder("Compilation Information"));
	//        m_state.setBackground((java.awt.Color) javax.swing.UIManager.getDefaults().get("Button.background"));
	//        m_state.setBorder(null);
        m_state.setEditable(false);
        jScrollPane1.setViewportView(m_state);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 10);
        getContentPane().add(jScrollPane1, gridBagConstraints);

        m_cancelbutton.setText("Cancel");
        m_cancelbutton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelbuttonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        gridBagConstraints.weighty = 0.0001;
        gridBagConstraints.fill = java.awt.GridBagConstraints.NONE;
        getContentPane().add(m_cancelbutton, gridBagConstraints);

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-319)/2, (screenSize.height-158)/2, 319, 158);
    }//GEN-END:initComponents

	private void cancelbuttonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_cancelbuttonActionPerformed
	{//GEN-HEADEREND:event_cancelbuttonActionPerformed
		// Add your handling code here:
		m_result = false;
		m_canceled = true;
		dispose();
	}//GEN-LAST:event_cancelbuttonActionPerformed
	
	/** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
	{
		setVisible(false);
		dispose();
	}//GEN-LAST:event_closeDialog
	
	public void setCompiler(ExeCompiler comp)
	{
		m_compiler = comp;
		comp.addListener(this);
		m_progress.setMaximum(100);
		m_progress.setMinimum(0);
		m_state.setText("");
	}
	
	public void compile(Runnable r)
	{
		Thread t = new Thread(r);
		t.start();
		setModal(true);
		setVisible(true);
	}
	
	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[])
	{
		new CompilationDialog(new javax.swing.JFrame(), true).setVisible(true);
	}
	
	public void complete()
	{
		if (!m_canceled)
		{
			m_result = true;
			setNewState(100, "Done");
			m_cancelbutton.setText("Done");			
			m_cancelbutton.grabFocus();
		}
	}	
	
	public void failed()
	{
		if (!m_canceled)
		{
			m_result = false;
			StringBuffer buf = new StringBuffer();
			buf.append("Compilation failed!\n");
			Vector v = m_compiler.getErrors();
			for (int i=0; i<v.size(); i++)
			{
				buf.append("\n- ");
				buf.append(v.get(i).toString());
			}
			buf.append("\n");
			setNewState(100, buf.toString());
		}
	}
	
	public void setNewState(int percentComplete, String state)
	{
		m_progress.setValue(percentComplete);
		m_state.append(state+"\n");
	}
	
	public boolean getResult()
	{
		return m_result;
	}
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton m_cancelbutton;
    private javax.swing.JProgressBar m_progress;
    private javax.swing.JTextArea m_state;
    // End of variables declaration//GEN-END:variables
	
}
