/*
 * SkeletonPropertyEditor.java
 *
 * Created on 14 aot 2003, 00:47
 */

package net.charabia.jsmoothgen.skeleton;

import javax.swing.table.*;
import javax.swing.*;
import java.util.*;
import java.awt.*;

/**
 *
 * @author  Rodrigo
 */
public class SkeletonPropertyEditor extends javax.swing.JPanel
{
	private SkeletonPropertyEditor.SkelPropTableModel m_model;
	private java.util.Vector m_columnNames = new Vector();
	
	
	public static class SkelPropTableModel extends AbstractTableModel
	{
		Vector m_props = new Vector();
		
		public SkelPropTableModel(SkeletonProperty[] props)
		{
			for (int i=0; i<props.length; i++)
			{
				m_props.add(props[i]);
			}
		}
		
		public SkelPropTableModel()
		{
			m_props.add(new SkeletonProperty());
		}
		
		public void add(SkeletonProperty prop)
		{
			m_props.addElement(prop);
			fireTableRowsInserted(m_props.size()-1, m_props.size());
			fireTableStructureChanged();
		}
		
		public void add(SkeletonProperty prop, int row)
		{
			m_props.insertElementAt(prop, row);
			fireTableRowsInserted(row, row);
			fireTableStructureChanged();
		}
		
		public void removeRow(int row)
		{
			m_props.removeElementAt(row);
			fireTableRowsDeleted(row, row);
		}
		
		public Class getColumnClass(int columnIndex)
		{
			return Object.class;
		}
		
		public String getColumnName(int column)
		{
			return "TEST";
		}
		
		public int getColumnCount()
		{
			return 5;
		}
		
		public int getRowCount()
		{
			return m_props.size();
		}
		
		public boolean isCellEditable(int rowIndex, int columnIndex)
		{
			return true;
		}
		
		public Object getValueAt(int rowIndex, int columnIndex)
		{
			SkeletonProperty sp = (SkeletonProperty)m_props.get(rowIndex);
			switch(columnIndex)
			{
				case 0:
					return sp.getIdName();
				case 1:
					return sp.getLabel();
				case 2:
					return sp.getDescription();
				case 3:
					return sp.getType();
				case 4:
					return sp.getValue();
				default:
					return "";
			}
		}
		
		public void setValueAt(Object aValue, int rowIndex, int columnIndex)
		{
			SkeletonProperty sp = (SkeletonProperty)m_props.get(rowIndex);
			switch(columnIndex)
			{
				case 0:
					sp.setIdName(aValue.toString());
					break;
				case 1:
					sp.setLabel(aValue.toString());
					break;
				case 2:
					sp.setDescription(aValue.toString());
					break;
				case 3:
					sp.setType(aValue.toString());
					break;
				case 4:
					sp.setValue(aValue.toString());
					break;
			}
		}
		
	}
	
	public String getColumnName(int columnIndex)
	{
		switch(columnIndex)
		{
			case 0:
				return "Id";
			case 1:
				return "Label";
			case 2:
				return "Description";
			case 3:
				return "Type";
			case 4:
				return "Value";
			default:
				return "pouet";
		}
	}
	
	/** Creates new form BeanForm */
	public SkeletonPropertyEditor()
	{
		m_model = new SkeletonPropertyEditor.SkelPropTableModel();
		initComponents();
		m_table.setModel(m_model);
	}
	
	
	public void setModel(SkeletonProperty[] sprops)
	{
		if (sprops == null)
			sprops = new SkeletonProperty[0];
		
		SkeletonPropertyEditor.SkelPropTableModel model = new SkeletonPropertyEditor.SkelPropTableModel(sprops);
		m_table.setModel(model);
		m_model = model;
		m_table.createDefaultColumnsFromModel() ;
		
		// model.addColumn("DescriptiveString");
		// model.addColumn("DescriptiveString");
		// model.addColumn("DescriptiveString");
		// model.addColumn("DescriptiveString");
		// model.addColumn("DescriptiveString");
		
		TableColumn type = m_table.getColumnModel().getColumn(3);
		type.setHeaderValue("POUET");
		JComboBox typeCombo = new JComboBox();
		typeCombo.addItem(SkeletonProperty.TYPE_STRING);
		typeCombo.addItem(SkeletonProperty.TYPE_TEXTAREA);
		typeCombo.addItem(SkeletonProperty.TYPE_BOOLEAN);
		type.setCellEditor(new DefaultCellEditor(typeCombo));
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	private void initComponents()//GEN-BEGIN:initComponents
	{
		m_popupMenu = new javax.swing.JPopupMenu();
		m_menuAddItem = new javax.swing.JMenuItem();
		m_menuRemoveItem = new javax.swing.JMenuItem();
		jScrollPane1 = new javax.swing.JScrollPane();
		m_table = new javax.swing.JTable();
		
		m_menuAddItem.setText("Add item");
		m_menuAddItem.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				m_menuAddItemActionPerformed(evt);
			}
		});
		
		m_popupMenu.add(m_menuAddItem);
		
		m_menuRemoveItem.setText("RemoveItems");
		m_menuRemoveItem.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				m_menuRemoveItemActionPerformed(evt);
			}
		});
		
		m_popupMenu.add(m_menuRemoveItem);
		
		
		setLayout(new java.awt.BorderLayout());
		
		jScrollPane1.setBorder(null);
		m_table.setModel(new javax.swing.table.DefaultTableModel(
		new Object [][]
		{
			{null, null, null, null},
			{null, null, null, null},
			{null, null, null, null},
			{null, null, null, null}
		},
		new String []
		{
			"Title 1", "Title 2", "Title 3", "Title 4"
		}
		));
		m_table.setTableHeader(null);
		m_table.addMouseListener(new java.awt.event.MouseAdapter()
		{
			public void mouseClicked(java.awt.event.MouseEvent evt)
			{
				tableMousePressed(evt);
			}
			public void mousePressed(java.awt.event.MouseEvent evt)
			{
				tableMousePressed(evt);
			}
			public void mouseReleased(java.awt.event.MouseEvent evt)
			{
				tableMousePressed(evt);
			}
		});
		
		jScrollPane1.setViewportView(m_table);
		
		add(jScrollPane1, java.awt.BorderLayout.CENTER);
		
	}//GEN-END:initComponents
	
	private void m_menuRemoveItemActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_m_menuRemoveItemActionPerformed
	{//GEN-HEADEREND:event_m_menuRemoveItemActionPerformed
		// Add your handling code here:
		int selr = m_table.getSelectedRow();
		if (selr != -1)
		{
			m_model.removeRow(selr);
		}
	}//GEN-LAST:event_m_menuRemoveItemActionPerformed
	
	private void m_menuAddItemActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_m_menuAddItemActionPerformed
	{//GEN-HEADEREND:event_m_menuAddItemActionPerformed
		// Add your handling code here:
		SkeletonProperty prop = new SkeletonProperty();
		int selr = m_table.getSelectedRow();
		if (selr >= 0)
			m_model.add(prop, selr);
		else
			m_model.add(prop);
	}//GEN-LAST:event_m_menuAddItemActionPerformed
	
	private void tableMousePressed(java.awt.event.MouseEvent evt)//GEN-FIRST:event_tableMousePressed
	{//GEN-HEADEREND:event_tableMousePressed
		System.out.println("pressed !");
		// Add your handling code here:
		if (evt.isPopupTrigger())
		{
			System.out.println("trigger !");
			showPopupMenu(evt);
		}
	}//GEN-LAST:event_tableMousePressed
	
	public void showPopupMenu(java.awt.event.MouseEvent evt)
	{
		int r = m_table.rowAtPoint(new Point(evt.getX(), evt.getY()));
		if (r != -1)
		{
			m_table.setRowSelectionInterval(r,r);
		}
		m_popupMenu.show(this, evt.getX(), evt.getY());
	}
	
	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JScrollPane jScrollPane1;
	private javax.swing.JMenuItem m_menuAddItem;
	private javax.swing.JMenuItem m_menuRemoveItem;
	private javax.swing.JPopupMenu m_popupMenu;
	private javax.swing.JTable m_table;
	// End of variables declaration//GEN-END:variables
	
}
