/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IDelayedLabelDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

public class DecoratingLabelProvider
extends LabelProvider
implements ILabelProvider,
IViewerLabelProvider {
    private ILabelProvider provider;
    private ILabelDecorator decorator;
    private ListenerList listeners = new ListenerList();

    public DecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
        Assert.isNotNull(provider);
        this.provider = provider;
        this.decorator = decorator;
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.provider.addListener(listener);
        if (this.decorator != null) {
            this.decorator.addListener(listener);
        }
        this.listeners.add(listener);
    }

    public void dispose() {
        this.provider.dispose();
        if (this.decorator != null) {
            this.decorator.dispose();
        }
    }

    public Image getImage(Object element) {
        Image decorated;
        Image image = this.provider.getImage(element);
        if (this.decorator != null && (decorated = this.decorator.decorateImage(image, element)) != null) {
            return decorated;
        }
        return image;
    }

    public ILabelDecorator getLabelDecorator() {
        return this.decorator;
    }

    public ILabelProvider getLabelProvider() {
        return this.provider;
    }

    public String getText(Object element) {
        String decorated;
        String text = this.provider.getText(element);
        if (this.decorator != null && (decorated = this.decorator.decorateText(text, element)) != null) {
            return decorated;
        }
        return text;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (this.provider.isLabelProperty(element, property)) {
            return true;
        }
        return this.decorator != null && this.decorator.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.provider.removeListener(listener);
        if (this.decorator != null) {
            this.decorator.removeListener(listener);
        }
        this.listeners.remove(listener);
    }

    public void setLabelDecorator(ILabelDecorator decorator) {
        ILabelDecorator oldDecorator = this.decorator;
        if (oldDecorator != decorator) {
            int i;
            Object[] listenerList = this.listeners.getListeners();
            if (oldDecorator != null) {
                i = 0;
                while (i < listenerList.length) {
                    oldDecorator.removeListener((ILabelProviderListener)listenerList[i]);
                    ++i;
                }
            }
            this.decorator = decorator;
            if (decorator != null) {
                i = 0;
                while (i < listenerList.length) {
                    decorator.addListener((ILabelProviderListener)listenerList[i]);
                    ++i;
                }
            }
            this.fireLabelProviderChanged(new LabelProviderChangedEvent(this));
        }
    }

    private boolean equals(Image oldImage, Image newImage) {
        return oldImage == null && newImage == null || oldImage != null && newImage != null && oldImage.equals((Object)newImage);
    }

    public void updateLabel(ViewerLabel settings, Object element) {
        IDelayedLabelDecorator delayedDecorator;
        ILabelDecorator currentDecorator = this.getLabelDecorator();
        String oldText = settings.getText();
        boolean decorationReady = true;
        if (currentDecorator instanceof IDelayedLabelDecorator && !(delayedDecorator = (IDelayedLabelDecorator)currentDecorator).prepareDecoration(element, oldText)) {
            decorationReady = false;
        }
        if (decorationReady || oldText == null || settings.getText().length() == 0) {
            settings.setText(this.getText(element));
        }
        Image oldImage = settings.getImage();
        if (decorationReady || oldImage == null) {
            settings.setImage(this.getImage(element));
        }
    }
}

