/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.Hashtable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;

public class ImageSegment
extends ParagraphSegment {
    public static final int TOP = 1;
    public static final int MIDDLE = 2;
    public static final int BOTTOM = 3;
    private int alignment = 3;
    private String imageId;

    public int getVerticalAlignment() {
        return this.alignment;
    }

    void setVerticalAlignment(int alignment) {
        this.alignment = alignment;
    }

    public Image getImage(Hashtable objectTable) {
        if (this.imageId == null) {
            return null;
        }
        Object obj = objectTable.get(this.imageId);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Image) {
            return (Image)obj;
        }
        return null;
    }

    public String getObjectId() {
        return this.imageId;
    }

    void setObjectId(String imageId) {
        this.imageId = imageId;
    }

    public boolean advanceLocator(GC gc, int wHint, Locator loc, Hashtable objectTable, boolean computeHeightOnly) {
        Image image = this.getImage(objectTable);
        int iwidth = 0;
        int iheight = 0;
        boolean newLine = false;
        if (image != null) {
            Rectangle rect = image.getBounds();
            iwidth = rect.width;
            iheight = rect.height;
        }
        if (wHint != -1 && loc.x + iwidth > wHint) {
            loc.width = loc.x = loc.indent + iwidth;
            loc.y += loc.rowHeight;
            if (computeHeightOnly) {
                loc.collectHeights(true);
            }
            loc.rowHeight = iheight;
            loc.leading = 0;
            newLine = true;
        } else {
            loc.x += iwidth;
            loc.rowHeight = Math.max(loc.rowHeight, iheight);
        }
        return newLine;
    }

    public void paint(GC gc, int width, Locator loc, Hashtable resourceTable, boolean selected) {
        Image image = this.getImage(resourceTable);
        int iwidth = 0;
        int iheight = 0;
        if (image == null) {
            return;
        }
        Rectangle rect = image.getBounds();
        iwidth = rect.width;
        iheight = rect.height;
        loc.width = iwidth;
        loc.height = iheight;
        if (loc.x + iwidth > width) {
            loc.x = loc.indent + loc.marginWidth;
            loc.y += loc.rowHeight;
            loc.rowHeight = 0;
            ++loc.rowCounter;
        }
        int ix = loc.x;
        int iy = loc.getBaseline(iheight, false);
        gc.drawImage(image, ix, iy);
        loc.x += iwidth;
        loc.rowHeight = Math.max(loc.rowHeight, iheight);
    }
}

