/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

public class ListenerList {
    private static final Object[] EmptyArray = new Object[0];
    private volatile Object[] listeners = EmptyArray;

    public synchronized void add(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.length;
        int i = 0;
        while (i < oldSize) {
            if (listener.equals(this.listeners[i])) {
                return;
            }
            ++i;
        }
        Object[] newListeners = new Object[oldSize + 1];
        System.arraycopy(this.listeners, 0, newListeners, 0, oldSize);
        newListeners[oldSize] = listener;
        this.listeners = newListeners;
    }

    public Object[] getListeners() {
        return this.listeners;
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public synchronized void remove(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.length;
        int i = 0;
        while (i < oldSize) {
            if (listener.equals(this.listeners[i])) {
                if (oldSize == 1) {
                    this.listeners = EmptyArray;
                } else {
                    Object[] newListeners = new Object[oldSize - 1];
                    System.arraycopy(this.listeners, 0, newListeners, 0, i);
                    System.arraycopy(this.listeners, i + 1, newListeners, i, oldSize - i - 1);
                    this.listeners = newListeners;
                }
                return;
            }
            ++i;
        }
    }

    public int size() {
        return this.listeners.length;
    }
}

