/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.swtgui;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.charabia.jsmoothgen.application.ExeCompiler;
import net.charabia.jsmoothgen.application.JSmoothModelBean;
import net.charabia.jsmoothgen.application.JSmoothModelPersistency;
import net.charabia.jsmoothgen.application.JavaPropertyPair;
import net.charabia.jsmoothgen.application.swtgui.ClearConsoleAction;
import net.charabia.jsmoothgen.application.swtgui.CompileAction;
import net.charabia.jsmoothgen.application.swtgui.ExecutablePage;
import net.charabia.jsmoothgen.application.swtgui.ExitAction;
import net.charabia.jsmoothgen.application.swtgui.JSmoothAction;
import net.charabia.jsmoothgen.application.swtgui.JSmoothPage;
import net.charabia.jsmoothgen.application.swtgui.JVMOptionsPage;
import net.charabia.jsmoothgen.application.swtgui.JavaAppPage;
import net.charabia.jsmoothgen.application.swtgui.NewAction;
import net.charabia.jsmoothgen.application.swtgui.OpenAction;
import net.charabia.jsmoothgen.application.swtgui.RunexeAction;
import net.charabia.jsmoothgen.application.swtgui.SaveAsProjectAction;
import net.charabia.jsmoothgen.application.swtgui.SaveProjectAction;
import net.charabia.jsmoothgen.application.swtgui.SkeletonPage;
import net.charabia.jsmoothgen.application.swtgui.WelcomePage;
import net.charabia.jsmoothgen.application.swtgui.resources.JSmoothResources;
import net.charabia.jsmoothgen.skeleton.SkeletonBean;
import net.charabia.jsmoothgen.skeleton.SkeletonList;
import net.charabia.jsmoothgen.skeleton.SkeletonProperty;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class JSmoothApplication {
    public final JSmoothAction ACTION_OPEN = new OpenAction(this);
    public final JSmoothAction ACTION_EXIT = new ExitAction(this);
    public final JSmoothAction ACTION_SAVE = new SaveProjectAction(this);
    public final JSmoothAction ACTION_SAVE_AS = new SaveAsProjectAction(this);
    public final JSmoothAction ACTION_NEW = new NewAction(this);
    public final JSmoothAction ACTION_COMPILE = new CompileAction(this);
    public final JSmoothAction ACTION_RUNEXE = new RunexeAction(this);
    public final JSmoothAction ACTION_CONSOLE_CLEAR = new ClearConsoleAction(this);
    private Shell shell;
    private Display display;
    private Label menusep;
    private Label switchersep;
    private StackLayout stack;
    public final JSmoothPage PAGE_SKELETON = new SkeletonPage(this);
    public final JSmoothPage PAGE_EXECUTABLE = new ExecutablePage(this);
    public final JSmoothPage PAGE_WELCOME = new WelcomePage(this);
    public final JSmoothPage PAGE_APPLICATION = new JavaAppPage(this);
    public final JSmoothPage PAGE_JVM_OPTIONS = new JVMOptionsPage(this);
    public final JSmoothPage[] PAGES = new JSmoothPage[]{this.PAGE_WELCOME, this.PAGE_SKELETON, this.PAGE_APPLICATION, this.PAGE_JVM_OPTIONS, this.PAGE_EXECUTABLE};
    private Composite pagearea;
    private Menu mainmenu;
    private ToolBar switcher;
    private Composite consolearea;
    private Text console;
    private static final int DIM_CONSOLE_HEIGHT = 150;
    private boolean dirty = false;
    private JSmoothModelBean jsmodel;
    private File projectfile;
    private ExeCompiler compiler;
    private SkeletonList skeletonList;
    private List skeletonNames;

    public JSmoothApplication(Display display) {
        this.display = display;
        JSmoothResources jSmoothResources = new JSmoothResources(this.display);
        this.skeletonList = new SkeletonList(new File("skeletons"));
    }

    public void newProject() {
        this.jsmodel = new JSmoothModelBean();
        this.jsmodel.setSkeletonName(this.getInitialSkeletonName());
        this.setSkeletonProperties(this.getInititalSkeletonProperties());
        this.jsmodel.setExecutableName("");
        this.jsmodel.setArguments("");
        this.jsmodel.setBundledJVMPath("");
        this.jsmodel.setClassPath(new String[0]);
        this.jsmodel.setCurrentDirectory("");
        this.jsmodel.setIconLocation("");
        this.jsmodel.setJarLocation("");
        this.jsmodel.setJavaProperties(new JavaPropertyPair[0]);
        this.jsmodel.setJVMSearchPath(new String[0]);
        this.jsmodel.setMainClassName("");
        this.jsmodel.setMaximumVersion("");
        this.jsmodel.setMinimumVersion("");
        this.jsmodel.setNoJvmMessage("");
        this.jsmodel.setNoJvmURL("");
        this.projectfile = null;
        this.compiler = new ExeCompiler();
        this.compiler.addListener(new SWTCompileListener());
        for (int i = 0; i < this.PAGES.length; ++i) {
            this.PAGES[i].load();
        }
        this.getShell().setText(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectfile == null) {
            return "";
        }
        return this.projectfile.getName();
    }

    public void setSkeletonProperty(SkeletonProperty property) {
        System.out.println("[DEBUG] Setting property \"" + property.getIdName() + "\" to value \"" + property.getValue() + "\"");
        JSmoothModelBean.Property[] modelProps = this.jsmodel.getSkeletonProperties();
        for (int i = 0; i < modelProps.length; ++i) {
            if (!property.getIdName().equals(modelProps[i].Key)) continue;
            modelProps[i].setValue(property.getValue());
        }
    }

    public void setSkeletonProperties(SkeletonProperty[] props) {
        JSmoothModelBean.Property[] modelProps = new JSmoothModelBean.Property[props.length];
        String sysoutProps = "";
        for (int i = 0; i < props.length; ++i) {
            modelProps[i] = new JSmoothModelBean.Property();
            System.out.println("[DEBUG] Setting property \"" + props[i].getIdName() + "\" to value \"" + props[i].getValue() + "\"");
            modelProps[i].Key = props[i].getIdName();
            modelProps[i].setValue(props[i].getValue());
        }
        this.jsmodel.setSkeletonProperties(modelProps);
    }

    public SkeletonProperty[] getInititalSkeletonProperties() {
        SkeletonBean skeleton = this.skeletonList.getSkeleton(this.jsmodel.getSkeletonName());
        return skeleton.getSkeletonProperties();
    }

    public SkeletonProperty[] getSkeletonProperties() {
        SkeletonBean skeleton = this.skeletonList.getSkeleton(this.jsmodel.getSkeletonName());
        SkeletonProperty[] skeletonProps = skeleton.getSkeletonProperties();
        JSmoothModelBean.Property[] modelProps = this.jsmodel.getSkeletonProperties();
        for (int i = 0; i < skeletonProps.length; ++i) {
            if (!skeletonProps[i].getIdName().equals(modelProps[i].Key)) continue;
            skeletonProps[i].setValue(modelProps[i].getValue());
        }
        return skeletonProps;
    }

    private void createSwitcherControl(Shell shell) {
        this.switcher = new ToolBar((Composite)shell, 0x880200);
        this.PAGE_WELCOME.createToolItem(this.switcher);
        this.PAGE_SKELETON.createToolItem(this.switcher);
        this.PAGE_APPLICATION.createToolItem(this.switcher);
        this.PAGE_EXECUTABLE.createToolItem(this.switcher);
    }

    private void createMainMenu(Shell shell) {
        this.mainmenu = new Menu((Decorations)shell, 2);
        MenuItem topItem = new MenuItem(this.mainmenu, 64);
        topItem.setText("File");
        Menu menu = new Menu((Decorations)shell, 4);
        topItem.setMenu(menu);
        MenuItem item = new MenuItem(menu, 0);
        item.setText("New");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSmoothApplication.this.ACTION_NEW.run();
            }
        });
        item = new MenuItem(menu, 0);
        item.setText("Open...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSmoothApplication.this.ACTION_OPEN.run();
            }
        });
        item = new MenuItem(menu, 0);
        item.setText("Save");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSmoothApplication.this.ACTION_SAVE.run();
            }
        });
        item = new MenuItem(menu, 0);
        item.setText("Save As...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSmoothApplication.this.ACTION_SAVE_AS.run();
            }
        });
        item = new MenuItem(menu, 2);
        item = new MenuItem(menu, 0);
        item.setText("Exit");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSmoothApplication.this.ACTION_EXIT.run();
            }
        });
        topItem = new MenuItem(this.mainmenu, 64);
        topItem.setText("Project");
        menu = new Menu((Decorations)shell, 4);
        topItem.setMenu(menu);
        item = new MenuItem(menu, 0);
        item.setText("Compile");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSmoothApplication.this.ACTION_COMPILE.run();
            }
        });
        item = new MenuItem(menu, 0);
        item.setText("Run .exe");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSmoothApplication.this.ACTION_RUNEXE.run();
            }
        });
        topItem = new MenuItem(this.mainmenu, 64);
        topItem.setText("Console");
        menu = new Menu((Decorations)shell, 4);
        topItem.setMenu(menu);
        item = new MenuItem(menu, 0);
        item.setText("Clear");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSmoothApplication.this.ACTION_CONSOLE_CLEAR.run();
            }
        });
        shell.setMenuBar(this.mainmenu);
    }

    private void createPages(Shell shell) {
        this.pagearea = new Composite((Composite)shell, 0);
        this.stack = new StackLayout();
        this.pagearea.setLayout((Layout)this.stack);
        for (int i = 0; i < this.PAGES.length; ++i) {
            this.PAGES[i].createControl(this.pagearea);
        }
    }

    public void showPage(JSmoothPage page) {
        ToolItem item;
        this.stack.topControl = page.getControl();
        if (this.pagearea != null) {
            this.pagearea.layout();
        }
        if (!(item = page.getToolItem()).getSelection()) {
            item.setSelection(true);
        }
    }

    public static void main(String[] args) {
        new JSmoothApplication(Display.getDefault()).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.shell == null) {
            this.createControls();
        }
        this.shell.open();
        this.newProject();
        this.showPage(this.PAGE_WELCOME);
        try {
            while (this.shell != null && !this.shell.isDisposed()) {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
            this.display.update();
        }
        finally {
            this.display.dispose();
        }
    }

    private void createControls() {
        this.shell = new Shell(this.display, 240);
        this.createMainMenu(this.shell);
        this.menusep = new Label((Composite)this.shell, 258);
        this.createConsole(this.shell);
        this.createSwitcherControl(this.shell);
        this.switchersep = new Label((Composite)this.shell, 514);
        this.createPages(this.shell);
        this.shell.setLayout((Layout)new JSmoothLayout());
        this.initializeBounds();
    }

    private void createConsole(Shell shell) {
        this.consolearea = new Composite((Composite)shell, 0);
        GridLayout gridlayout = new GridLayout();
        this.consolearea.setLayout((Layout)gridlayout);
        this.console = new Text(this.consolearea, 2826);
        this.console.setBackground(shell.getDisplay().getSystemColor(1));
        this.console.setForeground(shell.getDisplay().getSystemColor(9));
        GridData gridata = new GridData(1808);
        this.console.setLayoutData((Object)gridata);
        Menu menu = new Menu((Decorations)shell, 0);
        MenuItem item = new MenuItem(menu, 0);
        item.setText("Clear");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSmoothApplication.this.ACTION_CONSOLE_CLEAR.run();
            }
        });
        item = new MenuItem(menu, 0);
        item.setText("Copy");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSmoothApplication.this.console.copy();
            }
        });
        item = new MenuItem(menu, 0);
        item.setText("Copy All");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSmoothApplication.this.console.selectAll();
                JSmoothApplication.this.console.copy();
            }
        });
        this.console.setMenu(menu);
    }

    private void initializeBounds() {
        Point size = this.shell.computeSize(-1, -1, true);
        Point location = this.getInitialLocation(size);
        this.shell.setBounds(location.x, location.y, size.x, size.y);
    }

    private Point getInitialLocation(Point size) {
        Rectangle screen = this.display.getClientArea();
        int x = Math.max(0, screen.x + (screen.width - size.x) / 2);
        int y = Math.max(0, screen.y + (screen.height - size.y) / 3);
        return new Point(x, y);
    }

    public Shell getShell() {
        return this.shell;
    }

    private void fillSkeletonList(List list) {
        Iterator i = this.skeletonList.getIteratorNoDebugName();
        while (i.hasNext()) {
            list.add((String)i.next());
        }
    }

    public List getSkeletonList(boolean flush) {
        if (this.skeletonNames == null) {
            this.skeletonNames = new Vector();
            this.fillSkeletonList(this.skeletonNames);
        }
        if (flush) {
            this.skeletonNames.clear();
            this.fillSkeletonList(this.skeletonNames);
        }
        return this.skeletonNames;
    }

    public String[] getAllSkeletonNames() {
        return this.getSkeletonList(false).toArray(new String[0]);
    }

    public String getInitialSkeletonName() {
        String[] skelNames = this.getAllSkeletonNames();
        try {
            return skelNames[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return skelNames[0];
        }
    }

    public JSmoothModelBean getModelBean() {
        return this.jsmodel;
    }

    public boolean saveProjectAs(String projectfile) {
        System.out.println("[DEBUG] Saving project to file: " + projectfile);
        this.projectfile = new File(projectfile);
        try {
            JSmoothModelPersistency.save(this.projectfile, this.jsmodel);
        }
        catch (IOException e) {
            System.out.println("[ERROR] Failed saving project : " + e.getMessage());
            return false;
        }
        this.getShell().setText(this.getProjectName());
        return true;
    }

    public boolean saveProject() {
        return this.saveProjectAs(this.projectfile.getAbsolutePath());
    }

    public File getProjectFile() {
        return this.projectfile;
    }

    public boolean hasProjectFile() {
        return this.projectfile != null;
    }

    public void exit() {
        this.getShell().close();
    }

    public boolean openProject(String projectfile) {
        System.out.println("[DEBUG] Opening project : " + projectfile);
        File file = new File(projectfile);
        JSmoothModelBean jsmodel = null;
        try {
            jsmodel = JSmoothModelPersistency.load(file);
        }
        catch (IOException e) {
            System.out.println("[ERROR] Failed opening project : " + e.getMessage());
            return false;
        }
        this.projectfile = file;
        this.jsmodel = jsmodel;
        for (int i = 0; i < this.PAGES.length; ++i) {
            this.PAGES[i].load();
        }
        this.getShell().setText(this.getProjectName());
        return true;
    }

    public boolean compileProject() {
        this.consoleMessage("=== Compilation ===");
        File basedir = this.projectfile.getParentFile();
        this.jsmodel.normalizePaths(basedir);
        String skeletonName = this.jsmodel.getSkeletonName();
        SkeletonBean skeletonBean = this.skeletonList.getSkeleton(skeletonName);
        File skeletonRoot = this.skeletonList.getDirectory(skeletonBean);
        File exename = new File(this.jsmodel.getExecutableName());
        if (!exename.isAbsolute()) {
            exename = new File(basedir, this.jsmodel.getExecutableName());
        }
        boolean success = false;
        try {
            success = this.compiler.compile(skeletonRoot, skeletonBean, basedir, this.jsmodel, exename);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.consoleMessages(this.compiler.getErrors().toArray(new String[0]));
        this.compiler.cleanErrors();
        return success;
    }

    public void consoleMessage(String msg) {
        if (this.console.getText().length() != 0) {
            this.console.append("\r\n");
        }
        this.console.append(msg);
    }

    public void consoleMessages(String[] msg) {
        for (int i = 0; i < msg.length; ++i) {
            this.consoleMessage(msg[i]);
        }
    }

    public void clearConsole() {
        this.console.setText("");
    }

    public void consoleSection(String title) {
        StringBuffer buffer = new StringBuffer("-------------------------------------------------------------------------------------");
        if (title == null) {
            this.consoleMessage(buffer.toString());
            return;
        }
        buffer.replace(0, title.length() + 1, title + " ");
        this.consoleMessage(buffer.toString());
    }

    class SWTCompileListener
    implements ExeCompiler.StepListener {
        SWTCompileListener() {
        }

        public void setNewState(int percent, String state) {
            JSmoothApplication.this.consoleMessage(state);
        }

        public void failed() {
            JSmoothApplication.this.consoleMessage("Compile failed.");
        }

        public void complete() {
            JSmoothApplication.this.consoleMessage("Compile successfull.");
        }
    }

    class JSmoothLayout
    extends Layout {
        JSmoothLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point result = new Point(0, 0);
            Control[] ctrls = composite.getChildren();
            Point p = null;
            for (int i = 0; i < ctrls.length; ++i) {
                Control w = ctrls[i];
                if (JSmoothApplication.this.menusep == w) {
                    p = w.computeSize(wHint, hHint, flushCache);
                    result.y += p.y;
                    continue;
                }
                if (JSmoothApplication.this.switcher == w) {
                    p = w.computeSize(wHint, hHint, flushCache);
                    result.x += p.x;
                    result.y += p.y;
                    continue;
                }
                if (JSmoothApplication.this.switchersep == w) {
                    p = w.computeSize(wHint, hHint, flushCache);
                    result.x += p.x;
                    continue;
                }
                if (JSmoothApplication.this.consolearea == w) {
                    p = w.computeSize(wHint, hHint, flushCache);
                    result.y += 150;
                    continue;
                }
                if (JSmoothApplication.this.pagearea != w) continue;
                p = w.computeSize(wHint, hHint, flushCache);
                result.x += p.x;
                result.y = p.y + 150;
            }
            if (wHint != -1) {
                result.x = wHint;
            }
            if (hHint != -1) {
                result.y = hHint;
            }
            return result;
        }

        protected void layout(Composite cmp, boolean flushCache) {
            if (flushCache) {
                for (int i = 0; i < JSmoothApplication.this.PAGES.length; ++i) {
                    ((Composite)JSmoothApplication.this.PAGES[i].getControl()).layout();
                }
            }
            Rectangle clientarea = cmp.getClientArea();
            Control[] wgs = cmp.getChildren();
            Point p = null;
            for (int i = 0; i < wgs.length; ++i) {
                Control w = wgs[i];
                if (JSmoothApplication.this.menusep == w) {
                    p = w.computeSize(-1, -1, flushCache);
                    w.setBounds(clientarea.x, clientarea.y, clientarea.width, p.y);
                    clientarea.y += p.y;
                    clientarea.height += p.y;
                    continue;
                }
                if (JSmoothApplication.this.switcher == w) {
                    p = w.computeSize(-1, -1, flushCache);
                    w.setBounds(clientarea.x, clientarea.y, p.x, p.y);
                    clientarea.x += p.x;
                    clientarea.width -= p.x;
                    continue;
                }
                if (JSmoothApplication.this.switchersep == w) {
                    p = w.computeSize(-1, -1, flushCache);
                    w.setBounds(clientarea.x, clientarea.y, p.x, clientarea.height);
                    clientarea.x += p.x;
                    clientarea.width -= p.x;
                    continue;
                }
                if (JSmoothApplication.this.consolearea == w) {
                    p = w.computeSize(-1, 150, flushCache);
                    w.setBounds(clientarea.x, clientarea.height - 150, clientarea.width, p.y);
                    clientarea.height -= 150;
                    continue;
                }
                if (JSmoothApplication.this.pagearea != w) continue;
                w.setBounds(clientarea.x, clientarea.y, clientarea.width, clientarea.height);
            }
            if (flushCache) {
                cmp.setSize(cmp.computeSize(-1, -1));
            }
        }
    }
}

