/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.cmdline;

import java.awt.Toolkit;
import java.io.File;
import net.charabia.jsmoothgen.application.ExeCompiler;
import net.charabia.jsmoothgen.application.JSmoothModelBean;
import net.charabia.jsmoothgen.application.JSmoothModelPersistency;
import net.charabia.jsmoothgen.skeleton.SkeletonBean;
import net.charabia.jsmoothgen.skeleton.SkeletonList;

public class CommandLine {
    static void printUsage() {
        System.out.println("Usage: jsmoothc [projectfile.jsmooth]");
        System.out.println(" where projectfile.jsmooth is a project file created by JSmoothGen");
    }

    public static void main(String[] args) {
        File prj;
        if (args.length != 1) {
            CommandLine.printUsage();
            System.exit(10);
        }
        if (!(prj = new File(args[0])).exists()) {
            prj = new File(prj.toString() + ".jsmooth");
        }
        if (!prj.exists()) {
            System.err.println("Error: project file <" + args[0] + "> not found");
            System.exit(10);
        }
        System.setProperty("java.awt.headless", "true");
        Toolkit tk = Toolkit.getDefaultToolkit();
        String jsmoothbase = System.getProperty("jsmooth.basedir");
        try {
            JSmoothModelBean model = JSmoothModelPersistency.load(prj);
            File basedir = prj.getParentFile();
            File skelbase = new File("skeletons");
            if (jsmoothbase != null) {
                skelbase = new File(new File(jsmoothbase), "skeletons");
            }
            SkeletonList skelList = new SkeletonList(skelbase);
            File out = new File(basedir, model.getExecutableName());
            SkeletonBean skel = skelList.getSkeleton(model.getSkeletonName());
            File skelroot = skelList.getDirectory(skel);
            ExeCompiler compiler = new ExeCompiler();
            compiler.compile(skelroot, skel, basedir, model, out);
            System.exit(0);
        }
        catch (Exception exc) {
            System.err.println("Incorrect project file!");
        }
        System.exit(20);
    }
}

