/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import jsmooth.DriveInfo;
import jsmooth.Native;

public class JSmoothPropertiesDisplayer
extends Frame {
    private String[] m_args;
    private Label label1;
    private Button m_buttonClose;
    private TextArea m_text;

    public JSmoothPropertiesDisplayer(String[] stringArray) {
        this.m_args = stringArray;
        this.initComponents();
        this.displayInformation();
    }

    private void initComponents() {
        this.label1 = new Label();
        this.m_text = new TextArea();
        this.m_buttonClose = new Button();
        this.setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JSmoothPropertiesDisplayer.this.exitForm(windowEvent);
            }
        });
        this.label1.setAlignment(1);
        this.label1.setFont(new Font("Dialog", 0, 18));
        this.label1.setText("JSmooth Sample Program");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.label1, gridBagConstraints);
        this.m_text.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_text, gridBagConstraints);
        this.m_buttonClose.setLabel("Close");
        this.m_buttonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JSmoothPropertiesDisplayer.this.buttonCloseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_buttonClose, gridBagConstraints);
        Button button = new Button("JNI Tests");
        this.add((Component)button, gridBagConstraints);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    File file = new File("Z:/test");
                    System.out.println(file.getAbsoluteFile().toString());
                    System.out.println(file.getAbsoluteFile().getCanonicalPath().toString());
                    System.out.println("JNI Availability : " + Native.isAvailable());
                    if (Native.isAvailable()) {
                        DriveInfo driveInfo = Native.getDriveInfo((File)file);
                        if (driveInfo.getDriveType() == 2) {
                            // empty if block
                        }
                        if (driveInfo.getFreeSpaceForUser() < 0x4000000L) {
                            // empty if block
                        }
                        System.out.println("DriveInfo: " + driveInfo + " = " + driveInfo.toString());
                        System.out.println("path: " + Native.getExecutablePath());
                        System.out.println("filename: " + Native.getExecutableName());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.pack();
    }

    private void buttonCloseActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(87);
    }

    public static void main(String[] stringArray) throws Exception {
        ((Component)new JSmoothPropertiesDisplayer(stringArray)).setVisible(true);
    }

    private void displayInformation() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-- Sample --\n\n");
        stringBuffer.append("Current Directory: " + new File(".").getAbsolutePath() + "\n");
        stringBuffer.append("Arguments passed on the command line: " + this.m_args.length + " \n");
        for (int i = 0; i < this.m_args.length; ++i) {
            stringBuffer.append("" + i + ". " + this.m_args[i]);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Free Heap Memory: " + Runtime.getRuntime().freeMemory() + " bytes\n");
        stringBuffer.append("Total Heap Memory: " + Runtime.getRuntime().totalMemory() + " bytes\n");
        stringBuffer.append("\n");
        stringBuffer.append("System Properties:\n\n");
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            stringBuffer.append(properties.getProperty(string));
            stringBuffer.append("\n");
        }
        System.out.println(stringBuffer.toString());
        this.m_text.setText(stringBuffer.toString());
    }
}

