/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import sun.security.action.GetBooleanAction;
import sun.security.action.LoadLibraryAction;

public class MarshalInputStream
extends ObjectInputStream {
    private static final boolean useCodebaseOnlyProperty = AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.useCodebaseOnly"));
    protected static Map permittedSunClasses = new HashMap(3);
    private boolean skipDefaultResolveClass = false;
    private final Map doneCallbacks = new HashMap(3);
    private boolean useCodebaseOnly = useCodebaseOnlyProperty;

    public MarshalInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        super(inputStream);
    }

    public Runnable getDoneCallback(Object object) {
        return (Runnable)this.doneCallbacks.get(object);
    }

    public void setDoneCallback(Object object, Runnable runnable) {
        this.doneCallbacks.put(object, runnable);
    }

    public void done() {
        for (Runnable runnable : this.doneCallbacks.values()) {
            runnable.run();
        }
        this.doneCallbacks.clear();
    }

    public void close() throws IOException {
        this.done();
        super.close();
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Object object = this.readLocation();
        String string = objectStreamClass.getName();
        ClassLoader classLoader = this.skipDefaultResolveClass ? null : MarshalInputStream.latestUserDefinedLoader();
        String string2 = null;
        if (!this.useCodebaseOnly && object instanceof String) {
            string2 = (String)object;
        }
        try {
            return RMIClassLoader.loadClass(string2, string, classLoader);
        }
        catch (AccessControlException accessControlException) {
            return this.checkSunClass(string, accessControlException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                if (Character.isLowerCase(string.charAt(0)) && string.indexOf(46) == -1) {
                    return super.resolveClass(objectStreamClass);
                }
            }
            catch (ClassNotFoundException classNotFoundException2) {
                // empty catch block
            }
            throw classNotFoundException;
        }
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        Object object = this.readLocation();
        ClassLoader classLoader = this.skipDefaultResolveClass ? null : MarshalInputStream.latestUserDefinedLoader();
        String string = null;
        if (!this.useCodebaseOnly && object instanceof String) {
            string = (String)object;
        }
        return RMIClassLoader.loadProxyClass(string, stringArray, classLoader);
    }

    private static native ClassLoader latestUserDefinedLoader();

    private Class checkSunClass(String string, AccessControlException accessControlException) throws AccessControlException {
        Permission permission = accessControlException.getPermission();
        String string2 = null;
        if (permission != null) {
            string2 = permission.getName();
        }
        Class clazz = (Class)permittedSunClasses.get(string);
        if (string2 == null || clazz == null || !string2.equals("accessClassInPackage.sun.rmi.server") && !string2.equals("accessClassInPackage.sun.rmi.registry")) {
            throw accessControlException;
        }
        return clazz;
    }

    protected Object readLocation() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    void skipDefaultResolveClass() {
        this.skipDefaultResolveClass = true;
    }

    void useCodebaseOnly() {
        this.useCodebaseOnly = true;
    }

    static {
        try {
            String string = "sun.rmi.server.Activation$ActivationSystemImpl_Stub";
            String string2 = "sun.rmi.registry.RegistryImpl_Stub";
            permittedSunClasses.put(string, Class.forName(string));
            permittedSunClasses.put(string2, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError("Missing system class: " + classNotFoundException.getMessage());
        }
        AccessController.doPrivileged(new LoadLibraryAction("rmi"));
    }
}

