/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import sun.awt.image.BufImgVolatileSurfaceManager;
import sun.awt.image.CachingSurfaceManager;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.SurfaceData;
import sun.java2d.d3d.D3DCachingSurfaceManager;
import sun.java2d.d3d.D3DGraphicsConfig;
import sun.java2d.d3d.D3DGraphicsDevice;
import sun.java2d.d3d.D3DVolatileSurfaceManager;
import sun.java2d.loops.CompositeType;
import sun.java2d.opengl.WGLCachingSurfaceManager;
import sun.java2d.opengl.WGLGraphicsConfig;
import sun.java2d.opengl.WGLVolatileSurfaceManager;
import sun.java2d.windows.WindowsFlags;

public class SurfaceManagerFactory {
    public static SurfaceManager createCachingManager(BufferedImage bufferedImage) {
        if (WindowsFlags.isOGLEnabled()) {
            return new WGLCachingSurfaceManager(bufferedImage);
        }
        if (D3DGraphicsDevice.isD3DAvailable()) {
            return new D3DCachingSurfaceManager(bufferedImage);
        }
        return new CachingSurfaceManager(bufferedImage){

            protected SurfaceData createAccelSurface(GraphicsConfiguration graphicsConfiguration, int n, int n2) {
                return null;
            }

            protected boolean isDestSurfaceAccelerated(SurfaceData surfaceData) {
                return false;
            }

            protected boolean isOperationSupported(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl) {
                return false;
            }
        };
    }

    public static VolatileSurfaceManager createVolatileManager(SunVolatileImage sunVolatileImage, Object object) {
        GraphicsConfiguration graphicsConfiguration = sunVolatileImage.getGraphicsConfig();
        if (graphicsConfiguration instanceof WGLGraphicsConfig) {
            return new WGLVolatileSurfaceManager(sunVolatileImage, object);
        }
        if (graphicsConfiguration instanceof D3DGraphicsConfig) {
            return new D3DVolatileSurfaceManager(sunVolatileImage, object);
        }
        return new BufImgVolatileSurfaceManager(sunVolatileImage, object);
    }
}

