/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.sax;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.Decoder;
import com.sun.xml.internal.fastinfoset.DecoderStateTables;
import com.sun.xml.internal.fastinfoset.EncodingConstants;
import com.sun.xml.internal.fastinfoset.QualifiedName;
import com.sun.xml.internal.fastinfoset.algorithm.BuiltInEncodingAlgorithmFactory;
import com.sun.xml.internal.fastinfoset.algorithm.BuiltInEncodingAlgorithmState;
import com.sun.xml.internal.fastinfoset.sax.AttributesHolder;
import com.sun.xml.internal.fastinfoset.sax.SystemIdResolver;
import com.sun.xml.internal.fastinfoset.util.CharArray;
import com.sun.xml.internal.fastinfoset.util.CharArrayString;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithm;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithmException;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetException;
import com.sun.xml.internal.org.jvnet.fastinfoset.sax.EncodingAlgorithmContentHandler;
import com.sun.xml.internal.org.jvnet.fastinfoset.sax.FastInfosetReader;
import com.sun.xml.internal.org.jvnet.fastinfoset.sax.PrimitiveTypeContentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXDocumentParser
extends Decoder
implements FastInfosetReader {
    protected boolean _namespacePrefixesFeature = false;
    protected EntityResolver _entityResolver;
    protected DTDHandler _dtdHandler;
    protected ContentHandler _contentHandler;
    protected ErrorHandler _errorHandler;
    protected LexicalHandler _lexicalHandler;
    protected DeclHandler _declHandler;
    protected EncodingAlgorithmContentHandler _algorithmHandler;
    protected PrimitiveTypeContentHandler _primitiveHandler;
    protected BuiltInEncodingAlgorithmState builtInAlgorithmState = new BuiltInEncodingAlgorithmState();
    protected AttributesHolder _attributes;
    protected int[] _namespacePrefixes = new int[16];
    protected int _namespacePrefixesIndex;
    protected boolean _clearAttributes = false;

    public SAXDocumentParser() {
        DefaultHandler defaultHandler = new DefaultHandler();
        this._attributes = new AttributesHolder(this._registeredEncodingAlgorithms);
        this._entityResolver = defaultHandler;
        this._dtdHandler = defaultHandler;
        this._contentHandler = defaultHandler;
        this._errorHandler = defaultHandler;
        this._lexicalHandler = new LexicalHandlerImpl();
        this._declHandler = new DeclHandlerImpl();
    }

    protected void resetOnError() {
        this._clearAttributes = false;
        this._attributes.clear();
        this._namespacePrefixesIndex = 0;
        if (this._v != null) {
            this._v.prefix.clearCompletely();
        }
        this._duplicateAttributeVerifier.clear();
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return this._namespacePrefixesFeature;
        }
        if (string.equals("http://xml.org/sax/features/string-interning") || string.equals("http://jvnet.org/fastinfoset/parser/properties/string-interning")) {
            return this.getStringInterning();
        }
        throw new SAXNotRecognizedException(CommonResourceBundle.getInstance().getString("message.featureNotSupported") + string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            if (!bl) {
                throw new SAXNotSupportedException(string + ":" + bl);
            }
        } else if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            this._namespacePrefixesFeature = bl;
        } else if (string.equals("http://xml.org/sax/features/string-interning") || string.equals("http://jvnet.org/fastinfoset/parser/properties/string-interning")) {
            this.setStringInterning(bl);
        } else {
            throw new SAXNotRecognizedException(CommonResourceBundle.getInstance().getString("message.featureNotSupported") + string);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.getLexicalHandler();
        }
        if (string.equals("http://xml.org/sax/properties/declaration-handler")) {
            return this.getDeclHandler();
        }
        if (string.equals("http://jvnet.org/fastinfoset/parser/properties/external-vocabularies")) {
            return this.getExternalVocabularies();
        }
        if (string.equals("http://jvnet.org/fastinfoset/parser/properties/registered-encoding-algorithms")) {
            return this.getRegisteredEncodingAlgorithms();
        }
        if (string.equals("http://jvnet.org/fastinfoset/sax/properties/encoding-algorithm-content-handler")) {
            return this.getEncodingAlgorithmContentHandler();
        }
        if (string.equals("http://jvnet.org/fastinfoset/sax/properties/primitive-type-content-handler")) {
            return this.getPrimitiveTypeContentHandler();
        }
        throw new SAXNotRecognizedException(CommonResourceBundle.getInstance().getString("message.propertyNotRecognized", new Object[]{string}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            if (!(object instanceof LexicalHandler)) throw new SAXNotSupportedException("http://xml.org/sax/properties/lexical-handler");
            this.setLexicalHandler((LexicalHandler)object);
            return;
        } else if (string.equals("http://xml.org/sax/properties/declaration-handler")) {
            if (!(object instanceof DeclHandler)) throw new SAXNotSupportedException("http://xml.org/sax/properties/lexical-handler");
            this.setDeclHandler((DeclHandler)object);
            return;
        } else if (string.equals("http://jvnet.org/fastinfoset/parser/properties/external-vocabularies")) {
            if (!(object instanceof Map)) throw new SAXNotSupportedException("http://jvnet.org/fastinfoset/parser/properties/external-vocabularies");
            this.setExternalVocabularies((Map)object);
            return;
        } else if (string.equals("http://jvnet.org/fastinfoset/parser/properties/registered-encoding-algorithms")) {
            if (!(object instanceof Map)) throw new SAXNotSupportedException("http://jvnet.org/fastinfoset/parser/properties/registered-encoding-algorithms");
            this.setRegisteredEncodingAlgorithms((Map)object);
            return;
        } else if (string.equals("http://jvnet.org/fastinfoset/sax/properties/encoding-algorithm-content-handler")) {
            if (!(object instanceof EncodingAlgorithmContentHandler)) throw new SAXNotSupportedException("http://jvnet.org/fastinfoset/sax/properties/encoding-algorithm-content-handler");
            this.setEncodingAlgorithmContentHandler((EncodingAlgorithmContentHandler)object);
            return;
        } else if (string.equals("http://jvnet.org/fastinfoset/sax/properties/primitive-type-content-handler")) {
            if (!(object instanceof PrimitiveTypeContentHandler)) throw new SAXNotSupportedException("http://jvnet.org/fastinfoset/sax/properties/primitive-type-content-handler");
            this.setPrimitiveTypeContentHandler((PrimitiveTypeContentHandler)object);
            return;
        } else {
            if (!string.equals("http://jvnet.org/fastinfoset/parser/properties/buffer-size")) throw new SAXNotRecognizedException(CommonResourceBundle.getInstance().getString("message.propertyNotRecognized", new Object[]{string}));
            if (!(object instanceof Integer)) throw new SAXNotSupportedException("http://jvnet.org/fastinfoset/parser/properties/buffer-size");
            this.setBufferSize((Integer)object);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this._entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this._dtdHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this._contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        try {
            InputStream inputStream = inputSource.getByteStream();
            if (inputStream == null) {
                String string = inputSource.getSystemId();
                if (string == null) {
                    throw new SAXException(CommonResourceBundle.getInstance().getString("message.inputSource"));
                }
                this.parse(string);
            } else {
                this.parse(inputStream);
            }
        }
        catch (FastInfosetException fastInfosetException) {
            fastInfosetException.printStackTrace();
            throw new SAXException(fastInfosetException);
        }
    }

    public void parse(String string) throws IOException, SAXException {
        try {
            string = SystemIdResolver.getAbsoluteURI(string);
            this.parse(new URL(string).openStream());
        }
        catch (FastInfosetException fastInfosetException) {
            fastInfosetException.printStackTrace();
            throw new SAXException(fastInfosetException);
        }
    }

    public final void parse(InputStream inputStream) throws IOException, FastInfosetException, SAXException {
        this.setInputStream(inputStream);
        this.parse();
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this._lexicalHandler = lexicalHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this._lexicalHandler;
    }

    public void setDeclHandler(DeclHandler declHandler) {
        this._declHandler = declHandler;
    }

    public DeclHandler getDeclHandler() {
        return this._declHandler;
    }

    public void setEncodingAlgorithmContentHandler(EncodingAlgorithmContentHandler encodingAlgorithmContentHandler) {
        this._algorithmHandler = encodingAlgorithmContentHandler;
    }

    public EncodingAlgorithmContentHandler getEncodingAlgorithmContentHandler() {
        return this._algorithmHandler;
    }

    public void setPrimitiveTypeContentHandler(PrimitiveTypeContentHandler primitiveTypeContentHandler) {
        this._primitiveHandler = primitiveTypeContentHandler;
    }

    public PrimitiveTypeContentHandler getPrimitiveTypeContentHandler() {
        return this._primitiveHandler;
    }

    public final void parse() throws FastInfosetException, IOException {
        if (this._octetBuffer.length < this._bufferSize) {
            this._octetBuffer = new byte[this._bufferSize];
        }
        try {
            this.reset();
            this.decodeHeader();
            if (this._parseFragments) {
                this.processDIIFragment();
            } else {
                this.processDII();
            }
        }
        catch (RuntimeException runtimeException) {
            try {
                this._errorHandler.fatalError(new SAXParseException(runtimeException.getClass().getName(), null, runtimeException));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.resetOnError();
            throw new FastInfosetException(runtimeException);
        }
        catch (FastInfosetException fastInfosetException) {
            try {
                this._errorHandler.fatalError(new SAXParseException(fastInfosetException.getClass().getName(), null, fastInfosetException));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.resetOnError();
            throw fastInfosetException;
        }
        catch (IOException iOException) {
            try {
                this._errorHandler.fatalError(new SAXParseException(iOException.getClass().getName(), null, iOException));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.resetOnError();
            throw iOException;
        }
    }

    protected final void processDII() throws FastInfosetException, IOException {
        try {
            this._contentHandler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new FastInfosetException("processDII", sAXException);
        }
        this._b = this.read();
        if (this._b > 0) {
            this.processDIIOptionalProperties();
        }
        boolean bl = false;
        boolean bl2 = false;
        block28: while (!this._terminate || !bl) {
            this._b = this.read();
            switch (DecoderStateTables.DII[this._b]) {
                case 0: {
                    this.processEII(this._elementNameTable._array[this._b], false);
                    bl = true;
                    continue block28;
                }
                case 1: {
                    this.processEII(this._elementNameTable._array[this._b & 0x1F], true);
                    bl = true;
                    continue block28;
                }
                case 2: {
                    this.processEII(this.decodeEIIIndexMedium(), (this._b & 0x40) > 0);
                    bl = true;
                    continue block28;
                }
                case 3: {
                    this.processEII(this.decodeEIIIndexLarge(), (this._b & 0x40) > 0);
                    bl = true;
                    continue block28;
                }
                case 5: {
                    Object object = this.decodeLiteralQualifiedName(this._b & 3, this._elementNameTable.getNext());
                    this._elementNameTable.add((QualifiedName)object);
                    this.processEII((QualifiedName)object, (this._b & 0x40) > 0);
                    bl = true;
                    continue block28;
                }
                case 4: {
                    this.processEIIWithNamespaces();
                    bl = true;
                    continue block28;
                }
                case 20: {
                    if (bl2) {
                        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.secondOccurenceOfDTDII"));
                    }
                    bl2 = true;
                    Object object = (this._b & 2) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : "";
                    String string = (this._b & 1) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : "";
                    this._b = this.read();
                    while (this._b == 225) {
                        switch (this.decodeNonIdentifyingStringOnFirstBit()) {
                            case 0: {
                                if (!this._addToTable) break;
                                this._v.otherString.add(new CharArray(this._charBuffer, 0, this._charBufferLength, true));
                                break;
                            }
                            case 2: {
                                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.processingIIWithEncodingAlgorithm"));
                            }
                            case 1: {
                                break;
                            }
                        }
                        this._b = this.read();
                    }
                    if ((this._b & 0xF0) != 240) {
                        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.processingInstructionIIsNotTerminatedCorrectly"));
                    }
                    if (this._b == 255) {
                        this._terminate = true;
                    }
                    if (this._notations != null) {
                        this._notations.clear();
                    }
                    if (this._unparsedEntities == null) continue block28;
                    this._unparsedEntities.clear();
                    continue block28;
                }
                case 18: {
                    this.processCommentII();
                    continue block28;
                }
                case 19: {
                    this.processProcessingII();
                    continue block28;
                }
                case 23: {
                    this._doubleTerminate = true;
                }
                case 22: {
                    this._terminate = true;
                    continue block28;
                }
            }
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.IllegalStateDecodingDII"));
        }
        block30: while (!this._terminate) {
            this._b = this.read();
            switch (DecoderStateTables.DII[this._b]) {
                case 18: {
                    this.processCommentII();
                    continue block30;
                }
                case 19: {
                    this.processProcessingII();
                    continue block30;
                }
                case 23: {
                    this._doubleTerminate = true;
                }
                case 22: {
                    this._terminate = true;
                    continue block30;
                }
            }
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.IllegalStateDecodingDII"));
        }
        try {
            this._contentHandler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new FastInfosetException("processDII", sAXException);
        }
    }

    protected final void processDIIFragment() throws FastInfosetException, IOException {
        try {
            this._contentHandler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new FastInfosetException("processDII", sAXException);
        }
        this._b = this.read();
        if (this._b > 0) {
            this.processDIIOptionalProperties();
        }
        block47: while (!this._terminate) {
            this._b = this.read();
            switch (DecoderStateTables.EII[this._b]) {
                case 0: {
                    this.processEII(this._elementNameTable._array[this._b], false);
                    continue block47;
                }
                case 1: {
                    this.processEII(this._elementNameTable._array[this._b & 0x1F], true);
                    continue block47;
                }
                case 2: {
                    this.processEII(this.decodeEIIIndexMedium(), (this._b & 0x40) > 0);
                    continue block47;
                }
                case 3: {
                    this.processEII(this.decodeEIIIndexLarge(), (this._b & 0x40) > 0);
                    continue block47;
                }
                case 5: {
                    QualifiedName qualifiedName = this.decodeLiteralQualifiedName(this._b & 3, this._elementNameTable.getNext());
                    this._elementNameTable.add(qualifiedName);
                    this.processEII(qualifiedName, (this._b & 0x40) > 0);
                    continue block47;
                }
                case 4: {
                    this.processEIIWithNamespaces();
                    continue block47;
                }
                case 6: {
                    this._octetBufferLength = (this._b & 1) + 1;
                    this.processUtf8CharacterString();
                    continue block47;
                }
                case 7: {
                    this._octetBufferLength = this.read() + 3;
                    this.processUtf8CharacterString();
                    continue block47;
                }
                case 8: {
                    this._octetBufferLength = (this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read()) + 259;
                    this.processUtf8CharacterString();
                    continue block47;
                }
                case 9: {
                    this._octetBufferLength = (this._b & 1) + 1;
                    this.decodeUtf16StringAsCharBuffer();
                    if ((this._b & 0x10) > 0) {
                        this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
                    }
                    try {
                        this._contentHandler.characters(this._charBuffer, 0, this._charBufferLength);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 10: {
                    this._octetBufferLength = this.read() + 3;
                    this.decodeUtf16StringAsCharBuffer();
                    if ((this._b & 0x10) > 0) {
                        this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
                    }
                    try {
                        this._contentHandler.characters(this._charBuffer, 0, this._charBufferLength);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 11: {
                    this._octetBufferLength = (this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read()) + 259;
                    this.decodeUtf16StringAsCharBuffer();
                    if ((this._b & 0x10) > 0) {
                        this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
                    }
                    try {
                        this._contentHandler.characters(this._charBuffer, 0, this._charBufferLength);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 12: {
                    boolean bl = (this._b & 0x10) > 0;
                    this._identifier = (this._b & 2) << 6;
                    this._b = this.read();
                    this._identifier |= (this._b & 0xFC) >> 2;
                    this.decodeOctetsOnSeventhBitOfNonIdentifyingStringOnThirdBit(this._b);
                    this.decodeRestrictedAlphabetAsCharBuffer();
                    if (bl) {
                        this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
                    }
                    try {
                        this._contentHandler.characters(this._charBuffer, 0, this._charBufferLength);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 13: {
                    boolean bl = (this._b & 0x10) > 0;
                    this._identifier = (this._b & 2) << 6;
                    this._b = this.read();
                    this._identifier |= (this._b & 0xFC) >> 2;
                    this.decodeOctetsOnSeventhBitOfNonIdentifyingStringOnThirdBit(this._b);
                    this.processCIIEncodingAlgorithm(bl);
                    continue block47;
                }
                case 14: {
                    int n = this._b & 0xF;
                    try {
                        this._contentHandler.characters(this._characterContentChunkTable._array, this._characterContentChunkTable._offset[n], this._characterContentChunkTable._length[n]);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 15: {
                    int n = ((this._b & 3) << 8 | this.read()) + 16;
                    try {
                        this._contentHandler.characters(this._characterContentChunkTable._array, this._characterContentChunkTable._offset[n], this._characterContentChunkTable._length[n]);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 16: {
                    int n = ((this._b & 3) << 16 | this.read() << 8 | this.read()) + 1040;
                    try {
                        this._contentHandler.characters(this._characterContentChunkTable._array, this._characterContentChunkTable._offset[n], this._characterContentChunkTable._length[n]);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 17: {
                    int n = (this.read() << 16 | this.read() << 8 | this.read()) + 263184;
                    try {
                        this._contentHandler.characters(this._characterContentChunkTable._array, this._characterContentChunkTable._offset[n], this._characterContentChunkTable._length[n]);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 18: {
                    this.processCommentII();
                    continue block47;
                }
                case 19: {
                    this.processProcessingII();
                    continue block47;
                }
                case 21: {
                    String string = this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherNCName);
                    String string2 = (this._b & 2) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : "";
                    String string3 = (this._b & 1) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : "";
                    try {
                        this._contentHandler.skippedEntity(string);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processUnexpandedEntityReferenceII", sAXException);
                    }
                }
                case 23: {
                    this._doubleTerminate = true;
                }
                case 22: {
                    this._terminate = true;
                    continue block47;
                }
            }
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.IllegalStateDecodingEII"));
        }
        try {
            this._contentHandler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new FastInfosetException("processDII", sAXException);
        }
    }

    protected final void processDIIOptionalProperties() throws FastInfosetException, IOException {
        if (this._b == 32) {
            this.decodeInitialVocabulary();
            return;
        }
        if ((this._b & 0x40) > 0) {
            this.decodeAdditionalData();
        }
        if ((this._b & 0x20) > 0) {
            this.decodeInitialVocabulary();
        }
        if ((this._b & 0x10) > 0) {
            this.decodeNotations();
        }
        if ((this._b & 8) > 0) {
            this.decodeUnparsedEntities();
        }
        if ((this._b & 4) > 0) {
            String string = this.decodeCharacterEncodingScheme();
        }
        if ((this._b & 2) > 0) {
            boolean bl;
            boolean bl2 = bl = this.read() > 0;
        }
        if ((this._b & 1) > 0) {
            this.decodeVersion();
        }
    }

    protected final void processEII(QualifiedName qualifiedName, boolean bl) throws FastInfosetException, IOException {
        if (this._prefixTable._currentInScope[qualifiedName.prefixIndex] != qualifiedName.namespaceNameIndex) {
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.qNameOfEIINotInScope"));
        }
        if (bl) {
            this.processAIIs();
        }
        try {
            this._contentHandler.startElement(qualifiedName.namespaceName, qualifiedName.localName, qualifiedName.qName, this._attributes);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new FastInfosetException("processEII", sAXException);
        }
        if (this._clearAttributes) {
            this._attributes.clear();
            this._clearAttributes = false;
        }
        block47: while (!this._terminate) {
            this._b = this.read();
            switch (DecoderStateTables.EII[this._b]) {
                case 0: {
                    this.processEII(this._elementNameTable._array[this._b], false);
                    continue block47;
                }
                case 1: {
                    this.processEII(this._elementNameTable._array[this._b & 0x1F], true);
                    continue block47;
                }
                case 2: {
                    this.processEII(this.decodeEIIIndexMedium(), (this._b & 0x40) > 0);
                    continue block47;
                }
                case 3: {
                    this.processEII(this.decodeEIIIndexLarge(), (this._b & 0x40) > 0);
                    continue block47;
                }
                case 5: {
                    QualifiedName qualifiedName2 = this.decodeLiteralQualifiedName(this._b & 3, this._elementNameTable.getNext());
                    this._elementNameTable.add(qualifiedName2);
                    this.processEII(qualifiedName2, (this._b & 0x40) > 0);
                    continue block47;
                }
                case 4: {
                    this.processEIIWithNamespaces();
                    continue block47;
                }
                case 6: {
                    this._octetBufferLength = (this._b & 1) + 1;
                    this.processUtf8CharacterString();
                    continue block47;
                }
                case 7: {
                    this._octetBufferLength = this.read() + 3;
                    this.processUtf8CharacterString();
                    continue block47;
                }
                case 8: {
                    this._octetBufferLength = (this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read()) + 259;
                    this.processUtf8CharacterString();
                    continue block47;
                }
                case 9: {
                    this._octetBufferLength = (this._b & 1) + 1;
                    this.decodeUtf16StringAsCharBuffer();
                    if ((this._b & 0x10) > 0) {
                        this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
                    }
                    try {
                        this._contentHandler.characters(this._charBuffer, 0, this._charBufferLength);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 10: {
                    this._octetBufferLength = this.read() + 3;
                    this.decodeUtf16StringAsCharBuffer();
                    if ((this._b & 0x10) > 0) {
                        this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
                    }
                    try {
                        this._contentHandler.characters(this._charBuffer, 0, this._charBufferLength);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 11: {
                    this._octetBufferLength = (this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read()) + 259;
                    this.decodeUtf16StringAsCharBuffer();
                    if ((this._b & 0x10) > 0) {
                        this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
                    }
                    try {
                        this._contentHandler.characters(this._charBuffer, 0, this._charBufferLength);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 12: {
                    boolean bl2 = (this._b & 0x10) > 0;
                    this._identifier = (this._b & 2) << 6;
                    this._b = this.read();
                    this._identifier |= (this._b & 0xFC) >> 2;
                    this.decodeOctetsOnSeventhBitOfNonIdentifyingStringOnThirdBit(this._b);
                    this.decodeRestrictedAlphabetAsCharBuffer();
                    if (bl2) {
                        this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
                    }
                    try {
                        this._contentHandler.characters(this._charBuffer, 0, this._charBufferLength);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 13: {
                    boolean bl3 = (this._b & 0x10) > 0;
                    this._identifier = (this._b & 2) << 6;
                    this._b = this.read();
                    this._identifier |= (this._b & 0xFC) >> 2;
                    this.decodeOctetsOnSeventhBitOfNonIdentifyingStringOnThirdBit(this._b);
                    this.processCIIEncodingAlgorithm(bl3);
                    continue block47;
                }
                case 14: {
                    int n = this._b & 0xF;
                    try {
                        this._contentHandler.characters(this._characterContentChunkTable._array, this._characterContentChunkTable._offset[n], this._characterContentChunkTable._length[n]);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 15: {
                    int n = ((this._b & 3) << 8 | this.read()) + 16;
                    try {
                        this._contentHandler.characters(this._characterContentChunkTable._array, this._characterContentChunkTable._offset[n], this._characterContentChunkTable._length[n]);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 16: {
                    int n = ((this._b & 3) << 16 | this.read() << 8 | this.read()) + 1040;
                    try {
                        this._contentHandler.characters(this._characterContentChunkTable._array, this._characterContentChunkTable._offset[n], this._characterContentChunkTable._length[n]);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 17: {
                    int n = (this.read() << 16 | this.read() << 8 | this.read()) + 263184;
                    try {
                        this._contentHandler.characters(this._characterContentChunkTable._array, this._characterContentChunkTable._offset[n], this._characterContentChunkTable._length[n]);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processCII", sAXException);
                    }
                }
                case 18: {
                    this.processCommentII();
                    continue block47;
                }
                case 19: {
                    this.processProcessingII();
                    continue block47;
                }
                case 21: {
                    String string = this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherNCName);
                    String string2 = (this._b & 2) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : "";
                    String string3 = (this._b & 1) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : "";
                    try {
                        this._contentHandler.skippedEntity(string);
                        continue block47;
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException("processUnexpandedEntityReferenceII", sAXException);
                    }
                }
                case 23: {
                    this._doubleTerminate = true;
                }
                case 22: {
                    this._terminate = true;
                    continue block47;
                }
            }
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.IllegalStateDecodingEII"));
        }
        this._terminate = this._doubleTerminate;
        this._doubleTerminate = false;
        try {
            this._contentHandler.endElement(qualifiedName.namespaceName, qualifiedName.localName, qualifiedName.qName);
        }
        catch (SAXException sAXException) {
            throw new FastInfosetException("processEII", sAXException);
        }
    }

    private final void processUtf8CharacterString() throws FastInfosetException, IOException {
        if ((this._b & 0x10) > 0) {
            this._characterContentChunkTable.ensureSize(this._octetBufferLength);
            int n = this._characterContentChunkTable._arrayIndex;
            this.decodeUtf8StringAsCharBuffer(this._characterContentChunkTable._array, n);
            this._characterContentChunkTable.add(this._charBufferLength);
            try {
                this._contentHandler.characters(this._characterContentChunkTable._array, n, this._charBufferLength);
            }
            catch (SAXException sAXException) {
                throw new FastInfosetException("processCII", sAXException);
            }
        }
        this.decodeUtf8StringAsCharBuffer();
        try {
            this._contentHandler.characters(this._charBuffer, 0, this._charBufferLength);
        }
        catch (SAXException sAXException) {
            throw new FastInfosetException("processCII", sAXException);
        }
    }

    protected final void processEIIWithNamespaces() throws FastInfosetException, IOException {
        boolean bl = (this._b & 0x40) > 0;
        boolean bl2 = this._clearAttributes = this._namespacePrefixesFeature;
        if (++this._prefixTable._declarationId == Integer.MAX_VALUE) {
            this._prefixTable.clearDeclarationIds();
        }
        String string = "";
        String string2 = "";
        int n = this._namespacePrefixesIndex;
        int n2 = this.read();
        while ((n2 & 0xFC) == 204) {
            if (this._namespacePrefixesIndex == this._namespacePrefixes.length) {
                int[] nArray = new int[this._namespacePrefixesIndex * 3 / 2 + 1];
                System.arraycopy(this._namespacePrefixes, 0, nArray, 0, this._namespacePrefixesIndex);
                this._namespacePrefixes = nArray;
            }
            switch (n2 & 3) {
                case 0: {
                    string2 = "";
                    string = "";
                    this._namespacePrefixes[this._namespacePrefixesIndex++] = -1;
                    this._prefixIndex = -1;
                    this._namespaceNameIndex = -1;
                    break;
                }
                case 1: {
                    string = "";
                    string2 = this.decodeIdentifyingNonEmptyStringOnFirstBitAsNamespaceName(false);
                    this._namespacePrefixes[this._namespacePrefixesIndex++] = -1;
                    this._prefixIndex = -1;
                    break;
                }
                case 2: {
                    string = this.decodeIdentifyingNonEmptyStringOnFirstBitAsPrefix(false);
                    string2 = "";
                    this._namespaceNameIndex = -1;
                    this._namespacePrefixes[this._namespacePrefixesIndex++] = this._prefixIndex;
                    break;
                }
                case 3: {
                    string = this.decodeIdentifyingNonEmptyStringOnFirstBitAsPrefix(true);
                    string2 = this.decodeIdentifyingNonEmptyStringOnFirstBitAsNamespaceName(true);
                    this._namespacePrefixes[this._namespacePrefixesIndex++] = this._prefixIndex;
                }
            }
            this._prefixTable.pushScope(this._prefixIndex, this._namespaceNameIndex);
            if (this._namespacePrefixesFeature) {
                if (string != "") {
                    this._attributes.addAttribute(new QualifiedName("xmlns", "http://www.w3.org/2000/xmlns/", string), string2);
                } else {
                    this._attributes.addAttribute(EncodingConstants.DEFAULT_NAMESPACE_DECLARATION, string2);
                }
            }
            try {
                this._contentHandler.startPrefixMapping(string, string2);
            }
            catch (SAXException sAXException) {
                throw new IOException("processStartNamespaceAII");
            }
            n2 = this.read();
        }
        if (n2 != 240) {
            throw new IOException(CommonResourceBundle.getInstance().getString("message.EIInamespaceNameNotTerminatedCorrectly"));
        }
        int n3 = this._namespacePrefixesIndex;
        this._b = this.read();
        switch (DecoderStateTables.EII[this._b]) {
            case 0: {
                this.processEII(this._elementNameTable._array[this._b], bl);
                break;
            }
            case 2: {
                this.processEII(this.decodeEIIIndexMedium(), bl);
                break;
            }
            case 3: {
                this.processEII(this.decodeEIIIndexLarge(), bl);
                break;
            }
            case 5: {
                QualifiedName qualifiedName = this.decodeLiteralQualifiedName(this._b & 3, this._elementNameTable.getNext());
                this._elementNameTable.add(qualifiedName);
                this.processEII(qualifiedName, bl);
                break;
            }
            default: {
                throw new IOException(CommonResourceBundle.getInstance().getString("message.IllegalStateDecodingEIIAfterAIIs"));
            }
        }
        try {
            for (int i = n3 - 1; i >= n; --i) {
                int n4 = this._namespacePrefixes[i];
                this._prefixTable.popScope(n4);
                string = n4 > 0 ? this._prefixTable.get(n4 - 1) : (n4 == -1 ? "" : "xml");
                this._contentHandler.endPrefixMapping(string);
            }
            this._namespacePrefixesIndex = n;
        }
        catch (SAXException sAXException) {
            throw new IOException("processStartNamespaceAII");
        }
    }

    protected final void processAIIs() throws FastInfosetException, IOException {
        this._clearAttributes = true;
        if (++this._duplicateAttributeVerifier._currentIteration == Integer.MAX_VALUE) {
            this._duplicateAttributeVerifier.clear();
        }
        block22: do {
            boolean bl;
            QualifiedName qualifiedName;
            int n = this.read();
            switch (DecoderStateTables.AII[n]) {
                case 0: {
                    qualifiedName = this._attributeNameTable._array[n];
                    break;
                }
                case 1: {
                    bl = ((n & 0x1F) << 8 | this.read()) + 64;
                    qualifiedName = this._attributeNameTable._array[bl];
                    break;
                }
                case 2: {
                    bl = ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 8256;
                    qualifiedName = this._attributeNameTable._array[bl];
                    break;
                }
                case 3: {
                    qualifiedName = this.decodeLiteralQualifiedName(n & 3, this._attributeNameTable.getNext());
                    qualifiedName.createAttributeValues(256);
                    this._attributeNameTable.add(qualifiedName);
                    break;
                }
                case 5: {
                    this._doubleTerminate = true;
                }
                case 4: {
                    this._terminate = true;
                    continue block22;
                }
                default: {
                    throw new IOException(CommonResourceBundle.getInstance().getString("message.decodingAIIs"));
                }
            }
            if (qualifiedName.prefixIndex > 0 && this._prefixTable._currentInScope[qualifiedName.prefixIndex] != qualifiedName.namespaceNameIndex) {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.AIIqNameNotInScope"));
            }
            this._duplicateAttributeVerifier.checkForDuplicateAttribute(qualifiedName.attributeHash, qualifiedName.attributeId);
            n = this.read();
            switch (DecoderStateTables.NISTRING[n]) {
                case 0: {
                    this._octetBufferLength = (n & 7) + 1;
                    String string = this.decodeUtf8StringAsString();
                    if ((n & 0x40) > 0) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 1: {
                    this._octetBufferLength = this.read() + 9;
                    String string = this.decodeUtf8StringAsString();
                    if ((n & 0x40) > 0) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 2: {
                    this._octetBufferLength = (this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read()) + 265;
                    String string = this.decodeUtf8StringAsString();
                    if ((n & 0x40) > 0) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 3: {
                    this._octetBufferLength = (n & 7) + 1;
                    String string = this.decodeUtf16StringAsString();
                    if ((n & 0x40) > 0) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 4: {
                    this._octetBufferLength = this.read() + 9;
                    String string = this.decodeUtf16StringAsString();
                    if ((n & 0x40) > 0) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 5: {
                    this._octetBufferLength = (this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read()) + 265;
                    String string = this.decodeUtf16StringAsString();
                    if ((n & 0x40) > 0) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 6: {
                    bl = (n & 0x40) > 0;
                    this._identifier = (n & 0xF) << 4;
                    n = this.read();
                    this._identifier |= (n & 0xF0) >> 4;
                    this.decodeOctetsOnFifthBitOfNonIdentifyingStringOnFirstBit(n);
                    String string = this.decodeRestrictedAlphabetAsString();
                    if (bl) {
                        this._attributeValueTable.add(string);
                    }
                    this._attributes.addAttribute(qualifiedName, string);
                    break;
                }
                case 7: {
                    bl = (n & 0x40) > 0;
                    this._identifier = (n & 0xF) << 4;
                    n = this.read();
                    this._identifier |= (n & 0xF0) >> 4;
                    this.decodeOctetsOnFifthBitOfNonIdentifyingStringOnFirstBit(n);
                    this.processAIIEncodingAlgorithm(qualifiedName, bl);
                    break;
                }
                case 8: {
                    this._attributes.addAttribute(qualifiedName, this._attributeValueTable._array[n & 0x3F]);
                    break;
                }
                case 9: {
                    bl = ((n & 0x1F) << 8 | this.read()) + 64;
                    this._attributes.addAttribute(qualifiedName, this._attributeValueTable._array[bl]);
                    break;
                }
                case 10: {
                    bl = ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 8256;
                    this._attributes.addAttribute(qualifiedName, this._attributeValueTable._array[bl]);
                    break;
                }
                case 11: {
                    this._attributes.addAttribute(qualifiedName, "");
                    break;
                }
                default: {
                    throw new IOException(CommonResourceBundle.getInstance().getString("message.decodingAIIValue"));
                }
            }
        } while (!this._terminate);
        this._duplicateAttributeVerifier._poolCurrent = this._duplicateAttributeVerifier._poolHead;
        this._terminate = this._doubleTerminate;
        this._doubleTerminate = false;
    }

    protected final void processCommentII() throws FastInfosetException, IOException {
        switch (this.decodeNonIdentifyingStringOnFirstBit()) {
            case 0: {
                if (this._addToTable) {
                    this._v.otherString.add(new CharArray(this._charBuffer, 0, this._charBufferLength, true));
                }
                try {
                    this._lexicalHandler.comment(this._charBuffer, 0, this._charBufferLength);
                    break;
                }
                catch (SAXException sAXException) {
                    throw new FastInfosetException("processCommentII", sAXException);
                }
            }
            case 2: {
                throw new IOException(CommonResourceBundle.getInstance().getString("message.commentIIAlgorithmNotSupported"));
            }
            case 1: {
                CharArray charArray = this._v.otherString.get(this._integer);
                try {
                    this._lexicalHandler.comment(charArray.ch, charArray.start, charArray.length);
                    break;
                }
                catch (SAXException sAXException) {
                    throw new FastInfosetException("processCommentII", sAXException);
                }
            }
            case 3: {
                try {
                    this._lexicalHandler.comment(this._charBuffer, 0, 0);
                    break;
                }
                catch (SAXException sAXException) {
                    throw new FastInfosetException("processCommentII", sAXException);
                }
            }
        }
    }

    protected final void processProcessingII() throws FastInfosetException, IOException {
        String string = this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherNCName);
        switch (this.decodeNonIdentifyingStringOnFirstBit()) {
            case 0: {
                String string2 = new String(this._charBuffer, 0, this._charBufferLength);
                if (this._addToTable) {
                    this._v.otherString.add(new CharArrayString(string2));
                }
                try {
                    this._contentHandler.processingInstruction(string, string2);
                    break;
                }
                catch (SAXException sAXException) {
                    throw new FastInfosetException("processProcessingII", sAXException);
                }
            }
            case 2: {
                throw new IOException(CommonResourceBundle.getInstance().getString("message.processingIIWithEncodingAlgorithm"));
            }
            case 1: {
                try {
                    this._contentHandler.processingInstruction(string, this._v.otherString.get(this._integer).toString());
                    break;
                }
                catch (SAXException sAXException) {
                    throw new FastInfosetException("processProcessingII", sAXException);
                }
            }
            case 3: {
                try {
                    this._contentHandler.processingInstruction(string, "");
                    break;
                }
                catch (SAXException sAXException) {
                    throw new FastInfosetException("processProcessingII", sAXException);
                }
            }
        }
    }

    protected final void processCIIEncodingAlgorithm(boolean bl) throws FastInfosetException, IOException {
        if (this._identifier < 9) {
            Object object;
            if (this._primitiveHandler != null) {
                this.processCIIBuiltInEncodingAlgorithmAsPrimitive();
            } else {
                if (this._algorithmHandler != null) {
                    object = this.processBuiltInEncodingAlgorithmAsObject();
                    try {
                        this._algorithmHandler.object(null, this._identifier, object);
                    }
                    catch (SAXException sAXException) {
                        throw new FastInfosetException(sAXException);
                    }
                }
                object = new StringBuffer();
                this.processBuiltInEncodingAlgorithmAsCharacters((StringBuffer)object);
                try {
                    this._contentHandler.characters(((StringBuffer)object).toString().toCharArray(), 0, ((StringBuffer)object).length());
                }
                catch (SAXException sAXException) {
                    throw new FastInfosetException(sAXException);
                }
            }
            if (bl) {
                object = new StringBuffer();
                this.processBuiltInEncodingAlgorithmAsCharacters((StringBuffer)object);
                this._characterContentChunkTable.add(((StringBuffer)object).toString().toCharArray(), ((StringBuffer)object).length());
            }
        } else if (this._identifier == 9) {
            this._octetBufferOffset -= this._octetBufferLength;
            this.decodeUtf8StringIntoCharBuffer();
            try {
                this._lexicalHandler.startCDATA();
                this._contentHandler.characters(this._charBuffer, 0, this._charBufferLength);
                this._lexicalHandler.endCDATA();
            }
            catch (SAXException sAXException) {
                throw new FastInfosetException(sAXException);
            }
            if (bl) {
                this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
            }
        } else if (this._identifier >= 32 && this._algorithmHandler != null) {
            String string = this._v.encodingAlgorithm.get(this._identifier - 32);
            if (string == null) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.URINotPresent", new Object[]{this._identifier}));
            }
            EncodingAlgorithm encodingAlgorithm = (EncodingAlgorithm)this._registeredEncodingAlgorithms.get(string);
            if (encodingAlgorithm != null) {
                Object object = encodingAlgorithm.decodeFromBytes(this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
                try {
                    this._algorithmHandler.object(string, this._identifier, object);
                }
                catch (SAXException sAXException) {
                    throw new FastInfosetException(sAXException);
                }
            }
            try {
                this._algorithmHandler.octets(string, this._identifier, this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
            }
            catch (SAXException sAXException) {
                throw new FastInfosetException(sAXException);
            }
            if (bl) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.addToTableNotSupported"));
            }
        } else {
            if (this._identifier >= 32) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.algorithmDataCannotBeReported"));
            }
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.identifiers10to31Reserved"));
        }
    }

    protected final void processCIIBuiltInEncodingAlgorithmAsPrimitive() throws FastInfosetException, IOException {
        try {
            switch (this._identifier) {
                case 0: 
                case 1: {
                    this._primitiveHandler.bytes(this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
                    break;
                }
                case 2: {
                    int n = BuiltInEncodingAlgorithmFactory.shortEncodingAlgorithm.getPrimtiveLengthFromOctetLength(this._octetBufferLength);
                    if (n > this.builtInAlgorithmState.shortArray.length) {
                        short[] sArray = new short[n * 3 / 2 + 1];
                        System.arraycopy(this.builtInAlgorithmState.shortArray, 0, sArray, 0, this.builtInAlgorithmState.shortArray.length);
                        this.builtInAlgorithmState.shortArray = sArray;
                    }
                    BuiltInEncodingAlgorithmFactory.shortEncodingAlgorithm.decodeFromBytesToShortArray(this.builtInAlgorithmState.shortArray, 0, this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
                    this._primitiveHandler.shorts(this.builtInAlgorithmState.shortArray, 0, n);
                    break;
                }
                case 3: {
                    int n = BuiltInEncodingAlgorithmFactory.intEncodingAlgorithm.getPrimtiveLengthFromOctetLength(this._octetBufferLength);
                    if (n > this.builtInAlgorithmState.intArray.length) {
                        int[] nArray = new int[n * 3 / 2 + 1];
                        System.arraycopy(this.builtInAlgorithmState.intArray, 0, nArray, 0, this.builtInAlgorithmState.intArray.length);
                        this.builtInAlgorithmState.intArray = nArray;
                    }
                    BuiltInEncodingAlgorithmFactory.intEncodingAlgorithm.decodeFromBytesToIntArray(this.builtInAlgorithmState.intArray, 0, this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
                    this._primitiveHandler.ints(this.builtInAlgorithmState.intArray, 0, n);
                    break;
                }
                case 4: {
                    int n = BuiltInEncodingAlgorithmFactory.longEncodingAlgorithm.getPrimtiveLengthFromOctetLength(this._octetBufferLength);
                    if (n > this.builtInAlgorithmState.longArray.length) {
                        long[] lArray = new long[n * 3 / 2 + 1];
                        System.arraycopy(this.builtInAlgorithmState.longArray, 0, lArray, 0, this.builtInAlgorithmState.longArray.length);
                        this.builtInAlgorithmState.longArray = lArray;
                    }
                    BuiltInEncodingAlgorithmFactory.longEncodingAlgorithm.decodeFromBytesToLongArray(this.builtInAlgorithmState.longArray, 0, this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
                    this._primitiveHandler.longs(this.builtInAlgorithmState.longArray, 0, n);
                    break;
                }
                case 5: {
                    int n = BuiltInEncodingAlgorithmFactory.booleanEncodingAlgorithm.getPrimtiveLengthFromOctetLength(this._octetBufferLength, this._octetBuffer[this._octetBufferStart] & 0xFF);
                    if (n > this.builtInAlgorithmState.booleanArray.length) {
                        boolean[] blArray = new boolean[n * 3 / 2 + 1];
                        System.arraycopy(this.builtInAlgorithmState.booleanArray, 0, blArray, 0, this.builtInAlgorithmState.booleanArray.length);
                        this.builtInAlgorithmState.booleanArray = blArray;
                    }
                    BuiltInEncodingAlgorithmFactory.booleanEncodingAlgorithm.decodeFromBytesToBooleanArray(this.builtInAlgorithmState.booleanArray, 0, n, this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
                    this._primitiveHandler.booleans(this.builtInAlgorithmState.booleanArray, 0, n);
                    break;
                }
                case 6: {
                    int n = BuiltInEncodingAlgorithmFactory.floatEncodingAlgorithm.getPrimtiveLengthFromOctetLength(this._octetBufferLength);
                    if (n > this.builtInAlgorithmState.floatArray.length) {
                        float[] fArray = new float[n * 3 / 2 + 1];
                        System.arraycopy(this.builtInAlgorithmState.floatArray, 0, fArray, 0, this.builtInAlgorithmState.floatArray.length);
                        this.builtInAlgorithmState.floatArray = fArray;
                    }
                    BuiltInEncodingAlgorithmFactory.floatEncodingAlgorithm.decodeFromBytesToFloatArray(this.builtInAlgorithmState.floatArray, 0, this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
                    this._primitiveHandler.floats(this.builtInAlgorithmState.floatArray, 0, n);
                    break;
                }
                case 7: {
                    int n = BuiltInEncodingAlgorithmFactory.doubleEncodingAlgorithm.getPrimtiveLengthFromOctetLength(this._octetBufferLength);
                    if (n > this.builtInAlgorithmState.doubleArray.length) {
                        double[] dArray = new double[n * 3 / 2 + 1];
                        System.arraycopy(this.builtInAlgorithmState.doubleArray, 0, dArray, 0, this.builtInAlgorithmState.doubleArray.length);
                        this.builtInAlgorithmState.doubleArray = dArray;
                    }
                    BuiltInEncodingAlgorithmFactory.doubleEncodingAlgorithm.decodeFromBytesToDoubleArray(this.builtInAlgorithmState.doubleArray, 0, this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
                    this._primitiveHandler.doubles(this.builtInAlgorithmState.doubleArray, 0, n);
                    break;
                }
                case 8: {
                    int n = BuiltInEncodingAlgorithmFactory.uuidEncodingAlgorithm.getPrimtiveLengthFromOctetLength(this._octetBufferLength);
                    if (n > this.builtInAlgorithmState.longArray.length) {
                        long[] lArray = new long[n * 3 / 2 + 1];
                        System.arraycopy(this.builtInAlgorithmState.longArray, 0, lArray, 0, this.builtInAlgorithmState.longArray.length);
                        this.builtInAlgorithmState.longArray = lArray;
                    }
                    BuiltInEncodingAlgorithmFactory.uuidEncodingAlgorithm.decodeFromBytesToLongArray(this.builtInAlgorithmState.longArray, 0, this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
                    this._primitiveHandler.uuids(this.builtInAlgorithmState.longArray, 0, n);
                    break;
                }
                case 9: {
                    throw new UnsupportedOperationException("CDATA");
                }
                default: {
                    throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.unsupportedAlgorithm", new Object[]{this._identifier}));
                }
            }
        }
        catch (SAXException sAXException) {
            throw new FastInfosetException(sAXException);
        }
    }

    protected final void processAIIEncodingAlgorithm(QualifiedName qualifiedName, boolean bl) throws FastInfosetException, IOException {
        if (this._identifier < 9) {
            if (this._primitiveHandler != null || this._algorithmHandler != null) {
                Object object = this.processBuiltInEncodingAlgorithmAsObject();
                this._attributes.addAttributeWithAlgorithmData(qualifiedName, null, this._identifier, object);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                this.processBuiltInEncodingAlgorithmAsCharacters(stringBuffer);
                this._attributes.addAttribute(qualifiedName, stringBuffer.toString());
            }
        } else if (this._identifier >= 32 && this._algorithmHandler != null) {
            String string = this._v.encodingAlgorithm.get(this._identifier - 32);
            if (string == null) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.URINotPresent", new Object[]{this._identifier}));
            }
            EncodingAlgorithm encodingAlgorithm = (EncodingAlgorithm)this._registeredEncodingAlgorithms.get(string);
            if (encodingAlgorithm != null) {
                Object object = encodingAlgorithm.decodeFromBytes(this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
                this._attributes.addAttributeWithAlgorithmData(qualifiedName, string, this._identifier, object);
            } else {
                byte[] byArray = new byte[this._octetBufferLength];
                System.arraycopy(this._octetBuffer, this._octetBufferStart, byArray, 0, this._octetBufferLength);
                this._attributes.addAttributeWithAlgorithmData(qualifiedName, string, this._identifier, byArray);
            }
        } else {
            if (this._identifier >= 32) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.algorithmDataCannotBeReported"));
            }
            if (this._identifier == 9) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.CDATAAlgorithmNotSupported"));
            }
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.identifiers10to31Reserved"));
        }
        if (bl) {
            this._attributeValueTable.add(this._attributes.getValue(this._attributes.getIndex(qualifiedName.qName)));
        }
    }

    protected final void processBuiltInEncodingAlgorithmAsCharacters(StringBuffer stringBuffer) throws FastInfosetException, IOException {
        Object object = BuiltInEncodingAlgorithmFactory.getAlgorithm(this._identifier).decodeFromBytes(this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
        BuiltInEncodingAlgorithmFactory.getAlgorithm(this._identifier).convertToCharacters(object, stringBuffer);
    }

    protected final Object processBuiltInEncodingAlgorithmAsObject() throws FastInfosetException, IOException {
        return BuiltInEncodingAlgorithmFactory.getAlgorithm(this._identifier).decodeFromBytes(this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
    }

    private static final class DeclHandlerImpl
    implements DeclHandler {
        private DeclHandlerImpl() {
        }

        public void elementDecl(String string, String string2) throws SAXException {
        }

        public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        }

        public void internalEntityDecl(String string, String string2) throws SAXException {
        }

        public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        }
    }

    private static final class LexicalHandlerImpl
    implements LexicalHandler {
        private LexicalHandlerImpl() {
        }

        public void comment(char[] cArray, int n, int n2) {
        }

        public void startDTD(String string, String string2, String string3) {
        }

        public void endDTD() {
        }

        public void startEntity(String string) {
        }

        public void endEntity(String string) {
        }

        public void startCDATA() {
        }

        public void endCDATA() {
        }
    }
}

