/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sf.portecle.version.VersionException;

public class Version
implements Comparable<Version>,
Serializable {
    private int[] iSections;

    public Version(String string) throws VersionException {
        this(string, ".");
    }

    public Version(String string, String string2) throws VersionException {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
                if (n < 0) {
                    throw new VersionException();
                }
                arrayList.add(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new VersionException(numberFormatException);
            }
        }
        if (arrayList.size() == 0) {
            this.iSections = new int[]{0};
        } else {
            this.iSections = new int[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                this.iSections[n] = Math.abs((Integer)arrayList.get(n));
            }
        }
    }

    private int[] getSections() {
        return (int[])this.iSections.clone();
    }

    @Override
    public int compareTo(Version version) {
        int n;
        int[] nArray = version.getSections();
        for (n = 0; n < this.iSections.length && n < nArray.length; ++n) {
            if (this.iSections[n] > nArray[n]) {
                return 1;
            }
            if (this.iSections[n] >= nArray[n]) continue;
            return -1;
        }
        if (nArray.length > this.iSections.length) {
            for (n = this.iSections.length; n < nArray.length; ++n) {
                if (nArray[n] == 0) continue;
                return -1;
            }
        }
        if (this.iSections.length > nArray.length) {
            for (n = nArray.length; n < this.iSections.length; ++n) {
                if (this.iSections[n] == 0) continue;
                return 1;
            }
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)object) == 0;
    }

    public int hashCode() {
        int n = 27;
        for (int i = 0; i < this.iSections.length; ++i) {
            n = 53 * n + this.iSections[i];
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.iSections.length; ++i) {
            stringBuilder.append(this.iSections[i]);
            if (i + 1 >= this.iSections.length) continue;
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }
}

