/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.version;

import java.util.StringTokenizer;
import net.sf.portecle.version.VersionException;

public class JavaVersion
implements Comparable<JavaVersion> {
    private String m_sJavaVersion;
    private int m_iMajor;
    private int m_iMiddle;
    private int m_iMinor;
    private int m_iUpdate;
    private String m_sIdentifier;
    private static final char VERSION_DELIMITER = '.';
    private static final char START_UPDATE = '_';
    private static final char START_IDENTIFIER = '-';

    public JavaVersion() throws VersionException {
        this(System.getProperty("java.version"));
    }

    public JavaVersion(String string) throws VersionException {
        this.m_sJavaVersion = string;
        int n = this.m_sJavaVersion.indexOf(95);
        int n2 = this.m_sJavaVersion.indexOf(45);
        String string2 = null;
        String string3 = "0";
        String string4 = null;
        if (n == -1 && n2 == -1) {
            string2 = this.m_sJavaVersion;
        } else if (n != -1 && n2 == -1) {
            string2 = this.m_sJavaVersion.substring(0, n);
            string3 = this.m_sJavaVersion.substring(n + 1);
        } else if (n == -1 && n2 != -1) {
            string2 = this.m_sJavaVersion.substring(0, n2);
            string4 = this.m_sJavaVersion.substring(n2 + 1);
        } else {
            string2 = this.m_sJavaVersion.substring(0, n);
            string3 = this.m_sJavaVersion.substring(n + 1, n2);
            string4 = this.m_sJavaVersion.substring(n2 + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        if (stringTokenizer.countTokens() != 3) {
            throw new VersionException();
        }
        String string5 = stringTokenizer.nextToken();
        try {
            this.m_iMajor = Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersionException(numberFormatException);
        }
        if (this.m_iMajor < 0) {
            throw new VersionException();
        }
        String string6 = stringTokenizer.nextToken();
        try {
            this.m_iMiddle = Integer.parseInt(string6);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersionException(numberFormatException);
        }
        if (this.m_iMiddle < 0) {
            throw new VersionException();
        }
        String string7 = stringTokenizer.nextToken();
        try {
            this.m_iMinor = Integer.parseInt(string7);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersionException(numberFormatException);
        }
        if (this.m_iMinor < 0) {
            throw new VersionException();
        }
        try {
            this.m_iUpdate = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersionException(numberFormatException);
        }
        if (this.m_iUpdate < 0) {
            throw new VersionException();
        }
        this.m_sIdentifier = string4;
    }

    public int getMajor() {
        return this.m_iMajor;
    }

    public int getMiddle() {
        return this.m_iMiddle;
    }

    public int getMinor() {
        return this.m_iMinor;
    }

    public int getUpdate() {
        return this.m_iUpdate;
    }

    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public int compareTo(JavaVersion javaVersion) {
        if (this.m_iMajor > javaVersion.getMajor()) {
            return 1;
        }
        if (this.m_iMajor < javaVersion.getMajor()) {
            return -1;
        }
        if (this.m_iMiddle > javaVersion.getMiddle()) {
            return 1;
        }
        if (this.m_iMiddle < javaVersion.getMiddle()) {
            return -1;
        }
        if (this.m_iMinor > javaVersion.getMinor()) {
            return 1;
        }
        if (this.m_iMinor < javaVersion.getMinor()) {
            return -1;
        }
        if (this.m_iUpdate > javaVersion.getUpdate()) {
            return 1;
        }
        if (this.m_iUpdate < javaVersion.getUpdate()) {
            return -1;
        }
        String string = javaVersion.getIdentifier();
        if (this.m_sIdentifier == null && string != null) {
            return 1;
        }
        if (this.m_sIdentifier != null && string == null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JavaVersion)) {
            return false;
        }
        return this.compareTo((JavaVersion)object) == 0;
    }

    public int hashCode() {
        int n = 27;
        n = 53 * n + this.m_iMajor;
        n = 53 * n + this.m_iMiddle;
        n = 53 * n + this.m_iMinor;
        n = 53 * n + this.m_iUpdate;
        return 53 * n + (this.m_sIdentifier == null ? 0 : 1);
    }

    public String toString() {
        return this.m_sJavaVersion;
    }
}

