/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.gui.help;

import java.net.URL;
import java.util.LinkedList;
import java.util.Vector;
import net.sf.portecle.gui.help.HistoryEvent;
import net.sf.portecle.gui.help.HistoryEventListener;

public class History {
    private Vector<URL> m_vHistory = new Vector();
    private int m_iCurrent;
    private boolean m_bForward;
    private boolean m_bBack;
    private LinkedList<HistoryEventListener> listeners;

    public History(URL uRL) {
        this.m_vHistory.add(uRL);
        this.m_iCurrent = 0;
        this.m_bForward = false;
        this.m_bBack = false;
    }

    public void clear() {
        URL uRL = this.m_vHistory.get(0);
        this.m_vHistory.clear();
        this.m_vHistory.add(uRL);
        this.m_iCurrent = 0;
        this.m_bForward = false;
        this.m_bBack = false;
        this.fireHistoryEvent();
    }

    public void visit(URL uRL) {
        if (uRL.toExternalForm().equals(this.m_vHistory.get(this.m_iCurrent).toExternalForm())) {
            return;
        }
        if (!this.m_bForward) {
            this.m_vHistory.add(uRL);
            ++this.m_iCurrent;
        } else {
            int n = this.m_vHistory.size() - (this.m_iCurrent + 1);
            for (int i = 0; i < n; ++i) {
                this.m_vHistory.remove(this.m_vHistory.size() - 1);
            }
            this.m_vHistory.add(uRL);
            ++this.m_iCurrent;
        }
        this.m_bBack = this.m_iCurrent != 0;
        this.m_bForward = this.m_iCurrent + 1 != this.m_vHistory.size();
        this.fireHistoryEvent();
    }

    public URL goBack() {
        if (!this.m_bBack) {
            return null;
        }
        URL uRL = this.m_vHistory.get(--this.m_iCurrent);
        if (this.m_iCurrent == 0) {
            this.m_bBack = false;
            this.m_bForward = true;
            this.fireHistoryEvent();
        } else if (!this.m_bForward) {
            this.m_bForward = true;
            this.fireHistoryEvent();
        }
        return uRL;
    }

    public URL goForward() {
        if (!this.m_bForward) {
            return null;
        }
        URL uRL = this.m_vHistory.get(++this.m_iCurrent);
        if (this.m_iCurrent == this.m_vHistory.size() - 1) {
            this.m_bForward = false;
            this.m_bBack = true;
            this.fireHistoryEvent();
        } else if (!this.m_bBack) {
            this.m_bBack = true;
            this.fireHistoryEvent();
        }
        return uRL;
    }

    public synchronized void addHistoryEventListener(HistoryEventListener historyEventListener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        this.listeners.add(historyEventListener);
    }

    public synchronized void removeHistoryEventListener(HistoryEventListener historyEventListener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        } else {
            this.listeners.remove(historyEventListener);
        }
    }

    protected synchronized void fireHistoryEvent() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            HistoryEvent historyEvent = new HistoryEvent(this, this.m_bBack, this.m_bForward);
            for (HistoryEventListener historyEventListener : this.listeners) {
                historyEventListener.historyStatusChanged(historyEvent);
            }
        }
    }
}

