/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.gui.crypto;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.portecle.FPortecle;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.gui.crypto.ProviderTreeCellRend;

public class DProviderInfo
extends PortecleJDialog {
    public DProviderInfo(Window window) {
        super(window, true);
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        JButton jButton = this.getOkButton(true);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(FPortecle.RB.getString("DProviderInfo.jbCopy.text"));
        jButton2.setMnemonic(FPortecle.RB.getString("DProviderInfo.jbCopy.mnemonic").charAt(0));
        jButton2.setToolTipText(FPortecle.RB.getString("DProviderInfo.jbCopy.tooltip"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DProviderInfo.this.copyPressed();
            }
        });
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        JTree jTree = new JTree(this.createProviderNodes());
        jTree.setRowHeight(18);
        jTree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(jTree);
        jTree.setCellRenderer(new ProviderTreeCellRend());
        JScrollPane jScrollPane = new JScrollPane(jTree, 22, 32);
        jScrollPane.setPreferredSize(new Dimension(350, 200));
        jPanel2.add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.setTitle(FPortecle.RB.getString("DProviderInfo.Title"));
        this.getRootPane().setDefaultButton(jButton);
        this.initDialog();
        this.setResizable(true);
        jButton.requestFocusInWindow();
    }

    private DefaultMutableTreeNode createProviderNodes() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(FPortecle.RB.getString("DProviderInfo.TopNodeName"));
        for (Provider provider : Security.getProviders()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(provider.getName());
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(provider.getInfo()));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("" + provider.getVersion()));
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(FPortecle.RB.getString("DProviderInfo.ProviderProperties"));
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            for (Object object : new TreeSet<Object>(provider.keySet())) {
                String string = String.valueOf(object);
                String string2 = provider.getProperty(string);
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(MessageFormat.format(FPortecle.RB.getString("DProviderInfo.ProviderProperty"), string, string2)));
            }
        }
        return defaultMutableTreeNode;
    }

    private void copyPressed() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Provider provider : Security.getProviders()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DProviderInfo.Copy.ProviderName"), provider.getName()));
            stringBuilder.append('\n');
            stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DProviderInfo.Copy.ProviderVersion"), provider.getVersion()));
            stringBuilder.append('\n');
            stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DProviderInfo.Copy.ProviderDescription"), provider.getInfo()));
            stringBuilder.append('\n');
            stringBuilder.append(FPortecle.RB.getString("DProviderInfo.Copy.ProviderProperties"));
            stringBuilder.append('\n');
            for (Object object : new TreeSet<Object>(provider.keySet())) {
                String string = String.valueOf(object);
                String string2 = provider.getProperty(string);
                stringBuilder.append('\t');
                stringBuilder.append(string);
                stringBuilder.append('=');
                stringBuilder.append(string2);
                stringBuilder.append('\n');
            }
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }
}

