/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.gui;

import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sf.portecle.FPortecle;

public final class SwingHelper {
    private SwingHelper() {
    }

    public static void showAndWait(final Window window) {
        if (SwingUtilities.isEventDispatchThread()) {
            window.setVisible(true);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        window.setVisible(true);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                FPortecle.LOG.log(Level.WARNING, "Error setting window visible", interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                FPortecle.LOG.log(Level.WARNING, "Error setting window visible", invocationTargetException);
            }
        }
    }

    public static void selectAndFocus(JComponent jComponent) {
        Component component;
        JTextComponent jTextComponent = null;
        if (jComponent instanceof JTextComponent) {
            jTextComponent = (JTextComponent)jComponent;
        }
        if (jComponent instanceof JComboBox && (component = ((JComboBox)jComponent).getEditor().getEditorComponent()) instanceof JTextComponent) {
            jTextComponent = (JTextComponent)component;
        }
        if (jTextComponent != null) {
            jTextComponent.select(0, jTextComponent.getText().length());
        }
        jComponent.requestFocusInWindow();
    }

    public static int showConfirmDialog(Component component, Object object, String string) {
        Object[] objectArray = new String[]{"Yes", "No"};
        return JOptionPane.showOptionDialog(component, object, string, 0, 3, null, objectArray, objectArray[1]);
    }
}

