/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.crypto;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import net.sf.portecle.FPortecle;
import net.sf.portecle.NetUtil;
import net.sf.portecle.crypto.CryptoException;
import net.sf.portecle.crypto.NameUtil;
import net.sf.portecle.crypto.SignatureType;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordException;
import org.bouncycastle.x509.X509V1CertificateGenerator;

public final class X509CertUtil {
    private static final Logger LOG = Logger.getLogger(X509CertUtil.class.getCanonicalName());
    private static final String PKCS7_ENCODING = "PKCS7";
    private static final String PKIPATH_ENCODING = "PkiPath";
    private static final String OPENSSL_PEM_ENCODING = "OpenSSL_PEM";
    private static final String X509_CERT_TYPE = "X.509";

    private X509CertUtil() {
    }

    public static X509Certificate[] loadCertificates(URL uRL, Collection<Exception> collection) throws IOException {
        URL uRL2 = NetUtil.download(uRL);
        X509Certificate[] x509CertificateArray = null;
        for (String string : new String[]{PKCS7_ENCODING, PKIPATH_ENCODING, null, OPENSSL_PEM_ENCODING}) {
            try {
                x509CertificateArray = X509CertUtil.loadCertificates(uRL2, string);
                break;
            }
            catch (FileNotFoundException fileNotFoundException) {
                collection.add(fileNotFoundException);
                break;
            }
            catch (Exception exception) {
                collection.add(exception);
            }
        }
        return x509CertificateArray;
    }

    private static X509Certificate[] loadCertificates(URL uRL, String string) throws CryptoException, IOException {
        Collection<? extends Certificate> collection;
        block13: {
            InputStream inputStream = NetUtil.openGetStream(uRL);
            try {
                Object object;
                if (OPENSSL_PEM_ENCODING.equals(string)) {
                    object = new PEMReader(new InputStreamReader(inputStream));
                    collection = new ArrayList<Certificate>();
                    while (true) {
                        Object object2;
                        try {
                            object2 = ((PEMReader)object).readObject();
                        }
                        catch (IOException iOException) {
                            if (iOException instanceof PasswordException) continue;
                            throw iOException;
                        }
                        if (object2 == null) break;
                        if (!(object2 instanceof X509Certificate)) continue;
                        collection.add((Certificate)object2);
                    }
                    ((BufferedReader)object).close();
                    break block13;
                }
                object = CertificateFactory.getInstance(X509_CERT_TYPE);
                collection = string != null ? ((CertificateFactory)object).generateCertPath(inputStream, string).getCertificates() : ((CertificateFactory)object).generateCertificates(inputStream);
            }
            catch (Exception exception) {
                throw new CryptoException(FPortecle.RB.getString("NoLoadCertificate.exception.message"), exception);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "Could not close input stream from " + uRL, iOException);
                }
            }
        }
        return collection.toArray(new X509Certificate[collection.size()]);
    }

    public static X509CRL loadCRL(URL uRL) throws CryptoException, IOException {
        InputStream inputStream = NetUtil.openGetStream(uRL);
        try {
            X509CRL x509CRL;
            CertificateFactory certificateFactory = CertificateFactory.getInstance(X509_CERT_TYPE);
            X509CRL x509CRL2 = x509CRL = (X509CRL)certificateFactory.generateCRL(inputStream);
            return x509CRL2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(FPortecle.RB.getString("NoLoadCrl.exception.message"), generalSecurityException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Could not close input stream from " + uRL, iOException);
            }
        }
    }

    public static PKCS10CertificationRequest loadCSR(URL uRL) throws CryptoException, IOException {
        PEMReader pEMReader = new PEMReader(new InputStreamReader(NetUtil.openGetStream(uRL)));
        try {
            PKCS10CertificationRequest pKCS10CertificationRequest = (PKCS10CertificationRequest)pEMReader.readObject();
            if (!pKCS10CertificationRequest.verify()) {
                throw new CryptoException(FPortecle.RB.getString("NoVerifyCsr.exception.message"));
            }
            PKCS10CertificationRequest pKCS10CertificationRequest2 = pKCS10CertificationRequest;
            return pKCS10CertificationRequest2;
        }
        catch (ClassCastException classCastException) {
            throw new CryptoException(FPortecle.RB.getString("NoLoadCsr.exception.message"), classCastException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(FPortecle.RB.getString("NoLoadCsr.exception.message"), generalSecurityException);
        }
        finally {
            try {
                pEMReader.close();
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Could not close input stream from " + uRL, iOException);
            }
        }
    }

    public static X509Certificate[] convertCertificates(Certificate[] certificateArray) throws CryptoException {
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            x509CertificateArray[i] = X509CertUtil.convertCertificate(certificateArray[i]);
        }
        return x509CertificateArray;
    }

    public static X509Certificate convertCertificate(Certificate certificate) throws CryptoException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(X509_CERT_TYPE);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certificate.getEncoded());
            return (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            throw new CryptoException(FPortecle.RB.getString("NoConvertCertificate.exception.message"), certificateException);
        }
    }

    public static X509Certificate[] orderX509CertChain(X509Certificate[] x509CertificateArray) {
        int n;
        int n2 = 0;
        X509Certificate[] x509CertificateArray2 = (X509Certificate[])x509CertificateArray.clone();
        X509Certificate[] x509CertificateArray3 = new X509Certificate[x509CertificateArray.length];
        X509Certificate x509Certificate = null;
        for (X509Certificate x509Certificate2 : x509CertificateArray2) {
            if (!((Object)x509Certificate2.getIssuerDN()).equals(x509Certificate2.getSubjectDN())) continue;
            x509CertificateArray3[n2] = x509Certificate = x509Certificate2;
            ++n2;
        }
        if (x509Certificate == null) {
            return x509CertificateArray;
        }
        block1: do {
            n = 0;
            for (X509Certificate x509Certificate3 : x509CertificateArray2) {
                if (!((Object)x509Certificate3.getIssuerDN()).equals(x509Certificate.getSubjectDN()) || x509Certificate3 == x509Certificate) continue;
                x509CertificateArray3[n2] = x509Certificate = x509Certificate3;
                ++n2;
                n = 1;
                continue block1;
            }
        } while (n != 0);
        x509CertificateArray2 = new X509Certificate[n2];
        System.arraycopy(x509CertificateArray3, 0, x509CertificateArray2, 0, n2);
        x509CertificateArray3 = new X509Certificate[n2];
        for (n = 0; n < n2; ++n) {
            x509CertificateArray3[n] = x509CertificateArray2[x509CertificateArray2.length - 1 - n];
        }
        return x509CertificateArray3;
    }

    public static byte[] getCertEncodedDer(X509Certificate x509Certificate) throws CryptoException {
        try {
            return x509Certificate.getEncoded();
        }
        catch (CertificateException certificateException) {
            throw new CryptoException(FPortecle.RB.getString("NoDerEncode.exception.message"), certificateException);
        }
    }

    public static byte[] getCertEncodedPkcs7(X509Certificate x509Certificate) throws CryptoException {
        return X509CertUtil.getCertsEncodedPkcs7(new X509Certificate[]{x509Certificate});
    }

    public static byte[] getCertsEncodedPkcs7(X509Certificate[] x509CertificateArray) throws CryptoException {
        return X509CertUtil.getCertsEncoded(x509CertificateArray, PKCS7_ENCODING, "NoPkcs7Encode.exception.message");
    }

    public static byte[] getCertEncodedPkiPath(X509Certificate x509Certificate) throws CryptoException {
        return X509CertUtil.getCertsEncodedPkiPath(new X509Certificate[]{x509Certificate});
    }

    public static byte[] getCertsEncodedPkiPath(X509Certificate[] x509CertificateArray) throws CryptoException {
        return X509CertUtil.getCertsEncoded(x509CertificateArray, PKIPATH_ENCODING, "NoPkiPathEncode.exception.message");
    }

    private static byte[] getCertsEncoded(X509Certificate[] x509CertificateArray, String string, String string2) throws CryptoException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(X509_CERT_TYPE);
            return certificateFactory.generateCertPath(Arrays.asList(x509CertificateArray)).getEncoded(string);
        }
        catch (CertificateException certificateException) {
            throw new CryptoException(FPortecle.RB.getString(string2), certificateException);
        }
    }

    public static X509Certificate generateCert(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, PublicKey publicKey, PrivateKey privateKey, SignatureType signatureType) throws CryptoException {
        Hashtable<DERObjectIdentifier, String> hashtable = new Hashtable<DERObjectIdentifier, String>();
        Vector<DERObjectIdentifier> vector = new Vector<DERObjectIdentifier>();
        if (string != null) {
            hashtable.put(X509Name.CN, string);
            vector.add(0, X509Name.CN);
        }
        if (string2 != null) {
            hashtable.put(X509Name.OU, string2);
            vector.add(0, X509Name.OU);
        }
        if (string3 != null) {
            hashtable.put(X509Name.O, string3);
            vector.add(0, X509Name.O);
        }
        if (string4 != null) {
            hashtable.put(X509Name.L, string4);
            vector.add(0, X509Name.L);
        }
        if (string5 != null) {
            hashtable.put(X509Name.ST, string5);
            vector.add(0, X509Name.ST);
        }
        if (string6 != null) {
            hashtable.put(X509Name.C, string6);
            vector.add(0, X509Name.C);
        }
        if (string7 != null) {
            hashtable.put(X509Name.E, string7);
            vector.add(0, X509Name.E);
        }
        X509V1CertificateGenerator x509V1CertificateGenerator = new X509V1CertificateGenerator();
        x509V1CertificateGenerator.setIssuerDN(new X509Principal(vector, hashtable));
        x509V1CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis()));
        x509V1CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + (long)n * 24L * 60L * 60L * 1000L));
        x509V1CertificateGenerator.setSubjectDN(new X509Principal(vector, hashtable));
        x509V1CertificateGenerator.setPublicKey(publicKey);
        x509V1CertificateGenerator.setSignatureAlgorithm(signatureType.name());
        x509V1CertificateGenerator.setSerialNumber(X509CertUtil.generateX509SerialNumber());
        try {
            return x509V1CertificateGenerator.generate(privateKey, "BC");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(FPortecle.RB.getString("CertificateGenFailed.exception.message"), generalSecurityException);
        }
    }

    public static X509Certificate renewCert(X509Certificate x509Certificate, int n, PublicKey publicKey, PrivateKey privateKey) throws CryptoException {
        X509V1CertificateGenerator x509V1CertificateGenerator = new X509V1CertificateGenerator();
        Date date = new Date();
        Date date2 = x509Certificate.getNotAfter();
        if (date2 == null || date2.before(date)) {
            date2 = date;
        }
        x509V1CertificateGenerator.setNotBefore(date);
        x509V1CertificateGenerator.setNotAfter(new Date(date2.getTime() + (long)n * 24L * 60L * 60L * 1000L));
        x509V1CertificateGenerator.setPublicKey(publicKey);
        x509V1CertificateGenerator.setSignatureAlgorithm(x509Certificate.getSigAlgName());
        x509V1CertificateGenerator.setSerialNumber(X509CertUtil.generateX509SerialNumber());
        try {
            x509V1CertificateGenerator.setIssuerDN(PrincipalUtil.getIssuerX509Principal(x509Certificate));
            x509V1CertificateGenerator.setSubjectDN(PrincipalUtil.getSubjectX509Principal(x509Certificate));
            return x509V1CertificateGenerator.generate(privateKey, "BC");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(FPortecle.RB.getString("CertificateGenFailed.exception.message"), generalSecurityException);
        }
    }

    private static BigInteger generateX509SerialNumber() {
        return new BigInteger(Long.toString(System.currentTimeMillis() / 1000L));
    }

    public static PKCS10CertificationRequest generatePKCS10CSR(X509Certificate x509Certificate, PrivateKey privateKey) throws CryptoException {
        X509Name x509Name = new X509Name(((Object)x509Certificate.getSubjectDN()).toString());
        try {
            PKCS10CertificationRequest pKCS10CertificationRequest = new PKCS10CertificationRequest(x509Certificate.getSigAlgName(), x509Name, x509Certificate.getPublicKey(), null, privateKey);
            if (!pKCS10CertificationRequest.verify()) {
                throw new CryptoException(FPortecle.RB.getString("NoVerifyGenCsr.exception.message"));
            }
            return pKCS10CertificationRequest;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(FPortecle.RB.getString("NoGenerateCsr.exception.message"), generalSecurityException);
        }
    }

    public static boolean verifyCertificate(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws CryptoException {
        try {
            x509Certificate.verify(x509Certificate2.getPublicKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (SignatureException signatureException) {
            return false;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(FPortecle.RB.getString("NoVerifyCertificate.exception.message"), generalSecurityException);
        }
        return true;
    }

    public static X509Certificate[] establishTrust(KeyStore[] keyStoreArray, X509Certificate x509Certificate) throws CryptoException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (KeyStore keyStore : keyStoreArray) {
            arrayList.addAll(X509CertUtil.extractCertificates(keyStore));
        }
        return X509CertUtil.establishTrust(arrayList, x509Certificate);
    }

    private static X509Certificate[] establishTrust(List<X509Certificate> list, X509Certificate x509Certificate) throws CryptoException {
        for (X509Certificate x509Certificate2 : list) {
            if (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate2.getSubjectDN()) || !X509CertUtil.verifyCertificate(x509Certificate, x509Certificate2)) continue;
            if (((Object)x509Certificate2.getSubjectDN()).equals(x509Certificate2.getIssuerDN())) {
                return new X509Certificate[]{x509Certificate, x509Certificate2};
            }
            X509Certificate[] x509CertificateArray = X509CertUtil.establishTrust(list, x509Certificate2);
            if (x509CertificateArray == null) continue;
            X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length + 1];
            x509CertificateArray2[0] = x509Certificate;
            System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 1, x509CertificateArray.length);
            return x509CertificateArray2;
        }
        return null;
    }

    private static Collection<X509Certificate> extractCertificates(KeyStore keyStore) throws CryptoException {
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!keyStore.isCertificateEntry(string)) continue;
                arrayList.add(X509CertUtil.convertCertificate(keyStore.getCertificate(string)));
            }
            return arrayList;
        }
        catch (KeyStoreException keyStoreException) {
            throw new CryptoException(FPortecle.RB.getString("NoExtractCertificates.exception.message"), keyStoreException);
        }
    }

    public static String matchCertificate(KeyStore keyStore, X509Certificate x509Certificate) throws CryptoException {
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                X509Certificate x509Certificate2;
                String string = enumeration.nextElement();
                if (!keyStore.isCertificateEntry(string) || !x509Certificate.equals(x509Certificate2 = X509CertUtil.convertCertificate(keyStore.getCertificate(string)))) continue;
                return string;
            }
            return null;
        }
        catch (KeyStoreException keyStoreException) {
            throw new CryptoException(FPortecle.RB.getString("NoMatchCertificate.exception.message"), keyStoreException);
        }
    }

    public static String getCertificateAlias(X509Certificate x509Certificate) {
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
        String string = NameUtil.getCommonName(x500Principal);
        if (string == null) {
            return "";
        }
        String string2 = NameUtil.getCommonName(x500Principal2);
        if (x500Principal.equals(x500Principal2) || string2 == null) {
            return string;
        }
        return MessageFormat.format("{0} ({1})", string, string2);
    }
}

