/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.crypto;

import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.X509Name;

public final class NameUtil {
    private NameUtil() {
    }

    public static String getCommonName(X509Name x509Name) {
        if (x509Name == null) {
            return null;
        }
        Vector vector = x509Name.getValues(X509Name.CN);
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        return vector.get(0).toString();
    }

    public static String getCommonName(X500Principal x500Principal) {
        if (x500Principal == null) {
            return null;
        }
        return NameUtil.getCommonName(new X509Name(x500Principal.getName()));
    }
}

