/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.crypto;

import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.crypto.interfaces.DHKey;
import net.sf.portecle.FPortecle;
import net.sf.portecle.crypto.CryptoException;
import net.sf.portecle.crypto.KeyPairType;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DHKeyParameters;
import org.bouncycastle.crypto.params.DSAKeyParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public final class KeyPairUtil {
    private static final Logger LOG = Logger.getLogger(KeyPairUtil.class.getName());
    public static final int UNKNOWN_KEY_SIZE = -1;

    private KeyPairUtil() {
    }

    public static KeyPair generateKeyPair(KeyPairType keyPairType, int n) throws CryptoException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(keyPairType.name());
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            keyPairGenerator.initialize(n, secureRandom);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoException(MessageFormat.format(FPortecle.RB.getString("NoGenerateKeypair.exception.message"), new Object[]{keyPairType}), noSuchAlgorithmException);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new CryptoException(MessageFormat.format(FPortecle.RB.getString("NoGenerateKeypairParm.exception.message"), new Object[]{keyPairType}), invalidParameterException);
        }
    }

    public static int getKeyLength(PublicKey publicKey) {
        if (publicKey instanceof RSAKey) {
            return ((RSAKey)((Object)publicKey)).getModulus().bitLength();
        }
        if (publicKey instanceof DSAKey) {
            return ((DSAKey)((Object)publicKey)).getParams().getP().bitLength();
        }
        if (publicKey instanceof DHKey) {
            return ((DHKey)((Object)publicKey)).getParams().getP().bitLength();
        }
        if (publicKey instanceof ECKey) {
            return -1;
        }
        LOG.warning("Don't know how to get key size from key " + publicKey);
        return -1;
    }

    public static int getKeyLength(AsymmetricKeyParameter asymmetricKeyParameter) {
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            return ((RSAKeyParameters)asymmetricKeyParameter).getModulus().bitLength();
        }
        if (asymmetricKeyParameter instanceof DSAKeyParameters) {
            return ((DSAKeyParameters)asymmetricKeyParameter).getParameters().getP().bitLength();
        }
        if (asymmetricKeyParameter instanceof DHKeyParameters) {
            return ((DHKeyParameters)asymmetricKeyParameter).getParameters().getP().bitLength();
        }
        if (asymmetricKeyParameter instanceof ECKeyParameters) {
            return -1;
        }
        LOG.warning("Don't know how to get key size from parameters " + asymmetricKeyParameter);
        return -1;
    }
}

