/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.portecle.DViewCertificate;
import net.sf.portecle.FPortecle;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.crypto.CryptoException;
import net.sf.portecle.crypto.KeyPairUtil;
import net.sf.portecle.crypto.KeyStoreUtil;
import net.sf.portecle.crypto.X509CertUtil;
import net.sf.portecle.gui.SwingHelper;
import net.sf.portecle.gui.error.DThrowable;

class DImportKeyPair
extends PortecleJDialog {
    private JList m_jltKeyPairs;
    private JTextField m_jtfAlgorithm;
    private KeyStore m_pkcs12;
    private Key m_privateKey;
    private Certificate[] m_certificateChain;
    private String m_alias;

    public DImportKeyPair(Window window, KeyStore keyStore) throws CryptoException {
        super(window, true);
        this.m_pkcs12 = keyStore;
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        JLabel jLabel = new JLabel(FPortecle.RB.getString("DImportKeyPair.jlInstructions.text"));
        final JButton jButton = this.getOkButton(false);
        jButton.setEnabled(false);
        jButton.setToolTipText(FPortecle.RB.getString("DImportKeyPair.jbImport.tooltip"));
        final JButton jButton2 = new JButton(FPortecle.RB.getString("DImportKeyPair.jbCertificateDetails.text"));
        jButton2.setMnemonic(FPortecle.RB.getString("DImportKeyPair.jbCertificateDetails.mnemonic").charAt(0));
        jButton2.setToolTipText(FPortecle.RB.getString("DImportKeyPair.jbCertificateDetails.tooltip"));
        jButton2.setEnabled(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DImportKeyPair.this.certificateDetailsPressed();
            }
        });
        this.m_jltKeyPairs = new JList();
        this.m_jltKeyPairs.setSelectionMode(0);
        this.m_jltKeyPairs.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DImportKeyPair.this.populateAlgorithm();
                if (DImportKeyPair.this.m_jltKeyPairs.getSelectedIndex() == -1) {
                    jButton.setEnabled(false);
                    jButton2.setEnabled(false);
                } else {
                    jButton.setEnabled(true);
                    jButton2.setEnabled(true);
                }
            }
        });
        jLabel.setLabelFor(this.m_jltKeyPairs);
        JScrollPane jScrollPane = new JScrollPane(this.m_jltKeyPairs, 20, 30);
        jScrollPane.getViewport().setBackground(this.m_jltKeyPairs.getBackground());
        JLabel jLabel2 = new JLabel(FPortecle.RB.getString("DImportKeyPair.jlAlgorithm.text"));
        this.m_jtfAlgorithm = new JTextField(10);
        this.m_jtfAlgorithm.setText("");
        this.m_jtfAlgorithm.setToolTipText(FPortecle.RB.getString("DImportKeyPair.m_jtfAlgorithm.tooltip"));
        this.m_jtfAlgorithm.setEditable(false);
        jLabel2.setLabelFor(this.m_jtfAlgorithm);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(jLabel2);
        jPanel.add(this.m_jtfAlgorithm);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.setPreferredSize(new Dimension(400, 200));
        jPanel2.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()), new EmptyBorder(5, 5, 5, 5)));
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        JButton jButton3 = this.getCancelButton();
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(jButton);
        jPanel3.add(jButton3);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)jPanel3, "South");
        this.populateList();
        this.setTitle(FPortecle.RB.getString("DImportKeyPair.Title"));
        this.getRootPane().setDefaultButton(jButton.isEnabled() ? jButton : jButton3);
        this.initDialog();
        this.getRootPane().getDefaultButton().requestFocusInWindow();
    }

    private void populateList() throws CryptoException {
        try {
            Vector<String> vector = new Vector<String>();
            Enumeration<String> enumeration = this.m_pkcs12.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!this.m_pkcs12.isKeyEntry(string)) continue;
                this.m_pkcs12.getKey(string, KeyStoreUtil.DUMMY_PASSWORD);
                Certificate[] certificateArray = this.m_pkcs12.getCertificateChain(string);
                if (certificateArray == null || certificateArray.length == 0) continue;
                vector.add(string);
            }
            if (vector.size() > 0) {
                this.m_jltKeyPairs.setListData(vector);
                this.m_jltKeyPairs.setSelectedIndex(0);
            } else {
                this.m_jltKeyPairs.setListData(new String[]{FPortecle.RB.getString("DImportKeyPair.m_jltKeyPairs.empty")});
                this.m_jltKeyPairs.setEnabled(false);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(FPortecle.RB.getString("DImportKeyPair.ProblemAccessingPkcs12.exception.message"), generalSecurityException);
        }
    }

    private void populateAlgorithm() {
        try {
            String string = (String)this.m_jltKeyPairs.getSelectedValue();
            if (string == null) {
                this.m_jtfAlgorithm.setText("");
                return;
            }
            Certificate[] certificateArray = this.m_pkcs12.getCertificateChain(string);
            X509Certificate[] x509CertificateArray = X509CertUtil.convertCertificates(certificateArray);
            if (x509CertificateArray == null) {
                this.m_jtfAlgorithm.setText("");
                return;
            }
            x509CertificateArray = X509CertUtil.orderX509CertChain(x509CertificateArray);
            X509Certificate x509Certificate = x509CertificateArray[0];
            int n = KeyPairUtil.getKeyLength(x509Certificate.getPublicKey());
            this.m_jtfAlgorithm.setText(x509Certificate.getPublicKey().getAlgorithm());
            if (n != -1) {
                this.m_jtfAlgorithm.setText(MessageFormat.format(FPortecle.RB.getString("DImportKeyPair.m_jtfAlgorithm.text"), this.m_jtfAlgorithm.getText(), n));
            }
            this.m_jtfAlgorithm.setCaretPosition(0);
        }
        catch (KeyStoreException keyStoreException) {
            DThrowable.showAndWait(this, null, keyStoreException);
            this.closeDialog();
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            this.closeDialog();
        }
    }

    private void certificateDetailsPressed() {
        try {
            String string = (String)this.m_jltKeyPairs.getSelectedValue();
            assert (string != null);
            X509Certificate[] x509CertificateArray = X509CertUtil.convertCertificates(this.m_pkcs12.getCertificateChain(string));
            DViewCertificate dViewCertificate = new DViewCertificate((Window)this, MessageFormat.format(FPortecle.RB.getString("DImportKeyPair.ViewCertificateDetails.Title"), string), x509CertificateArray);
            dViewCertificate.setLocationRelativeTo(this);
            SwingHelper.showAndWait(dViewCertificate);
        }
        catch (KeyStoreException keyStoreException) {
            DThrowable.showAndWait(this, null, keyStoreException);
            this.closeDialog();
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            this.closeDialog();
        }
    }

    public Key getPrivateKey() {
        return this.m_privateKey;
    }

    public Certificate[] getCertificateChain() {
        return this.m_certificateChain;
    }

    public String getAlias() {
        return this.m_alias;
    }

    @Override
    protected void okPressed() {
        String string = (String)this.m_jltKeyPairs.getSelectedValue();
        assert (string != null);
        try {
            this.m_privateKey = this.m_pkcs12.getKey(string, new char[0]);
            this.m_certificateChain = this.m_pkcs12.getCertificateChain(string);
            this.m_alias = string;
        }
        catch (KeyStoreException keyStoreException) {
            DThrowable.showAndWait(this, null, keyStoreException);
            this.closeDialog();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            DThrowable.showAndWait(this, null, noSuchAlgorithmException);
            this.closeDialog();
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            DThrowable.showAndWait(this, null, unrecoverableKeyException);
            this.closeDialog();
        }
        super.okPressed();
    }
}

