/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import net.sf.portecle.FPortecle;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.crypto.KeyPairType;
import net.sf.portecle.gui.IntegerDocumentFilter;
import net.sf.portecle.gui.SwingHelper;

class DGenerateKeyPair
extends PortecleJDialog {
    private static final int BAD_KEYSIZE = -1;
    private JRadioButton m_jrbDSA;
    private JRadioButton m_jrbRSA;
    private JComboBox m_jcbKeySize;
    private KeyPairType m_keyPairType;
    private int m_iKeySize;
    private boolean m_bSuccess;

    public DGenerateKeyPair(Window window) {
        super(window, true);
        this.initComponents();
    }

    private void initComponents() {
        Object object;
        JLabel jLabel = new JLabel(FPortecle.RB.getString("DGenerateKeyPair.jlKeyAlg.text"));
        this.m_jrbDSA = new JRadioButton(FPortecle.RB.getString("DGenerateKeyPair.m_jrbDSA.text"), false);
        this.m_jrbDSA.setToolTipText(FPortecle.RB.getString("DGenerateKeyPair.m_jrbDSA.tooltip"));
        this.m_jrbRSA = new JRadioButton(FPortecle.RB.getString("DGenerateKeyPair.m_jrbRSA.text"), false);
        this.m_jrbRSA.setToolTipText(FPortecle.RB.getString("DGenerateKeyPair.m_jrbRSA.tooltip"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_jrbDSA);
        buttonGroup.add(this.m_jrbRSA);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.m_jrbDSA);
        jPanel.add(this.m_jrbRSA);
        JLabel jLabel2 = new JLabel(FPortecle.RB.getString("DGenerateKeyPair.jlKeySize.text"));
        this.m_jcbKeySize = new JComboBox();
        this.m_jcbKeySize.setToolTipText(FPortecle.RB.getString("DGenerateKeyPair.m_jcbKeySize.tooltip"));
        this.m_jcbKeySize.setEditable(true);
        Component component = this.m_jcbKeySize.getEditor().getEditorComponent();
        if (component instanceof JTextComponent && (object = ((JTextComponent)component).getDocument()) instanceof AbstractDocument) {
            ((AbstractDocument)object).setDocumentFilter(new IntegerDocumentFilter(5));
        }
        jLabel2.setLabelFor(this.m_jcbKeySize);
        object = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                String string = "DGenerateKeyPair.RsaKeySizes";
                String string2 = "DGenerateKeyPair.DefaultRsaKeySize";
                if (DGenerateKeyPair.this.m_jrbDSA.isSelected()) {
                    string = "DGenerateKeyPair.DsaKeySizes";
                    string2 = "DGenerateKeyPair.DefaultDsaKeySize";
                }
                Object object = DGenerateKeyPair.this.m_jcbKeySize.getSelectedItem();
                boolean bl = false;
                DGenerateKeyPair.this.m_jcbKeySize.removeAllItems();
                for (String string3 : FPortecle.RB.getString(string).split(",+")) {
                    DGenerateKeyPair.this.m_jcbKeySize.addItem(string3);
                    if (!string3.equals(object)) continue;
                    DGenerateKeyPair.this.m_jcbKeySize.setSelectedItem(string3);
                    bl = true;
                }
                if (!bl) {
                    DGenerateKeyPair.this.m_jcbKeySize.setSelectedItem(FPortecle.RB.getString(string2));
                }
            }
        };
        this.m_jrbDSA.addChangeListener((ChangeListener)object);
        this.m_jrbRSA.addChangeListener((ChangeListener)object);
        this.m_jrbRSA.setSelected(true);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.anchor = 17;
        GridBagConstraints gridBagConstraints3 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints3.gridy = n;
        jPanel2.add((Component)jLabel, gridBagConstraints3);
        gridBagConstraints3 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints3.gridy = n++;
        jPanel2.add((Component)jPanel, gridBagConstraints3);
        gridBagConstraints3 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints3.gridy = n;
        jPanel2.add((Component)jLabel2, gridBagConstraints3);
        gridBagConstraints3 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints3.gridy = n++;
        jPanel2.add((Component)this.m_jcbKeySize, gridBagConstraints3);
        JButton jButton = this.getOkButton(false);
        JButton jButton2 = this.getCancelButton();
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)jPanel3, "South");
        this.setTitle(FPortecle.RB.getString("DGenerateKeyPair.Title"));
        this.getRootPane().setDefaultButton(jButton);
        this.initDialog();
        SwingHelper.selectAndFocus(this.m_jcbKeySize);
    }

    private boolean validateKeyGenParameters() {
        int n = this.validateKeySize();
        if (n == -1) {
            SwingHelper.selectAndFocus(this.m_jcbKeySize);
            return false;
        }
        this.m_iKeySize = n;
        this.m_keyPairType = this.m_jrbDSA.isSelected() ? KeyPairType.DSA : KeyPairType.RSA;
        this.m_bSuccess = true;
        return true;
    }

    private int validateKeySize() {
        int n;
        String string = this.m_jcbKeySize.getSelectedItem().toString();
        if (string.isEmpty()) {
            JOptionPane.showMessageDialog(this, FPortecle.RB.getString("DGenerateKeyPair.KeySizeReq.message"), this.getTitle(), 2);
            return -1;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, FPortecle.RB.getString("DGenerateKeyPair.KeySizeIntegerReq.message"), this.getTitle(), 2);
            return -1;
        }
        if (this.m_jrbDSA.isSelected() && (n < 512 || n > 1024 || n % 64 != 0)) {
            JOptionPane.showMessageDialog(this, FPortecle.RB.getString("DGenerateKeyPair.UnsupportedDsaKeySize.message"), this.getTitle(), 2);
            return -1;
        }
        if (n < 512) {
            JOptionPane.showMessageDialog(this, FPortecle.RB.getString("DGenerateKeyPair.UnsupportedRsaKeySize.message"), this.getTitle(), 2);
            return -1;
        }
        return n;
    }

    public int getKeySize() {
        return this.m_iKeySize;
    }

    public KeyPairType getKeyPairType() {
        return this.m_keyPairType;
    }

    public boolean isSuccessful() {
        return this.m_bSuccess;
    }

    @Override
    protected void okPressed() {
        if (this.validateKeyGenParameters()) {
            super.okPressed();
        }
    }
}

