/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.io.Serializable;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.sf.portecle.FPortecle;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.crypto.ProviderUtil;

public class DChoosePkcs11Provider
extends PortecleJDialog {
    private JComboBox m_jcbProvider;
    private String m_sProvider;

    public DChoosePkcs11Provider(Window window, String string, String string2) {
        super(window, string, true);
        this.initComponents(string2);
    }

    public String getProvider() {
        return this.m_sProvider;
    }

    private void initComponents(String string) {
        Object object;
        Serializable serializable2;
        boolean bl;
        this.getContentPane().setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(FPortecle.RB.getString("DChoosePkcs11Provider.jlProvider.text"));
        this.m_jcbProvider = new JComboBox();
        this.m_jcbProvider.setToolTipText(FPortecle.RB.getString("DChoosePkcs11Provider.m_jcbProvider.tooltip"));
        jLabel.setLabelFor(this.m_jcbProvider);
        TreeSet<Provider> treeSet = new TreeSet<Provider>(ProviderUtil.getPkcs11Providers());
        boolean bl2 = bl = !treeSet.isEmpty();
        if (bl) {
            for (Serializable serializable2 : treeSet) {
                object = serializable2.getName();
                this.m_jcbProvider.addItem(object);
                if (!((String)object).equals(string)) continue;
                this.m_jcbProvider.setSelectedIndex(this.m_jcbProvider.getItemCount() - 1);
            }
        } else {
            this.m_jcbProvider.addItem(FPortecle.RB.getString("DChoosePkcs11Provider.NoPkcs11Providers"));
            this.m_jcbProvider.setEnabled(false);
        }
        JButton jButton = this.getOkButton(false);
        jButton.setEnabled(bl);
        serializable2 = this.getCancelButton();
        object = new JPanel(new FlowLayout(1));
        ((Container)object).add(jButton);
        ((Container)object).add((Component)serializable2);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(jLabel);
        jPanel.add(this.m_jcbProvider);
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)object, "South");
        this.getRootPane().setDefaultButton((JButton)(bl ? jButton : serializable2));
        this.initDialog();
    }

    private boolean checkProvider() {
        String string = (String)this.m_jcbProvider.getSelectedItem();
        if (string == null || Security.getProvider(string) == null) {
            String string2 = MessageFormat.format(FPortecle.RB.getString("DChoosePkcs11Provider.InvalidProvider.message"), string);
            JOptionPane.showMessageDialog(this, string2, this.getTitle(), 2);
            return false;
        }
        this.m_sProvider = string;
        return true;
    }

    @Override
    protected void okPressed() {
        if (this.checkProvider()) {
            super.okPressed();
        }
    }
}

