/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import sun.java2d.ScreenUpdateManager;
import sun.java2d.d3d.D3DScreenUpdateManager;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;

public class D3DRenderQueue
extends RenderQueue {
    private static D3DRenderQueue theInstance;
    private static Thread rqThread;

    private D3DRenderQueue() {
    }

    public static synchronized D3DRenderQueue getInstance() {
        if (theInstance == null) {
            theInstance = new D3DRenderQueue();
            theInstance.flushAndInvokeNow(new Runnable(){

                public void run() {
                    rqThread = Thread.currentThread();
                }
            });
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sync() {
        if (theInstance != null) {
            D3DScreenUpdateManager d3DScreenUpdateManager = (D3DScreenUpdateManager)ScreenUpdateManager.getInstance();
            d3DScreenUpdateManager.runUpdateNow();
            theInstance.lock();
            try {
                theInstance.ensureCapacity(4);
                theInstance.getBuffer().putInt(76);
                theInstance.flushNow();
            }
            finally {
                theInstance.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreDevices() {
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3DRenderQueue.lock();
        try {
            d3DRenderQueue.ensureCapacity(4);
            d3DRenderQueue.getBuffer().putInt(77);
            d3DRenderQueue.flushNow();
        }
        finally {
            d3DRenderQueue.unlock();
        }
    }

    public static boolean isRenderQueueThread() {
        return Thread.currentThread() == rqThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeGraphicsConfig(long l) {
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3DRenderQueue.lock();
        try {
            RenderBuffer renderBuffer = d3DRenderQueue.getBuffer();
            d3DRenderQueue.ensureCapacityAndAlignment(12, 4);
            renderBuffer.putInt(74);
            renderBuffer.putLong(l);
            d3DRenderQueue.flushNow();
        }
        finally {
            d3DRenderQueue.unlock();
        }
    }

    public void flushNow() {
        this.flushBuffer(null);
    }

    public void flushAndInvokeNow(Runnable runnable) {
        this.flushBuffer(runnable);
    }

    private native void flushBuffer(long var1, int var3, Runnable var4);

    private void flushBuffer(Runnable runnable) {
        int n = this.buf.position();
        if (n > 0 || runnable != null) {
            this.flushBuffer(this.buf.getAddress(), n, runnable);
        }
        this.buf.clear();
        this.refSet.clear();
    }
}

