/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.gui.crypto;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.sf.portecle.FPortecle;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.crypto.CryptoException;
import net.sf.portecle.gui.error.DThrowable;
import org.bouncycastle.openssl.PEMWriter;

public class DViewPEM
extends PortecleJDialog {
    private Object m_object;
    private String m_pem;
    private JFileChooser m_chooser;

    public DViewPEM(Window window, String string, Object object, JFileChooser jFileChooser) throws CryptoException {
        super(window, string, true);
        this.m_object = object;
        this.m_chooser = jFileChooser;
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        Object object;
        Object object2;
        if (this.m_pem == null) {
            object2 = new StringWriter();
            object = new PEMWriter((Writer)object2);
            try {
                ((PEMWriter)object).writeObject(this.m_object);
            }
            catch (IOException iOException) {
                throw new CryptoException(FPortecle.RB.getString("DViewPEM.exception.message"), iOException);
            }
            finally {
                try {
                    ((BufferedWriter)object).close();
                }
                catch (IOException iOException) {}
                this.m_pem = ((StringWriter)object2).toString();
            }
        }
        object2 = new JPanel(new FlowLayout(1));
        object = this.getOkButton(true);
        JButton jButton = new JButton(FPortecle.RB.getString("DViewPEM.jbSave.text"));
        jButton.setMnemonic(FPortecle.RB.getString("DViewPEM.jbSave.mnemonic").charAt(0));
        if (this.m_chooser == null || this.m_pem == null) {
            jButton.setEnabled(false);
        } else {
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DViewPEM.this.savePressed();
                }
            });
        }
        ((Container)object2).add((Component)object);
        ((Container)object2).add(jButton);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JTextArea jTextArea = new JTextArea(this.m_pem);
        jTextArea.setCaretPosition(0);
        jTextArea.setEditable(false);
        jTextArea.setFont(new Font("Monospaced", 0, jTextArea.getFont().getSize()));
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 22, 32);
        jScrollPane.setPreferredSize(new Dimension(500, 300));
        jPanel.add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)object2, "South");
        this.getRootPane().setDefaultButton((JButton)object);
        this.initDialog();
        this.setResizable(true);
        ((JComponent)object).requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePressed() {
        int n = this.m_chooser.showDialog(this, FPortecle.RB.getString("DViewPEM.jbSave.text"));
        if (n == 0) {
            Object object;
            int n2;
            File file = this.m_chooser.getSelectedFile();
            if (file.isFile() && (n2 = JOptionPane.showConfirmDialog(this, object = MessageFormat.format(FPortecle.RB.getString("DViewPEM.OverWriteFile.message"), file.getName()), this.getTitle(), 0)) == 1) {
                return;
            }
            object = null;
            try {
                object = new FileWriter(file);
                ((Writer)object).write(this.m_pem);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = MessageFormat.format(FPortecle.RB.getString("DViewPEM.NoWriteFile.message"), file.getName());
                JOptionPane.showMessageDialog(this, string, this.getTitle(), 2);
            }
            catch (IOException iOException) {
                DThrowable.showAndWait(this, null, iOException);
            }
            finally {
                if (object != null) {
                    try {
                        ((OutputStreamWriter)object).close();
                    }
                    catch (IOException iOException) {
                        DThrowable.showAndWait(this, null, iOException);
                    }
                }
            }
        }
    }
}

