/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.TransferHandler;

public class SingleFileDropHelper
extends TransferHandler {
    private static final DataFlavor FILE_FLAVOR = DataFlavor.javaFileListFlavor;
    private static final DataFlavor URILIST_FLAVOR;
    protected File file;

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (!transferSupport.isDrop()) {
            return false;
        }
        try {
            File file;
            List<File> list = this.getTransferFiles(transferSupport);
            if (list.size() == 1 && (file = list.get(0)).isFile()) {
                this.file = file.getAbsoluteFile();
                return true;
            }
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            return this.file != null;
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            // empty catch block
        }
        return false;
    }

    private List<File> getTransferFiles(TransferHandler.TransferSupport transferSupport) throws IOException, UnsupportedFlavorException {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (transferSupport.isDataFlavorSupported(FILE_FLAVOR)) {
            Object object = transferSupport.getTransferable().getTransferData(FILE_FLAVOR);
            if (object instanceof List) {
                for (Object e : (List)object) {
                    arrayList.add(new File(e.toString()));
                }
            }
        } else if (URILIST_FLAVOR != null && transferSupport.isDataFlavorSupported(URILIST_FLAVOR)) {
            String string;
            String string2 = (String)transferSupport.getTransferable().getTransferData(URILIST_FLAVOR);
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                try {
                    arrayList.add(new File(new URI(string)));
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            bufferedReader.close();
        }
        return arrayList;
    }

    static {
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            dataFlavor = null;
        }
        URILIST_FLAVOR = dataFlavor;
    }
}

