/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.crypto;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public enum KeyStoreType {
    JKS("JKS", true, true, new String[]{"jks"}),
    PKCS12("PKCS #12", false, false, new String[]{"p12", "pfx"}),
    JCEKS("JCEKS", true, true, new String[]{"jceks"}),
    CaseExactJKS("JKS (case sensitive)", true, true, new String[]{"jks"}),
    BKS("BKS", true, true, new String[]{"bks"}),
    UBER("UBER", true, true, new String[]{"ubr"}),
    GKR("GKR", true, true, new String[]{"gkr"}),
    PKCS11("PKCS #11", false, true, new String[0]);

    private final String prettyName;
    private final boolean entryCreationDateUseful;
    private final boolean entryPasswordSupported;
    private final Set<String> filenameExtensions;

    private KeyStoreType(String string2, boolean bl, boolean bl2, String[] stringArray) {
        this.prettyName = string2;
        this.entryCreationDateUseful = bl;
        this.entryPasswordSupported = bl2;
        switch (stringArray.length) {
            case 0: {
                this.filenameExtensions = Collections.emptySet();
                break;
            }
            case 1: {
                this.filenameExtensions = Collections.singleton(stringArray[0]);
                break;
            }
            default: {
                LinkedHashSet linkedHashSet = new LinkedHashSet(stringArray.length);
                Collections.addAll(linkedHashSet, stringArray);
                this.filenameExtensions = Collections.unmodifiableSet(linkedHashSet);
            }
        }
    }

    public boolean isEntryCreationDateUseful() {
        return this.entryCreationDateUseful;
    }

    public boolean isEntryPasswordSupported() {
        return this.entryPasswordSupported;
    }

    public Set<String> getFilenameExtensions() {
        return this.filenameExtensions;
    }

    public String toString() {
        return this.prettyName;
    }

    public static Set<String> getKeyStoreFilenameExtensions() {
        HashSet<String> hashSet = new HashSet<String>();
        for (KeyStoreType keyStoreType : KeyStoreType.values()) {
            for (String string : keyStoreType.getFilenameExtensions()) {
                hashSet.add(string);
            }
        }
        return hashSet;
    }
}

