/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NetUtil {
    private static final Logger LOG = Logger.getLogger(NetUtil.class.getCanonicalName());
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 20000;

    private NetUtil() {
    }

    public static InputStream openGetStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(10000);
        uRLConnection.setReadTimeout(20000);
        return uRLConnection.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream openPostStream(URL uRL, byte[] byArray, String string) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        uRLConnection.setConnectTimeout(10000);
        uRLConnection.setReadTimeout(20000);
        if (string != null) {
            uRLConnection.setRequestProperty("Content-Type", string);
        }
        uRLConnection.setRequestProperty("Content-Length", String.valueOf(byArray.length));
        OutputStream outputStream = uRLConnection.getOutputStream();
        try {
            outputStream.write(byArray);
        }
        finally {
            outputStream.close();
        }
        return uRLConnection.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL download(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            return uRL;
        }
        InputStream inputStream = NetUtil.openGetStream(uRL);
        File file = null;
        OutputStream outputStream = null;
        try {
            int n;
            file = File.createTempFile("portecle", null);
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            finally {
                if (file != null && !file.delete()) {
                    LOG.log(Level.WARNING, "Could not delete temporary file " + file);
                }
            }
            throw iOException;
        }
        finally {
            inputStream.close();
        }
        file.deleteOnExit();
        return file.toURI().toURL();
    }

    public static URL toURL(Object object) throws MalformedURLException {
        if (object instanceof File) {
            return ((File)object).toURI().toURL();
        }
        if (object instanceof URI) {
            return ((URI)object).toURL();
        }
        return (URL)object;
    }
}

