/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.table.AbstractTableModel;
import net.sf.portecle.FPortecle;
import net.sf.portecle.crypto.KeyStoreType;

class KeyStoreTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{FPortecle.RB.getString("KeyStoreTableModel.TypeColumn"), FPortecle.RB.getString("KeyStoreTableModel.AliasColumn"), FPortecle.RB.getString("KeyStoreTableModel.LastModifiedDateColumn")};
    public static final String KEY_PAIR_ENTRY = FPortecle.RB.getString("KeyStoreTableModel.KeyPairEntry");
    public static final String TRUST_CERT_ENTRY = FPortecle.RB.getString("KeyStoreTableModel.TrustCertEntry");
    public static final String KEY_ENTRY = FPortecle.RB.getString("KeyStoreTableModel.KeyEntry");
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, Date.class};
    private Object[][] m_data = new Object[0][this.getColumnCount()];
    private final FPortecle portecle;

    public KeyStoreTableModel(FPortecle fPortecle) {
        this.portecle = fPortecle;
    }

    public void load(KeyStore keyStore) throws KeyStoreException {
        boolean bl = KeyStoreType.valueOf(keyStore.getType()).isEntryCreationDateUseful();
        this.m_data = new Object[keyStore.size()][this.getColumnCount()];
        int n = 0;
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.m_data[n][0] = keyStore.isCertificateEntry(string) ? TRUST_CERT_ENTRY : (keyStore.isKeyEntry(string) && keyStore.getCertificateChain(string) != null && keyStore.getCertificateChain(string).length != 0 ? KEY_PAIR_ENTRY : KEY_ENTRY);
            this.m_data[n][1] = string;
            if (bl) {
                this.m_data[n][2] = keyStore.getCreationDate(string);
            }
            ++n;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_CLASSES.length;
    }

    @Override
    public int getRowCount() {
        return this.m_data.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.m_data[n][n2];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.isCellEditable(n, n2)) {
            this.portecle.renameEntry(this.m_data[n][n2].toString(), object.toString(), true);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return COLUMN_CLASSES[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 != 1) {
            return false;
        }
        return !KEY_ENTRY.equals(this.m_data[n][0]);
    }
}

