/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import net.sf.portecle.DChoosePkcs11Provider;
import net.sf.portecle.DExport;
import net.sf.portecle.DGenerateCertificate;
import net.sf.portecle.DGenerateKeyPair;
import net.sf.portecle.DGeneratingKeyPair;
import net.sf.portecle.DGetAlias;
import net.sf.portecle.DGetHostPort;
import net.sf.portecle.DImportKeyPair;
import net.sf.portecle.DKeyStoreReport;
import net.sf.portecle.DNewKeyStoreType;
import net.sf.portecle.DOptions;
import net.sf.portecle.DViewCRL;
import net.sf.portecle.DViewCSR;
import net.sf.portecle.DViewCertificate;
import net.sf.portecle.FileChooserFactory;
import net.sf.portecle.KeyStoreTableCellRend;
import net.sf.portecle.KeyStoreTableHeadRend;
import net.sf.portecle.KeyStoreTableModel;
import net.sf.portecle.KeyStoreWrapper;
import net.sf.portecle.RecentKeyStoreFileActionListener;
import net.sf.portecle.crypto.CryptoException;
import net.sf.portecle.crypto.KeyPairType;
import net.sf.portecle.crypto.KeyStoreType;
import net.sf.portecle.crypto.KeyStoreUtil;
import net.sf.portecle.crypto.ProviderUtil;
import net.sf.portecle.crypto.X509CertUtil;
import net.sf.portecle.gui.DesktopUtil;
import net.sf.portecle.gui.JMenuItemRecentFile;
import net.sf.portecle.gui.JMenuRecentFiles;
import net.sf.portecle.gui.LastDir;
import net.sf.portecle.gui.SingleFileDropHelper;
import net.sf.portecle.gui.SwingHelper;
import net.sf.portecle.gui.about.DAbout;
import net.sf.portecle.gui.crypto.DProviderInfo;
import net.sf.portecle.gui.error.DThrowable;
import net.sf.portecle.gui.help.FHelp;
import net.sf.portecle.gui.jar.DJarInfo;
import net.sf.portecle.gui.password.DChangePassword;
import net.sf.portecle.gui.password.DGetNewPassword;
import net.sf.portecle.gui.password.DGetPassword;
import net.sf.portecle.gui.statusbar.StatusBar;
import net.sf.portecle.gui.statusbar.StatusBarChangeHandler;
import net.sf.portecle.version.JavaVersion;
import net.sf.portecle.version.VersionException;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.PasswordFinder;

public class FPortecle
extends JFrame
implements StatusBar {
    private static final String RB_BASENAME = FPortecle.class.getPackage().getName() + "/resources";
    public static final ResourceBundle RB = ResourceBundle.getBundle(RB_BASENAME);
    public static final Logger LOG = Logger.getLogger(FPortecle.class.getName(), RB_BASENAME);
    private static final Preferences PREFS = Preferences.userNodeForPackage(FPortecle.class);
    private static final String REQ_JRE_VERSION = "1.6.0";
    private static final Double REQ_BC_VERSION = new Double(1.43);
    private static final boolean EXPERIMENTAL = Boolean.getBoolean("portecle.experimental");
    private static final int DEFAULT_TABLE_WIDTH = 600;
    private static final int DEFAULT_TABLE_HEIGHT = 400;
    private static final int RECENT_FILES_LENGTH = 4;
    private static final int RECENT_FILES_INDEX = EXPERIMENTAL ? 7 : 6;
    private static final String DEFAULT_LOOK_FEEL = UIManager.getCrossPlatformLookAndFeelClassName();
    static final File DEFAULT_CA_CERTS_FILE = new File(System.getProperty("java.home"), "lib" + File.separator + "security" + File.separator + "cacerts");
    private final LastDir m_lastDir = new LastDir();
    private boolean m_bUseCaCerts;
    private File m_fCaCertsFile;
    private KeyStore m_caCertsKeyStore;
    private KeyStoreWrapper m_keyStoreWrap;
    private SecureRandom m_rnd;
    private FHelp m_fHelp;
    private String lookFeelClassName;
    private Boolean m_bLookFeelDecorationOptions;
    private String selectedAlias;
    private JMenuRecentFiles m_jmrfFile;
    private JMenuItem m_jmiSaveKeyStoreAs;
    private JMenu m_jmChangeKeyStoreType;
    private JMenuItem m_jmiChangeKeyStoreTypeJks;
    private JMenuItem m_jmiChangeKeyStoreTypeCaseExactJks;
    private JMenuItem m_jmiChangeKeyStoreTypeJceks;
    private JMenuItem m_jmiChangeKeyStoreTypePkcs12;
    private JMenuItem m_jmiChangeKeyStoreTypeBks;
    private JMenuItem m_jmiChangeKeyStoreTypeUber;
    private JMenuItem m_jmiChangeKeyStoreTypeGkr;
    private JPopupMenu m_jpmKey;
    private JPopupMenu m_jpmKeyPair;
    private JMenuItem m_jmiSetKeyPairPass;
    private JPopupMenu m_jpmCert;
    private JPanel m_jpKeyStoreTable;
    private KeyStoreTable m_jtKeyStore;
    private JLabel m_jlStatusBar;
    private final NewKeyStoreAction m_newKeyStoreAction = new NewKeyStoreAction();
    private final OpenKeyStoreFileAction m_openKeyStoreFileAction = new OpenKeyStoreFileAction();
    private final OpenCaCertsKeyStoreAction m_openCaCertsKeyStoreFileAction = new OpenCaCertsKeyStoreAction();
    private final SaveKeyStoreAction m_saveKeyStoreAction = new SaveKeyStoreAction();
    private final ExamineCertAction m_examineCertAction = new ExamineCertAction();
    private final ExamineCertSSLAction m_examineCertSSLAction = new ExamineCertSSLAction();
    private final ExamineCsrAction m_examineCsrAction = new ExamineCsrAction();
    private final ExamineCrlAction m_examineCrlAction = new ExamineCrlAction();
    private final GenKeyPairAction m_genKeyPairAction = new GenKeyPairAction();
    private final ImportTrustCertAction m_importTrustCertAction = new ImportTrustCertAction();
    private final ImportKeyPairAction m_importKeyPairAction = new ImportKeyPairAction();
    private final SetKeyStorePassAction m_setKeyStorePassAction = new SetKeyStorePassAction();
    private final KeyStoreReportAction m_keyStoreReportAction = new KeyStoreReportAction();
    private final HelpAction m_helpAction = new HelpAction();

    public FPortecle() {
        this.m_bUseCaCerts = PREFS.getBoolean(RB.getString("AppPrefs.UseCaCerts"), false);
        this.m_fCaCertsFile = new File(PREFS.get(RB.getString("AppPrefs.CaCertsFile"), DEFAULT_CA_CERTS_FILE.getAbsolutePath()));
        this.initComponents();
    }

    private void initComponents() {
        this.initStatusBar();
        this.initMenu();
        this.initToolBar();
        this.initPopupMenus();
        this.initTable();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FPortecle.this.exitApplication();
            }
        });
        this.setDefaultCloseOperation(0);
        this.updateTitle();
        this.pack();
        int n = PREFS.getInt(RB.getString("AppPrefs.XPos"), 0);
        int n2 = PREFS.getInt(RB.getString("AppPrefs.YPos"), 0);
        if (n <= 0 || n2 <= 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation(new Point(n, n2));
        }
        if (!SwingUtilities.isRectangleContainingRectangle(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()), this.getBounds())) {
            this.m_jpKeyStoreTable.setPreferredSize(new Dimension(600, 400));
            this.setLocationRelativeTo(null);
        }
        this.setIconImage(this.getResImage("FPortecle.Icon.image"));
    }

    private void initMenu() {
        Object object;
        JMenuItem jMenuItem;
        JMenuBar jMenuBar = new JMenuBar();
        this.m_jmrfFile = new JMenuRecentFiles(RB.getString("FPortecle.m_jmrfFile.text"), 4, RECENT_FILES_INDEX);
        this.m_jmrfFile.setMnemonic(RB.getString("FPortecle.m_jmrfFile.mnemonic").charAt(0));
        JMenuItem jMenuItem2 = new JMenuItem(this.m_newKeyStoreAction);
        jMenuItem2.setToolTipText(null);
        jMenuItem2.addChangeListener(new StatusBarChangeHandler((String)this.m_newKeyStoreAction.getValue("LongDescription"), this));
        this.m_jmrfFile.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(this.m_openKeyStoreFileAction);
        jMenuItem3.setToolTipText(null);
        jMenuItem3.addChangeListener(new StatusBarChangeHandler((String)this.m_openKeyStoreFileAction.getValue("LongDescription"), this));
        this.m_jmrfFile.add(jMenuItem3);
        if (EXPERIMENTAL) {
            jMenuItem = new JMenuItem(RB.getString("FPortecle.jmiOpenKeyStorePkcs11.text"), RB.getString("FPortecle.jmiOpenKeyStorePkcs11.mnemonic").charAt(0));
            jMenuItem.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiOpenKeyStorePkcs11.image")));
            jMenuItem.setToolTipText(null);
            if (ProviderUtil.getPkcs11Providers().isEmpty()) {
                jMenuItem.setEnabled(false);
            }
            this.m_jmrfFile.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                protected void act() {
                    FPortecle.this.openKeyStorePkcs11();
                }
            });
            jMenuItem.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiOpenKeyStorePkcs11.statusbar"), this));
        }
        jMenuItem = new JMenuItem(this.m_openCaCertsKeyStoreFileAction);
        jMenuItem.setToolTipText(null);
        jMenuItem.addChangeListener(new StatusBarChangeHandler((String)this.m_openCaCertsKeyStoreFileAction.getValue("LongDescription"), this));
        this.m_jmrfFile.add(jMenuItem);
        this.m_jmrfFile.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem(this.m_saveKeyStoreAction);
        jMenuItem4.setToolTipText(null);
        jMenuItem4.addChangeListener(new StatusBarChangeHandler((String)this.m_saveKeyStoreAction.getValue("LongDescription"), this));
        this.m_jmrfFile.add(jMenuItem4);
        this.m_jmiSaveKeyStoreAs = new JMenuItem(RB.getString("FPortecle.m_jmiSaveKeyStoreAs.text"), RB.getString("FPortecle.m_jmiSaveKeyStoreAs.mnemonic").charAt(0));
        this.m_jmiSaveKeyStoreAs.setIcon(new ImageIcon(this.getResImage("FPortecle.m_jmiSaveKeyStoreAs.image")));
        this.m_jmiSaveKeyStoreAs.setEnabled(false);
        this.m_jmrfFile.add(this.m_jmiSaveKeyStoreAs);
        this.m_jmiSaveKeyStoreAs.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.saveKeyStoreAs();
            }
        });
        this.m_jmiSaveKeyStoreAs.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.m_jmiSaveKeyStoreAs.statusbar"), this));
        this.m_jmrfFile.addSeparator();
        for (int i = 4; i > 0; --i) {
            object = PREFS.get(RB.getString("AppPrefs.RecentFile") + i, null);
            if (object == null) continue;
            this.m_jmrfFile.add(this.createRecentFileMenuItem(new File((String)object)));
        }
        JMenuItem jMenuItem5 = new JMenuItem(RB.getString("FPortecle.jmiExit.text"), RB.getString("FPortecle.jmiExit.mnemonic").charAt(0));
        jMenuItem5.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiExit.image")));
        this.m_jmrfFile.add(jMenuItem5);
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.exitApplication();
            }
        });
        jMenuItem5.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiExit.statusbar"), this));
        object = new JMenu(RB.getString("FPortecle.jmTools.text"));
        ((AbstractButton)object).setMnemonic(RB.getString("FPortecle.jmTools.mnemonic").charAt(0));
        JMenuItem jMenuItem6 = new JMenuItem(this.m_genKeyPairAction);
        jMenuItem6.setToolTipText(null);
        jMenuItem6.addChangeListener(new StatusBarChangeHandler((String)this.m_genKeyPairAction.getValue("LongDescription"), this));
        ((JMenu)object).add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem(this.m_importTrustCertAction);
        jMenuItem7.setToolTipText(null);
        jMenuItem7.addChangeListener(new StatusBarChangeHandler((String)this.m_importTrustCertAction.getValue("LongDescription"), this));
        ((JMenu)object).add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem(this.m_importKeyPairAction);
        jMenuItem8.setToolTipText(null);
        jMenuItem8.addChangeListener(new StatusBarChangeHandler((String)this.m_importKeyPairAction.getValue("LongDescription"), this));
        ((JMenu)object).add(jMenuItem8);
        ((JMenu)object).addSeparator();
        JMenuItem jMenuItem9 = new JMenuItem(this.m_setKeyStorePassAction);
        jMenuItem9.setToolTipText(null);
        jMenuItem9.addChangeListener(new StatusBarChangeHandler((String)this.m_setKeyStorePassAction.getValue("LongDescription"), this));
        ((JMenu)object).add(jMenuItem9);
        this.m_jmChangeKeyStoreType = new JMenu(RB.getString("FPortecle.m_jmChangeKeyStoreType.text"));
        this.m_jmChangeKeyStoreType.setIcon(new ImageIcon(this.getResImage("FPortecle.m_jmChangeKeyStoreType.image")));
        this.m_jmChangeKeyStoreType.setMnemonic(RB.getString("FPortecle.m_jmChangeKeyStoreType.mnemonic").charAt(0));
        this.m_jmChangeKeyStoreType.setEnabled(false);
        ((JMenu)object).add(this.m_jmChangeKeyStoreType);
        this.m_jmiChangeKeyStoreTypeJks = new JMenuItem(RB.getString("FPortecle.m_jmiChangeKeyStoreTypeJks.text"), RB.getString("FPortecle.m_jmiChangeKeyStoreTypeJks.mnemonic").charAt(0));
        this.m_jmiChangeKeyStoreTypeJks.setEnabled(false);
        this.m_jmiChangeKeyStoreTypeJks.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.changeKeyStoreType(KeyStoreType.JKS);
            }
        });
        this.m_jmiChangeKeyStoreTypeJks.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.m_jmiChangeKeyStoreTypeJks.statusbar"), this));
        this.m_jmiChangeKeyStoreTypeCaseExactJks = new JMenuItem(RB.getString("FPortecle.m_jmiChangeKeyStoreTypeCaseExactJks.text"), RB.getString("FPortecle.m_jmiChangeKeyStoreTypeCaseExactJks.mnemonic").charAt(0));
        this.m_jmiChangeKeyStoreTypeCaseExactJks.setEnabled(false);
        this.m_jmiChangeKeyStoreTypeCaseExactJks.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.changeKeyStoreType(KeyStoreType.CaseExactJKS);
            }
        });
        this.m_jmiChangeKeyStoreTypeCaseExactJks.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.m_jmiChangeKeyStoreTypeCaseExactJks.statusbar"), this));
        this.m_jmiChangeKeyStoreTypeJceks = new JMenuItem(RB.getString("FPortecle.m_jmiChangeKeyStoreTypeJceks.text"), RB.getString("FPortecle.m_jmiChangeKeyStoreTypeJceks.mnemonic").charAt(0));
        this.m_jmiChangeKeyStoreTypeJceks.setEnabled(false);
        this.m_jmiChangeKeyStoreTypeJceks.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.changeKeyStoreType(KeyStoreType.JCEKS);
            }
        });
        this.m_jmiChangeKeyStoreTypeJceks.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.m_jmiChangeKeyStoreTypeJceks.statusbar"), this));
        this.m_jmiChangeKeyStoreTypePkcs12 = new JMenuItem(RB.getString("FPortecle.m_jmiChangeKeyStoreTypePkcs12.text"), RB.getString("FPortecle.m_jmiChangeKeyStoreTypePkcs12.mnemonic").charAt(0));
        this.m_jmiChangeKeyStoreTypePkcs12.setEnabled(false);
        this.m_jmiChangeKeyStoreTypePkcs12.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.changeKeyStoreType(KeyStoreType.PKCS12);
            }
        });
        this.m_jmiChangeKeyStoreTypePkcs12.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.m_jmiChangeKeyStoreTypePkcs12.statusbar"), this));
        this.m_jmiChangeKeyStoreTypeBks = new JMenuItem(RB.getString("FPortecle.m_jmiChangeKeyStoreTypeBks.text"), RB.getString("FPortecle.m_jmiChangeKeyStoreTypeBks.mnemonic").charAt(0));
        this.m_jmiChangeKeyStoreTypeBks.setEnabled(false);
        this.m_jmiChangeKeyStoreTypeBks.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.changeKeyStoreType(KeyStoreType.BKS);
            }
        });
        this.m_jmiChangeKeyStoreTypeBks.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.m_jmiChangeKeyStoreTypeBks.statusbar"), this));
        this.m_jmiChangeKeyStoreTypeUber = new JMenuItem(RB.getString("FPortecle.m_jmiChangeKeyStoreTypeUber.text"), RB.getString("FPortecle.m_jmiChangeKeyStoreTypeUber.mnemonic").charAt(0));
        this.m_jmiChangeKeyStoreTypeUber.setEnabled(false);
        this.m_jmiChangeKeyStoreTypeUber.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.changeKeyStoreType(KeyStoreType.UBER);
            }
        });
        this.m_jmiChangeKeyStoreTypeUber.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.m_jmiChangeKeyStoreTypeUber.statusbar"), this));
        this.m_jmiChangeKeyStoreTypeGkr = new JMenuItem(RB.getString("FPortecle.m_jmiChangeKeyStoreTypeGkr.text"), RB.getString("FPortecle.m_jmiChangeKeyStoreTypeGkr.mnemonic").charAt(0));
        this.m_jmiChangeKeyStoreTypeGkr.setEnabled(false);
        this.m_jmiChangeKeyStoreTypeGkr.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.changeKeyStoreType(KeyStoreType.GKR);
            }
        });
        this.m_jmiChangeKeyStoreTypeGkr.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.m_jmiChangeKeyStoreTypeGkr.statusbar"), this));
        this.m_jmChangeKeyStoreType.add(this.m_jmiChangeKeyStoreTypeJks);
        this.m_jmChangeKeyStoreType.add(this.m_jmiChangeKeyStoreTypePkcs12);
        this.m_jmChangeKeyStoreType.add(this.m_jmiChangeKeyStoreTypeJceks);
        this.m_jmChangeKeyStoreType.add(this.m_jmiChangeKeyStoreTypeCaseExactJks);
        this.m_jmChangeKeyStoreType.add(this.m_jmiChangeKeyStoreTypeBks);
        this.m_jmChangeKeyStoreType.add(this.m_jmiChangeKeyStoreTypeUber);
        this.m_jmChangeKeyStoreType.add(this.m_jmiChangeKeyStoreTypeGkr);
        JMenuItem jMenuItem10 = new JMenuItem(this.m_keyStoreReportAction);
        jMenuItem10.setToolTipText(null);
        jMenuItem10.addChangeListener(new StatusBarChangeHandler((String)this.m_keyStoreReportAction.getValue("LongDescription"), this));
        ((JMenu)object).add(jMenuItem10);
        ((JMenu)object).addSeparator();
        JMenuItem jMenuItem11 = new JMenuItem(RB.getString("FPortecle.jmiOptions.text"), RB.getString("FPortecle.jmiOptions.mnemonic").charAt(0));
        jMenuItem11.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiOptions.image")));
        ((JMenu)object).add(jMenuItem11);
        jMenuItem11.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.showOptions();
            }
        });
        jMenuItem11.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiOptions.statusbar"), this));
        JMenu jMenu = new JMenu(RB.getString("FPortecle.jmExamine.text"));
        jMenu.setMnemonic(RB.getString("FPortecle.jmExamine.mnemonic").charAt(0));
        JMenuItem jMenuItem12 = new JMenuItem(this.m_examineCertAction);
        jMenuItem12.setToolTipText(null);
        jMenuItem12.addChangeListener(new StatusBarChangeHandler((String)this.m_examineCertAction.getValue("LongDescription"), this));
        jMenu.add(jMenuItem12);
        JMenuItem jMenuItem13 = new JMenuItem(this.m_examineCertSSLAction);
        jMenuItem13.setToolTipText(null);
        jMenuItem13.addChangeListener(new StatusBarChangeHandler((String)this.m_examineCertSSLAction.getValue("LongDescription"), this));
        jMenu.add(jMenuItem13);
        JMenuItem jMenuItem14 = new JMenuItem(this.m_examineCsrAction);
        jMenuItem14.setToolTipText(null);
        jMenuItem14.addChangeListener(new StatusBarChangeHandler((String)this.m_examineCsrAction.getValue("LongDescription"), this));
        jMenu.add(jMenuItem14);
        JMenuItem jMenuItem15 = new JMenuItem(this.m_examineCrlAction);
        jMenuItem15.setToolTipText(null);
        jMenuItem15.addChangeListener(new StatusBarChangeHandler((String)this.m_examineCrlAction.getValue("LongDescription"), this));
        jMenu.add(jMenuItem15);
        JMenu jMenu2 = new JMenu(RB.getString("FPortecle.jmHelp.text"));
        jMenu2.setMnemonic(RB.getString("FPortecle.jmHelp.mnemonic").charAt(0));
        JMenuItem jMenuItem16 = new JMenuItem(this.m_helpAction);
        jMenuItem16.setToolTipText(null);
        jMenuItem16.addChangeListener(new StatusBarChangeHandler((String)this.m_helpAction.getValue("LongDescription"), this));
        jMenu2.add(jMenuItem16);
        JMenu jMenu3 = new JMenu(RB.getString("FPortecle.jmOnlineResources.text"));
        jMenu3.setIcon(new ImageIcon(this.getResImage("FPortecle.jmOnlineResources.image")));
        jMenu3.setMnemonic(RB.getString("FPortecle.jmOnlineResources.mnemonic").charAt(0));
        jMenu2.add(jMenu3);
        JMenuItem jMenuItem17 = new JMenuItem(RB.getString("FPortecle.jmiWebsite.text"), RB.getString("FPortecle.jmiWebsite.mnemonic").charAt(0));
        jMenuItem17.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiWebsite.image")));
        jMenu3.add(jMenuItem17);
        jMenuItem17.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.visitWebsite();
            }
        });
        jMenuItem17.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiWebsite.statusbar"), this));
        JMenuItem jMenuItem18 = new JMenuItem(RB.getString("FPortecle.jmiSFNetProject.text"), RB.getString("FPortecle.jmiSFNetProject.mnemonic").charAt(0));
        jMenuItem18.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiSFNetProject.image")));
        jMenu3.add(jMenuItem18);
        jMenuItem18.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.visitSFNetProject();
            }
        });
        jMenuItem18.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiSFNetProject.statusbar"), this));
        JMenuItem jMenuItem19 = new JMenuItem(RB.getString("FPortecle.jmiMailList.text"), RB.getString("FPortecle.jmiMailList.mnemonic").charAt(0));
        jMenuItem19.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiMailList.image")));
        jMenu3.add(jMenuItem19);
        jMenuItem19.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.visitMailListSignup();
            }
        });
        jMenuItem19.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiMailList.statusbar"), this));
        JMenuItem jMenuItem20 = new JMenuItem(RB.getString("FPortecle.jmiDonate.text"), RB.getString("FPortecle.jmiDonate.mnemonic").charAt(0));
        jMenuItem20.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiDonate.image")));
        jMenuItem20.setToolTipText(null);
        jMenu3.add(jMenuItem20);
        jMenuItem20.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.makeDonation();
            }
        });
        jMenuItem20.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiDonate.statusbar"), this));
        jMenu2.addSeparator();
        JMenuItem jMenuItem21 = new JMenuItem(RB.getString("FPortecle.jmiSecurityProviders.text"), RB.getString("FPortecle.jmiSecurityProviders.mnemonic").charAt(0));
        jMenuItem21.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiSecurityProviders.image")));
        jMenu2.add(jMenuItem21);
        jMenuItem21.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.showSecurityProviders();
            }
        });
        jMenuItem21.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiSecurityProviders.statusbar"), this));
        JMenuItem jMenuItem22 = new JMenuItem(RB.getString("FPortecle.jmiJars.text"), RB.getString("FPortecle.jmiJars.mnemonic").charAt(0));
        jMenuItem22.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiJars.image")));
        jMenu2.add(jMenuItem22);
        jMenuItem22.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.showJarInfo();
            }
        });
        jMenuItem22.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiJars.statusbar"), this));
        jMenu2.addSeparator();
        JMenuItem jMenuItem23 = new JMenuItem(RB.getString("FPortecle.jmiAbout.text"), RB.getString("FPortecle.jmiAbout.mnemonic").charAt(0));
        jMenuItem23.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiAbout.image")));
        jMenu2.add(jMenuItem23);
        jMenuItem23.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.showAbout();
            }
        });
        jMenuItem23.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiAbout.statusbar"), this));
        jMenuBar.add(this.m_jmrfFile);
        jMenuBar.add((JMenu)object);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
    }

    private JMenuItemRecentFile createRecentFileMenuItem(File file) {
        JMenuItemRecentFile jMenuItemRecentFile = new JMenuItemRecentFile(file);
        jMenuItemRecentFile.setIcon(new ImageIcon(this.getResImage("FPortecle.OpenRecent.image")));
        jMenuItemRecentFile.addActionListener(new RecentKeyStoreFileActionListener(file, this));
        jMenuItemRecentFile.addChangeListener(new StatusBarChangeHandler(MessageFormat.format(RB.getString("FPortecle.recentfile.statusbar"), file), this));
        return jMenuItemRecentFile;
    }

    private void initToolBar() {
        JButton jButton = new JButton();
        jButton.setAction(this.m_newKeyStoreAction);
        jButton.setText(null);
        jButton.setMnemonic(0);
        jButton.setFocusable(false);
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FPortecle.this.setStatusBarText((String)FPortecle.this.m_newKeyStoreAction.getValue("LongDescription"));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FPortecle.this.setDefaultStatusBarText();
            }
        });
        JButton jButton2 = new JButton();
        jButton2.setAction(this.m_openKeyStoreFileAction);
        jButton2.setText(null);
        jButton2.setMnemonic(0);
        jButton2.setFocusable(false);
        jButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FPortecle.this.setStatusBarText((String)FPortecle.this.m_openKeyStoreFileAction.getValue("LongDescription"));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FPortecle.this.setDefaultStatusBarText();
            }
        });
        JButton jButton3 = new JButton();
        jButton3.setAction(this.m_saveKeyStoreAction);
        jButton3.setText(null);
        jButton3.setMnemonic(0);
        jButton3.setFocusable(false);
        jButton3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FPortecle.this.setStatusBarText((String)FPortecle.this.m_saveKeyStoreAction.getValue("LongDescription"));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FPortecle.this.setDefaultStatusBarText();
            }
        });
        JButton jButton4 = new JButton();
        jButton4.setAction(this.m_genKeyPairAction);
        jButton4.setText(null);
        jButton4.setMnemonic(0);
        jButton4.setFocusable(false);
        jButton4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FPortecle.this.setStatusBarText((String)FPortecle.this.m_genKeyPairAction.getValue("LongDescription"));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FPortecle.this.setDefaultStatusBarText();
            }
        });
        JButton jButton5 = new JButton();
        jButton5.setAction(this.m_importTrustCertAction);
        jButton5.setText(null);
        jButton5.setMnemonic(0);
        jButton5.setFocusable(false);
        jButton5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FPortecle.this.setStatusBarText((String)FPortecle.this.m_importTrustCertAction.getValue("LongDescription"));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FPortecle.this.setDefaultStatusBarText();
            }
        });
        JButton jButton6 = new JButton();
        jButton6.setAction(this.m_importKeyPairAction);
        jButton6.setText(null);
        jButton6.setMnemonic(0);
        jButton6.setFocusable(false);
        jButton6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FPortecle.this.setStatusBarText((String)FPortecle.this.m_importKeyPairAction.getValue("LongDescription"));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FPortecle.this.setDefaultStatusBarText();
            }
        });
        JButton jButton7 = new JButton();
        jButton7.setAction(this.m_setKeyStorePassAction);
        jButton7.setText(null);
        jButton7.setMnemonic(0);
        jButton7.setFocusable(false);
        jButton7.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FPortecle.this.setStatusBarText((String)FPortecle.this.m_setKeyStorePassAction.getValue("LongDescription"));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FPortecle.this.setDefaultStatusBarText();
            }
        });
        JButton jButton8 = new JButton();
        jButton8.setAction(this.m_keyStoreReportAction);
        jButton8.setText(null);
        jButton8.setMnemonic(0);
        jButton8.setFocusable(false);
        jButton8.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FPortecle.this.setStatusBarText((String)FPortecle.this.m_keyStoreReportAction.getValue("LongDescription"));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FPortecle.this.setDefaultStatusBarText();
            }
        });
        JButton jButton9 = new JButton();
        jButton9.setAction(this.m_examineCertAction);
        jButton9.setText(null);
        jButton9.setMnemonic(0);
        jButton9.setFocusable(false);
        jButton9.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FPortecle.this.setStatusBarText((String)FPortecle.this.m_examineCertAction.getValue("LongDescription"));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FPortecle.this.setDefaultStatusBarText();
            }
        });
        JButton jButton10 = new JButton();
        jButton10.setAction(this.m_examineCrlAction);
        jButton10.setText(null);
        jButton10.setMnemonic(0);
        jButton10.setFocusable(false);
        jButton10.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FPortecle.this.setStatusBarText((String)FPortecle.this.m_examineCrlAction.getValue("LongDescription"));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FPortecle.this.setDefaultStatusBarText();
            }
        });
        JButton jButton11 = new JButton();
        jButton11.setAction(this.m_helpAction);
        jButton11.setText(null);
        jButton11.setMnemonic(0);
        jButton11.setFocusable(false);
        jButton11.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FPortecle.this.setStatusBarText((String)FPortecle.this.m_helpAction.getValue("LongDescription"));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FPortecle.this.setDefaultStatusBarText();
            }
        });
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        jToolBar.setName(RB.getString("FPortecle.jtbToolBar.name"));
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setMaximumSize(new Dimension(3, 16));
        jToolBar.add(jSeparator);
        jToolBar.add(jButton4);
        jToolBar.add(jButton5);
        jToolBar.add(jButton6);
        jToolBar.add(jButton7);
        jToolBar.add(jButton8);
        JSeparator jSeparator2 = new JSeparator(1);
        jSeparator2.setMaximumSize(new Dimension(3, 16));
        jToolBar.add(jSeparator2);
        jToolBar.add(jButton9);
        jToolBar.add(jButton10);
        JSeparator jSeparator3 = new JSeparator(1);
        jSeparator3.setMaximumSize(new Dimension(3, 16));
        jToolBar.add(jSeparator3);
        jToolBar.add(jButton11);
        this.getContentPane().add((Component)jToolBar, "North");
    }

    private void initTable() {
        KeyStoreTableModel keyStoreTableModel = new KeyStoreTableModel(this);
        this.m_jtKeyStore = new KeyStoreTable(keyStoreTableModel);
        this.m_jtKeyStore.setShowGrid(false);
        this.m_jtKeyStore.setRowMargin(0);
        this.m_jtKeyStore.getColumnModel().setColumnMargin(0);
        this.m_jtKeyStore.getTableHeader().setReorderingAllowed(false);
        this.m_jtKeyStore.setAutoResizeMode(4);
        this.m_jtKeyStore.setRowHeight(18);
        for (int i = 0; i < this.m_jtKeyStore.getColumnCount(); ++i) {
            TableColumn tableColumn = this.m_jtKeyStore.getColumnModel().getColumn(i);
            tableColumn.setHeaderRenderer(new KeyStoreTableHeadRend());
            tableColumn.setCellRenderer(new KeyStoreTableCellRend());
        }
        TableColumn tableColumn = this.m_jtKeyStore.getColumnModel().getColumn(0);
        tableColumn.setResizable(false);
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn.setPreferredWidth(20);
        int n = PREFS.getInt(RB.getString("AppPrefs.AliasWidth"), 0);
        TableColumn tableColumn2 = this.m_jtKeyStore.getColumnModel().getColumn(1);
        tableColumn2.setMinWidth(20);
        tableColumn2.setMaxWidth(10000);
        if (n <= 0) {
            tableColumn2.setPreferredWidth(350);
        } else {
            tableColumn2.setPreferredWidth(n);
        }
        this.m_jtKeyStore.setAutoCreateRowSorter(true);
        this.m_jtKeyStore.getRowSorter().toggleSortOrder(1);
        TableCellEditor tableCellEditor = this.m_jtKeyStore.getDefaultEditor(String.class);
        if (tableCellEditor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)tableCellEditor).setClickCountToStart(1000);
        }
        JScrollPane jScrollPane = new JScrollPane(this.m_jtKeyStore, 20, 30);
        jScrollPane.getViewport().setBackground(this.m_jtKeyStore.getBackground());
        int n2 = PREFS.getInt(RB.getString("AppPrefs.TableWidth"), 0);
        int n3 = PREFS.getInt(RB.getString("AppPrefs.TableHeight"), 0);
        this.m_jpKeyStoreTable = new JPanel(new BorderLayout(10, 10));
        if (n2 <= 0 || n3 <= 0) {
            this.m_jpKeyStoreTable.setPreferredSize(new Dimension(600, 400));
        } else {
            this.m_jpKeyStoreTable.setPreferredSize(new Dimension(n2, n3));
        }
        this.m_jpKeyStoreTable.add((Component)jScrollPane, "Center");
        this.m_jpKeyStoreTable.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.m_jtKeyStore.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                FPortecle.this.keyStoreTableDoubleClick(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FPortecle.this.maybeShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FPortecle.this.maybeShowPopup(mouseEvent);
            }
        });
        this.m_jpKeyStoreTable.setTransferHandler(this.m_jtKeyStore.getTransferHandler());
        this.getContentPane().add((Component)this.m_jpKeyStoreTable, "Center");
    }

    private void initStatusBar() {
        this.m_jlStatusBar = new JLabel();
        this.m_jlStatusBar.setBorder(new CompoundBorder(new EmptyBorder(3, 3, 3, 3), new CompoundBorder(new BevelBorder(1), new EmptyBorder(0, 2, 0, 2))));
        this.setDefaultStatusBarText();
        this.getContentPane().add((Component)this.m_jlStatusBar, "South");
    }

    private void initPopupMenus() {
        this.m_jpmKey = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(RB.getString("FPortecle.jmiKeyDelete.text"), RB.getString("FPortecle.jmiKeyDelete.mnemonic").charAt(0));
        jMenuItem.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiKeyDelete.image")));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.deleteSelectedEntry();
            }
        });
        jMenuItem.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiKeyDelete.statusbar"), this));
        this.m_jpmKey.add(jMenuItem);
        this.m_jpmKeyPair = new JPopupMenu();
        JMenuItem jMenuItem2 = new JMenuItem(RB.getString("FPortecle.jmiKeyPairCertDetails.text"), RB.getString("FPortecle.jmiKeyPairCertDetails.mnemonic").charAt(0));
        jMenuItem2.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiKeyPairCertDetails.image")));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.showSelectedEntry();
            }
        });
        jMenuItem2.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiKeyPairCertDetails.statusbar"), this));
        JMenuItem jMenuItem3 = new JMenuItem(RB.getString("FPortecle.jmiKeyPairExport.text"), RB.getString("FPortecle.jmiKeyPairExport.mnemonic").charAt(0));
        jMenuItem3.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiKeyPairExport.image")));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.exportSelectedEntry();
            }
        });
        jMenuItem3.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiKeyPairExport.statusbar"), this));
        JMenuItem jMenuItem4 = new JMenuItem(RB.getString("FPortecle.jmiGenerateCSR.text"), RB.getString("FPortecle.jmiGenerateCSR.mnemonic").charAt(0));
        jMenuItem4.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiGenerateCSR.image")));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.generateCsrSelectedEntry();
            }
        });
        jMenuItem4.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiGenerateCSR.statusbar"), this));
        JMenuItem jMenuItem5 = new JMenuItem(RB.getString("FPortecle.jmiImportCAReply.text"), RB.getString("FPortecle.jmiImportCAReply.mnemonic").charAt(0));
        jMenuItem5.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiImportCAReply.image")));
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.importCAReplySelectedEntry();
            }
        });
        jMenuItem5.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiImportCAReply.statusbar"), this));
        JMenuItem jMenuItem6 = new JMenuItem(RB.getString("FPortecle.jmiRenew.text"), RB.getString("FPortecle.jmiRenew.mnemonic").charAt(0));
        jMenuItem6.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiRenew.image")));
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.renewSelectedEntry();
            }
        });
        jMenuItem6.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiRenew.statusbar"), this));
        this.m_jmiSetKeyPairPass = new JMenuItem(RB.getString("FPortecle.m_jmiSetKeyPairPass.text"), RB.getString("FPortecle.m_jmiSetKeyPairPass.mnemonic").charAt(0));
        this.m_jmiSetKeyPairPass.setIcon(new ImageIcon(this.getResImage("FPortecle.m_jmiSetKeyPairPass.image")));
        this.m_jmiSetKeyPairPass.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.setPasswordSelectedEntry();
            }
        });
        this.m_jmiSetKeyPairPass.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.m_jmiSetKeyPairPass.statusbar"), this));
        JMenuItem jMenuItem7 = new JMenuItem(RB.getString("FPortecle.jmiKeyPairDelete.text"), RB.getString("FPortecle.jmiKeyPairDelete.mnemonic").charAt(0));
        jMenuItem7.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiKeyPairDelete.image")));
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.deleteSelectedEntry();
            }
        });
        jMenuItem7.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiKeyPairDelete.statusbar"), this));
        JMenuItem jMenuItem8 = new JMenuItem(RB.getString("FPortecle.jmiKeyPairClone.text"), RB.getString("FPortecle.jmiKeyPairClone.mnemonic").charAt(0));
        jMenuItem8.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiKeyPairClone.image")));
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.cloneSelectedKeyEntry();
            }
        });
        jMenuItem8.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiKeyPairClone.statusbar"), this));
        JMenuItem jMenuItem9 = new JMenuItem(RB.getString("FPortecle.jmiKeyPairRename.text"), RB.getString("FPortecle.jmiKeyPairRename.mnemonic").charAt(0));
        jMenuItem9.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiKeyPairRename.image")));
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.renameSelectedEntry();
            }
        });
        jMenuItem9.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiKeyPairRename.statusbar"), this));
        this.m_jpmKeyPair.add(jMenuItem2);
        this.m_jpmKeyPair.addSeparator();
        this.m_jpmKeyPair.add(jMenuItem3);
        this.m_jpmKeyPair.add(jMenuItem4);
        this.m_jpmKeyPair.add(jMenuItem5);
        if (EXPERIMENTAL) {
            this.m_jpmKeyPair.add(jMenuItem6);
        }
        this.m_jpmKeyPair.addSeparator();
        this.m_jpmKeyPair.add(this.m_jmiSetKeyPairPass);
        this.m_jpmKeyPair.add(jMenuItem7);
        this.m_jpmKeyPair.add(jMenuItem8);
        this.m_jpmKeyPair.add(jMenuItem9);
        this.m_jpmCert = new JPopupMenu();
        JMenuItem jMenuItem10 = new JMenuItem(RB.getString("FPortecle.jmiTrustCertDetails.text"), RB.getString("FPortecle.jmiTrustCertDetails.mnemonic").charAt(0));
        jMenuItem10.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiTrustCertDetails.image")));
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.showSelectedEntry();
            }
        });
        jMenuItem10.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiTrustCertDetails.statusbar"), this));
        JMenuItem jMenuItem11 = new JMenuItem(RB.getString("FPortecle.jmiTrustCertExport.text"), RB.getString("FPortecle.jmiTrustCertExport.mnemonic").charAt(0));
        jMenuItem11.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiTrustCertExport.image")));
        jMenuItem11.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.exportSelectedEntry();
            }
        });
        jMenuItem11.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiTrustCertExport.statusbar"), this));
        JMenuItem jMenuItem12 = new JMenuItem(RB.getString("FPortecle.jmiTrustCertDelete.text"), RB.getString("FPortecle.jmiTrustCertDelete.mnemonic").charAt(0));
        jMenuItem12.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiTrustCertDelete.image")));
        jMenuItem12.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.deleteSelectedEntry();
            }
        });
        jMenuItem12.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiTrustCertDelete.statusbar"), this));
        JMenuItem jMenuItem13 = new JMenuItem(RB.getString("FPortecle.jmiTrustCertClone.text"), RB.getString("FPortecle.jmiTrustCertClone.mnemonic").charAt(0));
        jMenuItem13.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiTrustCertClone.image")));
        jMenuItem13.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.cloneSelectedCertificateEntry();
            }
        });
        jMenuItem13.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiTrustCertClone.statusbar"), this));
        JMenuItem jMenuItem14 = new JMenuItem(RB.getString("FPortecle.jmiTrustCertRename.text"), RB.getString("FPortecle.jmiTrustCertRename.mnemonic").charAt(0));
        jMenuItem14.setIcon(new ImageIcon(this.getResImage("FPortecle.jmiTrustCertRename.image")));
        jMenuItem14.addActionListener(new ActionListener(){

            @Override
            protected void act() {
                FPortecle.this.renameSelectedEntry();
            }
        });
        jMenuItem14.addChangeListener(new StatusBarChangeHandler(RB.getString("FPortecle.jmiTrustCertRename.statusbar"), this));
        this.m_jpmCert.add(jMenuItem10);
        this.m_jpmCert.addSeparator();
        this.m_jpmCert.add(jMenuItem11);
        this.m_jpmCert.addSeparator();
        this.m_jpmCert.add(jMenuItem12);
        this.m_jpmCert.add(jMenuItem13);
        this.m_jpmCert.add(jMenuItem14);
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        Point point;
        int n;
        if (mouseEvent.isPopupTrigger() && (n = this.m_jtKeyStore.rowAtPoint(point = new Point(mouseEvent.getX(), mouseEvent.getY()))) != -1) {
            this.m_jtKeyStore.setRowSelectionInterval(n, n);
            String string = this.m_jtKeyStore.getSelectedType();
            if (string.equals(KeyStoreTableModel.KEY_PAIR_ENTRY)) {
                this.m_jpmKeyPair.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (string.equals(KeyStoreTableModel.TRUST_CERT_ENTRY)) {
                this.m_jpmCert.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (string.equals(KeyStoreTableModel.KEY_ENTRY)) {
                this.m_jpmKey.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else {
                LOG.warning("Popup context menu requested for unknown entry: " + string);
            }
        }
    }

    private void keyStoreTableDoubleClick(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.showSelectedEntry();
        }
    }

    private void showAbout() {
        DAbout dAbout = new DAbout((Window)this);
        dAbout.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dAbout);
    }

    private boolean generateKeyPair() {
        KeyPair keyPair;
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        DGenerateKeyPair dGenerateKeyPair = new DGenerateKeyPair((Window)this);
        dGenerateKeyPair.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dGenerateKeyPair);
        if (!dGenerateKeyPair.isSuccessful()) {
            return false;
        }
        int n = dGenerateKeyPair.getKeySize();
        KeyPairType keyPairType = dGenerateKeyPair.getKeyPairType();
        DGeneratingKeyPair dGeneratingKeyPair = new DGeneratingKeyPair((Window)this);
        SwingWorker<KeyPair, Object> swingWorker = dGeneratingKeyPair.getKeyPairWorker(keyPairType, n);
        swingWorker.execute();
        DGenerateCertificate dGenerateCertificate = new DGenerateCertificate((Window)this, RB.getString("FPortecle.GenerateCertificate.Title"), keyPairType);
        dGenerateCertificate.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dGenerateCertificate);
        if (!dGenerateCertificate.isSuccessful()) {
            swingWorker.cancel(true);
            return false;
        }
        if (!swingWorker.isDone()) {
            dGeneratingKeyPair.setLocationRelativeTo(this);
            SwingHelper.showAndWait(dGeneratingKeyPair);
            if (!dGeneratingKeyPair.isClosedByWorker()) {
                swingWorker.cancel(true);
                return false;
            }
        }
        try {
            keyPair = swingWorker.get();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            DThrowable.showAndWait(this, null, throwable == null ? executionException : throwable);
            return false;
        }
        X509Certificate x509Certificate = dGenerateCertificate.generateCertificate(keyPair);
        if (x509Certificate == null) {
            return false;
        }
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        String string = X509CertUtil.getCertificateAlias(x509Certificate).toLowerCase();
        try {
            string = this.getNewEntryAlias(keyStore, string, "DGenerateCertificate.KeyPairEntryAlias.Title", false);
        }
        catch (KeyStoreException keyStoreException) {
            DThrowable.showAndWait(this, null, keyStoreException);
            return false;
        }
        if (string == null) {
            return false;
        }
        char[] cArray = KeyStoreUtil.DUMMY_PASSWORD;
        if (this.m_keyStoreWrap.getKeyStoreType().isEntryPasswordSupported()) {
            DGetNewPassword dGetNewPassword = new DGetNewPassword((Window)this, RB.getString("DGenerateCertificate.KeyPairEntryPassword.Title"));
            dGetNewPassword.setLocationRelativeTo(this);
            SwingHelper.showAndWait(dGetNewPassword);
            cArray = dGetNewPassword.getPassword();
            if (cArray == null) {
                return false;
            }
        }
        try {
            if (keyStore.containsAlias(string)) {
                keyStore.deleteEntry(string);
            }
            keyStore.setKeyEntry(string, keyPair.getPrivate(), cArray, new X509Certificate[]{x509Certificate});
            this.m_keyStoreWrap.setEntryPassword(string, cArray);
            this.m_keyStoreWrap.setChanged(true);
        }
        catch (KeyStoreException keyStoreException) {
            DThrowable.showAndWait(this, null, keyStoreException);
            return false;
        }
        this.selectedAlias = string;
        this.updateControls();
        this.updateTitle();
        JOptionPane.showMessageDialog(this, RB.getString("FPortecle.KeyPairGenerationSuccessful.message"), RB.getString("FPortecle.GenerateCertificate.Title"), 1);
        return true;
    }

    private boolean openKeyStoreFile() {
        File file;
        int n;
        if (this.needSave() && ((n = this.wantSave()) == 0 && !this.saveKeyStore() || n == 2)) {
            return false;
        }
        JFileChooser jFileChooser = FileChooserFactory.getKeyStoreFileChooser(null);
        File file2 = this.m_lastDir.getLastDir();
        if (file2 != null) {
            jFileChooser.setCurrentDirectory(file2);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.OpenKeyStoreFile.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n2 = jFileChooser.showOpenDialog(this);
        return n2 == 0 && this.openKeyStoreFile(file = jFileChooser.getSelectedFile(), true);
    }

    private boolean openCaCertsKeyStoreFile() {
        int n;
        if (this.needSave() && ((n = this.wantSave()) == 0 && !this.saveKeyStore() || n == 2)) {
            return false;
        }
        return this.openKeyStoreFile(this.m_fCaCertsFile, false);
    }

    boolean openKeyStoreFile(File file, boolean bl) {
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(RB.getString("FPortecle.FileNotFound.message"), file), RB.getString("FPortecle.OpenKeyStoreFile.Title"), 2);
            return false;
        }
        if (!file.isFile()) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(RB.getString("FPortecle.NotFile.message"), file), RB.getString("FPortecle.OpenKeyStoreFile.Title"), 2);
            return false;
        }
        if (bl) {
            this.m_lastDir.updateLastDir(file);
        }
        DGetPassword dGetPassword = new DGetPassword((Window)this, MessageFormat.format(RB.getString("FPortecle.GetKeyStorePassword.Title"), file.getName()));
        dGetPassword.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dGetPassword);
        char[] cArray = dGetPassword.getPassword();
        if (cArray == null) {
            return false;
        }
        try {
            int n;
            KeyStore keyStore = null;
            KeyStoreType[] keyStoreTypeArray = KeyStoreUtil.getAvailableTypes();
            CryptoException[] cryptoExceptionArray = new CryptoException[keyStoreTypeArray.length];
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < keyStoreTypeArray.length; ++n) {
                stringBuilder.append(", ").append(keyStoreTypeArray[n].toString());
                try {
                    keyStore = KeyStoreUtil.loadKeyStore(file, cArray, keyStoreTypeArray[n]);
                    break;
                }
                catch (CryptoException cryptoException) {
                    cryptoExceptionArray[n] = cryptoException;
                    continue;
                }
            }
            if (keyStore == null) {
                if (stringBuilder.length() > 2) {
                    stringBuilder.delete(0, 2);
                }
                if ((n = SwingHelper.showConfirmDialog(this, MessageFormat.format(RB.getString("FPortecle.NoOpenKeyStoreFile.message"), file, stringBuilder), RB.getString("FPortecle.OpenKeyStoreFile.Title"))) == 0) {
                    for (CryptoException cryptoException : cryptoExceptionArray) {
                        DThrowable.showAndWait(this, null, cryptoException);
                    }
                }
                return false;
            }
            this.m_keyStoreWrap = new KeyStoreWrapper(keyStore, file, cArray);
            this.selectedAlias = null;
            this.updateControls();
            this.updateTitle();
            this.m_jmrfFile.add(this.createRecentFileMenuItem(file));
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(RB.getString("FPortecle.NoRead.message"), file), RB.getString("FPortecle.OpenKeyStoreFile.Title"), 2);
            return false;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
    }

    private boolean openKeyStorePkcs11() {
        int n;
        if (this.needSave() && ((n = this.wantSave()) == 0 && !this.saveKeyStore() || n == 2)) {
            return false;
        }
        DChoosePkcs11Provider dChoosePkcs11Provider = new DChoosePkcs11Provider((Window)this, RB.getString("FPortecle.ChoosePkcs11Provider.Title"), null);
        dChoosePkcs11Provider.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dChoosePkcs11Provider);
        String string = dChoosePkcs11Provider.getProvider();
        return string == null ? false : this.openKeyStorePkcs11(string);
    }

    boolean openKeyStorePkcs11(String string) {
        DGetPassword dGetPassword = new DGetPassword((Window)this, MessageFormat.format(RB.getString("FPortecle.GetKeyStorePassword.Title"), string));
        dGetPassword.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dGetPassword);
        char[] cArray = dGetPassword.getPassword();
        if (cArray == null) {
            return false;
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStoreUtil.loadKeyStore(string, cArray);
            this.m_keyStoreWrap = new KeyStoreWrapper(keyStore, null, cArray);
        }
        catch (CryptoException cryptoException) {
            int n = JOptionPane.showConfirmDialog(this, MessageFormat.format(RB.getString("FPortecle.NoOpenKeyStorePkcs11.message"), string), RB.getString("FPortecle.ChoosePkcs11Provider.Title"), 0);
            if (n == 0) {
                DThrowable.showAndWait(this, null, cryptoException);
            }
            return false;
        }
        this.selectedAlias = null;
        this.updateControls();
        this.updateTitle();
        return true;
    }

    boolean saveKeyStore() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        File file = this.m_keyStoreWrap.getKeyStoreFile();
        if (file == null) {
            return this.saveKeyStoreAs();
        }
        char[] cArray = this.m_keyStoreWrap.getPassword();
        if (cArray == null && (cArray = this.getNewKeyStorePassword()) == null) {
            return false;
        }
        try {
            this.m_keyStoreWrap.setKeyStore(KeyStoreUtil.saveKeyStore(this.m_keyStoreWrap.getKeyStore(), file, cArray));
            this.m_keyStoreWrap.setPassword(cArray);
            this.m_keyStoreWrap.setKeyStoreFile(file);
            this.m_keyStoreWrap.setChanged(false);
            this.updateControls();
            this.updateTitle();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(RB.getString("FPortecle.NoWriteFile.message"), file), RB.getString("FPortecle.SaveKeyStore.Title"), 2);
            return false;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
    }

    private char[] getNewKeyStorePassword() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        DGetNewPassword dGetNewPassword = new DGetNewPassword((Window)this, RB.getString("FPortecle.SetKeyStorePassword.Title"));
        dGetNewPassword.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dGetNewPassword);
        return dGetNewPassword.getPassword();
    }

    private boolean saveKeyStoreAs() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        char[] cArray = this.m_keyStoreWrap.getPassword();
        if ((this.m_keyStoreWrap.getKeyStoreFile() != null || this.m_keyStoreWrap.getKeyStoreFile() == null && cArray == null) && (cArray = this.getNewKeyStorePassword()) == null) {
            return false;
        }
        JFileChooser jFileChooser = FileChooserFactory.getKeyStoreFileChooser(this.m_keyStoreWrap.getKeyStoreType());
        File file = this.m_lastDir.getLastDir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.SaveKeyStoreAs.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            try {
                if (!this.confirmOverwrite(file2, RB.getString("FPortecle.SaveKeyStoreAs.Title"))) {
                    return false;
                }
                this.m_keyStoreWrap.setKeyStore(KeyStoreUtil.saveKeyStore(this.m_keyStoreWrap.getKeyStore(), file2, cArray));
                this.m_keyStoreWrap.setPassword(cArray);
                this.m_keyStoreWrap.setKeyStoreFile(file2);
                this.m_keyStoreWrap.setChanged(false);
                this.updateControls();
                this.updateTitle();
                this.m_jmrfFile.add(this.createRecentFileMenuItem(file2));
                this.m_lastDir.updateLastDir(file2);
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(RB.getString("FPortecle.NoWriteFile.message"), file2), RB.getString("FPortecle.SaveKeyStoreAs.Title"), 2);
                return false;
            }
            catch (Exception exception) {
                DThrowable.showAndWait(this, null, exception);
                return false;
            }
        }
        return false;
    }

    boolean needSave() {
        return this.m_keyStoreWrap != null && this.m_keyStoreWrap.isChanged();
    }

    int wantSave() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        File file = this.m_keyStoreWrap.getKeyStoreFile();
        String string = file == null ? RB.getString("FPortecle.Untitled") : file.getName();
        String string2 = MessageFormat.format(RB.getString("FPortecle.WantSaveChanges.message"), string);
        int n = JOptionPane.showConfirmDialog(this, string2, RB.getString("FPortecle.WantSaveChanges.Title"), 1);
        if (n == -1) {
            n = 2;
        }
        return n;
    }

    private boolean newKeyStore() {
        int n;
        if (this.needSave() && ((n = this.wantSave()) == 0 ? !this.saveKeyStore() : n == 2)) {
            return false;
        }
        try {
            DNewKeyStoreType dNewKeyStoreType = new DNewKeyStoreType((Window)this);
            dNewKeyStoreType.setLocationRelativeTo(this);
            SwingHelper.showAndWait(dNewKeyStoreType);
            KeyStoreType keyStoreType = dNewKeyStoreType.getKeyStoreType();
            if (keyStoreType == null) {
                return false;
            }
            KeyStore keyStore = KeyStoreUtil.createKeyStore(keyStoreType);
            this.m_keyStoreWrap = new KeyStoreWrapper(keyStore);
            this.selectedAlias = null;
            this.updateControls();
            this.updateTitle();
            return true;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
    }

    private void examineCert(File file) {
        if (file == null) {
            file = this.chooseExamineCertFile();
        }
        if (file == null) {
            return;
        }
        this.m_lastDir.updateLastDir(file);
        DViewCertificate.showAndWait(this, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean examineCertSSL() {
        Object object;
        InetSocketAddress inetSocketAddress = this.chooseExamineCertSSL();
        if (inetSocketAddress == null) {
            return false;
        }
        boolean bl = false;
        int n = 10000;
        X509Certificate[] x509CertificateArray = null;
        String string = null;
        String string2 = null;
        Socket socket = null;
        try {
            Object object2;
            if (bl) {
                object = (SSLSocketFactory)SSLSocketFactory.getDefault();
            } else {
                object2 = SSLContext.getInstance("SSL");
                TrustManager[] trustManagerArray = new X509TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                if (this.m_rnd == null) {
                    this.m_rnd = new SecureRandom();
                }
                ((SSLContext)object2).init(null, trustManagerArray, this.m_rnd);
                object = ((SSLContext)object2).getSocketFactory();
            }
            socket = (SSLSocket)((SocketFactory)object).createSocket();
            socket.setSoTimeout(n);
            socket.connect(inetSocketAddress, n);
            object2 = ((SSLSocket)socket).getSession();
            x509CertificateArray = (X509Certificate[])object2.getPeerCertificates();
            string = object2.getProtocol();
            string2 = object2.getCipherSuite();
            object2.invalidate();
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            if (socket != null && !socket.isClosed()) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    DThrowable.showAndWait(this, null, iOException);
                }
            }
        }
        try {
            if (x509CertificateArray != null && x509CertificateArray.length != 0) {
                object = new DViewCertificate(this, MessageFormat.format(RB.getString("FPortecle.CertDetailsSSL.Title"), inetSocketAddress.getHostName() + ":" + inetSocketAddress.getPort()), x509CertificateArray, string, string2);
                ((Window)object).setLocationRelativeTo(this);
                SwingHelper.showAndWait((Window)object);
                return true;
            }
            return false;
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            return false;
        }
    }

    private boolean examineCSR(File file) {
        if (file == null) {
            file = this.chooseExamineCSRFile();
        }
        if (file == null) {
            return false;
        }
        PKCS10CertificationRequest pKCS10CertificationRequest = this.openCSR(file);
        this.m_lastDir.updateLastDir(file);
        if (pKCS10CertificationRequest != null) {
            try {
                DViewCSR dViewCSR = new DViewCSR((Window)this, MessageFormat.format(RB.getString("FPortecle.CsrDetailsFile.Title"), file.getName()), pKCS10CertificationRequest);
                dViewCSR.setLocationRelativeTo(this);
                SwingHelper.showAndWait(dViewCSR);
                return true;
            }
            catch (CryptoException cryptoException) {
                DThrowable.showAndWait(this, null, cryptoException);
            }
        }
        return false;
    }

    private void examineCRL(File file) {
        if (file == null) {
            file = this.chooseExamineCRLFile();
        }
        if (file == null) {
            return;
        }
        this.m_lastDir.updateLastDir(file);
        DViewCRL.showAndWait(this, file);
    }

    private File chooseImportCAFile() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        JFileChooser jFileChooser = FileChooserFactory.getCertFileChooser();
        File file = this.m_lastDir.getLastDir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.ImportCaReply.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, RB.getString("FPortecle.ImportCaReply.button"));
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private File chooseExamineCertFile() {
        JFileChooser jFileChooser = FileChooserFactory.getCertFileChooser();
        File file = this.m_lastDir.getLastDir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.ExamineCertificate.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, RB.getString("FPortecle.ExamineCertificate.button"));
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private InetSocketAddress chooseExamineCertSSL() {
        DGetHostPort dGetHostPort = new DGetHostPort((Window)this, RB.getString("FPortecle.ExamineCertificateSSL.Title"), null);
        dGetHostPort.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dGetHostPort);
        return dGetHostPort.getHostPort();
    }

    private File chooseExamineCSRFile() {
        JFileChooser jFileChooser = FileChooserFactory.getCsrFileChooser(null);
        File file = this.m_lastDir.getLastDir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.ExamineCsr.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, RB.getString("FPortecle.ExamineCsr.button"));
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private File chooseExamineCRLFile() {
        JFileChooser jFileChooser = FileChooserFactory.getCrlFileChooser();
        File file = this.m_lastDir.getLastDir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.ExamineCrl.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, RB.getString("FPortecle.ExamineCrl.button"));
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private File chooseTrustCertFile() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        JFileChooser jFileChooser = FileChooserFactory.getX509FileChooser(null);
        File file = this.m_lastDir.getLastDir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.ImportTrustCert.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, RB.getString("FPortecle.ImportTrustCert.button"));
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private File chooseImportFile() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        JFileChooser jFileChooser = FileChooserFactory.getKeyPairFileChooser(null);
        File file = this.m_lastDir.getLastDir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.ImportKeyPairFile.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, RB.getString("FPortecle.ImportKeyPairFile.button"));
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private File chooseGenerateCsrFile(String string) {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        JFileChooser jFileChooser = FileChooserFactory.getCsrFileChooser(string);
        File file = this.m_lastDir.getLastDir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.GenerateCsr.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, RB.getString("FPortecle.GenerateCsr.button"));
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private X509Certificate[] openCert(File file) {
        try {
            URL uRL = file.toURI().toURL();
            ArrayList<Exception> arrayList = new ArrayList<Exception>();
            X509Certificate[] x509CertificateArray = X509CertUtil.loadCertificates(uRL, arrayList);
            if (x509CertificateArray == null) {
                int n = SwingHelper.showConfirmDialog(this, MessageFormat.format(RB.getString("FPortecle.NoOpenCertificate.message"), file), RB.getString("FPortecle.OpenCertificate.Title"));
                if (n == 0) {
                    for (Exception exception : arrayList) {
                        DThrowable.showAndWait(this, null, exception);
                    }
                }
            } else if (x509CertificateArray.length == 0) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(RB.getString("FPortecle.NoCertsFound.message"), file), RB.getString("FPortecle.OpenCertificate.Title"), 2);
            }
            return x509CertificateArray;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return null;
        }
    }

    private PKCS10CertificationRequest openCSR(File file) {
        try {
            return X509CertUtil.loadCSR(file.toURI().toURL());
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(RB.getString("FPortecle.NoRead.message"), file), MessageFormat.format(RB.getString("FPortecle.CsrDetailsFile.Title"), file.getName()), 2);
            return null;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return null;
        }
    }

    private boolean importCAReplySelectedEntry() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        String string = this.m_jtKeyStore.getSelectedAlias();
        if (string == null) {
            return false;
        }
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        File file = this.chooseImportCAFile();
        if (file == null) {
            return false;
        }
        Certificate[] certificateArray = this.openCert(file);
        if (certificateArray == null || certificateArray.length == 0) {
            return false;
        }
        try {
            Object object;
            Object[] objectArray;
            certificateArray = X509CertUtil.orderX509CertChain((X509Certificate[])certificateArray);
            X509Certificate[] x509CertificateArray = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(keyStore.getCertificateChain(string)));
            if (!x509CertificateArray[0].getPublicKey().equals(certificateArray[0].getPublicKey())) {
                JOptionPane.showMessageDialog(this, RB.getString("FPortecle.NoMatchPubKeyCaReply.message"), RB.getString("FPortecle.ImportCaReply.Title"), 0);
                return false;
            }
            if (this.m_bUseCaCerts && this.m_caCertsKeyStore == null) {
                this.m_caCertsKeyStore = this.openCaCertsKeyStore();
                if (this.m_caCertsKeyStore == null) {
                    return false;
                }
            }
            Certificate[] certificateArray2 = null;
            if (certificateArray.length > 1) {
                objectArray = certificateArray[certificateArray.length - 1];
                object = null;
                if (this.m_bUseCaCerts) {
                    object = X509CertUtil.matchCertificate(this.m_caCertsKeyStore, (X509Certificate)objectArray);
                }
                if (object == null) {
                    object = X509CertUtil.matchCertificate(keyStore, (X509Certificate)objectArray);
                }
                if (object == null) {
                    JOptionPane.showMessageDialog(this, RB.getString("FPortecle.NoMatchRootCertCaReplyConfirm.message"), RB.getString("FPortecle.ImportCaReply.Title"), 1);
                    DViewCertificate dViewCertificate = new DViewCertificate((Window)this, MessageFormat.format(RB.getString("FPortecle.CertDetails.Title"), file.getName()), new X509Certificate[]{objectArray});
                    dViewCertificate.setLocationRelativeTo(this);
                    SwingHelper.showAndWait(dViewCertificate);
                    int n = JOptionPane.showConfirmDialog(this, RB.getString("FPortecle.AcceptCaReply.message"), RB.getString("FPortecle.ImportCaReply.Title"), 0);
                    if (n != 0) {
                        return false;
                    }
                    certificateArray2 = certificateArray;
                } else {
                    certificateArray2 = certificateArray;
                }
            } else {
                objectArray = null;
                objectArray = this.m_bUseCaCerts ? new KeyStore[]{this.m_caCertsKeyStore, keyStore} : new KeyStore[]{keyStore};
                object = X509CertUtil.establishTrust(objectArray, certificateArray[0]);
                if (object == null) {
                    JOptionPane.showMessageDialog(this, RB.getString("FPortecle.NoTrustCaReply.message"), RB.getString("FPortecle.ImportCaReply.Title"), 0);
                    return false;
                }
                certificateArray2 = object;
            }
            objectArray = this.m_keyStoreWrap.getEntryPassword(string);
            if (objectArray == null) {
                objectArray = KeyStoreUtil.DUMMY_PASSWORD;
                if (this.m_keyStoreWrap.getKeyStoreType().isEntryPasswordSupported()) {
                    object = new DGetPassword((Window)this, RB.getString("FPortecle.KeyEntryPassword.Title"));
                    ((Window)object).setLocationRelativeTo(this);
                    SwingHelper.showAndWait((Window)object);
                    objectArray = ((DGetPassword)object).getPassword();
                    if (objectArray == null) {
                        return false;
                    }
                }
            }
            object = keyStore.getKey(string, (char[])objectArray);
            keyStore.deleteEntry(string);
            keyStore.setKeyEntry(string, (Key)object, (char[])objectArray, certificateArray2);
            this.m_keyStoreWrap.setChanged(true);
            this.m_keyStoreWrap.setEntryPassword(string, (char[])objectArray);
            this.updateControls();
            this.updateTitle();
            this.m_lastDir.updateLastDir(file);
            JOptionPane.showMessageDialog(this, RB.getString("FPortecle.ImportCaReplySuccessful.message"), RB.getString("FPortecle.ImportCaReply.Title"), 1);
            return true;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
    }

    private boolean renewSelectedEntry() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        String string = this.m_jtKeyStore.getSelectedAlias();
        if (string == null) {
            return false;
        }
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        try {
            char[] cArray = this.m_keyStoreWrap.getEntryPassword(string);
            if (cArray == null) {
                cArray = KeyStoreUtil.DUMMY_PASSWORD;
                if (this.m_keyStoreWrap.getKeyStoreType().isEntryPasswordSupported()) {
                    DGetPassword dGetPassword = new DGetPassword((Window)this, RB.getString("FPortecle.KeyEntryPassword.Title"));
                    dGetPassword.setLocationRelativeTo(this);
                    SwingHelper.showAndWait(dGetPassword);
                    cArray = dGetPassword.getPassword();
                    if (cArray == null) {
                        return false;
                    }
                }
            }
            int n = 365;
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string, new KeyStore.PasswordProtection(cArray));
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            X509Certificate x509Certificate = (X509Certificate)privateKeyEntry.getCertificate();
            PublicKey publicKey = x509Certificate.getPublicKey();
            X509Certificate x509Certificate2 = X509CertUtil.renewCert(x509Certificate, n, publicKey, privateKey);
            KeyStore.PrivateKeyEntry privateKeyEntry2 = new KeyStore.PrivateKeyEntry(privateKey, new Certificate[]{x509Certificate2});
            if (keyStore.containsAlias(string)) {
                keyStore.deleteEntry(string);
            }
            keyStore.setEntry(string, privateKeyEntry2, new KeyStore.PasswordProtection(cArray));
            this.m_keyStoreWrap.setChanged(true);
            this.m_keyStoreWrap.setEntryPassword(string, new char[0]);
            this.updateControls();
            this.updateTitle();
            JOptionPane.showMessageDialog(this, RB.getString("FPortecle.RenewSelfSignedSuccessful.message"), RB.getString("FPortecle.RenewSelfSigned.Title"), 1);
            return true;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
    }

    private boolean importTrustedCert() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        File file = this.chooseTrustCertFile();
        if (file == null) {
            return false;
        }
        X509Certificate[] x509CertificateArray = this.openCert(file);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return false;
        }
        if (x509CertificateArray.length > 1) {
            JOptionPane.showMessageDialog(this, RB.getString("FPortecle.NoMultipleTrustCertImport.message"), RB.getString("FPortecle.ImportTrustCert.Title"), 0);
            return false;
        }
        X509Certificate x509Certificate = x509CertificateArray[0];
        try {
            Object object;
            int n;
            KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
            String string = X509CertUtil.matchCertificate(keyStore, x509Certificate);
            if (string != null && (n = JOptionPane.showConfirmDialog(this, MessageFormat.format(RB.getString("FPortecle.TrustCertExistsConfirm.message"), string), RB.getString("FPortecle.ImportTrustCert.Title"), 0)) != 0) {
                return false;
            }
            if (this.m_bUseCaCerts && this.m_caCertsKeyStore == null) {
                this.m_caCertsKeyStore = this.openCaCertsKeyStore();
                if (this.m_caCertsKeyStore == null) {
                    return false;
                }
            }
            KeyStore[] keyStoreArray = null;
            keyStoreArray = this.m_bUseCaCerts ? new KeyStore[]{this.m_caCertsKeyStore, keyStore} : new KeyStore[]{keyStore};
            if (X509CertUtil.establishTrust(keyStoreArray, x509Certificate) == null) {
                JOptionPane.showMessageDialog(this, RB.getString("FPortecle.NoTrustPathCertConfirm.message"), RB.getString("FPortecle.ImportTrustCert.Title"), 1);
                object = new DViewCertificate((Window)this, MessageFormat.format(RB.getString("FPortecle.CertDetails.Title"), file.getName()), new X509Certificate[]{x509Certificate});
                ((Window)object).setLocationRelativeTo(this);
                SwingHelper.showAndWait((Window)object);
                int n2 = JOptionPane.showConfirmDialog(this, RB.getString("FPortecle.AcceptTrustCert.message"), RB.getString("FPortecle.ImportTrustCert.Title"), 0);
                if (n2 != 0) {
                    return false;
                }
            }
            object = X509CertUtil.getCertificateAlias(x509Certificate).toLowerCase();
            if ((object = this.getNewEntryAlias(keyStore, (String)object, "FPortecle.TrustCertEntryAlias.Title", false)) == null) {
                return false;
            }
            if (keyStore.containsAlias((String)object)) {
                keyStore.deleteEntry((String)object);
            }
            keyStore.setCertificateEntry((String)object, x509Certificate);
            this.m_keyStoreWrap.setChanged(true);
            this.selectedAlias = object;
            this.updateControls();
            this.updateTitle();
            this.m_lastDir.updateLastDir(file);
            JOptionPane.showMessageDialog(this, RB.getString("FPortecle.ImportTrustCertSuccessful.message"), RB.getString("FPortecle.ImportTrustCert.Title"), 1);
            return true;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importKeyPair() {
        Object object;
        Object object2;
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        File file = this.chooseImportFile();
        if (file == null) {
            return false;
        }
        this.m_lastDir.updateLastDir(file);
        if (!file.isFile()) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(RB.getString("FPortecle.NotFile.message"), file), RB.getString("FPortecle.ImportKeyPair.Title"), 2);
            return false;
        }
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        KeyStore keyStore2 = null;
        BufferedReader bufferedReader = null;
        try {
            object2 = new PasswordFinder(){
                private int passwordNumber = 1;

                @Override
                public char[] getPassword() {
                    DGetPassword dGetPassword = new DGetPassword((Window)FPortecle.this, MessageFormat.format(RB.getString("FPortecle.PrivateKeyPassword.Title"), String.valueOf(this.passwordNumber)));
                    dGetPassword.setLocationRelativeTo(FPortecle.this);
                    SwingHelper.showAndWait(dGetPassword);
                    char[] cArray = dGetPassword.getPassword();
                    ++this.passwordNumber;
                    return cArray;
                }
            };
            bufferedReader = new PEMReader((Reader)new FileReader(file.getPath()), (PasswordFinder)object2);
            keyStore2 = KeyStoreUtil.loadEntries((PEMReader)bufferedReader);
            if (keyStore2.size() == 0) {
                keyStore2 = null;
            }
        }
        catch (Exception exception) {
            arrayList.add(exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (keyStore2 == null) {
            object2 = new DGetPassword((Window)this, RB.getString("FPortecle.Pkcs12Password.Title"));
            ((Window)object2).setLocationRelativeTo(this);
            SwingHelper.showAndWait((Window)object2);
            object = ((DGetPassword)object2).getPassword();
            if (object == null) {
                return false;
            }
            try {
                keyStore2 = KeyStoreUtil.loadKeyStore(file, (char[])object, KeyStoreType.PKCS12);
            }
            catch (Exception exception) {
                arrayList.add(exception);
            }
        }
        if (keyStore2 == null && !arrayList.isEmpty()) {
            int n = SwingHelper.showConfirmDialog(this, MessageFormat.format(RB.getString("FPortecle.NoOpenKeyPairFile.message"), file), RB.getString("FPortecle.ImportKeyPairFile.Title"));
            if (n == 0) {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    Exception exception = (Exception)object.next();
                    DThrowable.showAndWait(this, null, exception);
                }
            }
            return false;
        }
        try {
            object2 = new DImportKeyPair((Window)this, keyStore2);
            ((Window)object2).setLocationRelativeTo(this);
            SwingHelper.showAndWait((Window)object2);
            object = ((DImportKeyPair)object2).getPrivateKey();
            Certificate[] certificateArray = ((DImportKeyPair)object2).getCertificateChain();
            if (object == null || certificateArray == null) {
                return false;
            }
            String string = ((DImportKeyPair)object2).getAlias();
            if (string == null) {
                string = X509CertUtil.getCertificateAlias(X509CertUtil.convertCertificate(certificateArray[0]));
            }
            if ((string = this.getNewEntryAlias(keyStore, string, "FPortecle.KeyPairEntryAlias.Title", false)) == null) {
                return false;
            }
            char[] cArray = KeyStoreUtil.DUMMY_PASSWORD;
            if (this.m_keyStoreWrap.getKeyStoreType().isEntryPasswordSupported()) {
                DGetNewPassword dGetNewPassword = new DGetNewPassword((Window)this, RB.getString("FPortecle.KeyEntryPassword.Title"));
                dGetNewPassword.setLocationRelativeTo(this);
                SwingHelper.showAndWait(dGetNewPassword);
                cArray = dGetNewPassword.getPassword();
                if (cArray == null) {
                    return false;
                }
            }
            if (keyStore.containsAlias(string)) {
                keyStore.deleteEntry(string);
            }
            keyStore.setKeyEntry(string, (Key)object, cArray, certificateArray);
            this.m_keyStoreWrap.setEntryPassword(string, cArray);
            this.m_keyStoreWrap.setChanged(true);
            this.selectedAlias = string;
            this.updateControls();
            this.updateTitle();
            JOptionPane.showMessageDialog(this, RB.getString("FPortecle.KeyPairImportSuccessful.message"), RB.getString("FPortecle.ImportKeyPair.Title"), 1);
            return true;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
    }

    private KeyStore openCaCertsKeyStore() {
        DGetPassword dGetPassword = new DGetPassword((Window)this, RB.getString("FPortecle.CaCertsKeyStorePassword.Title"));
        dGetPassword.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dGetPassword);
        char[] cArray = dGetPassword.getPassword();
        if (cArray == null) {
            return null;
        }
        try {
            int n;
            KeyStore keyStore = null;
            KeyStoreType[] keyStoreTypeArray = KeyStoreUtil.getAvailableTypes();
            CryptoException[] cryptoExceptionArray = new CryptoException[keyStoreTypeArray.length];
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < keyStoreTypeArray.length; ++n) {
                stringBuilder.append(", ").append(keyStoreTypeArray[n].toString());
                try {
                    keyStore = KeyStoreUtil.loadKeyStore(this.m_fCaCertsFile, cArray, keyStoreTypeArray[n]);
                    break;
                }
                catch (CryptoException cryptoException) {
                    cryptoExceptionArray[n] = cryptoException;
                    continue;
                }
            }
            if (keyStore == null) {
                if (stringBuilder.length() > 2) {
                    stringBuilder.delete(0, 2);
                }
                if ((n = SwingHelper.showConfirmDialog(this, MessageFormat.format(RB.getString("FPortecle.NoOpenCaCertsKeyStore.message"), this.m_fCaCertsFile, stringBuilder), RB.getString("FPortecle.OpenCaCertsKeyStore.Title"))) == 0) {
                    for (CryptoException cryptoException : cryptoExceptionArray) {
                        DThrowable.showAndWait(this, null, cryptoException);
                    }
                }
                return null;
            }
            return keyStore;
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(RB.getString("FPortecle.NoRead.message"), this.m_fCaCertsFile), RB.getString("FPortecle.OpenCaCertsKeyStore.Title"), 2);
            return null;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return null;
        }
    }

    private void showHelp() {
        if (this.m_fHelp == null) {
            URL uRL;
            URL uRL2;
            String string = RB.getString("FPortecle.Help.Contents");
            if (string.startsWith("/")) {
                uRL2 = FPortecle.class.getResource(string);
            } else {
                try {
                    uRL2 = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    DThrowable.showAndWait(this, null, malformedURLException);
                    return;
                }
            }
            string = RB.getString("FPortecle.Help.Home");
            if (string.startsWith("/")) {
                uRL = FPortecle.class.getResource(string);
            } else {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    DThrowable.showAndWait(this, null, malformedURLException);
                    return;
                }
            }
            this.m_fHelp = new FHelp(RB.getString("FPortecle.Help.Title"), uRL, uRL2);
            this.m_fHelp.setLocation(this.getX() + 25, this.getY() + 25);
        }
        SwingHelper.showAndWait(this.m_fHelp);
    }

    private void visitWebsite() {
        DesktopUtil.browse(this, URI.create(RB.getString("FPortecle.WebsiteAddress")));
    }

    private void visitSFNetProject() {
        DesktopUtil.browse(this, URI.create(RB.getString("FPortecle.SFNetProjectAddress")));
    }

    private void visitMailListSignup() {
        DesktopUtil.browse(this, URI.create(RB.getString("FPortecle.MailListSignupAddress")));
    }

    private void makeDonation() {
        DesktopUtil.browse(this, URI.create(RB.getString("FPortecle.DonateAddress")));
    }

    private void showSecurityProviders() {
        DProviderInfo dProviderInfo = new DProviderInfo((Window)this);
        dProviderInfo.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dProviderInfo);
    }

    private void showJarInfo() {
        try {
            DJarInfo dJarInfo = new DJarInfo((Window)this);
            dJarInfo.setLocationRelativeTo(this);
            SwingHelper.showAndWait(dJarInfo);
        }
        catch (IOException iOException) {
            DThrowable.showAndWait(this, null, iOException);
        }
    }

    private void showOptions() {
        DOptions dOptions = new DOptions((Window)this, this.m_bUseCaCerts, this.m_fCaCertsFile);
        dOptions.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dOptions);
        File file = dOptions.getCaCertsFile();
        if (!file.equals(this.m_fCaCertsFile)) {
            this.m_caCertsKeyStore = null;
        }
        this.m_fCaCertsFile = file;
        this.m_bUseCaCerts = dOptions.isUseCaCerts();
        String string = dOptions.getLookFeelClassName();
        boolean bl = dOptions.isLookFeelDecoration();
        if (!(string == null || string.equals(UIManager.getLookAndFeel().getClass().getName()) && bl == JFrame.isDefaultLookAndFeelDecorated())) {
            this.lookFeelClassName = string;
            this.m_bLookFeelDecorationOptions = bl;
            this.saveAppPrefs();
            JFrame.setDefaultLookAndFeelDecorated(bl);
            JDialog.setDefaultLookAndFeelDecorated(bl);
            try {
                UIManager.setLookAndFeel(this.lookFeelClassName);
                SwingUtilities.updateComponentTreeUI(this.getRootPane());
                this.pack();
            }
            catch (Exception exception) {
                DThrowable.showAndWait(this, null, exception);
            }
        }
    }

    private boolean changeKeyStoreType(KeyStoreType keyStoreType) {
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        assert (!this.m_keyStoreWrap.getKeyStore().getType().equals(keyStoreType.name()));
        try {
            Object object;
            Object object2;
            KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
            KeyStoreType keyStoreType2 = this.m_keyStoreWrap.getKeyStoreType();
            KeyStore keyStore2 = KeyStoreUtil.createKeyStore(keyStoreType);
            boolean bl = false;
            boolean bl2 = false;
            Object object3 = keyStore.aliases();
            while (object3.hasMoreElements()) {
                int n;
                object2 = object3.nextElement();
                if (keyStore.isCertificateEntry((String)object2)) {
                    int n2;
                    if (keyStore2.containsAlias((String)object2) && (n2 = JOptionPane.showConfirmDialog(this, RB.getString("FPortecle.WarnOverwriteAlias.message"), RB.getString("FPortecle.ChangeKeyStoreType.Title"), 0)) != 0) continue;
                    Certificate certificate = keyStore.getCertificate((String)object2);
                    keyStore2.setCertificateEntry((String)object2, certificate);
                    continue;
                }
                if (!keyStore.isKeyEntry((String)object2)) continue;
                Certificate[] certificateArray = keyStore.getCertificateChain((String)object2);
                if (certificateArray == null || certificateArray.length == 0) {
                    if (bl2) continue;
                    bl2 = true;
                    int n3 = JOptionPane.showConfirmDialog(this, RB.getString("FPortecle.WarnNoChangeKey.message"), RB.getString("FPortecle.ChangeKeyStoreType.Title"), 0);
                    if (n3 == 0) continue;
                    return false;
                }
                char[] cArray = this.m_keyStoreWrap.getEntryPassword((String)object2);
                if (cArray == null) {
                    cArray = KeyStoreUtil.DUMMY_PASSWORD;
                    if (keyStoreType2.isEntryPasswordSupported()) {
                        object = MessageFormat.format(RB.getString("FPortecle.ChangeKeyStoreTypeKeyPairEntryPassword.Title"), object2);
                        DGetPassword dGetPassword = new DGetPassword((Window)this, (String)object);
                        dGetPassword.setLocationRelativeTo(this);
                        SwingHelper.showAndWait(dGetPassword);
                        cArray = dGetPassword.getPassword();
                        if (cArray == null) {
                            return false;
                        }
                    }
                }
                object = keyStore.getKey((String)object2, cArray);
                if (!keyStoreType2.isEntryPasswordSupported()) {
                    if (!bl) {
                        bl = true;
                        JOptionPane.showMessageDialog(this, MessageFormat.format(RB.getString("FPortecle.ChangeFromPasswordUnsupported.message"), new String(KeyStoreUtil.DUMMY_PASSWORD)), RB.getString("FPortecle.ChangeKeyStoreType.Title"), 1);
                    }
                } else if (!keyStoreType.isEntryPasswordSupported()) {
                    cArray = KeyStoreUtil.DUMMY_PASSWORD;
                }
                if (keyStore2.containsAlias((String)object2) && (n = JOptionPane.showConfirmDialog(this, RB.getString("FPortecle.WarnOverwriteAlias.message"), RB.getString("FPortecle.ChangeKeyStoreType.Title"), 0)) != 0) continue;
                keyStore2.setKeyEntry((String)object2, (Key)object, cArray, certificateArray);
                this.m_keyStoreWrap.setEntryPassword((String)object2, cArray);
            }
            this.m_keyStoreWrap.setKeyStore(keyStore2);
            object3 = this.m_keyStoreWrap.getKeyStoreFile();
            if (object3 != null) {
                object2 = this.m_keyStoreWrap.getKeyStoreType().getFilenameExtensions();
                Set<String> set = keyStoreType.getFilenameExtensions();
                if (object2.isEmpty() || set.isEmpty()) {
                    this.m_keyStoreWrap.setKeyStoreFile(null);
                } else {
                    String string = set.iterator().next();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        String string2 = (String)object.next();
                        String string3 = ((File)object3).getPath().toLowerCase();
                        if (!string3.endsWith("." + string2)) continue;
                        this.m_keyStoreWrap.setKeyStoreFile(new File(string3.substring(0, string3.length() - string2.length()) + string));
                    }
                    if (((File)object3).equals(this.m_keyStoreWrap.getKeyStoreFile())) {
                        this.m_keyStoreWrap.setKeyStoreFile(null);
                    }
                }
            }
            this.m_keyStoreWrap.setChanged(true);
            this.updateControls();
            this.updateTitle();
            JOptionPane.showMessageDialog(this, RB.getString("FPortecle.ChangeKeyStoreTypeSuccessful.message"), RB.getString("FPortecle.ChangeKeyStoreType.Title"), 1);
            return true;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
    }

    private boolean setKeyStorePassword() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        char[] cArray = this.getNewKeyStorePassword();
        if (cArray == null) {
            return false;
        }
        this.m_keyStoreWrap.setPassword(cArray);
        this.m_keyStoreWrap.setChanged(true);
        this.updateControls();
        this.updateTitle();
        return true;
    }

    private boolean setPasswordSelectedEntry() {
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        assert (this.m_keyStoreWrap.getKeyStoreType().isEntryPasswordSupported());
        if (!KeyStoreTableModel.KEY_PAIR_ENTRY.equals(this.m_jtKeyStore.getSelectedType())) {
            return false;
        }
        String string = this.m_jtKeyStore.getSelectedAlias();
        char[] cArray = this.m_keyStoreWrap.getEntryPassword(string);
        DChangePassword dChangePassword = new DChangePassword((Window)this, RB.getString("FPortecle.SetKeyPairPassword.Title"), cArray);
        dChangePassword.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dChangePassword);
        if (cArray == null) {
            cArray = dChangePassword.getOldPassword();
        }
        char[] cArray2 = dChangePassword.getNewPassword();
        if (cArray == null || cArray2 == null) {
            return false;
        }
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        try {
            Certificate[] certificateArray = keyStore.getCertificateChain(string);
            Key key = keyStore.getKey(string, cArray);
            keyStore.deleteEntry(string);
            keyStore.setKeyEntry(string, key, cArray2, certificateArray);
            this.m_keyStoreWrap.setEntryPassword(string, cArray2);
            this.m_keyStoreWrap.setChanged(true);
        }
        catch (GeneralSecurityException generalSecurityException) {
            DThrowable.showAndWait(this, null, generalSecurityException);
            return false;
        }
        this.updateControls();
        this.updateTitle();
        return true;
    }

    private boolean exportSelectedEntry() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        String string = this.m_jtKeyStore.getSelectedType();
        if (string == null || string.equals(KeyStoreTableModel.KEY_ENTRY)) {
            return false;
        }
        String string2 = this.m_jtKeyStore.getSelectedAlias();
        try {
            DExport dExport = new DExport((Window)this, this.m_keyStoreWrap, string2);
            dExport.setLocationRelativeTo(this);
            SwingHelper.showAndWait(dExport);
            if (!dExport.exportSelected()) {
                return false;
            }
            boolean bl = false;
            bl = dExport.exportHead() ? (dExport.exportPem() ? this.exportHeadCertOnlyPem(string2) : (dExport.exportDer() ? this.exportHeadCertOnlyDER(string2) : (dExport.exportPkiPath() ? this.exportHeadCertOnlyPkiPath(string2) : this.exportHeadCertOnlyPkcs7(string2)))) : (dExport.exportChain() ? (dExport.exportPkiPath() ? this.exportAllCertsPkiPath(string2) : this.exportAllCertsPkcs7(string2)) : (dExport.exportPem() ? this.exportPrivKeyCertChainPEM(string2) : this.exportPrivKeyCertChainPKCS12(string2)));
            if (bl) {
                JOptionPane.showMessageDialog(this, RB.getString("FPortecle.ExportSuccessful.message"), RB.getString("FPortecle.Export.Title"), 1);
            }
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportHeadCertOnlyPem(String string) {
        File file;
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = this.getHeadCert(string);
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            return false;
        }
        String string2 = X509CertUtil.getCertificateAlias(x509Certificate);
        if (string2.isEmpty()) {
            string2 = string;
        }
        if ((file = this.chooseExportCertFile(string2)) == null) {
            return false;
        }
        if (!this.confirmOverwrite(file, this.getTitle())) {
            return false;
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new PEMWriter(new FileWriter(file));
            ((PEMWriter)bufferedWriter).writeObject(x509Certificate);
            this.m_lastDir.updateLastDir(file);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = MessageFormat.format(RB.getString("FPortecle.NoWriteFile.message"), file.getName());
            JOptionPane.showMessageDialog(this, string3, this.getTitle(), 2);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            DThrowable.showAndWait(this, null, iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    DThrowable.showAndWait(this, null, iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportHeadCertOnlyDER(String string) {
        File file;
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = this.getHeadCert(string);
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            return false;
        }
        String string2 = X509CertUtil.getCertificateAlias(x509Certificate);
        if (string2.isEmpty()) {
            string2 = string;
        }
        if ((file = this.chooseExportCertFile(string2)) == null) {
            return false;
        }
        if (!this.confirmOverwrite(file, this.getTitle())) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        try {
            byte[] byArray = X509CertUtil.getCertEncodedDer(x509Certificate);
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            this.m_lastDir.updateLastDir(file);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = MessageFormat.format(RB.getString("FPortecle.NoWriteFile.message"), file.getName());
            JOptionPane.showMessageDialog(this, string3, this.getTitle(), 2);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            DThrowable.showAndWait(this, null, iOException);
            boolean bl = false;
            return bl;
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    DThrowable.showAndWait(this, null, iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportHeadCertOnlyPkcs7(String string) {
        File file;
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = this.getHeadCert(string);
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            return false;
        }
        String string2 = X509CertUtil.getCertificateAlias(x509Certificate);
        if (string2.isEmpty()) {
            string2 = string;
        }
        if ((file = this.chooseExportPKCS7File(string2)) == null) {
            return false;
        }
        if (!this.confirmOverwrite(file, this.getTitle())) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        try {
            byte[] byArray = X509CertUtil.getCertEncodedPkcs7(x509Certificate);
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            this.m_lastDir.updateLastDir(file);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = MessageFormat.format(RB.getString("FPortecle.NoWriteFile.message"), file.getName());
            JOptionPane.showMessageDialog(this, string3, this.getTitle(), 2);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            DThrowable.showAndWait(this, null, iOException);
            boolean bl = false;
            return bl;
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    DThrowable.showAndWait(this, null, iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportHeadCertOnlyPkiPath(String string) {
        File file;
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = this.getHeadCert(string);
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            return false;
        }
        String string2 = X509CertUtil.getCertificateAlias(x509Certificate);
        if (string2.isEmpty()) {
            string2 = string;
        }
        if ((file = this.chooseExportPkiPathFile(string2)) == null) {
            return false;
        }
        if (!this.confirmOverwrite(file, this.getTitle())) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        try {
            byte[] byArray = X509CertUtil.getCertEncodedPkiPath(x509Certificate);
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            this.m_lastDir.updateLastDir(file);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = MessageFormat.format(RB.getString("FPortecle.NoWriteFile.message"), file.getName());
            JOptionPane.showMessageDialog(this, string3, this.getTitle(), 2);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            DThrowable.showAndWait(this, null, iOException);
            boolean bl = false;
            return bl;
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    DThrowable.showAndWait(this, null, iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportAllCertsPkcs7(String string) {
        File file;
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        X509Certificate[] x509CertificateArray = null;
        try {
            x509CertificateArray = X509CertUtil.convertCertificates(keyStore.getCertificateChain(string));
        }
        catch (KeyStoreException keyStoreException) {
            DThrowable.showAndWait(this, null, keyStoreException);
            return false;
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            return false;
        }
        String string2 = null;
        if (x509CertificateArray.length > 0) {
            string2 = X509CertUtil.getCertificateAlias(x509CertificateArray[0]);
        }
        if (string2 == null || string2.isEmpty()) {
            string2 = string;
        }
        if ((file = this.chooseExportPKCS7File(string2)) == null) {
            return false;
        }
        if (!this.confirmOverwrite(file, this.getTitle())) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        try {
            byte[] byArray = X509CertUtil.getCertsEncodedPkcs7(x509CertificateArray);
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            this.m_lastDir.updateLastDir(file);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = MessageFormat.format(RB.getString("FPortecle.NoWriteFile.message"), file.getName());
            JOptionPane.showMessageDialog(this, string3, this.getTitle(), 2);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            DThrowable.showAndWait(this, null, iOException);
            boolean bl = false;
            return bl;
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    DThrowable.showAndWait(this, null, iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportAllCertsPkiPath(String string) {
        File file;
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        X509Certificate[] x509CertificateArray = null;
        try {
            x509CertificateArray = X509CertUtil.convertCertificates(keyStore.getCertificateChain(string));
        }
        catch (KeyStoreException keyStoreException) {
            DThrowable.showAndWait(this, null, keyStoreException);
            return false;
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            return false;
        }
        String string2 = null;
        if (x509CertificateArray.length > 0) {
            string2 = X509CertUtil.getCertificateAlias(x509CertificateArray[0]);
        }
        if (string2 == null || string2.isEmpty()) {
            string2 = string;
        }
        if ((file = this.chooseExportPkiPathFile(string2)) == null) {
            return false;
        }
        if (!this.confirmOverwrite(file, this.getTitle())) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        try {
            byte[] byArray = X509CertUtil.getCertsEncodedPkiPath(x509CertificateArray);
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            this.m_lastDir.updateLastDir(file);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = MessageFormat.format(RB.getString("FPortecle.NoWriteFile.message"), file.getName());
            JOptionPane.showMessageDialog(this, string3, this.getTitle(), 2);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            DThrowable.showAndWait(this, null, iOException);
            boolean bl = false;
            return bl;
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    DThrowable.showAndWait(this, null, iOException);
                }
            }
        }
    }

    private X509Certificate getHeadCert(String string) throws CryptoException {
        try {
            KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
            X509Certificate x509Certificate = keyStore.isKeyEntry(string) ? X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(keyStore.getCertificateChain(string)))[0] : X509CertUtil.convertCertificate(keyStore.getCertificate(string));
            return x509Certificate;
        }
        catch (KeyStoreException keyStoreException) {
            String string2 = MessageFormat.format(RB.getString("FPortecle.NoAccessEntry.message"), string);
            throw new CryptoException(string2, keyStoreException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportPrivKeyCertChainPEM(String string) {
        Object object;
        Serializable serializable;
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        char[] cArray = this.m_keyStoreWrap.getEntryPassword(string);
        if (cArray == null) {
            cArray = KeyStoreUtil.DUMMY_PASSWORD;
            if (this.m_keyStoreWrap.getKeyStoreType().isEntryPasswordSupported()) {
                serializable = new DGetPassword((Window)this, RB.getString("FPortecle.KeyEntryPassword.Title"));
                serializable.setLocationRelativeTo(this);
                SwingHelper.showAndWait(serializable);
                cArray = serializable.getPassword();
                if (cArray == null) {
                    return false;
                }
            }
        }
        serializable = null;
        BufferedWriter bufferedWriter = null;
        try {
            Key key = keyStore.getKey(string, cArray);
            object = keyStore.getCertificateChain(string);
            DGetNewPassword dGetNewPassword = new DGetNewPassword((Window)this, RB.getString("FPortecle.PrivateKeyExportPassword.Title"));
            dGetNewPassword.setLocationRelativeTo(this);
            SwingHelper.showAndWait(dGetNewPassword);
            char[] cArray2 = dGetNewPassword.getPassword();
            if (cArray2 == null) {
                boolean bl = false;
                return bl;
            }
            String string2 = null;
            if (((Certificate[])object).length > 0 && object[0] instanceof X509Certificate) {
                string2 = X509CertUtil.getCertificateAlias((X509Certificate)object[0]);
            }
            if (string2 == null || string2.isEmpty()) {
                string2 = string;
            }
            if ((serializable = this.chooseExportPEMFile(string2)) == null) {
                boolean bl = false;
                return bl;
            }
            if (!this.confirmOverwrite((File)serializable, this.getTitle())) {
                boolean bl = false;
                return bl;
            }
            bufferedWriter = new PEMWriter(new FileWriter((File)serializable));
            if (cArray2.length == 0) {
                ((PEMWriter)bufferedWriter).writeObject(key);
            } else {
                String object2 = "DES-EDE3-CBC";
                SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                ((PEMWriter)bufferedWriter).writeObject(key, object2, cArray2, secureRandom);
            }
            for (Certificate certificate : object) {
                ((PEMWriter)bufferedWriter).writeObject(certificate);
            }
            bufferedWriter.flush();
            this.m_lastDir.updateLastDir((File)serializable);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = MessageFormat.format(RB.getString("FPortecle.NoWriteFile.message"), ((File)serializable).getName());
            JOptionPane.showMessageDialog(this, object, this.getTitle(), 2);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            DThrowable.showAndWait(this, null, iOException);
            boolean bl = false;
            return bl;
        }
        catch (GeneralSecurityException generalSecurityException) {
            DThrowable.showAndWait(this, null, generalSecurityException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    DThrowable.showAndWait(this, null, iOException);
                }
            }
        }
    }

    private boolean exportPrivKeyCertChainPKCS12(String string) {
        Serializable serializable;
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        char[] cArray = this.m_keyStoreWrap.getEntryPassword(string);
        if (cArray == null) {
            cArray = KeyStoreUtil.DUMMY_PASSWORD;
            if (this.m_keyStoreWrap.getKeyStoreType().isEntryPasswordSupported()) {
                serializable = new DGetPassword((Window)this, RB.getString("FPortecle.KeyEntryPassword.Title"));
                ((Window)serializable).setLocationRelativeTo(this);
                SwingHelper.showAndWait((Window)serializable);
                cArray = ((DGetPassword)serializable).getPassword();
                if (cArray == null) {
                    return false;
                }
            }
        }
        serializable = null;
        try {
            Key key = keyStore.getKey(string, cArray);
            Certificate[] certificateArray = keyStore.getCertificateChain(string);
            this.m_keyStoreWrap.setEntryPassword(string, cArray);
            KeyStore keyStore2 = KeyStoreUtil.createKeyStore(KeyStoreType.PKCS12);
            keyStore2.setKeyEntry(string, key, new char[0], certificateArray);
            DGetNewPassword dGetNewPassword = new DGetNewPassword((Window)this, RB.getString("FPortecle.Pkcs12Password.Title"));
            dGetNewPassword.setLocationRelativeTo(this);
            SwingHelper.showAndWait(dGetNewPassword);
            char[] cArray2 = dGetNewPassword.getPassword();
            if (cArray2 == null) {
                return false;
            }
            String string2 = null;
            if (certificateArray.length > 0 && certificateArray[0] instanceof X509Certificate) {
                string2 = X509CertUtil.getCertificateAlias((X509Certificate)certificateArray[0]);
            }
            if (string2 == null || string2.isEmpty()) {
                string2 = string;
            }
            if ((serializable = this.chooseExportPKCS12File(string2)) == null) {
                return false;
            }
            if (!this.confirmOverwrite((File)serializable, this.getTitle())) {
                return false;
            }
            KeyStoreUtil.saveKeyStore(keyStore2, (File)serializable, cArray2);
            this.m_lastDir.updateLastDir((File)serializable);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = MessageFormat.format(RB.getString("FPortecle.NoWriteFile.message"), ((File)serializable).getName());
            JOptionPane.showMessageDialog(this, string3, this.getTitle(), 2);
            return false;
        }
        catch (IOException iOException) {
            DThrowable.showAndWait(this, null, iOException);
            return false;
        }
        catch (GeneralSecurityException generalSecurityException) {
            DThrowable.showAndWait(this, null, generalSecurityException);
            return false;
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            return false;
        }
    }

    private File chooseExportCertFile(String string) {
        JFileChooser jFileChooser = FileChooserFactory.getX509FileChooser(string);
        File file = this.m_lastDir.getLastDir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.ExportCertificate.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, RB.getString("FPortecle.Export.button"));
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private File chooseExportPKCS7File(String string) {
        JFileChooser jFileChooser = FileChooserFactory.getPkcs7FileChooser(string);
        File file = this.m_lastDir.getLastDir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.ExportCertificates.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, RB.getString("FPortecle.Export.button"));
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private File chooseExportPkiPathFile(String string) {
        JFileChooser jFileChooser = FileChooserFactory.getPkiPathFileChooser(string);
        File file = this.m_lastDir.getLastDir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.ExportCertificates.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, RB.getString("FPortecle.Export.button"));
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private File chooseExportPKCS12File(String string) {
        JFileChooser jFileChooser = FileChooserFactory.getPkcs12FileChooser(string);
        File file = this.m_lastDir.getLastDir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.ExportKeyCertificates.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, RB.getString("FPortecle.Export.button"));
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private File chooseExportPEMFile(String string) {
        JFileChooser jFileChooser = FileChooserFactory.getPEMFileChooser(string);
        File file = this.m_lastDir.getLastDir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle(RB.getString("FPortecle.ExportKeyCertificates.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, RB.getString("FPortecle.Export.button"));
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateCsrSelectedEntry() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        if (!KeyStoreTableModel.KEY_PAIR_ENTRY.equals(this.m_jtKeyStore.getSelectedType())) {
            return false;
        }
        String string = this.m_jtKeyStore.getSelectedAlias();
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        File file = null;
        BufferedWriter bufferedWriter = null;
        try {
            Serializable serializable;
            char[] cArray = this.m_keyStoreWrap.getEntryPassword(string);
            if (cArray == null) {
                cArray = KeyStoreUtil.DUMMY_PASSWORD;
                if (this.m_keyStoreWrap.getKeyStoreType().isEntryPasswordSupported()) {
                    serializable = new DGetPassword((Window)this, RB.getString("FPortecle.KeyEntryPassword.Title"));
                    ((Window)serializable).setLocationRelativeTo(this);
                    SwingHelper.showAndWait((Window)serializable);
                    cArray = ((DGetPassword)serializable).getPassword();
                    if (cArray == null) {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            serializable = (PrivateKey)keyStore.getKey(string, cArray);
            this.m_keyStoreWrap.setEntryPassword(string, cArray);
            X509Certificate x509Certificate = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(keyStore.getCertificateChain(string)))[0];
            file = this.chooseGenerateCsrFile(X509CertUtil.getCertificateAlias(x509Certificate));
            if (file == null) {
                boolean bl = false;
                return bl;
            }
            if (!this.confirmOverwrite(file, RB.getString("FPortecle.GenerateCsr.Title"))) {
                boolean bl = false;
                return bl;
            }
            bufferedWriter = new PEMWriter(new FileWriter(file));
            ((PEMWriter)bufferedWriter).writeObject(X509CertUtil.generatePKCS10CSR(x509Certificate, (PrivateKey)serializable));
            JOptionPane.showMessageDialog(this, RB.getString("FPortecle.CsrGenerationSuccessful.message"), RB.getString("FPortecle.GenerateCsr.Title"), 1);
            this.m_lastDir.updateLastDir(file);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(RB.getString("FPortecle.NoWriteFile.message"), file), RB.getString("FPortecle.GenerateCsr.Title"), 2);
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    DThrowable.showAndWait(this, null, iOException);
                }
            }
        }
    }

    private boolean cloneSelectedKeyEntry() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        if (!KeyStoreTableModel.KEY_PAIR_ENTRY.equals(this.m_jtKeyStore.getSelectedType())) {
            return false;
        }
        String string = this.m_jtKeyStore.getSelectedAlias();
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        KeyStoreType keyStoreType = this.m_keyStoreWrap.getKeyStoreType();
        try {
            Serializable serializable;
            char[] cArray = this.m_keyStoreWrap.getEntryPassword(string);
            if (cArray == null) {
                cArray = KeyStoreUtil.DUMMY_PASSWORD;
                if (keyStoreType.isEntryPasswordSupported()) {
                    serializable = new DGetPassword((Window)this, RB.getString("FPortecle.KeyEntryPassword.Title"));
                    serializable.setLocationRelativeTo(this);
                    SwingHelper.showAndWait(serializable);
                    cArray = serializable.getPassword();
                    if (cArray == null) {
                        return false;
                    }
                }
            }
            this.m_keyStoreWrap.setEntryPassword(string, cArray);
            string = this.getNewEntryAlias(keyStore, string, "FPortecle.ClonedKeyPairEntryAlias.Title", true);
            if (string == null) {
                return false;
            }
            serializable = keyStore.getKey(string, cArray);
            Certificate[] certificateArray = keyStore.getCertificateChain(string);
            char[] cArray2 = KeyStoreUtil.DUMMY_PASSWORD;
            if (keyStoreType.isEntryPasswordSupported()) {
                DGetNewPassword dGetNewPassword = new DGetNewPassword((Window)this, RB.getString("FPortecle.ClonedKeyPairEntryPassword.Title"));
                dGetNewPassword.setLocationRelativeTo(this);
                SwingHelper.showAndWait(dGetNewPassword);
                cArray2 = dGetNewPassword.getPassword();
                if (cArray2 == null) {
                    return false;
                }
            }
            if (keyStore.containsAlias(string)) {
                keyStore.deleteEntry(string);
            }
            keyStore.setKeyEntry(string, (Key)serializable, cArray2, certificateArray);
            this.m_keyStoreWrap.setEntryPassword(string, cArray2);
            this.m_keyStoreWrap.setChanged(true);
            this.selectedAlias = string;
            this.updateControls();
            this.updateTitle();
            JOptionPane.showMessageDialog(this, RB.getString("FPortecle.KeyPairCloningSuccessful.message"), RB.getString("FPortecle.CloneKeyPair.Title"), 1);
            return true;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
    }

    private boolean cloneSelectedCertificateEntry() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        if (!KeyStoreTableModel.TRUST_CERT_ENTRY.equals(this.m_jtKeyStore.getSelectedType())) {
            return false;
        }
        String string = this.m_jtKeyStore.getSelectedAlias();
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        try {
            string = this.getNewEntryAlias(keyStore, string, "FPortecle.ClonedTrustCertEntryAlias.Title", true);
            if (string == null) {
                return false;
            }
            Certificate certificate = keyStore.getCertificate(string);
            if (keyStore.containsAlias(string)) {
                keyStore.deleteEntry(string);
            }
            keyStore.setCertificateEntry(string, certificate);
            this.m_keyStoreWrap.setChanged(true);
            this.selectedAlias = string;
            this.updateControls();
            this.updateTitle();
            JOptionPane.showMessageDialog(this, RB.getString("FPortecle.CertificateCloningSuccessful.message"), RB.getString("FPortecle.CloneCertificate.Title"), 1);
            return true;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
    }

    private boolean keyStoreReport() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        try {
            DKeyStoreReport dKeyStoreReport = new DKeyStoreReport(this, this.m_keyStoreWrap.getKeyStore());
            dKeyStoreReport.setLocationRelativeTo(this);
            SwingHelper.showAndWait(dKeyStoreReport);
            return true;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
    }

    private boolean showSelectedEntry() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        String string = this.m_jtKeyStore.getSelectedType();
        if (string == null || string.equals(KeyStoreTableModel.KEY_ENTRY)) {
            return false;
        }
        String string2 = this.m_jtKeyStore.getSelectedAlias();
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        try {
            X509Certificate[] x509CertificateArray = keyStore.isKeyEntry(string2) ? X509CertUtil.convertCertificates(keyStore.getCertificateChain(string2)) : new X509Certificate[]{X509CertUtil.convertCertificate(keyStore.getCertificate(string2))};
            DViewCertificate dViewCertificate = new DViewCertificate((Window)this, MessageFormat.format(RB.getString("FPortecle.CertDetailsEntry.Title"), string2), x509CertificateArray);
            dViewCertificate.setLocationRelativeTo(this);
            SwingHelper.showAndWait(dViewCertificate);
            return true;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
    }

    private boolean deleteSelectedEntry() {
        String string = this.m_jtKeyStore.getSelectedAlias();
        if (string == null) {
            return false;
        }
        int n = JOptionPane.showConfirmDialog(this, MessageFormat.format(RB.getString("FPortecle.DeleteEntry.message"), string), RB.getString("FPortecle.DeleteEntry.Title"), 0);
        if (n != 0) {
            return false;
        }
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        try {
            keyStore.deleteEntry(string);
            this.m_keyStoreWrap.removeEntryPassword(string);
            this.m_keyStoreWrap.setChanged(true);
        }
        catch (KeyStoreException keyStoreException) {
            DThrowable.showAndWait(this, null, keyStoreException);
            return false;
        }
        this.selectedAlias = null;
        this.updateControls();
        this.updateTitle();
        return true;
    }

    private boolean renameSelectedEntry() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        int n = this.m_jtKeyStore.getSelectedRow();
        if (!this.m_jtKeyStore.getModel().isCellEditable(n, 1)) {
            return false;
        }
        String string = this.m_jtKeyStore.getSelectedAlias();
        DGetAlias dGetAlias = new DGetAlias((Window)this, RB.getString("FPortecle.NewEntryAlias.Title"), string, true);
        dGetAlias.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dGetAlias);
        return this.renameEntry(string, dGetAlias.getAlias(), false);
    }

    boolean renameEntry(String string, String string2, boolean bl) {
        if (string2 == null) {
            return false;
        }
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        try {
            Object object;
            int n;
            if (string2.equalsIgnoreCase(string)) {
                if (!bl) {
                    JOptionPane.showMessageDialog(this, MessageFormat.format(RB.getString("FPortecle.RenameAliasIdentical.message"), string), RB.getString("FPortecle.RenameEntry.Title"), 0);
                }
                return false;
            }
            if (keyStore.containsAlias(string2) && (n = JOptionPane.showConfirmDialog(this, object = MessageFormat.format(RB.getString("FPortecle.OverWriteEntry.message"), string2), RB.getString("FPortecle.RenameEntry.Title"), 0)) != 0) {
                return false;
            }
            if (keyStore.isKeyEntry(string)) {
                object = this.m_keyStoreWrap.getEntryPassword(string);
                if (object == null) {
                    object = KeyStoreUtil.DUMMY_PASSWORD;
                    if (this.m_keyStoreWrap.getKeyStoreType().isEntryPasswordSupported()) {
                        DGetPassword dGetPassword = new DGetPassword((Window)this, RB.getString("FPortecle.KeyEntryPassword.Title"));
                        dGetPassword.setLocationRelativeTo(this);
                        SwingHelper.showAndWait(dGetPassword);
                        object = dGetPassword.getPassword();
                        if (object == null) {
                            return false;
                        }
                    }
                }
                Key key = keyStore.getKey(string, (char[])object);
                Certificate[] certificateArray = keyStore.getCertificateChain(string);
                keyStore.setKeyEntry(string2, key, (char[])object, certificateArray);
                this.m_keyStoreWrap.setEntryPassword(string2, (char[])object);
            } else {
                object = keyStore.getCertificate(string);
                keyStore.setCertificateEntry(string2, (Certificate)object);
            }
            keyStore.deleteEntry(string);
            this.m_keyStoreWrap.removeEntryPassword(string);
            this.m_keyStoreWrap.setChanged(true);
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
            return false;
        }
        this.selectedAlias = string2;
        this.updateControls();
        this.updateTitle();
        return true;
    }

    private void updateControls() {
        assert (this.m_keyStoreWrap != null);
        assert (this.m_keyStoreWrap.getKeyStore() != null);
        this.m_saveKeyStoreAction.setEnabled(this.m_keyStoreWrap.isChanged() || this.m_keyStoreWrap.getKeyStoreFile() == null);
        this.m_jmiSaveKeyStoreAs.setEnabled(true);
        this.m_genKeyPairAction.setEnabled(true);
        this.m_importTrustCertAction.setEnabled(true);
        this.m_importKeyPairAction.setEnabled(true);
        this.m_setKeyStorePassAction.setEnabled(true);
        this.m_keyStoreReportAction.setEnabled(true);
        this.setDefaultStatusBarText();
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        KeyStoreType keyStoreType = this.m_keyStoreWrap.getKeyStoreType();
        try {
            ((KeyStoreTableModel)this.m_jtKeyStore.getModel()).load(keyStore);
        }
        catch (KeyStoreException keyStoreException) {
            DThrowable.showAndWait(this, null, keyStoreException);
        }
        this.m_jmiSetKeyPairPass.setEnabled(keyStoreType.isEntryPasswordSupported());
        this.m_jmChangeKeyStoreType.setEnabled(true);
        this.m_jmiChangeKeyStoreTypeJks.setEnabled(KeyStoreUtil.isAvailable(KeyStoreType.JKS));
        this.m_jmiChangeKeyStoreTypeCaseExactJks.setEnabled(KeyStoreUtil.isAvailable(KeyStoreType.CaseExactJKS));
        this.m_jmiChangeKeyStoreTypeJceks.setEnabled(KeyStoreUtil.isAvailable(KeyStoreType.JCEKS));
        this.m_jmiChangeKeyStoreTypePkcs12.setEnabled(true);
        this.m_jmiChangeKeyStoreTypeBks.setEnabled(true);
        this.m_jmiChangeKeyStoreTypeUber.setEnabled(true);
        this.m_jmiChangeKeyStoreTypeGkr.setEnabled(KeyStoreUtil.isAvailable(KeyStoreType.GKR));
        switch (keyStoreType) {
            case JKS: {
                this.m_jmiChangeKeyStoreTypeJks.setEnabled(false);
                break;
            }
            case CaseExactJKS: {
                this.m_jmiChangeKeyStoreTypeCaseExactJks.setEnabled(false);
                break;
            }
            case JCEKS: {
                this.m_jmiChangeKeyStoreTypeJceks.setEnabled(false);
                break;
            }
            case PKCS12: {
                this.m_jmiChangeKeyStoreTypePkcs12.setEnabled(false);
                break;
            }
            case BKS: {
                this.m_jmiChangeKeyStoreTypeBks.setEnabled(false);
                break;
            }
            case UBER: {
                this.m_jmiChangeKeyStoreTypeUber.setEnabled(false);
                break;
            }
            case GKR: {
                this.m_jmiChangeKeyStoreTypeGkr.setEnabled(false);
                break;
            }
        }
        this.m_jtKeyStore.clearSelection();
        if (this.selectedAlias != null) {
            int n = this.m_jtKeyStore.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (!this.selectedAlias.equals(this.m_jtKeyStore.getValueAt(i, 1))) continue;
                this.m_jtKeyStore.setRowSelectionInterval(i, i);
                break;
            }
        }
    }

    private void updateTitle() {
        String string = RB.getString("FPortecle.Title");
        if (this.m_keyStoreWrap == null) {
            this.setTitle(string);
        } else {
            File file = this.m_keyStoreWrap.getKeyStoreFile();
            if (file == null) {
                this.setTitle(MessageFormat.format("[{0}] - {1}", RB.getString("FPortecle.Untitled"), string));
            } else {
                String string2 = this.m_keyStoreWrap.isChanged() ? RB.getString("FPortecle.Modified") : "";
                this.setTitle(MessageFormat.format("{0}{1} - {2}", file, string2, string));
            }
        }
    }

    @Override
    public void setStatusBarText(String string) {
        this.m_jlStatusBar.setText(string);
    }

    @Override
    public void setDefaultStatusBarText() {
        if (this.m_keyStoreWrap == null) {
            this.setStatusBarText(RB.getString("FPortecle.noKeyStore.statusbar"));
        } else {
            int n;
            KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
            try {
                n = keyStore.size();
            }
            catch (KeyStoreException keyStoreException) {
                this.setStatusBarText("");
                DThrowable.showAndWait(this, null, keyStoreException);
                return;
            }
            String string = KeyStoreType.valueOf(keyStore.getType()).toString();
            String string2 = keyStore.getProvider().getName();
            if (n == 1) {
                this.setStatusBarText(MessageFormat.format(RB.getString("FPortecle.entry.statusbar"), string, string2));
            } else {
                this.setStatusBarText(MessageFormat.format(RB.getString("FPortecle.entries.statusbar"), string, string2, n));
            }
        }
    }

    private void saveAppPrefs() {
        try {
            PREFS.putInt(RB.getString("AppPrefs.TableWidth"), this.m_jpKeyStoreTable.getWidth());
            PREFS.putInt(RB.getString("AppPrefs.TableHeight"), this.m_jpKeyStoreTable.getHeight());
            PREFS.putInt(RB.getString("AppPrefs.AliasWidth"), this.m_jtKeyStore.getColumnModel().getColumn(1).getWidth());
            PREFS.putInt(RB.getString("AppPrefs.XPos"), this.getX());
            PREFS.putInt(RB.getString("AppPrefs.YPos"), this.getY());
            PREFS.putBoolean(RB.getString("AppPrefs.UseCaCerts"), this.m_bUseCaCerts);
            PREFS.put(RB.getString("AppPrefs.CaCertsFile"), this.m_fCaCertsFile.toString());
            File[] fileArray = this.m_jmrfFile.getRecentFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                PREFS.put(RB.getString("AppPrefs.RecentFile") + (i + 1), fileArray[i].toString());
            }
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            if (this.lookFeelClassName != null) {
                PREFS.put(RB.getString("AppPrefs.LookFeel"), this.lookFeelClassName);
            } else if (lookAndFeel != null) {
                UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
                for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) {
                    if (!lookAndFeel.getName().equals(lookAndFeelInfo.getName())) continue;
                    PREFS.put(RB.getString("AppPrefs.LookFeel"), lookAndFeelInfo.getClassName());
                    break;
                }
            }
            if (this.m_bLookFeelDecorationOptions != null) {
                PREFS.putBoolean(RB.getString("AppPrefs.LookFeelDecor"), this.m_bLookFeelDecorationOptions);
            } else {
                PREFS.putBoolean(RB.getString("AppPrefs.LookFeelDecor"), JFrame.isDefaultLookAndFeelDecorated());
            }
            PREFS.sync();
        }
        catch (Exception exception) {
            DThrowable.showAndWait(this, null, exception);
        }
    }

    private static boolean checkJRE() {
        JavaVersion javaVersion;
        JavaVersion javaVersion2;
        String string = System.getProperty("java.version");
        assert (string != null);
        try {
            javaVersion2 = new JavaVersion(string);
        }
        catch (VersionException versionException) {
            String string2 = MessageFormat.format(RB.getString("FPortecle.NoParseJreVersion.message"), string);
            LOG.warning(string2);
            JOptionPane.showMessageDialog(new JFrame(), string2, RB.getString("FPortecle.Title"), 2);
            return true;
        }
        try {
            javaVersion = new JavaVersion(REQ_JRE_VERSION);
        }
        catch (VersionException versionException) {
            String string3 = MessageFormat.format(RB.getString("FPortecle.NoParseJreVersion.message"), string);
            LOG.warning(string3);
            JOptionPane.showMessageDialog(new JFrame(), string3, RB.getString("FPortecle.Title"), 2);
            return true;
        }
        if (javaVersion2.compareTo(javaVersion) < 0) {
            String string4 = MessageFormat.format(RB.getString("FPortecle.MinJreVersionReq.message"), javaVersion2, javaVersion);
            LOG.severe(string4);
            JOptionPane.showMessageDialog(new JFrame(), string4, RB.getString("FPortecle.Title"), 0);
            return false;
        }
        return true;
    }

    private void exitApplication() {
        if (this.needSave()) {
            switch (this.wantSave()) {
                case 0: {
                    this.saveKeyStore();
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.saveAppPrefs();
        System.exit(0);
    }

    private static void initLookAndFeel() {
        try {
            UIManager.setLookAndFeel(PREFS.get(RB.getString("AppPrefs.LookFeel"), DEFAULT_LOOK_FEEL));
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        boolean bl = PREFS.getBoolean(RB.getString("AppPrefs.LookFeelDecor"), false);
        JFrame.setDefaultLookAndFeelDecorated(bl);
        JDialog.setDefaultLookAndFeelDecorated(bl);
    }

    private void setCursorBusy() {
        Component component = this.getRootPane().getGlassPane();
        component.addMouseListener(new MouseAdapter(){});
        component.setVisible(true);
        component.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void setCursorFree() {
        Component component = this.getRootPane().getGlassPane();
        component.setVisible(false);
        component.setCursor(Cursor.getPredefinedCursor(0));
    }

    private Image getResImage(String string) {
        return Toolkit.getDefaultToolkit().createImage(FPortecle.class.getResource(RB.getString(string)));
    }

    private boolean confirmOverwrite(File file, String string) {
        if (file.isFile()) {
            String string2 = MessageFormat.format(RB.getString("FPortecle.OverWriteFile.message"), file.getName());
            int n = JOptionPane.showConfirmDialog(this, string2, string, 0);
            return n == 0;
        }
        return true;
    }

    private String getNewEntryAlias(KeyStore keyStore, String string, String string2, boolean bl) throws KeyStoreException {
        block4: while (true) {
            DGetAlias dGetAlias = new DGetAlias((Window)this, RB.getString(string2), string.toLowerCase(), bl);
            dGetAlias.setLocationRelativeTo(this);
            SwingHelper.showAndWait(dGetAlias);
            string = dGetAlias.getAlias();
            if (string == null) {
                return null;
            }
            if (!keyStore.containsAlias(string)) {
                return string;
            }
            String string3 = MessageFormat.format(RB.getString("FPortecle.OverWriteEntry.message"), string);
            int n = JOptionPane.showConfirmDialog(this, string3, RB.getString(string2), 1);
            switch (n) {
                case 0: {
                    return string;
                }
                case 1: {
                    continue block4;
                }
            }
            break;
        }
        return null;
    }

    public boolean openFile(File file) {
        if (file != null) {
            String string = file.getName().toLowerCase(Locale.ENGLISH);
            for (String string2 : FileChooserFactory.CERT_EXTS) {
                if (!string.endsWith("." + string2)) continue;
                this.examineCert(file);
                return true;
            }
            for (String string2 : FileChooserFactory.CRL_EXTS) {
                if (!string.endsWith("." + string2)) continue;
                this.examineCRL(file);
                return true;
            }
            for (String string2 : FileChooserFactory.CSR_EXTS) {
                if (!string.endsWith("." + string2)) continue;
                this.examineCSR(file);
                return true;
            }
            return this.openKeyStoreFile(file, true);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        void var2_8;
        String[] stringArray2;
        if (!FPortecle.checkJRE()) {
            System.exit(1);
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        try {
            Double d;
            stringArray2 = Security.getProvider("BC");
            if (stringArray2 == null) {
                Class<?> object = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                stringArray2 = (Provider)object.newInstance();
                Security.addProvider((Provider)stringArray2);
            }
            if (REQ_BC_VERSION.compareTo(d = new Double(stringArray2.getVersion())) > 0) {
                JOptionPane.showMessageDialog(new JFrame(), MessageFormat.format(RB.getString("FPortecle.NoBcVersion.message"), REQ_BC_VERSION, d), RB.getString("FPortecle.Title"), 2);
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, "FPortecle.NoLoadBc.message", throwable);
            JOptionPane.showMessageDialog(new JFrame(), RB.getString("FPortecle.NoLoadBc.message"), RB.getString("FPortecle.Title"), 0);
            System.exit(1);
        }
        for (String string : stringArray2 = RB.getString("FPortecle.AdditionalProviders").split("[\\s,]+")) {
            String[] stringArray3 = string.split(":+", 2);
            if (Security.getProvider(stringArray3[0]) != null) continue;
            try {
                Class<?> clazz = Class.forName(stringArray3[1]);
                Security.addProvider((Provider)clazz.newInstance());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Object var2_6 = null;
        for (String string : stringArray) {
            if (string.equals("-open")) continue;
            File file = new File(string);
            break;
        }
        SwingUtilities.invokeLater(new CreateAndShowGui((File)var2_8));
    }

    private static class CreateAndShowGui
    implements Runnable {
        private final File m_file;

        public CreateAndShowGui(File file) {
            this.m_file = file;
        }

        @Override
        public void run() {
            FPortecle.initLookAndFeel();
            FPortecle fPortecle = new FPortecle();
            fPortecle.setVisible(true);
            fPortecle.openFile(this.m_file);
        }
    }

    private class KeyStoreTable
    extends JTable {
        private KeyStoreTable(KeyStoreTableModel keyStoreTableModel) {
            super(keyStoreTableModel);
            this.getSelectionModel().setSelectionMode(0);
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    String string;
                    if (!listSelectionEvent.getValueIsAdjusting() && (string = KeyStoreTable.this.getSelectedAlias()) != null) {
                        FPortecle.this.selectedAlias = string;
                    }
                }
            });
            this.setTransferHandler(new FileTransferHander());
        }

        private String getSelectedType() {
            int n = this.getSelectedRow();
            return n >= 0 ? (String)this.getValueAt(n, 0) : null;
        }

        private String getSelectedAlias() {
            int n = this.getSelectedRow();
            return n >= 0 ? (String)this.getValueAt(n, 1) : null;
        }

        private class FileTransferHander
        extends SingleFileDropHelper {
            private FileTransferHander() {
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                if (super.canImport(transferSupport)) {
                    FPortecle.this.m_lastDir.updateLastDir(this.file);
                    return true;
                }
                return false;
            }

            @Override
            public boolean importData(JComponent jComponent, Transferable transferable) {
                if (this.file != null) {
                    int n;
                    if (FPortecle.this.needSave() && ((n = FPortecle.this.wantSave()) == 0 && !FPortecle.this.saveKeyStore() || n == 2)) {
                        return false;
                    }
                    return FPortecle.this.openFile(this.file);
                }
                return false;
            }
        }
    }

    private abstract class ActionListener
    implements java.awt.event.ActionListener {
        private ActionListener() {
        }

        protected abstract void act();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FPortecle.this.setDefaultStatusBarText();
            FPortecle.this.setCursorBusy();
            FPortecle.this.repaint();
            try {
                this.act();
            }
            finally {
                FPortecle.this.setCursorFree();
            }
        }
    }

    private abstract class AbstractAction
    extends javax.swing.AbstractAction {
        private AbstractAction() {
        }

        protected abstract void act();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FPortecle.this.setDefaultStatusBarText();
            FPortecle.this.setCursorBusy();
            FPortecle.this.repaint();
            try {
                this.act();
            }
            finally {
                FPortecle.this.setCursorFree();
            }
        }
    }

    private class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
            this.putValue("LongDescription", RB.getString("FPortecle.HelpAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.HelpAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.HelpAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.HelpAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.HelpAction.image")));
            this.setEnabled(true);
        }

        @Override
        public void act() {
            FPortecle.this.showHelp();
        }
    }

    private class ExamineCrlAction
    extends AbstractAction {
        public ExamineCrlAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)RB.getString("FPortecle.ExamineCrlAction.accelerator").charAt(0), 2));
            this.putValue("LongDescription", RB.getString("FPortecle.ExamineCrlAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.ExamineCrlAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.ExamineCrlAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.ExamineCrlAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.ExamineCrlAction.image")));
            this.setEnabled(true);
        }

        @Override
        public void act() {
            FPortecle.this.examineCRL(null);
        }
    }

    private class ExamineCsrAction
    extends AbstractAction {
        public ExamineCsrAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)RB.getString("FPortecle.ExamineCsrAction.accelerator").charAt(0), 2));
            this.putValue("LongDescription", RB.getString("FPortecle.ExamineCsrAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.ExamineCsrAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.ExamineCsrAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.ExamineCsrAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.ExamineCsrAction.image")));
            this.setEnabled(true);
        }

        @Override
        public void act() {
            FPortecle.this.examineCSR(null);
        }
    }

    private class ExamineCertSSLAction
    extends AbstractAction {
        public ExamineCertSSLAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)RB.getString("FPortecle.ExamineCertSSLAction.accelerator").charAt(0), 2));
            this.putValue("LongDescription", RB.getString("FPortecle.ExamineCertSSLAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.ExamineCertSSLAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.ExamineCertSSLAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.ExamineCertSSLAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.ExamineCertSSLAction.image")));
            this.setEnabled(true);
        }

        @Override
        public void act() {
            FPortecle.this.examineCertSSL();
        }
    }

    private class ExamineCertAction
    extends AbstractAction {
        public ExamineCertAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)RB.getString("FPortecle.ExamineCertAction.accelerator").charAt(0), 2));
            this.putValue("LongDescription", RB.getString("FPortecle.ExamineCertAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.ExamineCertAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.ExamineCertAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.ExamineCertAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.ExamineCertAction.image")));
            this.setEnabled(true);
        }

        @Override
        public void act() {
            FPortecle.this.examineCert(null);
        }
    }

    private class KeyStoreReportAction
    extends AbstractAction {
        public KeyStoreReportAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)RB.getString("FPortecle.KeyStoreReportAction.accelerator").charAt(0), 2));
            this.putValue("LongDescription", RB.getString("FPortecle.KeyStoreReportAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.KeyStoreReportAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.KeyStoreReportAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.KeyStoreReportAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.KeyStoreReportAction.image")));
            this.setEnabled(false);
        }

        @Override
        public void act() {
            FPortecle.this.keyStoreReport();
        }
    }

    private class SetKeyStorePassAction
    extends AbstractAction {
        public SetKeyStorePassAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)RB.getString("FPortecle.SetKeyStorePassAction.accelerator").charAt(0), 2));
            this.putValue("LongDescription", RB.getString("FPortecle.SetKeyStorePassAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.SetKeyStorePassAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.SetKeyStorePassAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.SetKeyStorePassAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.SetKeyStorePassAction.image")));
            this.setEnabled(false);
        }

        @Override
        public void act() {
            FPortecle.this.setKeyStorePassword();
        }
    }

    private class ImportKeyPairAction
    extends AbstractAction {
        public ImportKeyPairAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)RB.getString("FPortecle.ImportKeyPairAction.accelerator").charAt(0), 2));
            this.putValue("LongDescription", RB.getString("FPortecle.ImportKeyPairAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.ImportKeyPairAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.ImportKeyPairAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.ImportKeyPairAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.ImportKeyPairAction.image")));
            this.setEnabled(false);
        }

        @Override
        public void act() {
            FPortecle.this.importKeyPair();
        }
    }

    private class ImportTrustCertAction
    extends AbstractAction {
        public ImportTrustCertAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)RB.getString("FPortecle.ImportTrustCertAction.accelerator").charAt(0), 2));
            this.putValue("LongDescription", RB.getString("FPortecle.ImportTrustCertAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.ImportTrustCertAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.ImportTrustCertAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.ImportTrustCertAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.ImportTrustCertAction.image")));
            this.setEnabled(false);
        }

        @Override
        public void act() {
            FPortecle.this.importTrustedCert();
        }
    }

    private class GenKeyPairAction
    extends AbstractAction {
        public GenKeyPairAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)RB.getString("FPortecle.GenKeyPairAction.accelerator").charAt(0), 2));
            this.putValue("LongDescription", RB.getString("FPortecle.GenKeyPairAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.GenKeyPairAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.GenKeyPairAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.GenKeyPairAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.GenKeyPairAction.image")));
            this.setEnabled(false);
        }

        @Override
        public void act() {
            FPortecle.this.generateKeyPair();
        }
    }

    private class OpenCaCertsKeyStoreAction
    extends AbstractAction {
        public OpenCaCertsKeyStoreAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)RB.getString("FPortecle.OpenCaCertsKeyStoreAction.accelerator").charAt(0), 2));
            this.putValue("LongDescription", RB.getString("FPortecle.OpenCaCertsKeyStoreAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.OpenCaCertsKeyStoreAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.OpenCaCertsKeyStoreAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.OpenCaCertsKeyStoreAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.OpenCaCertsKeyStoreAction.image")));
            this.setEnabled(true);
        }

        @Override
        public void act() {
            FPortecle.this.openCaCertsKeyStoreFile();
        }
    }

    private class OpenKeyStoreFileAction
    extends AbstractAction {
        public OpenKeyStoreFileAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)RB.getString("FPortecle.OpenKeyStoreFileAction.accelerator").charAt(0), 2));
            this.putValue("LongDescription", RB.getString("FPortecle.OpenKeyStoreFileAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.OpenKeyStoreFileAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.OpenKeyStoreFileAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.OpenKeyStoreFileAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.OpenKeyStoreFileAction.image")));
            this.setEnabled(true);
        }

        @Override
        public void act() {
            FPortecle.this.openKeyStoreFile();
        }
    }

    private class SaveKeyStoreAction
    extends AbstractAction {
        public SaveKeyStoreAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)RB.getString("FPortecle.SaveKeyStoreAction.accelerator").charAt(0), 2));
            this.putValue("LongDescription", RB.getString("FPortecle.SaveKeyStoreAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.SaveKeyStoreAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.SaveKeyStoreAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.SaveKeyStoreAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.SaveKeyStoreAction.image")));
            this.setEnabled(false);
        }

        @Override
        public void act() {
            FPortecle.this.saveKeyStore();
        }
    }

    private class NewKeyStoreAction
    extends AbstractAction {
        public NewKeyStoreAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)RB.getString("FPortecle.NewKeyStoreAction.accelerator").charAt(0), 2));
            this.putValue("LongDescription", RB.getString("FPortecle.NewKeyStoreAction.statusbar"));
            this.putValue("MnemonicKey", RB.getString("FPortecle.NewKeyStoreAction.mnemonic").charAt(0));
            this.putValue("Name", RB.getString("FPortecle.NewKeyStoreAction.text"));
            this.putValue("ShortDescription", RB.getString("FPortecle.NewKeyStoreAction.tooltip"));
            this.putValue("SmallIcon", new ImageIcon(FPortecle.this.getResImage("FPortecle.NewKeyStoreAction.image")));
            this.setEnabled(true);
        }

        @Override
        public void act() {
            FPortecle.this.newKeyStore();
        }
    }
}

